VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Swimmers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private db As dBase
Private dbpath As String
Private db3 As New dBaseIII
Dim swrec As Recordset
Private clDate As New Dates
Private clbs As New Clubs
Public Sub setDB(datab As dBase)
Set db = datab
clbs.setDB db
clbs.openClubs
End Sub
Public Sub createTable(datab As dBase)
Dim SwimmerKey As Field, lastname As Field, Firstname As Field
Dim Nickname As Field, Birthday As Field, Initials As Field
Dim address As Field, Town As Field, state As Field, USSID As Field
Dim zip As Field, sex As Field, cbirth As Field, regyear As Field
Dim clubkey As Field, swname As Field, midinit As Field
Dim phone As Field, Active As Field, regStatus As Field

Dim tb As TableDef
Set db = datab
Set tb = db.createTable("Swimmers")
Set SwimmerKey = createKey(tb, "SwimmerKey")
Set swname = createText(tb, "Name", 30)
Set lastname = createText(tb, "Lastname", 20)
Set Firstname = createText(tb, "Firstname", 15)
Set Nickname = createText(tb, "Nickname", 15)
Set midinit = createText(tb, "Middle", 15)
Set Initials = createText(tb, "Initials", 3)
Set address = createText(tb, "Address", 30)
Set Town = createText(tb, "Town", 20)
Set state = createText(tb, "State", 2)
Set sex = createText(tb, "Sex", 1)
Set cbirth = createLong(tb, "Cbirth")
Set USSID = createText(tb, "USSID", 16)
Set zip = createText(tb, "Zip", 10)
Set regyear = createText(tb, "RegYear", 4)
Set Birthday = createDateField(tb, "Birthday")
Set clubkey = createLong(tb, "ClubKey")
Set phone = createText(tb, "Phone", 15)
Set Active = createBoolean(tb, "Active")
Set regStatus = createLong(tb, "RegStatus")
regStatus.DefaultValue = REGISTERED
Active.DefaultValue = True
makeIndex tb, "SwimmerKey", True
makeIndex tb, "Name", False
makeIndex tb, "LastName", False
db.appendTable tb
End Sub
Public Sub Update()
Dim i As Integer
'pick path to dbaseII database
If dbpath <> "" Then
  Menu.cDlg.InitDir = dbpath
End If
Menu.cDlg.DialogTitle = "Select USS DB-III File Directory"
Menu.cDlg.Filter = "dBase-III files|*.dbf"
Menu.cDlg.ShowOpen
dbpath = Menu.cDlg.filename
i = Len(dbpath)
While Mid(dbpath, i, 1) <> "\"
  i = i - 1
Wend
dbpath = Left$(dbpath, i) 'strip off filename
updateSwimmers
End Sub
Public Sub updateSwimmers()
Dim nm$, i As Integer, lname$, frname$, midinit$, USSID$, club$
Dim inits As String, bday As Date
Dim clbs As New Clubs
Dim updating As Boolean, adding As Boolean, found As Boolean
Dim nameRec As Recordset

Screen.MousePointer = vbHourglass
clbs.setDB db
clbs.openClubs
'reads in records from USS database and
'either adds or updates swimmer depending on
'whether it finds a match
db3.openDB dbpath
db3.openSwimmers
db3.openClub
Set swrec = db.openTableRecord("Swimmers")
swrec.Index = "LastName"
While Not db3.swimmerEOF
 lname$ = db3.swmrLname
 frname$ = db3.swmrFrname
 USSID$ = db3.swmrUSSID
 found = False
 Set nameRec = db.openRecord("Select * from Swimmers where USSID=" + Chr$(34) + USSID$ + Chr$(34))
 'swrec.Index = "USSID"
 'swrec.Seek "=", USSID
 If nameRec.BOF Then
   swrec.AddNew     'if no match add a new swimmer
   adding = True
   found = True
 Else
 swrec.Index = "Swimmerkey"
 swrec.Seek "=", nameRec![SwimmerKey]
 'even if exact match, initials or birthday must also match
 ' While Not nameRec.EOF And Not found
 '  If UCase$(frname) = UCase$(nameRec![Firstname]) Or db3.swmrUSSID = nameRec![ussid] Then
     swrec.Edit
     updating = True
     found = True
   'End If
   'If Not nameRec.EOF And Not found Then nameRec.MoveNext
  ' Wend
   nameRec.Close
   If Not found Then
     swrec.AddNew
     updating = False
     adding = True
   End If
 
 End If
 If IsNull(db3.swmrUSSID) Or lname$ = "" Or frname = "" Then
   adding = False
   updating = False
 End If
 
   
 'i = InStr(nm$, ",")    'split names apart
 'If i > 0 Then
If updating Or adding Then
   lname$ = db3.swmrLname 'convert_lastname(Left$(nm$, i - 1))
   frname$ = db3.swmrFrname 'convert_firstname(Trim$(Right$(nm$, Len(nm$) - i)))
   midinit$ = db3.swmrInitial 'Right$(frname$, 1)
   club$ = db3.swmrClub
    
 Menu.Status.Caption = frname$ + " " + lname$
 Menu.Status.Refresh
 swrec![Name] = lname$ + ", " + frname$
 swrec![lastname] = lname$
 swrec![Firstname] = Left$(frname$, swrec![Firstname].Size)
 swrec![Middle] = midinit$
 If Len(Trim$(db3.swmrCbirth)) = 6 Then
    swrec![cbirth] = db3.swmrCbirth
 End If
 If IsDate(db3.Birthday) Then
    swrec![Birthday] = db3.Birthday
 End If
 swrec![Nickname] = db3.swmrPFname
 'swrec![Initials] = db3.swmrInits
 swrec![clubkey] = clbs.findKey(club)
 swrec![address] = db3.swmrAdl1
 swrec![Town] = Left$(db3.swmrTown, swrec![Town].Size)
 swrec![state] = db3.swmrState
 swrec![zip] = db3.swmrZip
 swrec![sex] = db3.swmrSex
 swrec![regyear] = db3.regyear
 swrec![phone] = db3.swmrPhone
 swrec![clubkey] = clbs.findKey(db3.swmrClub)
 swrec![USSID] = db3.swmrUSSID
 
 swrec.Update
 End If
 db3.swmrMoveNext
 
Wend
Screen.MousePointer = vbDefault
End Sub
Public Function findLastNames(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName, Swimmers.name, Swimmers.birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Lastname) = " + Chr$(34) + nm$ + Chr$(34) + "))" + _
"ORDER BY Swimmers.Firstname;"

Set findLastNames = db.openRecord(query$)
End Function
Public Function fuzzyLastNames(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName, Swimmers.Name, Swimmers.birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Lastname) like " + Chr$(34) + nm$ + "*" + Chr$(34) + "))" + _
"ORDER BY Swimmers.Lastname;"

Set fuzzyLastNames = db.openRecord(query$)
End Function
Public Function findName(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName,Swimmers.Name, Swimmers.birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Name) = " + Chr$(34) + nm$ + Chr$(34) + "))" + _
"ORDER BY Swimmers.name;"

Set findName = db.openRecord(query$)
End Function
Public Function findSwimmer(ByVal lname$, ByVal frname$, club$, init$, cbirth As Long, USSID As String, found As Boolean) As Recordset
Dim rec As Recordset
Dim mname$, nick$, clubkey As Integer

clubkey = clbs.findKey(club$)
found = False
  Set rec = findByUSS(init, cbirth, USSID)
  If rec.BOF Then
    rec.Close
    Set rec = findByLastnameAndClub(Trim$(lname), Trim$(club))
    If rec.RecordCount = 0 Then
      Set rec = findByLastname(lname)
      If Not rec.BOF Then
      rec.MoveLast
      rec.MoveFirst
      End If
    End If
    'rec.MoveLast
    'rec.MoveFirst
    If rec.RecordCount > 1 Then
      frname$ = UCase$(Trim$(frname))
      found = False
      While Not rec.EOF And Not found
        found = frname$ = UCase$(rec![Firstname])
        If Not found Then rec.MoveNext
      Wend
      'if no first name matches try nickname
      If Not found Then
       rec.MoveFirst
       While Not rec.EOF And Not found
        nick$ = ""
         If rec![Nickname] & "" <> "" Then
          nick$ = UCase$(rec![Nickname])
         End If
         found = (UCase$(frname$) = nick$)
         If Not found Then rec.MoveNext
       Wend
      End If
      'if still no match try shortening first name
      If Not found Then
        frname$ = Left$(frname$, Len(frname$) - 1)
        While Len(frname$) > 2 And Not found
          rec.MoveFirst
          While Not rec.EOF And Not found
            mname$ = rec![Firstname]
            If Len(mname$) > Len(frname$) Then
              mname$ = Left$(mname$, Len(frname$))
              found = frname$ = mname$
            End If
            If Not found Then rec.MoveNext
          Wend
          If Len(frname$) > 2 And Not found Then
            frname$ = Left$(frname$, Len(frname) - 1)
          End If
        Wend
      End If

    Else
      If Not rec.BOF Then
         If rec.RecordCount = 1 And rec![clubkey] = clubkey And Trim$(rec![Firstname]) = frname$ Then
            found = True    'only one found so must be it
        Else
            found = False
        End If
       End If
    End If
    'If found Then
    '  key = rec![SwimmerKey]
    '  swim_keys(i) = key
    '  add_events key, i
    'Else
    '  noMatches.add Str$(i) & " " & getName$(i) & " - " & Trim$(swmr(i).team)
    'End If
  Else      'USS number matches
    'key = rec![SwimmerKey]
    'swim_keys(i) = key
    'add_events key, i
    found = True
  End If    'recordcount>1 for USS match
Set findSwimmer = rec
End Function
Public Function findByUSS(init$, cbirth As Long, USSID As String) As Recordset
Dim query$, i As Integer
Dim rec As Recordset

init$ = TrimIt(init$)
If Len(TrimIt(USSID)) > 0 Then
    query$ = "SELECT DISTINCTROW swimmers.swimmerkey, Swimmers.Lastname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Swimmers.birthday From Swimmers " + _
    "WHERE ( (Swimmers.ussid=" + Chr$(34) + USSID + Chr$(34) + "));"
    Set rec = db.openRecord(query$)
Else
  query$ = "SELECT DISTINCTROW swimmers.swimmerkey, Swimmers.Lastname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Swimmers.birthday " + _
  "From Swimmers " + _
  "WHERE ( (Swimmers.Initials=" + Chr$(34) + init$ + Chr$(34) + ") AND ((Swimmers.Cbirth)=" + Str$(cbirth) + "));"
  Set rec = db.openRecord(query$)
End If

If rec.BOF Then
  i = InStr(init$, Chr$(0))
  If i > 0 Then init$ = "   "
  query$ = "SELECT DISTINCTROW swimmers.swimmerkey, Swimmers.Lastname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Swimmers.Birthday " + _
  "From Swimmers " + _
  "WHERE ( (Swimmers.Initials=" + Chr$(34) + init$ + Chr$(34) + ") AND ((Swimmers.Cbirth)=" + Str$(cbirth) + "));"
  Set rec = db.openRecord(query$)
End If
Set findByUSS = rec

End Function
Public Function findByLastnameAndClub(ByVal lname$, ByVal club$) As Recordset
Dim query$, i As Integer
lname$ = UCase$(Trim$(lname$))
club$ = Trim$(club$)
i = InStr(lname$, Chr$(0))
If i > 0 Then lname$ = " "
i = InStr(club$, Chr$(0))
If i > 0 Then club$ = " "
i = InStr(lname$, Chr$(34))
If i > 0 Then Mid$(lname$, i, 1) = "'"
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Swimmers.Birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE (((Swimmers.Lastname)=" + Chr$(34) + lname$ + Chr$(34) + ") AND ((Clubs.ClubCode)='" + club$ + "'));"

Set findByLastnameAndClub = db.openRecord(query$)
End Function

Public Function findByLastname(ByVal lname$) As Recordset
Dim query$, i As Integer
lname$ = UCase$(Trim$(lname))
i = InStr(lname$, Chr$(0))
If i > 0 Then lname$ = "  "
query$ = "SELECT DISTINCTROW Swimmers.Swimmerkey, Swimmers.Firstname, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Cbirth, Swimmers.birthday, Swimmers.ClubKey " + _
"From Swimmers WHERE (((Swimmers.Lastname)=" + Chr$(34) + lname$ + Chr$(34) + "));"

Set findByLastname = db.openRecord(query$)
End Function

Public Function findByClub(club$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.Name, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, swimmers.birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE ( ((Clubs.ClubCode)='" + club$ + "')) order by Swimmers.lastname;"

Set findByClub = db.openRecord(query$)

End Function
Public Function findKey(key As Integer) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.Name, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Swimmers.birthday, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE ( ((Swimmers.swimmerkey)=" + Str$(key) + ")) order by Swimmers.lastname;"

Set findKey = db.openRecord(query$)
End Function
Public Function addSwimmer(lname As String, frname As String, clubkey As Integer, regstat As Long) As Recordset
Set swrec = db.openTableRecord("Swimmers")
swrec.AddNew
swrec![Firstname] = Left(UCase$(frname), swrec![Firstname].Size)
swrec![lastname] = Left$(UCase$(lname), swrec![lastname].Size)
swrec![Name] = UCase$(lname) + ", " + UCase(frname)
swrec![regStatus] = regstat
swrec![clubkey] = clubkey
swrec.Update
swrec.Bookmark = swrec.LastModified
Set addSwimmer = swrec
End Function
Function convert_firstname(ByVal fr$) As String
Dim i As Integer
If UCase$(fr$) = fr$ Then
   fr$ = LCase$(fr$)
   i = InStr(fr$, " ")  'Two first names
   If i > 0 Then
      Call setcap(fr$, i + 1)
   End If
   If Len(fr$) >= 1 Then
     Mid$(fr$, 1, 1) = UCase$(Left$(fr$, 1))
   End If
End If
convert_firstname = fr$
End Function
Private Function convert_lastname(ByVal ln$) As String
Dim i As Integer
 If (UCase$(ln$) = ln$) Then
       ln$ = LCase$(ln$)
       If Len(ln$) >= 1 Then
         Mid$(ln$, 1, 1) = UCase$(Left$(ln$, 1))
       End If
       If Len(ln$) >= 2 Then
         If Left$(ln$, 2) = "Mc" Then 'Mcsweeney
            Call setcap(ln$, 3)
         End If
       End If
       If Len(ln$) >= 3 Then
         If Left$(ln$, 3) = "Mac" Then 'Macdonald
           Call setcap(ln$, 4)
         End If
       End If
       i = InStr(ln$, "-")  'hyphenate name
       If i > 0 Then
         Call setcap(ln$, i + 1)
       End If
       i = InStr(ln$, "'")  'O'connor
       If i > 0 Then
         Call setcap(ln$, i + 1)
       End If
 End If
 convert_lastname = ln$
End Function
Sub setcap(s$, l As Integer)
If Len(s$) >= l Then
  Mid$(s$, l, 1) = UCase$(Mid$(s$, l, 1))
End If
End Sub

Public Sub makeMixedCase()
Dim rec As Recordset
Dim fr$, ln$

Set rec = db.openTableRecord("Swimmers")
While Not rec.EOF
  fr$ = convert_firstname(rec![Firstname])
  ln$ = convert_lastname(rec![lastname])
  rec.Edit
  rec![Firstname] = fr$
  rec![lastname] = ln$
  rec![address] = convert_firstname(rec![address] & "")
  rec![Middle] = convert_firstname(rec![Middle] & "")
  rec![Nickname] = convert_firstname(rec![Nickname] & "")
  rec![Town] = convert_firstname(rec![Town] & "")
  rec.Update
  rec.MoveNext
Wend
rec.Close
End Sub
Property Get SwimmerKey() As Long
SwimmerKey = swrec![SwimmerKey]
End Property
Public Function TrimIt(ByVal s As String) As String
s = Trim$(s)
If Len(s) > 0 Then
    If Asc(s) = 0 Then
     s = ""
    End If
End If
TrimIt = s
End Function



