Attribute VB_Name = "Setfunc"
'Attribute VB_Name = "SETFUNC"
Option Explicit
'Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpzFileName As String, ByVal wCmd As Integer, dwdata As Any) As Integer
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFilename$)
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$, ByVal lplFileName$) As Integer


Function get_clubname$(club$)
Dim tm As Integer, found As Integer
Dim clubname$, init$, tname$, contact$, coach$, phone$
Dim add1$, add2$, city$, state$, zip$

clubname$ = ""
tm = FreeFile
found = False
If Len(Dir$("teamlist.txt")) > 0 Then
  Open "teamlist.txt" For Input As #tm
While Not EOF(tm) And Not found
  Line Input #tm, init$
  Line Input #tm, tname$
  found = (UCase$(club$) = UCase$(RTrim$(init$)))
  If found Then clubname$ = tname$
  If Left$(tname$, 1) = "*" Then
  ' l_print init$
  Else
    Line Input #tm, contact$
    Line Input #tm, coach$
    Line Input #tm, phone$
    Line Input #tm, add1$
    Line Input #tm, add2$
    Line Input #tm, city$
    Line Input #tm, state$
    Line Input #tm, zip$
    'l_print RTrim$(city$) + ", " + RTrim$(state$) + " "
    Line Input #tm, init$        'asterisks
    'l_tab 50
    If Len(LTrim$(contact$)) = 0 Then
     ' l_print RTrim$(coach$)
    Else
      'l_print RTrim$(contact$)
    End If
    'l_printcr " " + RTrim$(phone$)
End If
Wend
Close #tm
End If

get_clubname$ = clubname$
End Function

Function get_linked_enums(enum As Integer, ev() As Integer) As Integer
Dim s$, i As Integer, max As Integer, k As Integer
max = 10
'returns a list of linked events in the
' ev array, the return value is the number of events
ReDim ev(max) As Integer
i = 1
s$ = Trim$(events(enum).evlink)
If Len(s$) = 0 Then s$ = Str$(enum)
While Len(s$) > 0
  ev(i) = Val(s$)
  i = i + 1
  If (i > max) Then
    max = max + 10
    ReDim ev(max) As Integer
  End If
  k = InStr(s$, ",")
  If k > 0 Then
    s$ = Trim$(Right$(s$, Len(s$) - k))
  Else
    s$ = ""
  End If
Wend
get_linked_enums = i - 1

End Function

Function get_profile$(Paragraph$, tag$, deflt$)
Dim s$, ans As Integer
  s$ = Space$(180)
  ans = GetPrivateProfileString(Paragraph$, tag$, deflt$, s$, 80, Trim$(md.meetdir) + "\Meet5.ini")
  get_profile$ = stripend$(s$)

End Function

Function get_rprofile$(Paragraph$, tag$, deflt$)
Dim s$, ans As Integer
  s$ = Space$(180)
  ans = GetPrivateProfileString(Paragraph$, tag$, deflt$, s$, 80, Trim$(md.meetdir) + "\records.ini")
  get_rprofile$ = stripend$(s$)

End Function

Sub get_score(para$, tag$, score() As Integer)
Dim s$, sval$, i As Integer, j As Integer
  s$ = get_profile$(para$, tag$, "0")
  For i = 1 To 48
    score(i) = 0
  Next i
  j = 1
  i = InStr(s$, ",")
  While i > 0
    sval$ = Left$(s$, i - 1)
    score(j) = Val(sval$)
    j = j + 1
    s$ = Right$(s$, Len(s$) - i)
    i = InStr(s$, ",")
  Wend
  score(j) = Val(s$)
End Sub

Function get_token$(s$)
'removes one comma-delimited token from the string
Dim i As Integer

i = InStr(s$, ",")
If i > 0 Then
  get_token$ = Left$(s$, i - 1)
  s$ = Trim$(Right$(s$, Len(s$) - i))
Else
  get_token = s$
End If

End Function

Function GetDQ$(en As ENTRYREC, round As Integer)
Select Case round
  Case RESULTS
    If Asc(en.DisqualR) <> 0 Then
      GetDQ$ = "D.Q"
    Else
      GetDQ$ = timestring$(en.result)
    End If
    If Asc(en.escratch) <> 0 Then
      GetDQ$ = "Scratch"
    End If
  Case FINALS
    If Asc(en.DisqualF) <> 0 Then
      GetDQ$ = "D.Q"
    Else
      GetDQ$ = timestring$(en.final)
    End If
    If Asc(en.fscratch) <> 0 Then
      GetDQ$ = "Scratch"
    End If

  
End Select

End Function

Function getdqtime(en As ENTRYREC, round As Integer)
Select Case round
  Case RESULTS
    If Asc(en.DisqualR) <> 0 Then
      getdqtime = DQ
    Else
      If Asc(en.escratch) <> 0 Then
        getdqtime = SCRATCH
      Else
        getdqtime = (en.result)
      End If
    End If
  Case FINALS
    If Asc(en.DisqualF) <> 0 Then
      getdqtime = DQ
    Else
      If Asc(en.fscratch) <> 0 Then
        getdqtime = SCRATCH
      Else
        getdqtime = (en.final)
      End If
    End If
  Case FINALS

End Select

End Function

Function getname$(k As Integer)
If k <= UBound(swmr) Then
 getname$ = RTrim$(swmr(k).frname) + " " + RTrim$(swmr(k).lname)
End If
End Function

Function getstroke(events() As EVENTX, ev As Integer)

getstroke = events(ev).stroke              'return stroke number from stroke name
End Function '============================================================

Sub hilite(C As Control)
  C.SelStart = 0
  C.SelLength = Len(C.Text)
End Sub

Function in_club(swmr As SWIMMER, club$, swname$) As Integer
Dim e As Integer, r As Integer, rage As Integer
    If RTrim$(swmr.team) = club$ Then
      e = swmr.eventpoint
      If (e > 0) Then
        r = checkrelays(events(entries(e).evnum).stroke)
        rage = events(entries(e).evnum).maxage
      Else
       r = False
     End If
     
      If r Then
         swname$ = RTrim$(swmr.lname) + " " + RTrim$(swmr.frname) + Str$(rage)
      Else
         swname$ = RTrim$(swmr.lname) + " " + RTrim$(swmr.frname) + Str$(swmr.age)
      End If
      in_club = Not r 'true only if not relay
     Else
       in_club = False
     End If

End Function

Sub iSWAP(i As Integer, j As Integer)
Dim t As Integer
t = i
i = j
j = t

End Sub

Function make_dash_date$(d As Single)
Dim st$

st$ = makedate$(d)
st$ = Left$(st$, 2) + "-" + Mid$(st$, 3, 2) + "-" + Right$(st$, 2)
make_dash_date$ = st$
End Function

Sub make_eventlist(sex$, minage As Integer, maxage As Integer, evnmbrs() As Integer, evcnt As Integer)
Dim stroke As Integer
ReDim dist(10) As Integer
Dim d As Integer, i As Integer

dist(1) = 25
dist(2) = 50
dist(3) = 100
dist(4) = 200
dist(5) = 400
dist(6) = 500
dist(7) = 800
dist(8) = 1000
dist(9) = 1500
dist(10) = 1650

evcnt = 0
For stroke = FREE To MEDRELAY
  For d = 1 To 10
    For i = 1 To md.numevents
      If (events(i).stroke = stroke) And (events(i).sex = sex$) And (events(i).maxage = maxage) And (events(i).dist = dist(d)) Then
        evcnt = evcnt + 1
        evnmbrs(evcnt) = i
      End If
    Next i
  Next d
Next stroke
End Sub

Function make_seedcourse$()
Select Case md.course
  Case "YDS"
    make_seedcourse$ = "Y"
  Case "LCM"
    make_seedcourse$ = "M"
  Case "SCM"
    make_seedcourse$ = "S"
End Select
End Function

Function makedate$(dt As Single)
Dim yr As Long, dayval As Long, ds$
      yr = dt \ 10000
      dayval = dt - (yr * 10000)
      ds$ = LTrim$(Str$(dayval))
      If Len(ds$) < 4 Then ds$ = "0" + ds$
makedate$ = ds$ + LTrim$(Str$(yr))
End Function

Rem $DYNAMIC
Function maketime$(t)
Dim t1 As Integer, t2 As Integer, t3 As Integer, tm$, mTime
Select Case t
     Case 0, 10000:
        tm$ = "   N.T."
     Case 20000:
        tm$ = "   D.Q."
     Case Is >= 30000
        tm$ = "Scratch"
     Case Else
        mTime = t + 0.005        'round up
        t1 = Int(mTime / 100)            'minutes
        t2 = Int(mTime - (100 * t1)) 'seconds
        t3 = Int((mTime - (100 * t1) - t2) * 100) 'hundredths
        If t1 > 0 Then
            tm$ = digprn$(t1) + ":"
        Else
            tm$ = "  "
        End If
        tm$ = tm$ + digprn$(t2) + "."
        tm$ = tm$ + digprn$(t3)
     End Select

'replace leading zero with a space
If Left$(tm$, 1) = "0" Then
  Mid$(tm$, 1, 1) = " "
End If
maketime$ = tm$

End Function '----*************************************************************

Function nonconforming(entr As ENTRYREC) As Integer
  nonconforming = True
  If md.course = "LCM" And entr.seedcourse = "M" Then nonconforming = False
  If md.course = "YDS" And entr.seedcourse = "Y" Then nonconforming = False
  If md.course = "SCM" And entr.seedcourse = "S" Then nonconforming = False
End Function

Function onechar$(t As Integer)
Dim s$
s$ = Chr$(Asc("0") + t)
onechar$ = s$

End Function '----*************************************************************

Sub printeventname(events() As EVENTX, md As MEETDESC, eventnum As Integer, evstr$, sstr$, dstr$, short As Integer)
Dim st As Integer, min As Integer, max As Integer
Dim senior$, andunder$, andover$, Vrsity$, DASH$
If short Then
  senior$ = " Senr"
  andunder$ = "&U"
  andover$ = "&O"
  Vrsity$ = " Vars"
  DASH$ = "-"
Else
  senior$ = " Senior"
  andunder$ = " and Under"
  andover$ = " and Over"
  Vrsity$ = " Varsity"
  DASH$ = " - "
End If

st = getstroke(events(), eventnum)
Select Case UCase$(events(eventnum).sex)
   Case "F"
      evstr$ = "Girls "
        If events(eventnum).maxage > 18 Then
          evstr$ = "Womens "
        End If
   Case "M"
      evstr$ = "Boys "
        If events(eventnum).maxage > 18 Then
          evstr$ = "Mens "
        End If

   Case "N"
     evstr$ = "Swimmers "
   Case "U"
     evstr$ = "Unified "
End Select
If short Then
 evstr$ = UCase$(events(eventnum).sex)
End If
min = events(eventnum).minage   'concise local copies
max = events(eventnum).maxage

Select Case min
   Case 0:
     Select Case max
      Case 25
         evstr$ = evstr$ + senior$
      'Else
      '   evstr$ = evstr$ + Str$(max) + andunder$
      'End If
      Case VARSITY
        evstr$ = evstr$ + Vrsity$ + " "
      'End If
      Case JV
        evstr$ = evstr$ + "JV "
      'End If
      Case OPENMEET
        evstr$ = evstr$ + "Open "
      Case Else
         evstr$ = evstr$ + Str$(max) + andunder$
      End Select
   Case Is > 0:
      If max = 25 Then
         evstr$ = evstr$ + Str$(min) + andover$
      Else
        evstr$ = evstr$ + Str$(min) + DASH$ + Str$(max)
      End If
End Select
sstr$ = evstr$                          'save 1st line of 2-line desc
dstr$ = Str$(events(eventnum).dist)
If events(eventnum).stroke = DIVING Then
   'If events(eventnum).dist = 25 Then
   '  dstr$ = "1"
   'Else
   '  dstr$ = "3"
   'End If
End If

If Not short Then
If events(eventnum).stroke = DIVING Then
   dstr$ = dstr$ + " M"
Else
Select Case md.course
   Case "YDS": dstr$ = dstr$ + " YD"
   Case "LCM", "SCM": dstr$ = dstr$ + " M"
End Select
End If
End If
dstr$ = dstr$ + " " + strokename$(events(eventnum).stroke)

evstr$ = evstr$ + dstr$
If short Then
  evstr$ = LTrim$(Str$(eventnum)) + " " + evstr$
End If
End Sub '----*************************************************************

Function read_age_groups(minage() As Integer, maxage() As Integer) As Integer
Dim F As Integer, max As Integer, i As Integer

max = 0
If Len(Dir$(RTrim$(md.meetdir) + "\agegrps.dat")) > 0 Then
 F = FreeFile
 i = 1
 Open "agegrps.dat" For Input As #F
 While Not EOF(F)
   Input #F, minage(i), maxage(i)
   i = i + 1
 Wend
 max = i - 1
 Close #F
End If
read_age_groups = max
End Function

Sub read_initial_files(readrec As Integer)
Dim fl As Integer, i As Integer, file$
ReDim sessex(10) As String * 1
ReDim sesnames(10) As String * 25
Dim Drive$, ans As Integer, tdir$, rt$
'--------------------------------------------
' Find the correct drive, read in meet4.ini
' and then read in current meet file
'If READREC is TRUE read in swimmers and entries as well
'--------------------------------------------
'----------------------------------------------
' Get swim4 root path from swim4.ini
'----------------------------------------------
tdir$ = Space$(40)

ans = GetPrivateProfileString("swim4", "path", "c:\swim4\", tdir$, 40, "Swim4.ini")
rt$ = Right$(tdir$, 1)
While rt$ = " " Or rt$ = Chr$(0)
  tdir$ = Left$(tdir$, Len(tdir$) - 1)
  rt$ = Right$(tdir$, 1)
Wend
md.basedir = tdir$
md.meetdir = tdir$ + "meets"
md.webdir = tdir$ + "webpage"
Drive$ = Left$(md.basedir, 2)
ChDrive Drive$
'--------------------------------------
'Search for drive containing \swim4
'--------------------------------------
'On Error GoTo baddrive
'ChDrive "c"
'ChDir "C:\"
'While Len(Dir$("swim4", ATTR_DIRECTORY)) = 0
'drive$ = Chr$(Asc(Left$(CurDir$, 1)) + 1)
'ChDrive drive$
'ChDir "\"
'Wend

  tdir$ = RTrim$(md.basedir)     'allow for drives)
  tdir$ = Left$(tdir$, Len(tdir$) - 1)
  ChDir tdir$
  'md.basedir = CurDir$  'meet exes and help underneath
  If Len(Dir$("meet4.ini")) > 0 Then
    fl = FreeFile
    Open "meet4.ini" For Input As #fl
    Line Input #fl, md.meetdir
    Line Input #fl, file$
    i = InStr(file$, ".")
    If i > 0 Then
     file$ = Left$(file$, i - 1)
    End If
    md.meetfile = file$
    Close #fl
    On Local Error GoTo nomeet
    ChDir md.meetdir
'  Call readmeet(md.meetfile, md.numevents, md.meetname, md.meetlocation, md.date, md.course, md.meas, md.numsessions, md.sessend(), sessex(), sesnames())
  For i = 1 To md.numsessions
    md.sessex(i) = sessex(i)
    md.sesnames(i) = sesnames(i)
  Next i
'  Call read_setup(md)
  If readrec Then
'   Call readrecfile
 End If
  End If
mtexit:
Exit Sub

nomeet:
  ans = MsgBox("Previously selected meet has been deleted", vbOK, "Error " + Str$(Err))
  Resume mtexit
End Sub





Sub restart()
Dim d$, suc%
'reset base help file
'Call HelpClose
'Call HelpRegister(RTrim$(md.basedir) + "help\meet4.hlp", suc%)
'If suc% Then
'  Call HelpSetOptions(9, 15, 7, 0, 7, 7, 67)
'End If
 'menu.fremem.caption = STR$(FRE(-1))

'd$ = RTRIM$(md.basedir) + "\meet4.exe"
'PRINT "chaining " + d$, FREEFILE, FRE(-1); FRE(-2)
'CHAIN d$
End Sub

Sub save_events(fl As Integer, m4 As Integer)
Dim i As Integer
  For i = 1 To md.numevents
    If m4 Then
      Print #fl, events(i).evname
    End If
    Print #fl, UCase$(events(i).sex)
    Print #fl, events(i).minage
    Print #fl, events(i).maxage
    Print #fl, events(i).dist
    Print #fl, UCase$(strokename$(events(i).stroke))
    Print #fl, events(i).slowcut
    Print #fl, events(i).fastcut
    If m4 Then
      Print #fl, events(i).final
      Print #fl, events(i).evlink
    End If
   Next i
Close #fl

End Sub

Rem $DYNAMIC
Sub savemeet(md As MEETDESC)
'Always save as SwimMeet 4.0 Meet file
Dim fl As Integer, i As Integer, file$, file3$, fl3 As Integer
fl = FreeFile
file$ = RTrim$(md.meetfile) + ".mt4"
Open file$ For Output As #fl
fl3 = FreeFile
file3$ = RTrim$(md.meetfile) + ".mee"
Open file3$ For Output As #fl3
  Print #fl, "Swim 4.0" 'tag to indicate new format
  Print #fl, md.meetname
  Print #fl3, md.meetname
  Print #fl, md.meetlocation
  Print #fl, md.date
  Print #fl, md.course
  Print #fl3, md.date
  Print #fl3, md.course
  Print #fl, "Sessions: "; md.numsessions
  For i = 1 To md.numsessions
    Print #fl, md.sesnames(i)
    Print #fl, md.sessend(i); " "; md.sessex(i)
  Next i
  Call save_events(fl, True)
  Call save_events(fl3, False)
Close #fl
Close #fl3

End Sub

Function SetDQ$(en As ENTRYREC, round As Integer)
Select Case round
  Case RESULTS
    en.DisqualR = Chr$(1)
  Case FINALS
    en.DisqualF = Chr$(1)
End Select
SetDQ$ = "D.Q."
End Function

Function SetScr$(en As ENTRYREC, round As Integer)
Select Case round
  Case RESULTS
    en.escratch = Chr$(1)
  Case FINALS
    en.fscratch = Chr$(1)
End Select
SetScr$ = "Scratch"

End Function

Sub sSWAP(s1$, s2$)
Dim t$

t$ = s1$
s1$ = s2$
s2$ = t$

End Sub

Function stcenter$(ByVal st$, l As Integer)
stcenter$ = Space$((l - Len(st$)) / 2) + st$
End Function

Function stripend$(ByVal tdir$)
Dim rt$
tdir$ = Trim$(tdir$)
rt$ = Right$(tdir$, 1)
While rt$ = " " Or rt$ = Chr$(0)
  tdir$ = Left$(tdir$, Len(tdir$) - 1)
  rt$ = Right$(tdir$, 1)
Wend
stripend$ = tdir$
End Function

Rem $DYNAMIC
Function strokename$(s As Integer)
        Select Case s
           Case FREE
              strokename$ = "Free"
           Case BACK
              strokename$ = "Back"
           Case BREAST
              strokename$ = "Breast"
           Case FLY
              strokename$ = "Fly"
           Case IM
              strokename$ = "IM"
           Case RELAY
              strokename$ = "Free Relay"
           Case MEDRELAY
              strokename$ = "Medley Relay"
           Case DIVING
              strokename$ = "Diving"
           Case FLOAT
               strokename$ = "Float"
           Case WALK
               strokename$ = "Walk"
           Case UNASSISTED
               strokename$ = "Unassisted"
           Case ASSISTED
               strokename$ = "Assisted"
           Case Else
              strokename$ = "Free"
           End Select
End Function

Sub SWAP(x As Single, y As Single)
Dim t As Single
t = x
x = y
y = t

End Sub

Function timestring$(value As Single)
Dim s$
Select Case value
  Case NT
    s$ = "N.T."
  Case DQ
   s$ = "D.Q."
  Case SCRATCH
   s$ = "Scratch"
  Case Else
   s$ = Format$(value, "####.00")
 End Select
timestring$ = s$
End Function

Sub timeval(s$, t)
t = 0
Select Case Left$(UCase$(s$), 1)
  Case "N"
    t = NT
  Case "S"
    t = SCRATCH
  Case "D"
    t = DQ
  Case "U"
    t = UNSCRATCH
  Case Else
     t = Val(s$)
End Select

End Sub

Function unofficial(entry As ENTRYREC) As Integer
unofficial = Asc(entry.unofficial) <> 0
End Function


Sub write_profile(para$, tag$, st$)
Dim ans As Integer

ans = WritePrivateProfileString(para$, tag$, st$, Trim$(md.meetdir) + "\Meet5.ini")

End Sub

Sub write_score(para$, tag$, scnt As Integer, score() As Integer)
Dim i As Integer, s$
If scnt <= 48 Then
s$ = ""
For i = 1 To scnt - 1
  s$ = s$ + Str$(score(i)) + ","
Next i
If scnt > 0 Then
 s$ = s$ + Str$(score(scnt)) 'ass in last one without comma
End If
i = WritePrivateProfileString(para$, tag$, s$, Trim$(md.meetdir) + "\meet5.ini")
End If
End Sub


Rem $DYNAMIC
Function AgeStr$(min As Integer, max As Integer)
Dim ag$, stmin$, STMAX$
ag$ = ""
stmin$ = LTrim$(Str$(min))
STMAX$ = LTrim$(Str$(max))

If max = 25 And min = 0 Then
   ag$ = "Senior"
End If
If max = VARSITY And min = 0 Then
  ag$ = "Varsity"
End If
If max = JV And min = 0 Then
  ag$ = "JV"
End If
If max = OPENMEET And min = 0 Then
  ag$ = "Open"
End If

If max = 25 And min <> 0 Then
   ag$ = stmin$ + "/O"
End If

If max < 25 And min = 0 Then
  ag$ = STMAX$ + "&U"
End If

If max <> 25 And min <> 0 Then
  ag$ = stmin$ + "-" + STMAX$
End If

AgeStr$ = ag$

End Function

Function build_event_recs_by_age(eventnumber As Integer, minage As Integer, maxage As Integer, finalflag As Integer)
Dim swcnt As Integer, i As Integer, j As Integer, k As Integer
Dim found As Integer, heat As Integer, agemax As Integer
'ReDim minage(20) As Integer, maxage(20) As Integer
Dim A As Integer, heatmax As Integer

'agemax = read_age_groups(minage(), maxage())
    swcnt = 1
    For i = 1 To md.nswim              'construct array of swimmers from records
     If minage <= swmr(i).age And swmr(i).age <= maxage Then
      k = swmr(i).eventpoint        'first event in event array belonging to this swimmer
      found = False
      j = 1
      While (k > 0) And (Not found)
        If entries(k).evnum = eventnumber Then
          found = True
          If finalflag < 0 Then
            heat = Asc(entries(k).fheat)
          Else
            heat = Asc(entries(k).eheat)
          End If
          If heat > heatmax Then heatmax = heat
          If heat > 0 Then
            erec(swcnt) = k           'entry record number
            swrec(swcnt) = i          'swimmer record number
            swcnt = swcnt + 1
          End If
         End If
        k = entries(k).nextpnt
     Wend
    End If      'ages
    Next i
build_event_recs_by_age = swcnt - 1
End Function

Sub build_eventrecs(eventnumber As Integer, ByVal stev As Integer, kmax As Integer, heatmax As Integer, swrec() As Integer, erec() As Integer, finalflag As Integer)
Dim swcnt As Integer, i As Integer, j As Integer, k As Integer
Dim found As Integer, heat As Integer
Dim e As Integer, e1 As Integer, ecnt As Integer
ReDim ev(10) As Integer

swcnt = stev
heatmax = 0

'----check for combined events------------------
If Val(Trim$(events(eventnumber).evlink)) > 0 Then
  ecnt = get_linked_enums(eventnumber, ev())
  For i = 1 To ecnt
    e1 = e1 + entry_count(ev(i))
  Next i
Else
  ecnt = 1
  ev(1) = eventnumber
  e1 = entry_count(ev(1))
End If
ReDim swrec(e1) As Integer, erec(e1) As Integer
For e = 1 To ecnt
For i = 1 To md.nswim              'construct array of swimmers from records
 k = swmr(i).eventpoint        'first event in event array belonging to this swimmer
 found = False
 j = 1
 While (k > 0) And (Not found)
   'If entries(k).evnum = eventnumber Then
   If entries(k).evnum = ev(e) Then
      found = True
      If finalflag < 0 Then
        heat = Asc(entries(k).fheat)
      Else
        heat = Asc(entries(k).eheat)
      End If
      If heat > heatmax Then heatmax = heat
      If heat > 0 Then
        erec(swcnt) = k           'entry record number
        swrec(swcnt) = i          'swimmer record number
        swcnt = swcnt + 1
      End If
   End If
   k = entries(k).nextpnt
 Wend
Next i
Next e
kmax = swcnt - 1
End Sub

Function calc_seedcourse$(C$)
Select Case C$
  Case "YDS"
    calc_seedcourse$ = "Y"
  Case "LCM"
    calc_seedcourse$ = "M"
  Case "SCM"
    calc_seedcourse$ = "S"
  Case Else
    calc_seedcourse$ = Left$(md.course, 1)
    If md.course = "LCM" Then
      calc_seedcourse$ = "M"
    End If
End Select

End Function

Function calcstrokeindex(ev As EVENTX)
Dim stoff As Integer, doff As Integer
  Select Case ev.dist
     Case 25
       doff = 1
     Case 50
       doff = 2
     Case 100
       doff = 3
     Case 200
       doff = 4
     Case 400, 500
       doff = 5
     Case 800, 1000
       doff = 6
     Case 1500, 1650
       doff = 7
  End Select
  Select Case ev.stroke
     Case FREE
        stoff = 0
     Case BACK
        stoff = 7
     Case BREAST
        stoff = 11
     Case FLY
        stoff = 15
     Case IM
        stoff = 19
        doff = doff - 2
     Case RELAY, MEDRELAY
        stoff = 0
        doff = 0    'not in time stds file
    End Select
'ev.stroke = doff + stoff
calcstrokeindex = doff + stoff
End Function

Function checkrelays(strokenum As Integer)
Dim check As Integer
check = False
If strokenum = RELAY Or strokenum = MEDRELAY Then
   check = True
End If
checkrelays = check
End Function

Function ClearDQ$(en As ENTRYREC, round As Integer)
  Select Case round
    Case RESULTS
      en.DisqualR = Chr$(0)
      ClearDQ$ = timestring$(en.result)
    Case FINALS
      en.DisqualF = Chr$(0)
      ClearDQ$ = timestring$(en.final)
  End Select
End Function

Sub clearlist(C As Control)
Dim i As Integer

i = C.ListCount
While i > 0
  C.RemoveItem i - 1
  i = C.ListCount
Wend
End Sub

Function ClearScr$(en As ENTRYREC, round As Integer)
  Select Case round
    Case RESULTS
      en.escratch = Chr$(0)
      ClearScr$ = timestring$(en.result)
    Case FINALS
      en.fscratch = Chr$(0)
      ClearScr$ = timestring$(en.final)
  End Select

End Function

Sub convert5(efile4$, efile5$)
Dim F As Integer, f1 As Integer
Dim en As ENTRY4, en1 As ENTRYREC
F = FreeFile
Open efile4$ For Random As #F Len = Len(en)
f1 = FreeFile
Open efile5$ For Random As #f1 Len = Len(en1)
While Not EOF(F)
  Get #F, , en
  en1.DisqualR = Chr$(False)
  en1.DisqualF = Chr$(False)
  If en.result = DQ Then
    en1.DisqualR = Chr$(1)
  End If
  If en.final = DQ Then
    en1.DisqualF = Chr$(1)
  End If
  If (Asc(en.unoff) And 2) = 0 Then
    en1.seedcourse = Left$(md.course, 1) 'conforming
  Else
    en1.seedcourse = Left$(md.course, 1) 'nonconforming
    If en1.seedcourse = "Y" Then
      en1.seedcourse = "M"
    Else
      en1.seedcourse = "Y"
    End If
  End If
  If (Asc(en.unoff) And 1) = 0 Then
    en1.unofficial = Chr$(False)
  Else
    en1.unofficial = Chr$(1)
  End If
  en1.evnum = en.evnum
  en1.seed = en.seed
  en1.result = en.result
  en1.final = en.final
  en1.backupr = 0
  en1.backupf = 0
  en1.swimoff = 0
  en1.backups = 0
  en1.entrpnt = en.entrpnt
  en1.splpnt = en.splpnt
  en1.escratch = en.escratch
  en1.fscratch = en.fscratch
  en1.att = en.att
  en1.eplace = en.eplace
  en1.fplace = en.fplace
  en1.points = en.points
  en1.eheat = en.eheat
  en1.elane = en.elane
  en1.fheat = en.fheat
  en1.flane = en.flane
  en1.nextpnt = en.nextpnt

  Put #f1, , en1
Wend
Close #F
Close #f1

End Sub

Rem $DYNAMIC
Function digprn$(t As Integer)
Dim dig As Integer, dig2 As Integer, tim$

dig = Int(t / 10)
tim$ = onechar$(dig)
dig2 = Int(t - dig * 10)
tim$ = tim$ + onechar$(dig2)
digprn$ = tim$
End Function '----*************************************************************

Function entry_count(eventnumber As Integer)
Dim swcnt As Integer, i As Integer, j As Integer, k As Integer
Dim kmax As Integer, found As Integer

swcnt = 0
For i = 1 To md.nswim              'construct array of swimmers from records
 k = swmr(i).eventpoint        'first event in event array belonging to this swimmer
 found = False
 j = 1
 While (k > 0) And (Not found)
   If entries(k).evnum = eventnumber Then
     swcnt = swcnt + 1
     found = True
   End If
   k = entries(k).nextpnt
 Wend
Next i
If swcnt = 0 Then
  entry_count = 0
Else
  entry_count = swcnt '- 1
End If

End Function

Function filexist(F$) As Integer
filexist = (Len(Dir$(F$)) > 0)

End Function

Function get_age_groups(minage() As Integer, maxage() As Integer)
Dim i As Integer, agcnt As Integer, found As Integer, jsave As Integer
Dim j As Integer

agcnt = 0
For i = 1 To md.numevents
  found = False
  j = 1
  While (j <= agcnt) And (Not found)
    found = (events(i).maxage = maxage(j))
    j = j + 1
  Wend
  If Not found Then
    agcnt = agcnt + 1
    minage(agcnt) = events(i).minage
    maxage(agcnt) = events(i).maxage
  End If
Next i
For i = 1 To agcnt
  For j = i To agcnt
    If maxage(i) > maxage(j) Then
      iSWAP maxage(i), maxage(j)
      iSWAP minage(i), minage(j)
    End If
  Next j
Next i
get_age_groups = agcnt
End Function

Function yes_no(s$) As Integer
If Trim$(UCase$(s$)) = "YES" Then
  yes_no = True
Else
  yes_no = False
End If
End Function

Function yesno$(y As Integer)
If y <> 0 Then
  yesno$ = "Yes"
Else
  yesno$ = "No"
End If

End Function

