VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SDIFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private sdi_filename As String
'meet information
Private meet_name As String
Private meet_location As String
Private meet_date As Date
Private meet_course As Integer, meas As String
Private mtype As Integer

Private numsessions As Integer
Private swim_keys() As Integer
Private sfl As Integer
Private db As dBase, rec As Recordset
Dim Index As Integer, swim_eof As Boolean
Dim clDate As New Dates
Dim stp As New Setup
Private meet_key As Integer
Dim evrec As Recordset
Private reqLSC As Boolean
Private IgnoreClub As Boolean
Private thisLSC As String

'unmatched swimmers stored here
Private noMatches As New Collection     'each name once
Private all_nomatches As New Collection 'all records stored here
Private strk As New stroke

'club management
Private clb As New Clubs
Private alias As Collection 'set by clubalias
Private club_code As String      'current club being processed

'variables used to manage splits
Private finalflag As Boolean        'import finals
Private bothflag As Boolean         'import prelims
Private split_flag As Boolean       'save splits if true
Private split_list() As Single      'array of split times
Private split_count As Integer      'number in array
Private stroke_key As Integer
Private club_key As Integer
Private stype As Integer
Private attached_flag As Boolean
Private eventkey As Long

'swimmers class
Private sw As New Swimmers

'relay data
Private rela As New RELAY
Private doing_relay As Boolean

'these mimic the constants in the SwimType table
Const PRELIMS = 1, FINALS = 2, TFINALS = 3, swimoff = 4, TIMETRIAL = 5, RELAY = 6
Const Yds = 1, Lcm = 2, Scm = 3 'must match course class--NOT SDI order

'SDI record types
Dim dum As Dum_rec
Dim a0 As Filedesc          'A0, used as general input field
Dim meetrec As MeetRecord   'B1
Dim clubrec As Team_ID      'C1
Dim d0 As Individual_event  'D0
Dim d3 As IndivInfoRec      'D3
Dim e0 As Relay_event       'E0
Dim f0 As Relay_Name     'F0
Dim g0 As Split_record      'G0

'current swimmer
Private prev_name As String         'name of last one read
Private swimmer_key As Integer
Private name_found As Boolean       'wether matched or not
Private relay_leg As Integer
Dim a0ahead(10) As Filedesc
Private lookPtr As Integer
Private agrp As New AgeGroup

Public Sub setDB(datab As dBase)
Set db = datab
ReDim split_list(70) As Single
End Sub
Public Sub setMeetType(m_type As Integer)
mtype = m_type
End Sub
Public Sub setLocation(locn$)
meet_location = locn$
End Sub
Public Sub setDescription(desc$)
meet_name = desc$
End Sub
Private Sub enter_relay_splits()
Dim i As Integer, nm$, lname$, frname$
Dim found As Boolean
Dim rec As Recordset
Dim dist As Integer, split_stroke As Integer
Dim t As Single
Dim split_dist As Integer

relay_leg = relay_leg + 1
nm$ = g0.Swimmername
  i = InStr(nm$, ",")
  If i > 0 Then
    lname$ = Left$(nm$, i - 1)
    frname$ = Trim$(Right$(nm$, Len(nm$) - i))
  End If
  Set rec = sw.findSwimmer(lname$, frname$, club_code, g0.init, val(g0.cbirth), "", name_found)
  
  If name_found Then
    swimmer_key = rec![SwimmerKey]
    club_key = clb.findKey(club_code)
    rela.addSwimmer eventkey, rec![SwimmerKey], relay_leg
    If relay_leg = 1 Then
      load_splitlist
   dist = evrec![Distance]
   If evrec![strokekey] = MEDRELAY Then
     split_stroke = BACK
   Else
     split_stroke = FREE
   End If
   t = 0
   Select Case dist
     Case 200
       If split_count = 1 Then t = split_list(1)
       If split_count = 2 Then t = split_list(2)
       split_dist = 50
     Case 400
       If split_count = 2 Then t = split_list(2)
       If split_count = 4 Then t = split_list(4)
       If split_count = 16 Then t = split_list(4)
       split_dist = 100
     Case 800
       If split_count = 4 Then t = split_list(4)
       If split_count = 8 Then t = split_list(8)
       If split_count = 32 Then t = split_list(8)
       split_dist = 200
   End Select
   If t <> 0 Then
     evrec.AddNew
     evrec![SwimmerKey] = swimmer_key
     evrec![strokekey] = split_stroke
     evrec![clubkey] = club_key
     evrec![Distance] = split_dist
     evrec![SwimTime] = t
     evrec![SplitEventKey] = eventkey
     evrec![SwimType] = stype
     evrec![coursekey] = meet_course
     evrec![meetKey] = meet_key
     evrec![attached] = True
     evrec.Update
    End If
  
    End If
  End If
End Sub
Private Sub load_splitlist()
Dim i As Integer, valid As Boolean, t As Single
'copies first few splits from split record in g0
split_count = val(g0.total_splits)
i = 1
While Trim$(g0.Split_time(i)) <> "" And i <= 10
    t = getRealTime(g0.Split_time(i), valid)
    If valid Then split_list(i) = t
    i = i + 1
Wend

End Sub
Public Sub Import(file$, AddUnmatched As Boolean)
Dim mt As New Meets
Dim found As Boolean, Quit As Boolean, newmeet As Boolean
Dim cb$, lsc$, ans As Integer
Dim lastname$

'find the key for this meet: it will usually be new
mt.setDB db
meet_key = mt.findKey(meet_name, meet_location, meet_date, meet_course, newmeet, mtype)
ans = vbYes
If Not newmeet Then
 ans = MsgBox("A meet with this name and date has already been imported." + Chr(13) + _
   "Do you want to continue anyway?", vbYesNo, "Duplicate meet")
End If
 If ans = vbYes Then

sdi_filename = file$
clb.setDB db
clb.openClubs       'club lookup
rela.setDB db

'read in the meet file and meet data
readMeet file$    'read in meet and data
mt.setLocation meet_location
mt.setDescription meet_name
mt.setCourse meet_course
'now match clubs for legal initials
makeClubList
Screen.MousePointer = vbHourglass

lastname = ""
lookPtr = 0
Set evrec = db.openTableRecord("Events")
sw.setDB db
openSDIFile
getNextRec
If a0.rectype = "A0" Then     'legal file
  Quit = False
 While Not EOF(sfl) And Not Quit
   getNextRec
   Select Case a0.rectype
     Case "C1"
      LSet clubrec = a0
      club_code = getClubName(clubrec, lsc$)
      club_key = clb.findKey(club_code)
       If club_key = 0 Then
           club_code = findAlias(club_code)
           club_key = clb.findKey(club_code)
           doing_relay = False
           relay_leg = 0
       End If
       'If reqLSC And Left$(clubrec.TeamCode, 2) = stp.getLSC Then
       ' club_key = 1     'non-zero for zone meets
       'End If

     Case "D0"
      LSet d0 = a0
      If d0.Swimmername <> lastname Then
        lastname = d0.Swimmername
        lookAhead
        If a0.rectype = "D3" Then
          LSet d3 = a0
        End If
      End If
      If club_key > 0 Or IgnoreClub Then
        doing_relay = False
        relay_leg = 0
        enter_kid AddUnmatched
      End If
      
      Case "D3"
        LSet d3 = a0        'save for d0 entries
      
     Case "G0"
      LSet g0 = a0
       If Not doing_relay Then
            enter_splits    'uses d0 and g0
       Else
            enter_relay_splits
       End If
     Case "E0"
      LSet e0 = a0
      If club_key > 0 Then
        doing_relay = True
        relay_leg = 0
        enter_relay    'uses relayeven
      End If
     Case "F0"
      LSet f0 = a0
      If club_key > 0 Then enter_relayname 'uses relayname
    End Select
 Wend
Else
  MsgBox "Not a USS SDI File"
End If
Screen.MousePointer = vbDefault

UnmatchedSwmrs.setCollection noMatches
UnmatchedSwmrs.setDB db
UnmatchedSwmrs.setsdi Me
UnmatchedSwmrs.Show vbModal
End If  'not new
End Sub
Public Sub enter_relay()
Dim club As String, j As Integer, relayswimmerkey As Integer

  club_key = clb.findKey(club_code)
  If club_key = 0 And club_code <> "none" Then
   club_code = alias.Item(club_code)
   club_key = clb.findKey(club_code)
  End If
  If club_key = 0 And reqLSC Then
    club = stp.getLSC
  Else
  club = clb.getName(club_code)
  End If
  Set rec = sw.findName(club)
  If rec.RecordCount = 0 Then
   Set rec = db.openTableRecord("Swimmers")
   rec.AddNew
   rec![Name] = Left$(club, rec![Name].Size)
   rec![lastname] = ""
   rec![Firstname] = ""
   j = InStr(club, " ")
   If j > 0 Then
     rec![lastname] = Left$(Left$(club, j - 1), rec![lastname].Size)
     rec![Firstname] = Left$(Right$(club, Len(club) - j), rec![Firstname].Size)
   End If
   rec![clubkey] = club_key
   rec.Update
   rec.Bookmark = rec.LastModified
  End If
  relayswimmerkey = rec![SwimmerKey]
  add_RelayEvent relayswimmerkey
End Sub
Public Sub enter_relayname()

End Sub
Public Sub setMatched(matched As Collection)
Dim swm As Integer, i As Integer, j As Integer, k As Integer
Dim key As Integer, s$, swname As String, thisname As String
Dim thisd0 As String
'each line in collection contains a swimmer key
'followed by a dash, followed by a swimmer name
For swm = 1 To matched.count
  s$ = matched.Item(swm)
  i = InStr(s$, "-")
  If i > 0 Then
    swimmer_key = val(Left$(s$, i - 1))
    swname = Trim$(Right$(s$, Len(s$) - i))
    j = InStr(swname, "-")
    If j > 0 Then
      swname = Trim$(Left$(swname, j - 1))
    End If
    For j = 1 To all_nomatches.count
       thisd0 = all_nomatches(j)
       For k = 1 To Len(thisd0)
         Mid$(dum.dummy, k, 1) = Mid$(thisd0, k, 1)
       Next k
       LSet d0 = dum
       thisname = Trim$(d0.Swimmername)
       If thisname = swname Then
         Set rec = sw.findKey(swimmer_key)
         If Not rec.BOF Then
         club_key = rec![clubkey]
         add_indiv_event
         End If
       End If
    Next j
  End If
Next swm

End Sub
Private Sub enter_kid(AddUnmatched As Boolean)
Dim nm$, lname$, frname$
Dim i As Integer, ans As Integer, thisd0 As String
Dim j As Integer

'uses contents of current d0 record
nm$ = Trim$(d0.Swimmername)
ImportMeet.Status.Caption = nm$
ImportMeet.Status.Refresh

ans = DoEvents      'allow interrupts
If (Not reqLSC) Or (reqLSC And d0.lsc = thisLSC) Then
If nm$ <> prev_name$ Then
  i = InStr(nm$, ",")
  If i > 0 Then
    lname$ = Left$(nm$, i - 1)
    frname$ = Trim$(Right$(nm$, Len(nm$) - i))
    j = Len(frname)
    If Mid$(frname, j - 1, 1) = " " Then 'remove initial
      frname = Trim$(Left$(frname, j - 1))
    End If
  End If
  Set rec = sw.findSwimmer(lname$, frname$, club_code, d0.init, val(d0.cbirth), d3.USSNum, name_found)
  If name_found Then
    swimmer_key = rec![SwimmerKey]
    add_indiv_event      'uses d0 and swimmerkey
  Else
   If AddUnmatched Then
     Set rec = sw.addSwimmer(lname$, frname$, club_key, 1)
     swimmer_key = rec![SwimmerKey]
     add_indiv_event      'uses d0 and swimmerkey
   Else
    noMatches.Add nm$ & " - " & club_code
    LSet dum = d0
    thisd0 = dum.dummy
    all_nomatches.Add thisd0
   End If
  End If
Else
  If name_found Then
     add_indiv_event        'else add to current swimmer
  Else
    LSet dum = d0
    thisd0 = dum.dummy
    all_nomatches.Add thisd0   'all unmatched records to this collection
  End If
End If
End If
prev_name = nm$
End Sub
Private Sub add_indiv_event()
'adds one event result for current swimmer and club
Dim t As Single, valid As Boolean, stype As Integer
Dim ckey As Integer, age As Integer

t = getTime(valid, stype, ckey)
If valid Then
 If Not IsNull(rec![Birthday]) Then
  age = agrp.calcAge(rec![Birthday], meet_date)
  End If
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    stroke_key = val(d0.stroke)   'NOTE this depends on order being the same
    evrec![strokekey] = stroke_key
    evrec![coursekey] = ckey
    evrec![Distance] = val(d0.dist)
    evrec![meetKey] = meet_key
    attached_flag = (d0.attached = "A")
    evrec![attached] = attached_flag
    evrec![coursekey] = ckey 'meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![age] = age
    evrec![SplitEventKey] = 0
    evrec.Update        'don't save if invalid
    evrec.Bookmark = evrec.LastModified
    eventkey = evrec![eventkey]
End If
End Sub
Private Sub add_RelayEvent(relaykey)
'adds one event result for current swimmer and club
Dim t As Single, valid As Boolean, stype As Integer
Dim ckey As Integer

t = getRelayTime(valid, stype, ckey)
If valid Then
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = relaykey
    stroke_key = val(e0.stroke)   'NOTE this depends on order being the same
    evrec![strokekey] = stroke_key
    evrec![coursekey] = ckey
    evrec![Distance] = val(e0.dist)
    evrec![meetKey] = meet_key
    attached_flag = True
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = 0
    evrec.Update        'don't save if invalid
    evrec.Bookmark = evrec.LastModified
    eventkey = evrec![eventkey]
End If
End Sub
Private Function getTime(valid As Boolean, stype As Integer, course_key As Integer) As Single
Dim result As Single, Final As Single
Dim fvalid As Boolean, rvalid As Boolean
Dim rkey As Integer, fkey As Integer
'checks settings of bothflag and finalflag and
'returns either the fastest of the two or
'the desired legal time. Valid is false if not legal

  result = getRealTime(d0.Prelim, rvalid)
  Final = getRealTime(d0.Final, fvalid)
  rkey = getCourseKey(d0.prelimcourse)
  If rkey = 0 Then rvalid = False       'mean's DQ'd
  fkey = getCourseKey(d0.finalcourse)
  If fkey = 0 Then fvalid = False
If bothflag = False And finalflag = False Then
  If rvalid Then
    getTime = result
    valid = True
    course_key = rkey
  End If
  If fvalid And Not rvalid Then
    getTime = Final
    stype = PRELIMS
    valid = True
    course_key = fkey
  End If
End If
If (Not bothflag) And finalflag Then
  getTime = Final
  stype = FINALS
  course_key = fkey
End If
If bothflag Then
  If Not fvalid And rvalid Then
    getTime = result
    valid = rvalid
    stype = PRELIMS
    course_key = rkey
  End If
  If Not rvalid And fvalid Then
    getTime = Final
    valid = fvalid
    stype = PRELIMS
    course_key = fkey
  End If
  If fvalid And rvalid Then
    If result < Final Then
      getTime = result
      stype = PRELIMS
      course_key = rkey
    Else
      getTime = Final
      stype = FINALS
      course_key = fkey
    End If
    valid = True
  End If
End If
End Function
Private Function getRelayTime(valid As Boolean, stype As Integer, course_key As Integer) As Single
 Dim result As Single, Final As Single
Dim fvalid As Boolean, rvalid As Boolean
Dim rkey As Integer, fkey As Integer
  result = getRealTime(e0.Prelim, rvalid)
  Final = getRealTime(e0.Final, fvalid)
  rkey = getCourseKey(e0.prelimcourse)
  If rkey = 0 Then rvalid = False       'mean's DQ'd
  fkey = getCourseKey(e0.finalcourse)
  If fkey = 0 Then fvalid = False
If bothflag = False And finalflag = False Then
  If rvalid Then
    getRelayTime = result
    valid = True
    course_key = rkey
  End If
  If fvalid And Not rvalid Then
    getRelayTime = Final
    stype = PRELIMS
    valid = True
    course_key = fkey
  End If
End If
If (Not bothflag) And finalflag Then
  getRelayTime = Final
  stype = FINALS
  course_key = fkey
End If
If bothflag Then
  If Not fvalid And rvalid Then
    getRelayTime = result
    valid = rvalid
    stype = PRELIMS
    course_key = rkey
  End If
  If Not rvalid And fvalid Then
    getRelayTime = Final
    valid = fvalid
    stype = PRELIMS
    course_key = fkey
  End If
  If fvalid And rvalid Then
    If result < Final Then
      getRelayTime = result
      stype = PRELIMS
      course_key = rkey
    Else
      getRelayTime = Final
      stype = FINALS
      course_key = fkey
    End If
    valid = True
  End If
End If

End Function
Public Function getMeetCourse() As String
Select Case meet_course
  Case 1
    getMeetCourse = "YDS"
  Case 2
    getMeetCourse = "LCM"
  Case 3
    getMeetCourse = "SCM"
End Select
End Function
Private Function getCourseKey(s$)
Select Case s$
  Case "2", "Y"
   getCourseKey = Yds
  Case "3", "L"
   getCourseKey = Lcm
  Case "1", "S"
   getCourseKey = Scm
  Case "X"
    getCourseKey = 0    'DQ's
 End Select
End Function
Private Function getRealTime(s As String, valid As Boolean) As Single
Dim i As Integer, t As Single
i = InStr(s, ":")
If i > 0 Then
  s = Trim$(Left$(s, i - 1) + Right$(s, Len(s) - i))
End If
t = val(s)
If t > 0 Then
  valid = True
  getRealTime = t
Else
  valid = False
  getRealTime = 0
End If
End Function
Private Sub enter_splits()
Dim i As Integer, sfirst As Integer, j As Integer
Dim valid As Boolean, ftime As Single
 If club_key > 0 And name_found Then
  split_count = val(g0.total_splits)
  i = 1
  j = 1
  sfirst = 0
  While i <= split_count
    While i <= split_count And j <= 10
     split_list(i) = getRealTime(g0.Split_time(j), valid)
     i = i + 1
     j = j + 1
    Wend
    If i < split_count Then
      'Get #sfl, , g0
      getNextRec
      LSet g0 = a0
      j = 1
    End If
  Wend
 ftime = evrec![SwimTime]
  If split_list(split_count) = ftime Then 'allow splits to be added
    Select Case evrec![Distance]
      Case 100
        save_100s eventkey
      Case 200
        save_200s eventkey
      Case 400
        save_400s eventkey
      Case 500
        save_500s eventkey
      Case 800
        save_800s eventkey
      Case 1000
        save_1000s eventkey
      Case 1500
        save_1500s eventkey
      Case 1650
        save_1650s eventkey
    End Select
  End If
 End If

End Sub
Private Sub save_100s(eventkey As Long)
If stroke_key <> IM Then
  If split_count = 4 Then
    add_split_event eventkey, 50, split_list(2)
  End If
  If split_count = 2 Then
    add_split_event eventkey, 50, split_list(1)
  End If
End If
End Sub
Private Sub save_200s(eventkey As Long)
If stroke_key <> IM Then
 If split_count = 4 Then
  add_split_event eventkey, 100, split_list(2)
 End If
 If split_count = 8 Then
  add_split_event eventkey, 100, split_list(4)
 End If
End If
End Sub
Private Sub save_500s(eventkey As Long)
If split_count = 10 Then
  add_split_event eventkey, 200, split_list(4)
End If
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(8)
End If
End Sub
Private Sub save_400s(eventkey As Long)
If stroke_key = IM Then
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(1), FLY
  End If
  If split_count = 8 Then
    add_split_eventAndStroke eventkey, 100, split_list(2), FLY
  End If
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(4), FLY
  End If
Else
  If split_count = 4 Then
    add_split_event eventkey, 100, split_list(1)
    add_split_event eventkey, 200, split_list(2)
  End If
  If split_count = 8 Then
    add_split_event eventkey, 100, split_list(2)
    add_split_event eventkey, 200, split_list(4)
  End If
  If split_count = 16 Then
    add_split_event eventkey, 100, split_list(4)
    add_split_event eventkey, 200, split_list(8)
  End If
End If
End Sub
Private Sub save_800s(eventkey As Long)
If split_count = 8 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 400, split_list(4)
End If
If split_count = 16 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 400, split_list(8)
End If
End Sub
Private Sub save_1000s(eventkey As Long)
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 500, split_list(10)
End If
If split_count = 40 Then
  add_split_event eventkey, 200, split_list(8)
  add_split_event eventkey, 400, split_list(20)
End If
End Sub
Private Sub save_1500s(eventkey As Long)
If split_count = 15 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 800, split_list(8)
End If
If split_count = 30 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 800, split_list(16)
End If
End Sub
Private Sub save_1650s(eventkey As Long)
If split_count = 33 Then
  add_split_event eventkey, 500, split_list(10)
  add_split_event eventkey, 1000, split_list(20)
End If
If split_count = 66 Then
  add_split_event eventkey, 500, split_list(20)
  add_split_event eventkey, 1000, split_list(40)
End If
End Sub
Private Sub add_split_event(evkey As Long, dist As Integer, t As Single)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.Update
End Sub
Private Sub add_split_eventAndStroke(evkey As Long, dist As Integer, t As Single, stroke_key As Integer)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.Update
End Sub
Public Sub importBoth()
  bothflag = True
End Sub
Public Sub importPrelims()
  bothflag = False
  finalflag = False
End Sub
Public Sub importFinals()
  finalflag = True
  bothflag = False
End Sub
Public Sub setSplits(savesplits As Boolean)
 split_flag = savesplits
End Sub

Public Sub makeClubList()
Dim i As Integer, club_count As Integer
Dim cmax As Integer, cb$, j As Integer
Dim found As Boolean, key As Integer, lsc$
'make a table of all the clubs in the meet
'belonging to this LSC or having no spec'd LSC


cmax = 100
club_count = 0
ReDim club_names(cmax) As String
openSDIFile
While Not EOF(sfl)
 'Get #sfl, , dum
 getNextRec
 LSet dum = a0
 If Left$(dum.dummy, 2) = "C1" Then
  LSet clubrec = dum
  cb$ = getClubName(clubrec, lsc$)
  If lsc$ = "" Or lsc$ = stp.getLSC Then
    found = False
    j = 1
    While j <= club_count And Not found
     found = cb$ = club_names(j)
     j = j + 1
    Wend
    If Not found Then
      club_count = club_count + 1
      If club_count > cmax Then
        cmax = cmax + 50
        ReDim Preserve club_names(cmax) As String
      End If
      club_names(club_count) = cb$
    End If
  End If '   If in LSC
 End If 'if C1 record
Wend
'now filter for legal clubs
For i = 1 To club_count
 key = clb.findKey(club_names(i))
 If key <> 0 Then
   club_names(i) = ""   'erase those which are found
 End If
Next i
'load remainder into a collection and pass it to
'the alias form
Dim colClubs As New Collection
For i = 1 To club_count
  If club_names(i) <> "" Then
    colClubs.Add club_names(i), club_names(i)
  End If
Next i
If colClubs.count > 0 Then  'bring up alias box
  ClubAlias.setBadClubs colClubs
  ClubAlias.setDB db
  ClubAlias.Show vbModal
  Set alias = ClubAlias.getAliases
  Unload ClubAlias
End If

End Sub
Private Function getClubName(clubrec As Team_ID, lsc$) As String
Dim c$
  c$ = RTrim$(clubrec.TeamCode + clubrec.ExtendedTeamCode)
  lsc$ = Trim$(Left$(c$, 2))
  getClubName = Right$(c$, Len(c$) - 2)
End Function
Private Sub openSDIFile()

sfl = FreeFile
'Open sdi_filename For Binary As #sfl Len = Len(dum)
Open sdi_filename For Input As #sfl
End Sub
Private Sub closeSDIFIle()
Close #sfl
End Sub
Private Function findAlias(club_code As String) As String
On Local Error GoTo noclub
findAlias = alias.Item(club_code)
okclub:
Exit Function

noclub:
  findAlias = "none"
  Resume okclub
End Function
Public Sub readMeet(file$)
Dim found As Boolean, m$, typ$
Dim locn$, mname$ 'not used
sdi_filename = file$
openSDIFile
found = False
While Not EOF(sfl) And Not found
  'Get #sfl, , dum
  getNextRec
  LSet dum = a0
  If Left$(dum.dummy, 2) = "B1" Then
    found = True
    LSet meetrec = dum
  End If
Wend
meet_name = Trim$(meetrec.Meetname)
meet_location = Trim$(meetrec.city) + ", " + Trim$(meetrec.state)
typ$ = Trim$(meetrec.reserved)
Select Case typ$
  Case "Y"
    meet_course = 1
  Case "M", "L"
    meet_course = 2
  Case "S"
    meet_course = 3
End Select
m$ = meetrec.Startdate

m$ = Left$(m$, 2) + "-" + Mid$(m$, 3, 2) + "-" + Right$(m$, 4)
clDate.setStringDate m$
meet_date = clDate.getDate
closeSDIFIle
End Sub
Public Function Meetname() As String
Meetname = meet_name
End Function
Public Function MeetLocation() As String
MeetLocation = meet_location
End Function
Public Function getDate() As Date
getDate = meet_date
End Function
Public Sub setCourse(c$)
Dim crs As New course
crs.setDB db
meet_course = crs.findKey(c$)
End Sub
Public Sub setLSC(lsc As String, req_LSC As Boolean, ignore_club As Boolean)
reqLSC = req_LSC
thisLSC = lsc
IgnoreClub = ignore_club
End Sub

Private Sub Class_Initialize()
reqLSC = False
End Sub
Private Sub getNextRec()
Dim s$
Dim thisdum As Dum_rec
If lookPtr > 0 Then
  a0 = a0ahead(lookPtr)
  lookPtr = lookPtr - 1
Else
    'Get #sfl, , a0
    Do
    Line Input #sfl, s$
    s$ = Trim(s$)
    Loop Until Len(s$) > 0 Or EOF(sfl)
    thisdum.dummy = s$
    LSet a0 = thisdum
    
End If
End Sub
Private Sub lookAhead()
'Get #sfl, , a0
getNextRec
lookPtr = lookPtr + 1
a0ahead(lookPtr) = a0
End Sub
