VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Menu 
   Caption         =   "DBSwim"
   ClientHeight    =   4560
   ClientLeft      =   735
   ClientTop       =   1110
   ClientWidth     =   7860
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4560
   ScaleWidth      =   7860
   Begin VB.CommandButton Showmeets 
      Caption         =   "ShowMeets"
      Height          =   375
      Left            =   1920
      TabIndex        =   5
      Top             =   3960
      Width           =   1095
   End
   Begin VB.CommandButton showTimes 
      Caption         =   "Show times"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3360
      TabIndex        =   3
      ToolTipText     =   "Show /edit all swimmer times"
      Top             =   3960
      Width           =   1095
   End
   Begin VB.ListBox Swmrlist 
      Height          =   3180
      Left            =   2640
      TabIndex        =   2
      ToolTipText     =   "Double click to show times"
      Top             =   480
      Width           =   4575
   End
   Begin VB.ListBox ClubList 
      Height          =   3180
      Left            =   840
      TabIndex        =   0
      ToolTipText     =   "Select club to show its swimmers"
      Top             =   480
      Width           =   1575
   End
   Begin MSComDlg.CommonDialog cDlg 
      Left            =   480
      Top             =   3960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FontSize        =   2.24051e-38
   End
   Begin VB.Label regTo 
      Height          =   255
      Left            =   5040
      TabIndex        =   4
      Top             =   4080
      Width           =   2655
   End
   Begin VB.Label Status 
      Height          =   255
      Left            =   2760
      TabIndex        =   1
      Top             =   120
      Width           =   4095
   End
   Begin VB.Menu mnufile 
      Caption         =   "&File"
      Begin VB.Menu mnuopen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuCreate 
         Caption         =   "&Create"
      End
      Begin VB.Menu mnuupdate 
         Caption         =   "&Update from USS Files"
         Begin VB.Menu updateClubs 
            Caption         =   "Update Clubs"
         End
         Begin VB.Menu updateSwimmers 
            Caption         =   "Update Swimmers"
         End
      End
      Begin VB.Menu mnuC 
         Caption         =   "Convert"
         Begin VB.Menu mnuconvert 
            Caption         =   "Swimmer names to mixed case"
         End
         Begin VB.Menu mnucnvclubs 
            Caption         =   "Club names to mixed case"
         End
      End
      Begin VB.Menu mnuaddmeet 
         Caption         =   "Add meet to list"
      End
      Begin VB.Menu mnumaint 
         Caption         =   "Maintenance"
         Begin VB.Menu mnuremovedupes 
            Caption         =   "Remove duplicate times"
         End
         Begin VB.Menu mnuRemoveZero 
            Caption         =   "Remove Zero times"
         End
         Begin VB.Menu mnuCompact 
            Caption         =   "Compact database"
         End
         Begin VB.Menu mnuCountSwim 
            Caption         =   "Count swimmers in txt file"
         End
         Begin VB.Menu mnuComputeAges 
            Caption         =   "Compute ages for each swim"
         End
      End
      Begin VB.Menu mnusep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuimport 
      Caption         =   "&Import"
      Begin VB.Menu ImportLSA 
         Caption         =   "Import &LSA Files"
      End
      Begin VB.Menu importSDI 
         Caption         =   "Import &SDI Files"
      End
      Begin VB.Menu mnuEmail 
         Caption         =   "Import Email addresses"
      End
   End
   Begin VB.Menu mnuexport 
      Caption         =   "&Export"
      Begin VB.Menu mnuclublist 
         Caption         =   "Club/Team lists"
      End
      Begin VB.Menu mnuteam 
         Caption         =   "Team files"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu viewMeets 
         Caption         =   "Meets imported"
      End
      Begin VB.Menu vewMeetTypes 
         Caption         =   "Meet types"
      End
      Begin VB.Menu mnubest 
         Caption         =   "Best times"
      End
      Begin VB.Menu mnuswimmer_details 
         Caption         =   "Swimmer details"
      End
      Begin VB.Menu mnuViewTeams 
         Caption         =   "Teams"
      End
      Begin VB.Menu mnuStats 
         Caption         =   "Statistics"
      End
      Begin VB.Menu mnudash4 
         Caption         =   "-"
      End
      Begin VB.Menu mnusearch 
         Caption         =   "Search"
      End
   End
   Begin VB.Menu mnuprint 
      Caption         =   "&Print"
      Begin VB.Menu mnuprintClub 
         Caption         =   "Print &Club members"
      End
      Begin VB.Menu printClubList 
         Caption         =   "Print &List of clubs"
      End
   End
   Begin VB.Menu mnusetup 
      Caption         =   "&Setup"
      Begin VB.Menu setupLSC 
         Caption         =   "Set up LSC parameters"
      End
      Begin VB.Menu setupPrinters 
         Caption         =   "Setup Printers"
      End
      Begin VB.Menu relationships 
         Caption         =   "relations"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu helpUsing 
         Caption         =   "Using DBSwim"
      End
      Begin VB.Menu mnuRegister 
         Caption         =   "Register dbSwim"
      End
      Begin VB.Menu mnuabout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "Menu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private db As New dBase
Private clb As New Clubs
Private swmrs As New Swimmers
Private crs As New course
Private mt As New Meets
Private strk As New stroke
Private evnt As New Events
Private rly As New RELAY
Private mtevents As New MeetEvents
'Private splt As New Splits
Private mtype As New MeetType
Private styp As New SwimType
Private reln As New Relations
Private recs As New records
Private rectypes As New RecordType
Private regStatus As New RegisterStatus
Private SwimDBPath As String
Private SwimDBFile As String
Private filename As String
Private stp As New Setup
Private pr As New clsPrinters
Dim rec As Recordset

Private Sub setDBs()
'set db pointer into all classes
clb.setDB db
swmrs.setDB db
crs.setDB db
mt.setDB db
strk.setDB db
rly.setDB db
'splt.setDB db
styp.setDB db
reln.setDB db
evnt.setDB db
mtype.setDB db
recs.setDB db
rectypes.setDB db
regStatus.setDB db
mtevents.setDB db
End Sub

Private Sub ClubList_Click()
Dim qry$, club$ ', rec As Recordset
Dim i As Integer

club$ = ClubList.Text
qry$ = "SELECT DISTINCTROW Swimmers.swimmerkey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE (((Clubs.ClubCode)='" + club$ + "')) order by swimmers.lastname;"
Set rec = db.openRecord(qry$)
Swmrlist.Clear
While Not rec.EOF
  Swmrlist.AddItem rec![lastname] & ", " & rec![Firstname]
  i = Swmrlist.ListCount - 1
  Swmrlist.ItemData(i) = rec![SwimmerKey]
  rec.MoveNext
Wend
rec.Close
showTimes.Enabled = False
End Sub
Public Sub setClub(club$)
Dim found As Boolean, i As Integer, j As Integer
i = 0
found = False
While Not found And i < ClubList.ListCount
  tx$ = ClubList.List(i)
  j = InStr(tx$, club$)
  If j > 0 Then
    ClubList.ListIndex = i
    found = True
  Else
   i = i + 1
  End If
Wend
End Sub
Private Sub Form_Load()
Dim ini As New Profile

'first check for registration
'read in registration info from swim4.ini
ini.setFilename "swim4.ini"
'nm$ = Register.decodename(ini.getProfile("dbRegistration11", "Name", "none"))
'REG$ = (ini.getProfile("dbRegistration11", "Code", "none"))
'dt$ = Register.decodename(ini.getProfile("dbRegistration11", "Date", ""))

'cname = val(Register.make_code(nm$))
'creg = val(Register.decodename(REG$))
'If cname <> creg Then
' Register.Show vbModal
' nmstring$ = ini.getProfile("dbRegistration11", "Name", "none")
' nm$ = Register.decodename$(nmstring$)
'End If
'If nmstring$ = "none" Then
' regTo.Caption = "Unregistered copy"
'Else
' regTo.Caption = "Licensed to: " + nm$
'End If

openDatabase
End Sub
Private Sub openDatabase()
SwimDBPath = stp.getPath
filename = stp.getFileName + ".mdb"
SwimDBFile = SwimDBPath + filename
Caption = "DbSwim 1.2: " + SwimDBPath + filename
If Len(Dir$(SwimDBFile)) > 0 Then
  db.openDB (SwimDBFile)
  If db.opened Then
    setDBs
    clb.openClubs
    While Not clb.EndFile
     ClubList.AddItem clb.NextClub
    Wend
    If ClubList.ListCount > 0 Then
        ClubList.ListIndex = 0
    End If
  End If
End If

End Sub

Private Sub loadClublist()
 clb.openClubs
  While Not clb.EndFile
    ClubList.AddItem clb.NextClub
  Wend
End Sub
Private Sub ImportLSA_Click()
ImportMeet.setDB db
ImportMeet.setLSA
ImportMeet.Show vbModal
End Sub

Private Sub importSDI_Click()
ImportMeet.setDB db
ImportMeet.setsdi
ImportMeet.Show vbModal
End Sub

Private Sub mnuabout_Click()
About.Show
End Sub

Private Sub mnuaddmeet_Click()
addMeet.setDB db
addMeet.Show vbModal
End Sub

Private Sub mnubest_Click()
AgeGrpSwim.setDB db
AgeGrpSwim.Show
End Sub

Private Sub mnuclublist_Click()
cDlg.DialogTitle = "Select directory for clublists"
cDlg.filename = "clubs.htm"
cDlg.CancelError = True
On Local Error GoTo mnuclubquit
cDlg.ShowSave
If Len(cDlg.filename) > 0 Then
    Screen.MousePointer = vbHourglass
  clb.makeFiles cDlg.filename
End If
mnuclubexit:
Screen.MousePointer = vbDefault
Exit Sub
mnuclubquit:
 Resume mnuclubexit
End Sub

Private Sub mnucnvclubs_Click()
Screen.MousePointer = vbHourglass
 clb.mixedConvert
Screen.MousePointer = vbDefault
End Sub

Private Sub mnuCompact_Click()
Dim dp As New Dupes
dp.setDB db
dp.compact

End Sub

Private Sub mnuComputeAges_Click()
Dim evrec As Recordset, mtkey As Long, KidKey As Long
Dim swrec As Recordset, mtrec As Recordset
Dim Mtdate As Date, Birthday As Date, mtyear As Integer, byear As Integer
Dim bmoday As Integer, mtmoday As Integer, age As Integer
Dim agrp As New AgeGroup

Screen.MousePointer = vbHourglass
Set evrec = db.openTableRecord("Events")
Set swrec = db.openTableRecord("Swimmers")
Set mtrec = db.openTableRecord("Meets")
swrec.Index = "SwimmerKey"
mtrec.Index = "MeetKey"
While Not evrec.EOF
  mtkey = evrec![meetKey]
  KidKey = evrec![SwimmerKey]
  swrec.Seek "=", KidKey
  mtrec.Seek "=", mtkey
  If Not swrec.NoMatch And Not mtrec.NoMatch Then
   If Not IsNull(swrec![Birthday]) And Not IsNull(mtrec![MeetDate]) Then
    
    Birthday = swrec![Birthday]
    Mtdate = mtrec![MeetDate]
    age = agrp.calcAge(Birthday, Mtdate)
    
    evrec.Edit
    evrec![age] = age
    evrec.Update
    End If
   End If
  evrec.MoveNext
Wend
Screen.MousePointer = vbDefault
evrec.Close
mtrec.Close
swrec.Close
End Sub

Private Sub mnuconvert_Click()
Screen.MousePointer = vbHourglass
swmrs.makeMixedCase
Screen.MousePointer = vbDefault
End Sub

Private Sub mnuCountSwim_Click()
Dim f As Integer, count As Integer, max As Integer
Dim dimmax As Integer, i As Integer, j As Integer, tmp As Integer
dimmax = 200
ReDim nums(dimmax) As Integer, renums(dimmax) As Integer
cDlg.Filter = "Text files|*.txt"
cDlg.ShowOpen
If Len(cDlg.filename) > 0 Then
  f = FreeFile
  i = 1
  Open cDlg.filename For Input As #f
  While Not EOF(f)
    Input #f, nums(i)
    i = i + 1
    If i > dimmax Then
      dimmax = dimmax + 100
      ReDim Preserve nums(dimmax) As Integer, renums(dimmax) As Integer
    End If
  Wend
  max = i - 1
  Close #f
  For i = 1 To max
    For j = i To max
      If nums(i) > nums(j) Then
        tmp = nums(i)
        nums(i) = nums(j)
        nums(j) = tmp
      End If
    Next j
  Next i
  i = 1
  j = 1
  renums(j) = nums(i)
  For i = 1 To max
    If nums(i) <> renums(j) Then
      j = j + 1
      renums(j) = nums(i)
    End If
  Next i
MsgBox Str$(j) + " Swimmers"
 End If
End Sub

Private Sub mnuCreate_Click()
Dim fl As New file
'create each table in the database
Screen.MousePointer = vbHourglass
cDlg.filename = "SwimData.mdb"
cDlg.ShowSave
If cDlg.filename <> "" Then
fl.setFile cDlg.filename
stp.setFilename fl.rootName
stp.setPath fl.pathName

If db.opened Then
  db.CloseDB
End If
  db.createDB (SwimDBPath + stp.getFileName)
'  setDBs


clb.createTable db
swmrs.createTable db
crs.createTable db
mt.createTable db
strk.createTable db
rly.createTable db
'splt.createTable
styp.createTable db
evnt.createTable db
mtype.createTable db
recs.createTable db
rectypes.createTable db
regStatus.createTable db
mtevents.createTable db
setDBs
Screen.MousePointer = vbDefault
Status.Caption = "Database template created"
End If
End Sub

Private Sub mnuEmail_Click()
Dim f As Integer, filename As String
Dim s$, rec As Recordset, i As Integer
Dim team$, email$

cDlg.Filter = "Text files|*.txt"
cDlg.ShowOpen
filename = cDlg.filename
If Len(filename) > 0 Then
    Screen.MousePointer = vbHourglass
    Set rec = db.openTableRecord("Clubs")
    rec.Index = "Clubcode"
    f = FreeFile
    Open filename For Input As #f
    While Not EOF(f)
      Line Input #f, s$
      s$ = Trim$(s$)
      i = InStr(s$, " ")
      If i > 0 Then
         team$ = Left$(s$, i - 1)
         email$ = Right$(s$, Len(s$) - i)
         rec.Seek "=", team$
         If Not rec.NoMatch Then
           rec.Edit
           rec![clubEmail] = email$
           rec.Update
         End If
      End If
    Wend
    Close #f
End If
Screen.MousePointer = vbDefault
End Sub

Private Sub mnuExit_Click()
End
End Sub

Private Sub mnuopen_Click()
Dim fl As New file
cDlg.Filter = "Database files|*.mdb"
cDlg.ShowOpen
If cDlg.filename <> "" Then
  fl.setFile cDlg.filename
  stp.setFilename fl.rootName
  stp.setPath fl.pathName
  openDatabase
  Caption = "DBSwim: " + cDlg.filename
End If
End Sub

Private Sub mnuRegister_Click()
Register.Show vbModal
End Sub

Private Sub mnuremovedupes_Click()
Dim dp As New Dupes
Screen.MousePointer = vbHourglass
dp.setDB db
dp.remove
Screen.MousePointer = vbDefault
End Sub

Private Sub mnuRemoveZero_Click()
Dim trec As Recordset, qry$
If dbOpened Then
  Screen.MousePointer = vbHourglass
  qry$ = "SELECT Events.swimtime From Events WHERE (((Events.swimtime)=0));"
  Set trec = db.openRecord(qry$)
  While Not trec.EOF
   trec.Delete
   trec.MoveNext
  Wend
 Screen.MousePointer = vbDefault
Else
'  noDbErr
End If

End Sub

Private Sub mnusearch_Click()
swmrSearch.setDB db
swmrSearch.Show vbModal

End Sub
Private Sub mnuStats_Click()
Dim swrec As Recordset, rec As Recordset
Dim classes(20) As Integer      'stores histogram
Dim query$, f As Integer, Index As Integer
Dim fl As New file

Dim tstds As New TimeStandards
cDlg.Filter = "time standards|Times*.mdb"
cDlg.ShowOpen
If Len(cDlg.filename) > 0 Then
    tstds.setFile cDlg.filename
    fl.setFile cDlg.filename
    Set swrec = db.openTableRecord("Swimmers")
    swrec.MoveFirst

    While Not swrec.EOF
    If swrec![sex] = "M" Or swrec![sex] = "F" Then
    Menu.Status = swrec![Firstname] + " " + swrec![lastname]
    Menu.Status.Refresh
    query$ = "SELECT Events.StrokeKey, Events.Distance, Events.CourseKey, Events.SwimmerKey, Events.SwimTime, Meets.MeetDate " & _
    "FROM Meets INNER JOIN Events ON Meets.MeetKey = Events.MeetKey " & _
    "Where (((Events.SwimmerKey) = " + Str$(swrec![SwimmerKey]) + ")) and (events.swimtime>0) ORDER BY Events.StrokeKey, Events.Distance;"

    Set rec = db.openRecord(query$)
        While Not rec.EOF
          tstds.setCourseKey rec![coursekey]
          tstds.setAge val(Format$(rec![MeetDate] - swrec![Birthday], "yy"))
          tstds.setSex swrec![sex] & ""
            tstds.getTimeStandard rec![SwimTime], rec![strokekey], rec![Distance]
            Index = tstds.getClassKey
            classes(Index) = classes(Index) + 1
           rec.MoveNext
        Wend
    End If
    swrec.MoveNext
    Wend
End If
f = FreeFile
'Open "statlog.txt" For Output As #f
Open fl.pathName + fl.rootName + ".txt" For Output As #f
For i = 0 To 20
  Print #f, i, classes(i)
  Debug.Print i, classes(i)
Next i
Close #f
MsgBox "Done:" + Str$(classes(1))
End Sub

Private Sub mnuswimmer_details_Click()
Dim Index As Integer
Index = Swmrlist.ListIndex
If ClubList.ListIndex >= 0 Then
 SwimmerData.setClub ClubList.Text
 If Index >= 0 Then
   SwimmerData.setName Swmrlist.Text
 End If
SwimmerData.setDB db
 SwimmerData.Show
End If
End Sub

Private Sub mnuteam_Click()
Dim tm As New teamfile
cDlg.Filter = "*.txt"
cDlg.ShowOpen
If Len(cDlg.filename) > 0 Then
  tm.setDB db
  tm.buildTeam cDlg.filename
End If
End Sub

Private Sub mnuViewTeams_Click()
editTeams.setDB db
editTeams.Show vbModal
End Sub

Private Sub relationships_Click()
'create relation meet_event, meets,events, meetkey
db.createRelation "meet_event", "Meets", "Events", "Meetkey"
db.createRelation "Swimmer_event", "Swimmers", "Events", "Swimmerkey"
End Sub

Private Sub setupLSC_Click()
frmSetup.Show vbModal
End Sub

Private Sub setupPrinters_Click()
pr.setFonts
End Sub

Private Sub Showmeets_Click()
Dim i As Integer, key As Integer
i = Swmrlist.ListIndex
If i >= 0 Then
  key = val(Swmrlist.ItemData(i))
  ShowSwamMeets.setSwimmerKey key
  ShowSwamMeets.Show vbModal
End If
End Sub

Private Sub showTimes_Click()
Swmrlist_DblClick
End Sub

Private Sub Swmrlist_Click()
showTimes.Enabled = True
End Sub

Private Sub Swmrlist_DblClick()
Dim fr$, ln$, s$
Dim i As Integer

Screen.MousePointer = vbHourglass
s$ = Swmrlist.Text
i = InStr(s$, ",")
ln$ = Left$(s$, i - 1)
fr$ = Trim$(Right$(s$, Len(s$) - i - 1))
swmrEvents.setFrname fr$
swmrEvents.setLname ln$
swmrEvents.setDB db
Screen.MousePointer = vbDefault
swmrEvents.Show
End Sub

Private Sub updateClubs_Click()

Screen.MousePointer = vbHourglass
If Not db.opened Then
  db.openDB (SwimDBPath)
  setDBs
End If
clb.Update     'update list from dbase-III database
Status.Caption = "Clubs updated"
loadClublist
Screen.MousePointer = vbDefault
End Sub

Private Sub updateSwimmers_Click()
Screen.MousePointer = vbHourglass

If Not db.opened Then
  db.openDB SwimDBFile
  setDBs
End If
swmrs.Update     'update list from dbase-III database
Screen.MousePointer = vbDefault
Status.Caption = "Swimmers updated"
End Sub

Private Sub vewMeetTypes_Click()
viewMeetTypes.Show
End Sub

Private Sub viewMeets_Click()
vwMeets.setDB db
vwMeets.Show
End Sub
