VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Meet5Data"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
 Option Explicit
'setup data are here
Private stp As New Setup
'local arrays and constance
Private sessex(10) As String * 1
Private sesnames(10) As String * 25
Private sessend(10) As Integer
Private meetfile$
Private numevents As Integer
Private meet_name As String
Private meet_location As String
Private meet_date As Date
Private meet_course As Integer, meas As String
Private mtype As Integer
Private numsessions As Integer
Private entries() As ENTRYREC
Private Events() As EVENTX
Private swmr() As SWIMMER
Private swext() As SWIMMEREXTN
Private swim_keys() As Integer
Private sfl As Integer, efl As Integer, spfl As Integer
Private rfl As Integer, xfl As Integer
Private swimdim As Integer, entrdim As Integer, nswim As Integer
Private evnum As Integer
Private db As dBase, rec As Recordset
Dim Index As Integer, swim_eof As Boolean
Dim clDate As New Dates
Private meet_key As Integer
Dim evrec As Recordset
Private noMatches As New Collection
Private strk As New stroke
'club management
Private clb As New Clubs
Private alias As Collection 'set by clubalias
'variables used ot manage splits
'Private splt As New Splits
Private finalflag As Boolean        'import finals
Private bothflag As Boolean         'import prelims
Private split_flag As Boolean       'save splits if true
Private split_list() As Single      'array of split times
Private split_count As Integer      'number in array
Private swimmer_key As Integer
Private stroke_key As Integer
Private club_key As Integer
Private stype As Integer
Private attached_flag As Boolean
'swimmers class
Private sw As New Swimmers
Private agrp As New AgeGroup
'relay data
Dim relay_entrants As RELAYENTRANTS
Private rela As New RELAY
'these mimic the constants in the SwimType table
Const PRELIMS = 1, FINALS = 2, TFINALS = 3, swimoff = 4, TIMETRIAL = 5, RELAY = 6

Private Sub readMeet(mtfile$)
Dim c$, n$, l$    'phony course place holder
Dim i As Integer, dt As Date
  meetfile = mtfile$
  Call read_meet(meetfile, numevents, n$, l$, dt, c$, meas, numsessions, sessend(), sessex(), sesnames())
  readrecfile
End Sub


Public Sub read_meet(ByVal file$, numevents As Integer, Meetname$, Location$, mdate As Date, course$, meas$, numsessions As Integer, sessend() As Integer, sessex() As String * 1, sesnames() As String * 25)
Dim i As Integer, sval As Integer, filenum As Integer, tf As Integer
Dim s$, stroke$, v4flag As Integer, maxevents As Integer

maxevents = EVMAX
ReDim Events(maxevents) As EVENTX
filenum = FreeFile
i = InStr(file$, ".")
If i = 0 Then
  file$ = RTrim$(file$) + ".mt4"
End If
If InStr(LCase(file), "mt6") > 0 Then
  readMeet6 file, Meetname, Location, mdate, course
Else
If Len(Dir$(file$)) > 0 Then
Open file$ For Input As #filenum
Input #filenum, s$                  'meet description
If s$ = "Swim 4.0" Then
  Line Input #filenum, Meetname$
  Line Input #filenum, Location$
  v4flag = True
Else
  v4flag = False
  Meetname$ = s$
  numsessions = 0
End If

Input #filenum, mdate
Input #filenum, course$

Select Case course$
   Case "YDS": meas = "YD"
   Case "SCM", "LCM": meas = "M"
End Select
'-------If this is a 4.0 file, read in session info
If v4flag Then
  Input #filenum, s$
  i = InStr(s$, ":") + 1    'skip "sessions:"
  s$ = Right$(s$, Len(s$) - i)
  numsessions = val(s$)
  For i = 1 To numsessions
    Line Input #filenum, sesnames(i)
    Input #filenum, sessend(i), sessex(i)
  Next i
End If
i = 1
While Not EOF(filenum) And (i < EVMAX)
   If v4flag Then
     Input #filenum, Events(i).evname
   Else
     Events(i).evname = Str$(i)
   End If
   Input #filenum, s$
   Events(i).sex = UCase$(Left$(s$, 1))
   Input #filenum, Events(i).Minage
   Input #filenum, Events(i).Maxage
   Input #filenum, Events(i).dist
   Input #filenum, stroke$
   Select Case Left$(UCase$(stroke$), 3)
      Case "FRE"
          sval = FREE
          If UCase$(stroke$) = "FREE RELAY" Then
            sval = RELAY
          End If
      Case "FLY"
          sval = FLY
      Case "BRE"
          sval = BREAST
      Case "BAC"
          sval = BACK
      Case "IM"
          sval = IM
      Case "REL"
          sval = RELAY
      Case "MED"
          sval = MEDRELAY
      Case "DIV"
          sval = DIVING
      Case "FLO"
          sval = FLOAT
      Case "UNA"
           sval = UNASSISTED
      Case "WAL"
           sval = WALK
      Case "ASS"
           sval = ASSISTED
      End Select

   Events(i).stroke = sval

   Input #filenum, Events(i).slowcut
   Input #filenum, Events(i).fastcut
   If v4flag Then
     Input #filenum, Events(i).Final
     Line Input #filenum, Events(i).evlink
   End If
   i = i + 1
Wend
numevents = i - 1
Close #filenum
End If
End If
End Sub
Private Sub readMeet6(filename As String, meet_name As String, MeetLocation As String, meet_date As Date, meetcourse As String)
Dim prf As New Profile, i As Integer, para$
prf.setFilename filename

meet_name = prf.getProfile("Meet", "Name", "")
meet_date = CVDate(prf.getProfile("Meet", "Date", date))
MeetLocation = prf.getProfile("Meet", "Location", "here")
meetcourse = prf.getProfile("Meet", "SeedCourse", "YDS")
evcnt = val(prf.getProfile("Meet", "EventCount", "0"))

For i = 1 To evcnt
    para$ = "Event" + Str$(i)
    'Set evnt = New clsEvents
    Events(i).sex = prf.getProfile(para, "Sex", "F")
    Events(i).evname = prf.getProfile(para, "Name", Str$(i))
    Events(i).dist = val(prf.getProfile(para, "Distance", "100"))
    Events(i).stroke = strk.getStrokeKey(prf.getProfile(para, "Stroke", "free"))
    Events(i).Minage = val(prf.getProfile(para, "Minage", 0))
    Events(i).Maxage = val(prf.getProfile(para, "Maxage", 0))
    Events(i).slowcut = val(prf.getProfile(para, "SlowCut " + meetcourse, "0"))
    Events(i).fastcut = val(prf.getProfile(para, "FastCut " + meetcourse, "0"))
    Events(i).Final = (prf.getProfile(para, "Finals", "true") = "true")
    
Next i


End Sub
Private Function filexist(file$) As Boolean
filexist = Len(Dir$(file$)) > 0
End Function
Private Sub readrecfile()
Dim i As Integer, k As Integer, kmax As Integer
Dim sfile$, efile$, spfile$, relayfile$, exfile$
Dim bite As Integer, ans As Integer
Dim sfile4$, efile4$, spfile4$
Dim split As SPLITREC, sw As SWIMMER, en As ENTRYREC, extn As SWIMMEREXTN
Dim fl As New file, root$

Close #sfl
Close #efl
Close #spfl

fl.setFile (meetfile)
root = fl.rootName
sfile4$ = fl.pathName + RTrim$(Left$(root, 4)) + "swmr.rc4"
efile4$ = fl.pathName + RTrim$(Left$(root, 4)) + "entr.rc4"
spfile4$ = fl.pathName + RTrim$(Left$(root, 4)) + "splt.rc4"
sfile$ = fl.pathName + RTrim$(Left$(root, 4)) + "swmr.rc5"
efile$ = fl.pathName + RTrim$(Left$(root, 4)) + "entr.rc5"
exfile$ = fl.pathName + RTrim$(Left$(root, 4)) + "extn.rc5"
spfile$ = fl.pathName + RTrim$(Left$(root, 4)) + "splt.rc5"
relayfile$ = fl.pathName + RTrim$(Left$(root, 4)) + "rela.rc5"
If filexist(sfile4$) And Not filexist(sfile$) Then
   Screen.MousePointer = vbHourglass
   FileCopy sfile4$, sfile$
   FileCopy spfile4$, spfile$
'   Call convert5(efile4$, efile$)
   Screen.MousePointer = vbDefault
End If

sfl = FreeFile
Open sfile$ For Random As #sfl Len = Len(sw)
efl = FreeFile
Open efile$ For Random As #efl Len = Len(en)
spfl = FreeFile
Open spfile$ For Random As #spfl Len = Len(split)
rfl = FreeFile
Open relayfile$ For Random As #rfl Len = Len(relay_entrants)
xfl = FreeFile
Open exfile$ For Random As #xfl Len = Len(extn)

'If (md.nswim = 0) Then
   swimdim = LOF(sfl) / Len(sw) + 10   'get size of files
   entrdim = LOF(efl) / Len(en) + 50    'for redimensioning arrays
   ReDim swmr(swimdim) As SWIMMER
   ReDim swim_keys(swimdim) As Integer
   ReDim entries(entrdim) As ENTRYREC
   ReDim swext(swimdim) As SWIMMEREXTN
   i = 1
   k = 1

  While (Not EOF(sfl)) And (i < swimdim)
    bite = Seek(sfl)                             'location of swimmer record
    Get #sfl, , swmr(i)
    Get #xfl, , swext(i)
    If Not EOF(sfl) Then
       k = swmr(i).eventpoint
       While k > 0
          Get #efl, k, entries(k)
          k = entries(k).nextpnt
       Wend
       i = i + 1
     End If
  Wend
nswim = i - 1
'totalevents = k - 1     '
evnum = LOF(efl) / Len(entries(1))
'End If
End Sub

Private Function getName$(k As Integer)
If k <= UBound(swmr) Then
 getName$ = RTrim$(swmr(k).frname) + " " + RTrim$(swmr(k).lname)
End If
End Function
Public Sub setMeetType(m_type As Integer)
mtype = m_type
End Sub
Public Sub setDB(datab As dBase)
Set db = datab
sw.setDB db
clb.setDB db
End Sub
Public Sub Import(file$, AddUnmatched As Boolean)
Dim i As Integer, lname$, frname$, mname$
Dim found As Boolean ', rec As Recordset
Dim key As Integer, ans As Integer
Dim mt As New Meets, newmeet As Boolean
Dim club_code As String

'read in the meet file and meet data
readMeet (file$)    'read in meet and data
'find the key for this meet: it will usually be new
mt.setDB db
'now match clubs for legal initials
'clb.setDB db
makeClubList
meet_key = mt.findKey(meet_name, meet_location, meet_date, meet_course, newmeet, mtype)
ans = vbYes
If Not newmeet Then
 ans = MsgBox("A meet with this name and date has already been imported." + Chr(13) + _
   "Do you want to continue anyway?", vbYesNo, "Duplicate meet")
End If
If ans = vbYes Then
' clb.setDB db
 clb.openClubs       'club lookup
 rela.setDB db
 Screen.MousePointer = vbHourglass
'matching takes place first by USS number
'and then by last name and club
'if there are still too many matches, we try to
'match partial first names or nicknames

Set evrec = db.openTableRecord("Events")

For i = 1 To nswim
 ImportMeet.Status.Caption = getName$(i)
 ImportMeet.Status.Refresh
 club_code = Trim$(swmr(i).team)
 club_key = clb.findKey(club_code)
 If club_key = 0 Then
   club_code = findAlias(club_code)
   club_key = clb.findKey(club_code)
 End If
If club_code <> "none" And club_key <> 0 Then

 ans = DoEvents
If Not checkRelayEntry(i) Then
  clDate.setSDate swmr(i).bday
  Set rec = sw.findSwimmer(swmr(i).lname, swmr(i).frname, club_code, swmr(i).init, clDate.getCbirth, swext(i).USSID, found)
  If found Then
    swimmer_key = rec![SwimmerKey]
    swim_keys(i) = swimmer_key
    add_events i, club_key, rec
  Else
   'leave out stranded relays
   frname$ = UCase$(Trim$(swmr(i).frname))
   If frname$ <> "RELAY" And Len(Trim$(swmr(i).lname)) > 1 And frname$ <> Trim$(swmr(i).team) Then
    If Not AddUnmatched Then
     noMatches.Add Str$(i) & " " & getName$(i) & " - " & Trim$(club_code)
    Else
    'add new kid into database
    sw.addSwimmer Trim$(swmr(i).lname), Trim(swmr(i).frname), club_key, 1
    swimmer_key = rec![SwimmerKey]
    swim_keys(i) = swimmer_key
    add_events i, club_key, rec
    End If
   End If
  End If
Else
  import_relay i
End If      'relay swimmer
End If 'no club
Next i
Screen.MousePointer = vbDefault
ImportMeet.Status.Caption = "Import completed"
UnmatchedSwmrs.setCollection noMatches
UnmatchedSwmrs.setDB db
UnmatchedSwmrs.setMeet5 Me
UnmatchedSwmrs.Show vbModal
'evrec.Close
End If 'if newmeet

End Sub
Private Function findAlias(club_code As String) As String
On Local Error GoTo noclub
findAlias = alias.Item(club_code)
okclub:
Exit Function

noclub:
  findAlias = "none"
  Resume okclub
End Function
Private Sub import_relay(ByVal i As Integer)
Dim clubcode$, club$, club_key As Integer
Dim lsc$, rec As Recordset
Dim relayswimmerkey As Integer, j As Integer

lsc$ = Trim$(swmr(i).lsc)
If lsc = "" Or lsc = stp.getLSC Then
  clubcode = Trim$(swmr(i).team)
  club_key = clb.findKey(clubcode)
  If club_key = 0 Then
   clubcode = alias.Item(clubcode)
   club_key = clb.findKey(clubcode)
  End If
  If clubcode <> "none" Then
    club = clb.getName(clubcode)
    Set rec = sw.findName(club)
    If rec.RecordCount = 0 Then
     Set rec = db.openTableRecord("Swimmers")
     rec.AddNew
     rec![Name] = Left$(club, rec![Name].Size)
     rec![lastname] = ""
     rec![Firstname] = ""
     j = InStr(club, " ")
     If j > 0 Then
       rec![lastname] = Left$(Left$(club, j - 1), rec![lastname].Size)
       rec![Firstname] = Left$(Right$(club, Len(club) - j), rec![Firstname].Size)
     End If
     rec![clubkey] = club_key
     rec.Update
     rec.Bookmark = rec.LastModified
    End If
    relayswimmerkey = rec![SwimmerKey]
    add_relayEvents relayswimmerkey, i
  End If
 End If
End Sub
Public Function add_swevents(swimkey As Integer, Index As Integer) As Boolean
Dim rec As Recordset
'brain check: must be same sex
Set rec = db.openTableRecord("Swimmers")
rec.Index = "SwimmerKey"
rec.Seek "=", swimkey
If (Trim$(swmr(Index).sex) = rec![sex]) Or (IsNull(rec![sex])) Then
 swimmer_key = swimkey
 add_events Index, clb.findKey(Trim$(swmr(Index).team)), rec
 add_swevents = True
Else
  MsgBox "Swimmers are not of same sex"
  add_swevents = False
End If
End Function
Private Sub add_events(Index As Integer, clubkey, rec As Recordset)
Dim ent As ENTRYREC, e As Integer, t As Single, evntpnt As Integer
Dim valid As Boolean, age As Integer

Set evrec = db.openTableRecord("Events")
evntpnt = swmr(Index).eventpoint
'clb.setDB db
While evntpnt > 0
  If Not IsNull(rec![Birthday]) Then
    age = agrp.calcAge(rec![Birthday], meet_date)
  End If
  ent = entries(evntpnt)
  e = ent.evnum
  t = getTime(ent, valid, stype)
  If valid Then     'skip all if invalid time
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    stroke_key = Events(e).stroke   'NOTE this depends on order being the same
    evrec![strokekey] = stroke_key
    evrec![Distance] = Events(e).dist
    evrec![meetKey] = meet_key
    attached_flag = (Asc(ent.att) = 1)
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    'club_key = clb.findKey(Trim$(swmr(index).team))
    evrec![clubkey] = clubkey
    evrec![age] = age
    evrec![SwimType] = stype
     evrec![SplitEventKey] = 0
    evrec.Update        'don't save if invalid
    If split_flag Then
      evrec.Bookmark = evrec.LastModified
      add_splits evrec![eventkey], ent, stype
    End If
  End If
  evntpnt = entries(evntpnt).nextpnt
Wend
'End If
End Sub
Public Sub add_relayEvents(swimkey As Integer, Index As Integer)
Dim ent As ENTRYREC, e As Integer, t As Single, evntpnt As Integer
Dim valid As Boolean
Dim stype As Integer, club_key As Integer

evntpnt = swmr(Index).eventpoint
While evntpnt > 0
  ent = entries(evntpnt)
  e = ent.evnum
  t = getTime(ent, valid, stype)
  If valid Then     'skip all if invalid time
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimkey
    evrec![strokekey] = Events(e).stroke 'NOTE this depends on order being the same
    evrec![Distance] = Events(e).dist
    evrec![meetKey] = meet_key
    evrec![attached] = (Asc(ent.att) = 1)
    evrec![coursekey] = meet_course
    club_key = clb.findKey(Trim$(swmr(Index).team))
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec.Update        'don't save if invalid
'   If split_flag Then
    evrec.Bookmark = evrec.LastModified
    addRelayswimmers ent, evrec![eventkey], stype, club_key
'      add_splits evrec![eventkey], ent, stype
 '  End If
  End If
  evntpnt = entries(evntpnt).nextpnt
Wend
End Sub
Private Sub load_splitlist(evnt As ENTRYREC, split_type As Integer)
Dim s As Integer, spnt As Integer
Dim srec As SPLITREC
  s = 1
  spnt = evnt.splpnt
  While spnt > 0
    Get #spfl, spnt, srec
    If srec.Class = split_type Then
      split_list(s) = srec.times
      s = s + 1
    End If
    spnt = srec.nextpnt
    Wend
  split_count = s - 1          'total splits accumulated
End Sub
Private Sub addRelayswimmers(ent As ENTRYREC, eventkey As Long, s_type As Integer, clubkey As Integer)
Dim leg As Integer, Index As Integer, found As Boolean
Dim clDate As New Dates, swrec As Recordset
Dim leadoffkey As Integer, dist As Integer, split_stroke As Integer
Dim t As Single, split_dist As Integer

leadoffkey = 0      'key to lead off swimmer for split
If ent.entrpnt > 0 Then
  For leg = 1 To 4
    Get #rfl, ent.entrpnt, relay_entrants
    Index = relay_entrants.entrids(leg)
    clDate.setSDate swmr(Index).bday
    If swim_keys(Index) = 0 Then
     Set swrec = sw.findSwimmer(swmr(Index).lname, swmr(Index).frname, swmr(Index).team, swmr(Index).init, clDate.getCbirth, "", found)
     If found Then
       rela.addSwimmer eventkey, swrec![SwimmerKey], leg
       If leg = 1 Then leadoffkey = swrec![SwimmerKey]
       swim_keys(Index) = swrec![SwimmerKey]
     End If
    Else
     rela.addSwimmer eventkey, swim_keys(Index), leg
     If leg = 1 Then leadoffkey = swim_keys(Index)
    End If
  Next leg
'put in lead-off split
  If leadoffkey <> 0 Then
   load_splitlist ent, s_type
   dist = evrec![Distance]
   If evrec![strokekey] = MEDRELAY Then
     split_stroke = BACK
   Else
     split_stroke = FREE
   End If
   t = 0
   Select Case dist
     Case 200
       If split_count = 4 Then t = split_list(1)
       If split_count = 8 Then t = split_list(2)
       split_dist = 50
     Case 400
       If split_count = 4 Then t = split_list(1)
       If split_count = 8 Then t = split_list(2)
       If split_count = 16 Then t = split_list(4)
       split_dist = 100
     Case 800
       If split_count = 8 Then t = split_list(2)
       If split_count = 16 Then t = split_list(4)
       If split_count = 32 Then t = split_list(8)
       split_dist = 200
   End Select
   If t <> 0 Then
     evrec.AddNew
     evrec![SwimmerKey] = leadoffkey
     evrec![strokekey] = split_stroke
     evrec![clubkey] = clubkey
     evrec![Distance] = split_dist
     evrec![SwimTime] = t
     evrec![SplitEventKey] = eventkey
     evrec![SwimType] = stype
     evrec![coursekey] = meet_course
     evrec![meetKey] = meet_key
     evrec![attached] = True
     evrec.Update
    End If
  End If    'if entrpnt>0
End If
End Sub
Private Sub add_splits(eventkey As Long, evnt As ENTRYREC, stype As Integer)
Dim split_type As Integer
ReDim split_list(70) As Single
Dim s As Integer, spnt As Integer
Dim srec As SPLITREC, ftime As Single

If evnt.splpnt > 0 Then    'accumulate entries in split list
  If stype = PRELIMS Then   'determine which splits
    split_type = RSPLIT     'to extract by type
    ftime = evnt.result     'save final result
  Else
    split_type = FSPLIT     'to compare with
    ftime = evnt.Final      'final split
  End If
  load_splitlist evnt, split_type     'load splits into array
  'do a sanity check:
  'only allow splits if final split equals final time
  If split_list(split_count) = ftime Then 'allow splits to be added
    Select Case Events(evnt.evnum).dist
      Case 100
        save_100s eventkey
      Case 200
        save_200s eventkey
      Case 400
        save_400s eventkey
      Case 500
        save_500s eventkey
      Case 800
        save_800s eventkey
      Case 1000
        save_1000s eventkey
      Case 1500
        save_1500s eventkey
      Case 1650
        save_1650s eventkey
    End Select
  End If
End If
End Sub
Private Sub save_100s(eventkey As Long)
If split_count = 4 Then
  add_split_event eventkey, 50, split_list(2)
End If
If split_count = 2 Then
  add_split_event eventkey, 50, split_list(1)
End If
End Sub
Private Sub save_200s(eventkey As Long)
If stroke_key <> IM Then
 If split_count = 4 Then
  add_split_event eventkey, 100, split_list(2)
 End If
 If split_count = 8 Then
  add_split_event eventkey, 50, split_list(2)
  add_split_event eventkey, 100, split_list(4)
 End If
Else
 If split_count = 4 Then
  add_split_eventAndStroke eventkey, 50, split_list(1), FLY
 End If
 If split_count = 8 Then
  add_split_eventAndStroke eventkey, 50, split_list(2), FLY
 End If
End If
End Sub
Private Sub save_500s(eventkey As Long)
If split_count = 10 Then
  add_split_event eventkey, 200, split_list(4)
End If
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(8)
End If
End Sub
Private Sub save_400s(eventkey As Long)
If stroke_key = IM Then
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(1), FLY
  End If
  If split_count = 8 Then
    add_split_eventAndStroke eventkey, 100, split_list(2), FLY
  End If
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(4), FLY
  End If
Else
  If split_count = 4 Then
    add_split_event eventkey, 100, split_list(1)
    add_split_event eventkey, 200, split_list(2)
  End If
  If split_count = 8 Then
    add_split_event eventkey, 100, split_list(2)
    add_split_event eventkey, 200, split_list(4)
  End If
  If split_count = 16 Then
    add_split_event eventkey, 100, split_list(4)
    add_split_event eventkey, 200, split_list(8)
  End If
End If
End Sub
Private Sub save_800s(eventkey As Long)
If split_count = 8 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 400, split_list(4)
End If
If split_count = 16 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 400, split_list(8)
End If
End Sub
Private Sub save_1000s(eventkey As Long)
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 500, split_list(10)
End If
If split_count = 40 Then
  add_split_event eventkey, 200, split_list(8)
  add_split_event eventkey, 400, split_list(20)
End If
End Sub
Private Sub save_1500s(eventkey As Long)
If split_count = 15 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 800, split_list(8)
End If
If split_count = 30 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 800, split_list(16)
End If
End Sub
Private Sub save_1650s(eventkey As Long)
If split_count = 33 Then
  add_split_event eventkey, 500, split_list(10)
  add_split_event eventkey, 1000, split_list(20)
End If
If split_count = 66 Then
  add_split_event eventkey, 500, split_list(20)
  add_split_event eventkey, 1000, split_list(40)
End If
End Sub
Private Sub add_split_event(evkey As Long, dist As Integer, t As Single)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.Update
End Sub
Public Sub setMeetname(s$)
meet_name = Trim(s$)
End Sub
Public Sub setLocation(s$)
meet_location = Trim$(s$)
End Sub
Public Sub setDate(d$)
meet_date = CDate(d$)
End Sub
Public Sub setCourse(c$)
Dim crs As New course
crs.setDB db
meet_course = crs.findKey(c$)
End Sub
Public Sub setSplits(savesplits As Boolean)
 split_flag = savesplits
End Sub
Public Sub importBoth()
  bothflag = True
End Sub
Public Sub importPrelims()
  bothflag = False
  finalflag = False
End Sub
Public Sub importFinals()
  finalflag = True
  bothflag = False
End Sub
Private Function checkRelayEntry(Index As Integer)
Dim check As Integer, epnt As Integer, strokenum As Integer
epnt = swmr(Index).eventpoint
If epnt > 0 Then
  strokenum = Events(entries(epnt).evnum).stroke
  check = False
  If strokenum = RELAY Or strokenum = MEDRELAY Then
   check = True
  End If
Else
  check = False
End If
checkRelayEntry = check
End Function

Private Function getFinal(evt As ENTRYREC, valid As Boolean) As Single
Dim t As Single
t = evt.Final
valid = True
If t = 0 Or Asc(evt.fscratch) <> 0 Then
  valid = False
End If
If Asc(evt.DisqualF) <> 0 Then
  valid = False
End If
If valid Then
  getFinal = t
Else
  getFinal = 0
End If
End Function
Private Function getResult(evt As ENTRYREC, valid As Boolean) As Single
Dim t As Single
t = evt.result
valid = True
If t = 0 Or Asc(evt.escratch) <> 0 Then
  valid = False
End If
If Asc(evt.DisqualR) <> 0 Then
  valid = False
End If
If valid Then
  getResult = t
Else
  getResult = 0
End If
End Function

Private Function getTime(evt As ENTRYREC, valid As Boolean, stype As Integer) As Single
Dim result As Single, Final As Single
Dim fvalid As Boolean, rvalid As Boolean
'checks settings of bothflag and finalflag and
'returns either the fastest of the two or
'the desired legal time. Valid is false if not legal
If bothflag = False And finalflag = False Then
  getTime = getResult(evt, valid)
  stype = RSPLIT
End If
If (Not bothflag) And finalflag Then
  getTime = getFinal(evt, valid)
  stype = FSPLIT
End If
If bothflag Then
  result = getResult(evt, rvalid)
  Final = getFinal(evt, fvalid)
  If Not fvalid And rvalid Then
    getTime = result
    valid = rvalid
    stype = RSPLIT
  End If
  If fvalid And rvalid Then
    If result < Final Then
      getTime = result
      stype = FSPLIT
    Else
      getTime = Final
      stype = FSPLIT
    End If
    valid = True
  End If
End If
End Function
Private Sub makeClubList()
Dim i As Integer, club_count As Integer
Dim cmax As Integer, cb$, j As Integer
Dim found As Boolean, key As Integer, lsc$
'make a table of all the clubs in the meet
'belonging to this LSC or having no spec'd LSC

cmax = 100
club_count = 0
ReDim club_names(cmax) As String
For i = 1 To nswim
  cb$ = Trim$(swmr(i).team)
  lsc$ = Trim$(swmr(i).lsc)
  If lsc$ = "" Or lsc$ = stp.getLSC Then
    found = False
    j = 1
    While j <= club_count And Not found
     found = cb$ = club_names(j)
     j = j + 1
    Wend
    If Not found Then
      club_count = club_count + 1
      If club_count > cmax Then
        cmax = cmax + 50
        ReDim Preserve club_names(cmax) As String
      End If
      club_names(club_count) = cb$
    End If
  End If '   If in LSC
Next i
'now filter for legal clubs
For i = 1 To club_count
 key = clb.findKey(club_names(i))
 If key <> 0 Then
   club_names(i) = ""   'erase those which are found
 End If
Next i
'load remainder into a collection and pass it to
'the alias form
Dim colClubs As New Collection
For i = 1 To club_count
  If club_names(i) <> "" Then
    colClubs.Add club_names(i), club_names(i)
  End If
Next i
If colClubs.count > 0 Then  'bring up alias box
  ClubAlias.setBadClubs colClubs
  ClubAlias.setDB db
  ClubAlias.Show vbModal
  
  Set alias = ClubAlias.getAliases
  
  'Unload ClubAlias
End If

End Sub

Public Function getMeetName() As String
getMeetName = meet_name
End Function
Public Function getMeetDate() As Date
getMeetDate = meet_date
End Function
Private Sub add_split_eventAndStroke(evkey As Long, dist As Integer, t As Single, stroke_key As Integer)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![coursekey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.Update
End Sub

Private Sub Class_Initialize()
ReDim split_list(70) As Single
End Sub
