VERSION 5.00
Begin VB.Form ImportMeet 
   Caption         =   "Import LSA Meet File"
   ClientHeight    =   5100
   ClientLeft      =   1140
   ClientTop       =   1740
   ClientWidth     =   7455
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   5100
   ScaleWidth      =   7455
   Begin VB.CheckBox IgnoreClub 
      Caption         =   "Ignore club initials"
      Height          =   255
      Left            =   2280
      TabIndex        =   28
      ToolTipText     =   "Ignore if regional or Zone team"
      Top             =   3240
      Width           =   1575
   End
   Begin VB.CheckBox requireLSC 
      Caption         =   "Require LSC name"
      Height          =   255
      Left            =   2280
      TabIndex        =   27
      Top             =   2880
      Width           =   1815
   End
   Begin VB.ComboBox cbMeetType 
      Height          =   315
      Left            =   6240
      Style           =   2  'Dropdown List
      TabIndex        =   25
      Top             =   2640
      Width           =   1215
   End
   Begin VB.TextBox teamName 
      Height          =   375
      Left            =   2520
      TabIndex        =   24
      Text            =   " "
      Top             =   4680
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.CheckBox onlyOneteam 
      Caption         =   "Add only one team"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      Top             =   4800
      Width           =   2055
   End
   Begin VB.CheckBox AddUnmatched 
      Caption         =   "Add unmatched Swimmers"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      Top             =   4440
      Width           =   2775
   End
   Begin VB.CheckBox Importsplits 
      Caption         =   "Import splits"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   3480
      Width           =   1575
   End
   Begin VB.CommandButton Cancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   495
      Left            =   1680
      TabIndex        =   19
      Top             =   3840
      Width           =   1095
   End
   Begin VB.CommandButton Import 
      Caption         =   "Begin Import"
      Default         =   -1  'True
      Height          =   495
      Left            =   120
      TabIndex        =   18
      Top             =   3840
      Width           =   1215
   End
   Begin VB.Frame Frame2 
      Caption         =   "Select times to import"
      ForeColor       =   &H00FF0000&
      Height          =   1455
      Left            =   3960
      TabIndex        =   14
      Top             =   3240
      Width           =   1695
      Begin VB.OptionButton Final 
         Caption         =   "Final time"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   960
         Width           =   1215
      End
      Begin VB.OptionButton Prelim 
         Caption         =   "Prelim time"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton Fastest 
         Caption         =   "Fastest time"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select course"
      ForeColor       =   &H00FF0000&
      Height          =   1455
      Left            =   5760
      TabIndex        =   10
      Top             =   3240
      Width           =   1575
      Begin VB.OptionButton Scm 
         Caption         =   "SCM"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton Lcm 
         Caption         =   "LCM"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   600
         Width           =   855
      End
      Begin VB.OptionButton Yds 
         Caption         =   "YDS"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   240
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin VB.TextBox MeetDate 
      Height          =   285
      Left            =   4680
      TabIndex        =   9
      Text            =   " "
      Top             =   2640
      Width           =   1455
   End
   Begin VB.TextBox MeetLocation 
      Height          =   375
      Left            =   4680
      TabIndex        =   5
      Text            =   " "
      Top             =   1800
      Width           =   2415
   End
   Begin VB.TextBox Meetname 
      Height          =   375
      Left            =   4680
      TabIndex        =   4
      Text            =   " "
      Top             =   1080
      Width           =   2535
   End
   Begin VB.FileListBox File1 
      Height          =   1845
      Left            =   2280
      Pattern         =   "*.mt4;*.mt6"
      TabIndex        =   2
      Top             =   840
      Width           =   1575
   End
   Begin VB.DirListBox Dir1 
      Height          =   2055
      Left            =   360
      TabIndex        =   1
      Top             =   840
      Width           =   1575
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
   Begin VB.Label Label5 
      Caption         =   "Meet Type"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   6240
      TabIndex        =   26
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Status 
      Caption         =   " "
      Height          =   255
      Left            =   4680
      TabIndex        =   21
      Top             =   120
      Width           =   2535
   End
   Begin VB.Label Label4 
      Caption         =   "Meet date"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   4800
      TabIndex        =   8
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Meet location"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   4800
      TabIndex        =   7
      Top             =   1560
      Width           =   1935
   End
   Begin VB.Label Label2 
      Caption         =   "Meet name"
      ForeColor       =   &H00FF0000&
      Height          =   375
      Left            =   4800
      TabIndex        =   6
      Top             =   600
      Width           =   2295
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Select Meet (MT4) file from desired directory"
      ForeColor       =   &H00FF0000&
      Height          =   495
      Left            =   1920
      TabIndex        =   3
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "ImportMeet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim meetfile As String
Dim sdiflag As Boolean
Dim sdf As New SDIFile
Dim db As dBase
Dim mtype As New MeetType
Dim reqLSC As Boolean
Dim stp As New Setup
Dim mt As New Meet5Data
Public Sub setDB(datab As dBase)
Set db = datab
End Sub

Private Sub Cancel_Click()
Unload ImportMeet
Screen.MousePointer = vbDefault
End Sub

Private Sub Dir1_Change()
File1.path = Dir1.path
End Sub

Private Sub Drive1_Change()
Dir1.path = Drive1.Drive
End Sub
Public Sub setsdi()
sdiflag = True
File1.Pattern = "*.cl2;*.sdi;*.sdf;*.sd3;*.txt"
Label1.Caption = "Select SDI (cl2) file from desired directory"
End Sub
Public Sub setLSA()
sdiflag = False
File1.Pattern = "*.mt4;*.mt6"
Label1.Caption = "Select Meet (MT4) file from desired directory"
End Sub

Private Sub File1_Click()
Dim mname$, mlocn$, mdate As Date, mcrs$, meas$, numEvents As Integer
Dim numSes As Integer, sessend(20) As Integer, sesnames(20) As String * 25, sessex(20) As String * 1
Dim f As Integer, dt As New Dates
meetfile = File1.path + "\" + File1.fileName
If Not sdiflag Then
 mt.read_meet meetfile, numEvents, mname, mlocn, mdate, mcrs$, meas$, numSes, sessend, sessex, sesnames
' f = FreeFile
' Open meetfile For Input As #f
' Line Input #f, mname$    'skip "Swim 4.0" line
' Line Input #f, mname$
' Line Input #f, mlocn$
' Input #f, mdate
' Line Input #f, mcrs$
' Close #f
 dt.setDDate mdate
Else
  sdf.readMeet (meetfile)
  mname$ = sdf.Meetname
  mlocn$ = sdf.MeetLocation
  mcrs$ = sdf.getMeetCourse
  dt.setDDate sdf.getDate
End If
Meetname.Text = mname$
MeetLocation.Text = mlocn$
MeetDate.Text = dt.formatDate
Select Case mcrs$
  Case "YDS"
    Yds.Value = True
  Case "LCM"
    Lcm.Value = True
  Case "SCM"
    Scm.Value = True
End Select
End Sub

Private Sub Form_Load()
'sdiflag = False
'Dim stp As New Setup
Dim path$

path$ = stp.getDataPath
On Local Error GoTo chdrerr
ChDrive Left(path$, 1)
If path <> "" Then ChDir (path$)
setPath:
reqLSC = False
requireLSC.Caption = "Require LSC=" + stp.getLSC()
mtype.setDB db
mtype.opentable
While Not mtype.EndFile
  cbMeetType.AddItem mtype.getNext
Wend
If cbMeetType.ListCount > 0 Then
  cbMeetType.ListIndex = 0
End If
Exit Sub

chdrerr:
  Resume setPath

End Sub

Private Sub import_Click()
Dim m5 As New Meet5Data
Dim locn$, mname$
Dim error As Boolean, ans As Integer

stp.putDataPath File1.path

error = False
If requireLSC.Value = 1 Then reqLSC = True
locn$ = Trim$(MeetLocation.Text)
mname$ = Trim$(Meetname.Text)
If Len(locn$) < 2 Then
  error = True
  MsgBox "You must enter a meet location"
End If
If Len(mname$) < 2 Then
  error = True
  MsgBox "You must enter a meet name"
End If
If Not error Then
 db.BeginTrans          'begin transaction
 If Not sdiflag Then
  m5.setDB db
  m5.setMeetname Meetname.Text
  m5.setDate MeetDate.Text
  m5.setLocation MeetLocation.Text
  m5.setMeetType cbMeetType.ListIndex + 1
  If Yds.Value Then m5.setCourse ("YDS")
  If Lcm.Value Then m5.setCourse ("LCM")
  If Scm.Value Then m5.setCourse ("SCM")
  If Fastest.Value Then m5.importBoth
  If Prelim.Value Then m5.importPrelims
  If Final.Value Then m5.importFinals
  m5.setSplits (Importsplits.Value = 1)
  m5.Import meetfile, (AddUnmatched.Value = 1)
 Else
  sdf.setDB db
  sdf.setLocation MeetLocation.Text
  sdf.setDescription Meetname.Text
  sdf.setMeetType cbMeetType.ListIndex + 1
  If Yds.Value Then sdf.setCourse ("YDS")
  If Lcm.Value Then sdf.setCourse ("LCM")
  If Scm.Value Then sdf.setCourse ("SCM")

  If Fastest.Value Then sdf.importBoth
  If Prelim.Value Then sdf.importPrelims
  If Final.Value Then sdf.importFinals
  sdf.setLSC stp.getLSC, reqLSC, (IgnoreClub.Value = 1)
  sdf.Import meetfile, (AddUnmatched.Value = 1)
 End If
 ans = MsgBox("Do you want to confirm this database entry?" + Chr$(13) + "Click No to roll back to previous state", vbYesNo, "Confirm update to database")
 If ans = vbYes Then
   db.Commit
 Else
   db.RollBack
 End If
Set m5 = Nothing
Set sdf = Nothing
 Unload ImportMeet
End If 'if no errors
End Sub

Private Sub onlyOneteam_Click()
If onlyOneteam.Value = 1 Then
  teamName.Visible = True
Else
  teamName.Visible = False
End If
End Sub

Private Sub outLSC_Click()

End Sub
