VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsEvents"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
'Class clsEvents
'Definition of swimming events
Private ev_number As Integer    'event number
Private ev_minage As Integer    'minimum age
Private ev_maxage As Integer    'maximum age
Private ev_distance As Integer  'distance
Private ev_stroke As String     'stroke
Private ev_sex As String        'sex
Private ev_slowcut As Single    'slowest allowed
Private ev_fastcut As Single    'fastest allowed
Private ev_final As Boolean     'true if prelims/finals
Private ev_links As String      'list of other combined events
Property Let Eventnumber(ByVal ev As Integer)
  ev_number = ev
End Property
Property Let Distance(ByVal d As Integer)
 ev_distance = d
End Property
Property Let stroke(ByVal s As String)
  Select Case Left(UCase$(s), 3)
    Case "FRE"
      ev_stroke = "Free"
    Case "FLY", "BUT"
      ev_stroke = "Fly"
    Case "BRE"
      ev_stroke = "Breast"
    Case "BAC"
      ev_stroke = "Back"
    Case "IM"
      ev_stroke = "IM"
    Case "REL"
      ev_stroke = "Free Relay"
    Case "MED"
      ev_stroke = "Medley Relay"
   End Select
End Property
Property Let Sex(ByVal s As String)
  ev_sex = Left$(Trim$(UCase$(s)), 1)
End Property
Property Let slowcut(ByVal t As Single)
  ev_slowcut = t
End Property
Property Let fastcut(ByVal t As Single)
  ev_fastcut = t
End Property
Property Let minage(a As Integer)
  ev_minage = a
End Property
Property Let maxage(a As Integer)
  ev_maxage = a
End Property
Property Get maxage() As Integer
  maxage = ev_maxage
End Property
Property Get minage() As Integer
  minage = ev_minage
End Property
Property Let final(ByVal f As Integer)
  If f <> 0 Then
    ev_final = True
  Else
    ev_final = False
  End If
End Property
Property Let Links(lnk As String)
  ev_links = lnk
End Property
Property Get Eventnumber() As Integer
  Eventnumber = ev_number
End Property
Property Get Distance() As Integer
 Distance = ev_distance
End Property
Property Get stroke() As String
  stroke = ev_stroke
End Property
Property Get Sex() As String
  Sex = ev_sex
End Property
Property Get slowcut() As Single
  slowcut = ev_slowcut
End Property
Property Get fastcut() As Single
  fastcut = ev_fastcut
End Property

Property Get Name() As String
 Name = AgeString + Str$(Distance) + " " + stroke
End Property
Private Function AgeString()
 If ev_minage = 0 Then
   If ev_maxage <> 25 Then
     AgeString = Str$(ev_maxage) + "&U"
   Else '0-25 represents Senior Events
     AgeString = " Senior "
   End If
 Else
   If ev_maxage = 25 Then
     'xx-25 represent "xx and Over"
     AgeString = Str$(ev_minage) + "/O"
   Else
     AgeString = Str$(ev_minage) + "-" + Str$(ev_maxage)
   End If
 End If
End Function
