VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Swimmers"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private db As dBase
Private dbpath As String
Private db3 As New dBaseIII
Dim swrec As Recordset
Private clDate As New Dates
Public Sub setDB(datab As dBase)
Set db = datab
End Sub
Public Sub createTable()
Dim SwimmerKey As Field, Lastname As Field, Firstname As Field
Dim Nickname As Field, Birthday As Field, Initials As Field
Dim address As Field, Town As Field, State As Field
Dim zip As Field, sex As Field, cbirth As Field, regyear As Field
Dim clubkey As Field, swname As Field, midinit As Field
Dim phone As Field, Active As Field, regStatus As Field

Dim tb As TableDef
Set tb = db.createTable("Swimmers")
Set SwimmerKey = createKey(tb, "SwimmerKey")
Set swname = createText(tb, "Name", 30)
Set Lastname = createText(tb, "Lastname", 20)
Set Firstname = createText(tb, "Firstname", 15)
Set Nickname = createText(tb, "Nickname", 15)
Set midinit = createText(tb, "MidInit", 1)
Set Initials = createText(tb, "Initials", 3)
Set address = createText(tb, "Address", 30)
Set Town = createText(tb, "Town", 20)
Set State = createText(tb, "State", 2)
Set sex = createText(tb, "Sex", 1)
Set cbirth = createLong(tb, "Cbirth")
Set zip = createText(tb, "Zip", 10)
Set regyear = createText(tb, "RegYear", 1)
Set Birthday = createDateField(tb, "Birthday")
Set clubkey = createLong(tb, "ClubKey")
Set phone = createText(tb, "Phone", 15)
Set Active = createBoolean(tb, "Active")
Set regStatus = createLong(tb, "RegStatus")
regStatus.DefaultValue = REGISTERED
Active.DefaultValue = True
makeIndex tb, "SwimmerKey", True
makeIndex tb, "Name", False
makeIndex tb, "LastName", False
db.appendTable tb
End Sub
Public Sub update()
Dim i As Integer
'pick path to dbaseII database
If dbpath <> "" Then
  Menu.cDlg.InitDir = dbpath
End If
Menu.cDlg.DialogTitle = "Select USS DB-III File Directory"
Menu.cDlg.Filter = "dBase-III files|*.dbf"
Menu.cDlg.ShowOpen
dbpath = Menu.cDlg.filename
i = Len(dbpath)
While Mid(dbpath, i, 1) <> "\"
  i = i - 1
Wend
dbpath = Left$(dbpath, i) 'strip off filename
updateSwimmers
End Sub
Public Sub updateSwimmers()
Dim nm$, i As Integer, lname$, frname$, midinit$
Dim inits As String, bday As Date
Dim clbs As New Clubs
Screen.MousePointer = vbHourglass
clbs.setDB db
'reads in records from USS database and
'either adds or updates swimmer depending on
'whether it finds a match
db3.openDB dbpath
db3.openSwimmers
Set swrec = db.openTableRecord("Swimmers")
swrec.index = "Name"
While Not db3.swimmerEOF
 nm$ = db3.swmrName
 swrec.Seek "=", nm$
 If swrec.NoMatch Then
   swrec.AddNew     'if no match add a new swimmer
 Else
 'even if exact match, initials or birthday must also match
   If db3.swmrInitials = swrec![Initials] Or db3.swmrCbirth = swrec![cbirth] Then
     swrec.Edit
   Else
     swrec.AddNew
   End If
 End If
   
 i = InStr(nm$, ",")    'split names apart
 If i > 0 Then
   lname$ = Left$(nm$, i - 1)
   frname$ = Trim$(Right$(nm$, Len(nm$) - i))
   If Mid$(frname$, Len(frname$) - 1, 1) = " " Then
     midinit$ = Right$(frname$, 1)
     frname$ = Left$(frname$, Len(frname$) - 2)
   Else
     midinit$ = ""
   End If
   i = InStr(frname$, " ")
   If i > 0 Then
    frname$ = Left$(frname$, i - 1)
   End If
 End If
 If midinit = "" Then midinit = Right$(db3.swmrInits, 1)
 
 Menu.status.Caption = nm$
 Menu.status.Refresh
 swrec![Name] = nm$
 swrec![Lastname] = lname$
 swrec![Firstname] = frname$
 swrec![midinit] = midinit$
 swrec![cbirth] = db3.swmrCbirth
 swrec![Birthday] = db3.Birthday
 swrec![Nickname] = ""
 swrec![Initials] = db3.swmrInits
 swrec![address] = db3.swmrAdl1
 swrec![Town] = db3.swmrTown
 swrec![State] = db3.swmrState
 swrec![zip] = db3.swmrZip
 swrec![sex] = db3.swmrSex
 swrec![regyear] = db3.regyear
 swrec![phone] = db3.swmrPhone
 swrec![clubkey] = clbs.findKey(db3.swmrClub)
 swrec.update
 db3.swmrMoveNext
Wend
Screen.MousePointer = vbDefault
End Sub
Public Function findLastNames(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName, Swimmers.name, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Lastname) = " + Chr$(34) + nm$ + Chr$(34) + "))" + _
"ORDER BY Swimmers.Firstname;"

Set findLastNames = db.openRecord(query$)
End Function
Public Function fuzzyLastNames(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName, Swimmers.Name, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Lastname) like " + Chr$(34) + nm$ + "*" + Chr$(34) + "))" + _
"ORDER BY Swimmers.Lastname;"

Set fuzzyLastNames = db.openRecord(query$)
End Function
Public Function findName(nm$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Firstname,Swimmers.NickName,Swimmers.Name, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"Where (((Swimmers.Name) = " + Chr$(34) + nm$ + Chr$(34) + "))" + _
"ORDER BY Swimmers.name;"

Set findName = db.openRecord(query$)
End Function
Public Function findSwimmer(ByVal lname$, ByVal frname$, club$, init$, cbirth As Long, found As Boolean) As Recordset
Dim rec As Recordset
Dim mname$, nick$
  Set rec = findByUSS(init, cbirth)
  If rec.RecordCount = 0 Then
    rec.Close
    Set rec = findByLastnameAndClub(Trim$(lname), Trim$(club))
    If rec.RecordCount = 0 Then
      Set rec = findByLastname(lname)
    End If
    If rec.RecordCount > 1 Then
      frname$ = UCase$(Trim$(frname))
      found = False
      While Not rec.EOF And Not found
        found = frname$ = rec![Firstname]
        If Not found Then rec.MoveNext
      Wend
      'if no first name matches try nickname
      If Not found Then
       rec.MoveFirst
       While Not rec.EOF And Not found
        nick$ = ""
         If rec![Nickname] <> Null Then
          nick$ = UCase$(rec![Nickname])
         End If
         found = (UCase$(frname$) = nick$)
         If Not found Then rec.MoveNext
       Wend
      End If
      'if still no match try shortening first name
      If Not found Then
        frname$ = Left$(frname$, Len(frname$) - 1)
        While Len(frname$) > 2 And Not found
          rec.MoveFirst
          While Not rec.EOF And Not found
            mname$ = rec![Firstname]
            If Len(mname$) > Len(frname$) Then
              mname$ = Left$(mname$, Len(frname$))
              found = frname$ = mname$
            End If
            If Not found Then rec.MoveNext
          Wend
          If Len(frname$) > 2 And Not found Then
            frname$ = Left$(frname$, Len(frname) - 1)
          End If
        Wend
      End If

    Else
     If rec.RecordCount = 1 Then
      found = True    'only one found so must be it
    Else
      found = False
     End If
    End If
    'If found Then
    '  key = rec![SwimmerKey]
    '  swim_keys(i) = key
    '  add_events key, i
    'Else
    '  noMatches.add Str$(i) & " " & getName$(i) & " - " & Trim$(swmr(i).team)
    'End If
  Else      'USS number matches
    'key = rec![SwimmerKey]
    'swim_keys(i) = key
    'add_events key, i
    found = True
  End If    'recordcount>1 for USS match
Set findSwimmer = rec
End Function
Public Function findByUSS(init$, cbirth As Long) As Recordset
Dim query$, i As Integer
i = InStr(init$, Chr$(0))
If i > 0 Then init$ = "   "
query$ = "SELECT DISTINCTROW swimmers.swimmerkey, Swimmers.Lastname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth " + _
"From Swimmers " + _
"WHERE ( (Swimmers.Initials='" + init$ + "') AND ((Swimmers.Cbirth)=" + Str$(cbirth) + "));"
Set findByUSS = db.openRecord(query$)

End Function
Public Function findByLastnameAndClub(ByVal lname$, ByVal club$) As Recordset
Dim query$, i As Integer
lname$ = Trim$(lname$)
club$ = Trim$(club$)
i = InStr(lname$, Chr$(0))
If i > 0 Then lname$ = " "
i = InStr(club$, Chr$(0))
If i > 0 Then club$ = " "
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE (((Swimmers.Lastname)=" + Chr$(34) + lname$ + Chr$(34) + ") AND ((Clubs.ClubCode)='" + club$ + "'));"

Set findByLastnameAndClub = db.openRecord(query$)
End Function

Public Function findByLastname(ByVal lname$) As Recordset
Dim query$, i As Integer
lname$ = Trim$(lname)
i = InStr(lname$, Chr$(0))
If i > 0 Then lname$ = "  "
query$ = "SELECT DISTINCTROW Swimmers.Swimmerkey, Swimmers.Firstname, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Cbirth, Swimmers.ClubKey " + _
"From Swimmers WHERE (((Swimmers.Lastname)=" + Chr$(34) + lname$ + Chr$(34) + "));"

Set findByLastname = db.openRecord(query$)
End Function

Public Function findByClub(club$) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.Name, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE ( ((Clubs.ClubCode)='" + club$ + "')) order by Swimmers.lastname;"

Set findByClub = db.openRecord(query$)

End Function
Public Function findKey(key As Integer) As Recordset
Dim query$
query$ = "SELECT DISTINCTROW Swimmers.SwimmerKey, Swimmers.Lastname, Swimmers.Nickname, Swimmers.Firstname, Swimmers.Name, Swimmers.ClubKey, Swimmers.Initials, Swimmers.Cbirth, Clubs.ClubCode " + _
"FROM Swimmers INNER JOIN Clubs ON Swimmers.ClubKey = Clubs.ClubKey " + _
"WHERE ( ((Swimmers.swimmerkey)=" + Str$(key) + ")) order by Swimmers.lastname;"

Set findKey = db.openRecord(query$)
End Function
Public Function addSwimmer(lname As String, frname As String, clubkey As Integer, regstat As Long) As Recordset
Set swrec = db.openTableRecord("Swimmers")
swrec.AddNew
swrec![Firstname] = UCase$(frname)
swrec![Lastname] = UCase$(lname)
swrec![Name] = UCase$(lname) + ", " + UCase(frname)
swrec![regStatus] = regstat
swrec![clubkey] = clubkey
swrec.update
swrec.MoveLast
Set addSwimmer = swrec
End Function
