VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SDIFile"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Private sdi_filename As String
'meet information
Private meet_name As String
Private meet_location As String
Private meet_date As Date
Private meet_course As Integer, meas As String
Private mtype As Integer

Private numsessions As Integer
Private swim_keys() As Integer
Private sfl As Integer
Private db As dBase, rec As Recordset
Dim index As Integer, swim_eof As Boolean
Dim clDate As New Dates
Dim stp As New Setup
Private meet_key As Integer
Dim evrec As Recordset
Private reqLSC As Boolean
Private thisLSC As String

'unmatched swimmers stored here
Private noMatches As New Collection     'each name once
Private all_nomatches As New Collection 'all records stored here
Private strk As New stroke

'club management
Private clb As New Clubs
Private alias As Collection 'set by clubalias
Private club_code As String      'current club being processed

'variables used to manage splits
Private finalflag As Boolean        'import finals
Private bothflag As Boolean         'import prelims
Private split_flag As Boolean       'save splits if true
Private split_list() As Single      'array of split times
Private split_count As Integer      'number in array
Private stroke_key As Integer
Private club_key As Integer
Private stype As Integer
Private attached_flag As Boolean
Private eventkey As Long

'swimmers class
Private sw As New Swimmers

'relay data
Private rela As New RELAY

'these mimic the constants in the SwimType table
Const PRELIMS = 1, FINALS = 2, TFINALS = 3, swimoff = 4, TIMETRIAL = 5, RELAY = 6
Const YDS = 1, LCM = 2, SCM = 3 'must match course class--NOT SDI order

'SDI record types
Dim dum As Dum_rec
Dim a0 As Filedesc          'A0, used as general input field
Dim meetrec As MeetRecord   'B1
Dim clubrec As Team_ID      'C1
Dim d0 As Individual_event  'D0
Dim e0 As Relay_event       'E0
Dim f0 As Relay_Name     'F0
Dim g0 As Split_record      'G0

'current swimmer
Private prev_name As String         'name of last one read
Private swimmer_key As Integer
Private name_found As Boolean       'wether matched or not

Public Sub setDB(datab As dBase)
Set db = datab
ReDim split_list(70) As Single
End Sub
Public Sub setMeetType(m_type As Integer)
mtype = m_type
End Sub
Public Sub setLocation(locn$)
meet_location = locn$
End Sub
Public Sub setDescription(desc$)
meet_name = desc$
End Sub

Public Sub import(file$)
Dim mt As New Meets
Dim found As Boolean, quit As Boolean, newmeet As Boolean
Dim cb$, LSC$, ans As Integer

'find the key for this meet: it will usually be new
mt.setDB db
meet_key = mt.findKey(meet_name, meet_location, meet_date, meet_course, newmeet, mtype)
ans = vbYes
If Not newmeet Then
 ans = MsgBox("A meet with this name and date has already been imported." + Chr(13) + _
   "Do you want to continue anyway?", vbYesNo, "Duplicate meet")
End If
 If ans = vbYes Then

sdi_filename = file$
clb.setDB db
clb.openClubs       'club lookup
rela.setDB db

'read in the meet file and meet data
readMeet file$    'read in meet and data
mt.setLocation meet_location
mt.setDescription meet_name
mt.setCourse meet_course
'now match clubs for legal initials
makeClubList
Screen.MousePointer = vbHourglass


Set evrec = db.openTableRecord("Events")
sw.setDB db
openSDIFile
Get #sfl, , a0
If a0.rectype = "A0" Then     'legal file
  quit = False
 While Not EOF(sfl) And Not quit
   Get #sfl, , a0
   Select Case a0.rectype
     Case "C1"
      LSet clubrec = a0
      club_code = getClubName(clubrec, LSC$)
      club_key = clb.findKey(club_code)
       If club_key = 0 Then
           club_code = findAlias(club_code)
           club_key = clb.findKey(club_code)
       End If

     Case "D0"
      LSet d0 = a0
      If club_key > 0 Or club_code = "none" Then enter_kid
     Case "G0"
      LSet g0 = a0
       enter_splits    'uses d0 and g0
     Case "E0"
      LSet e0 = a0
      If club_key > 0 Then enter_relay    'uses relayeven
     Case "F0"
      LSet f0 = a0
      If club_key > 0 Then enter_relayname 'uses relayname
    End Select
 Wend
Else
  MsgBox "Not a USS SDI File"
End If
Screen.MousePointer = vbDefault

UnmatchedSwmrs.setCollection noMatches
UnmatchedSwmrs.setDB db
UnmatchedSwmrs.setsdi Me
UnmatchedSwmrs.Show vbModal
End If  'not new
End Sub
Public Sub enter_relay()
Dim club As String, j As Integer, relayswimmerkey As Integer

  club_key = clb.findKey(club_code)
  If club_key = 0 Then
   club_code = alias.Item(club_code)
   club_key = clb.findKey(club_code)
  End If
  club = clb.getName(club_code)
  Set rec = sw.findName(club)
  If rec.RecordCount = 0 Then
   Set rec = db.openTableRecord("Swimmers")
   rec.AddNew
   rec![Name] = Left$(club, rec![Name].Size)
   rec![Lastname] = ""
   rec![Firstname] = ""
   j = InStr(club, " ")
   If j > 0 Then
     rec![Lastname] = Left$(Left$(club, j - 1), rec![Lastname].Size)
     rec![Firstname] = Left$(Right$(club, Len(club) - j), rec![Firstname].Size)
   End If
   rec![clubkey] = club_key
   rec.update
   rec.MoveLast
  End If
  relayswimmerkey = rec![SwimmerKey]
  add_RelayEvent relayswimmerkey
End Sub
Public Sub enter_relayname()

End Sub
Public Sub setMatched(matched As Collection)
Dim swm As Integer, i As Integer, j As Integer, k As Integer
Dim key As Integer, s$, swname As String, thisname As String
Dim thisd0 As String
'each line in collection contains a swimmer key
'followed by a dash, followed by a swimmer name
For swm = 1 To matched.Count
  s$ = matched.Item(swm)
  i = InStr(s$, "-")
  If i > 0 Then
    swimmer_key = Val(Left$(s$, i - 1))
    swname = Trim$(Right$(s$, Len(s$) - i))
    For j = 1 To all_nomatches.Count
       thisd0 = all_nomatches(j)
       For k = 1 To Len(thisd0)
         Mid$(dum.dummy, k, 1) = Mid$(thisd0, k, 1)
       Next k
       LSet d0 = dum
       thisname = Trim$(d0.Swimmername)
       If thisname = swname Then
         Set rec = sw.findKey(swimmer_key)
         club_key = rec![clubkey]
         add_indiv_event
       End If
    Next j
  End If
Next swm

End Sub
Private Sub enter_kid()
Dim nm$, lname$, frname$
Dim i As Integer, ans As Integer, thisd0 As String

'uses contents of current d0 record
nm$ = Trim$(d0.Swimmername)
ImportMeet.status.Caption = nm$
ImportMeet.status.Refresh

ans = DoEvents      'allow interrupts
If (Not reqLSC) Or (reqLSC And d0.LSC = thisLSC) Then
If nm$ <> prev_name$ Then
  i = InStr(nm$, ",")
  If i > 0 Then
    lname$ = Left$(nm$, i - 1)
    frname$ = Trim$(Right$(nm$, Len(nm$) - i))
  End If
  Set rec = sw.findSwimmer(lname$, frname$, club_code, d0.init, Val(d0.cbirth), name_found)
  If name_found Then
    swimmer_key = rec![SwimmerKey]
    add_indiv_event      'uses d0 and swimmerkey
  Else
    noMatches.Add nm$ & " - " & club_code
    LSet dum = d0
    thisd0 = dum.dummy
    all_nomatches.Add thisd0
  End If
Else
  If name_found Then
     add_indiv_event        'else add to current swimmer
  Else
    LSet dum = d0
    thisd0 = dum.dummy
    all_nomatches.Add thisd0   'all unmatched records to this collection
  End If
End If
End If
prev_name = nm$
End Sub
Private Sub add_indiv_event()
'adds one event result for current swimmer and club
Dim t As Single, valid As Boolean, stype As Integer
Dim ckey As Integer

t = getTime(valid, stype, ckey)
If valid Then
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    stroke_key = Val(d0.stroke)   'NOTE this depends on order being the same
    evrec![strokekey] = stroke_key
    evrec![courseKey] = ckey
    evrec![Distance] = Val(d0.dist)
    evrec![meetKey] = meet_key
    attached_flag = (d0.attached = "A")
    evrec![attached] = attached_flag
    evrec![courseKey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = 0
    evrec.update        'don't save if invalid
    evrec.MoveLast
    eventkey = evrec![eventkey]
End If
End Sub
Private Sub add_RelayEvent(relaykey)
'adds one event result for current swimmer and club
Dim t As Single, valid As Boolean, stype As Integer
Dim ckey As Integer

t = getRelayTime(valid, stype, ckey)
If valid Then
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = relaykey
    stroke_key = Val(e0.stroke)   'NOTE this depends on order being the same
    evrec![strokekey] = stroke_key
    evrec![courseKey] = ckey
    evrec![Distance] = Val(e0.dist)
    evrec![meetKey] = meet_key
    attached_flag = True
    evrec![attached] = attached_flag
    evrec![courseKey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = 0
    evrec.update        'don't save if invalid
    evrec.MoveLast
    eventkey = evrec![eventkey]
End If
End Sub
Private Function getTime(valid As Boolean, stype As Integer, course_key As Integer) As Single
Dim result As Single, final As Single
Dim fvalid As Boolean, rvalid As Boolean
Dim rkey As Integer, fkey As Integer
'checks settings of bothflag and finalflag and
'returns either the fastest of the two or
'the desired legal time. Valid is false if not legal

  result = getRealTime(d0.prelim, rvalid)
  final = getRealTime(d0.final, fvalid)
  rkey = getCourseKey(d0.prelimcourse)
  If rkey = 0 Then rvalid = False       'mean's DQ'd
  fkey = getCourseKey(d0.finalcourse)
  If fkey = 0 Then fvalid = False
If bothflag = False And finalflag = False Then
  If rvalid Then
    getTime = result
    valid = True
    course_key = rkey
  End If
  If fvalid And Not rvalid Then
    getTime = final
    stype = PRELIMS
    valid = True
    course_key = fkey
  End If
End If
If (Not bothflag) And finalflag Then
  getTime = final
  stype = FINALS
  course_key = fkey
End If
If bothflag Then
  If Not fvalid And rvalid Then
    getTime = result
    valid = rvalid
    stype = PRELIMS
    course_key = rkey
  End If
  If Not rvalid And fvalid Then
    getTime = final
    valid = fvalid
    stype = PRELIMS
    course_key = fkey
  End If
  If fvalid And rvalid Then
    If result < final Then
      getTime = result
      stype = PRELIMS
      course_key = rkey
    Else
      getTime = final
      stype = FINALS
      course_key = fkey
    End If
    valid = True
  End If
End If
End Function
Private Function getRelayTime(valid As Boolean, stype As Integer, course_key As Integer) As Single
 Dim result As Single, final As Single
Dim fvalid As Boolean, rvalid As Boolean
Dim rkey As Integer, fkey As Integer
  result = getRealTime(e0.prelim, rvalid)
  final = getRealTime(e0.final, fvalid)
  rkey = getCourseKey(e0.prelimcourse)
  If rkey = 0 Then rvalid = False       'mean's DQ'd
  fkey = getCourseKey(e0.finalcourse)
  If fkey = 0 Then fvalid = False
If bothflag = False And finalflag = False Then
  If rvalid Then
    getRelayTime = result
    valid = True
    course_key = rkey
  End If
  If fvalid And Not rvalid Then
    getRelayTime = final
    stype = PRELIMS
    valid = True
    course_key = fkey
  End If
End If
If (Not bothflag) And finalflag Then
  getRelayTime = final
  stype = FINALS
  course_key = fkey
End If
If bothflag Then
  If Not fvalid And rvalid Then
    getRelayTime = result
    valid = rvalid
    stype = PRELIMS
    course_key = rkey
  End If
  If Not rvalid And fvalid Then
    getRelayTime = final
    valid = fvalid
    stype = PRELIMS
    course_key = fkey
  End If
  If fvalid And rvalid Then
    If result < final Then
      getRelayTime = result
      stype = PRELIMS
      course_key = rkey
    Else
      getRelayTime = final
      stype = FINALS
      course_key = fkey
    End If
    valid = True
  End If
End If

End Function
Private Function getCourseKey(s$)
Select Case s$
  Case "2", "Y"
   getCourseKey = YDS
  Case "3", "L"
   getCourseKey = LCM
  Case "1", "S"
   getCourseKey = SCM
  Case "X"
    getCourseKey = 0    'DQ's
 End Select
End Function
Private Function getRealTime(s As String, valid As Boolean) As Single
Dim i As Integer, t As Single
i = InStr(s, ":")
If i > 0 Then
  s = Trim$(Left$(s, i - 1) + Right$(s, Len(s) - i))
End If
t = Val(s)
If t > 0 Then
  valid = True
  getRealTime = t
Else
  valid = False
  getRealTime = 0
End If
End Function
Private Sub enter_splits()
Dim i As Integer, sfirst As Integer, j As Integer
Dim valid As Boolean, ftime As Single
 If club_key > 0 And name_found Then
  split_count = Val(g0.total_splits)
  i = 1
  j = 1
  sfirst = 0
  While i <= split_count
    While i <= split_count And j <= 10
     split_list(i) = getRealTime(g0.Split_time(j), valid)
     i = i + 1
     j = j + 1
    Wend
    If i < split_count Then
      Get #sfl, , g0
      j = 1
    End If
  Wend
 ftime = evrec![SwimTime]
  If split_list(split_count) = ftime Then 'allow splits to be added
    Select Case evrec![Distance]
      Case 100
        save_100s eventkey
      Case 200
        save_200s eventkey
      Case 400
        save_400s eventkey
      Case 500
        save_500s eventkey
      Case 800
        save_800s eventkey
      Case 1000
        save_1000s eventkey
      Case 1500
        save_1500s eventkey
      Case 1650
        save_1650s eventkey
    End Select
  End If
 End If

End Sub
Private Sub save_100s(eventkey As Long)
If stroke_key <> IM Then
  If split_count = 4 Then
    add_split_event eventkey, 50, split_list(2)
  End If
  If split_count = 2 Then
    add_split_event eventkey, 50, split_list(1)
  End If
End If
End Sub
Private Sub save_200s(eventkey As Long)
If stroke_key <> IM Then
 If split_count = 4 Then
  add_split_event eventkey, 100, split_list(2)
 End If
 If split_count = 8 Then
  add_split_event eventkey, 100, split_list(4)
 End If
End If
End Sub
Private Sub save_500s(eventkey As Long)
If split_count = 10 Then
  add_split_event eventkey, 200, split_list(4)
End If
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(8)
End If
End Sub
Private Sub save_400s(eventkey As Long)
If stroke_key = IM Then
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(1), FLY
  End If
  If split_count = 8 Then
    add_split_eventAndStroke eventkey, 100, split_list(2), FLY
  End If
  If split_count = 4 Then
    add_split_eventAndStroke eventkey, 100, split_list(4), FLY
  End If
Else
  If split_count = 4 Then
    add_split_event eventkey, 100, split_list(1)
    add_split_event eventkey, 200, split_list(2)
  End If
  If split_count = 8 Then
    add_split_event eventkey, 100, split_list(2)
    add_split_event eventkey, 200, split_list(4)
  End If
  If split_count = 16 Then
    add_split_event eventkey, 100, split_list(4)
    add_split_event eventkey, 200, split_list(8)
  End If
End If
End Sub
Private Sub save_800s(eventkey As Long)
If split_count = 8 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 400, split_list(4)
End If
If split_count = 16 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 400, split_list(8)
End If
End Sub
Private Sub save_1000s(eventkey As Long)
If split_count = 20 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 500, split_list(10)
End If
If split_count = 40 Then
  add_split_event eventkey, 200, split_list(8)
  add_split_event eventkey, 400, split_list(20)
End If
End Sub
Private Sub save_1500s(eventkey As Long)
If split_count = 15 Then
  add_split_event eventkey, 200, split_list(2)
  add_split_event eventkey, 800, split_list(8)
End If
If split_count = 30 Then
  add_split_event eventkey, 200, split_list(4)
  add_split_event eventkey, 800, split_list(16)
End If
End Sub
Private Sub save_1650s(eventkey As Long)
If split_count = 33 Then
  add_split_event eventkey, 500, split_list(10)
  add_split_event eventkey, 1000, split_list(20)
End If
If split_count = 66 Then
  add_split_event eventkey, 500, split_list(20)
  add_split_event eventkey, 1000, split_list(40)
End If
End Sub
Private Sub add_split_event(evkey As Long, dist As Integer, t As Single)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![courseKey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.update
End Sub
Private Sub add_split_eventAndStroke(evkey As Long, dist As Integer, t As Single, stroke_key As Integer)
    evrec.AddNew
    evrec![SwimTime] = t
    evrec![SwimmerKey] = swimmer_key
    evrec![strokekey] = stroke_key 'NOTE this depends on order being the same
    evrec![Distance] = dist
    evrec![meetKey] = meet_key
    evrec![attached] = attached_flag
    evrec![courseKey] = meet_course
    evrec![clubkey] = club_key
    evrec![SwimType] = stype
    evrec![SplitEventKey] = evkey
    evrec.update
End Sub


Public Sub importBoth()
  bothflag = True
End Sub
Public Sub importPrelims()
  bothflag = False
  finalflag = False
End Sub
Public Sub importFinals()
  finalflag = True
  bothflag = False
End Sub
Public Sub setSplits(savesplits As Boolean)
 split_flag = savesplits
End Sub

Public Sub makeClubList()
Dim i As Integer, club_count As Integer
Dim cmax As Integer, cb$, j As Integer
Dim found As Boolean, key As Integer, LSC$
'make a table of all the clubs in the meet
'belonging to this LSC or having no spec'd LSC


cmax = 100
club_count = 0
ReDim club_names(cmax) As String
openSDIFile
While Not EOF(sfl)
 Get #sfl, , dum
 If Left$(dum.dummy, 2) = "C1" Then
  LSet clubrec = dum
  cb$ = getClubName(clubrec, LSC$)
  If LSC$ = "" Or LSC$ = stp.getLSC Then
    found = False
    j = 1
    While j <= club_count And Not found
     found = cb$ = club_names(j)
     j = j + 1
    Wend
    If Not found Then
      club_count = club_count + 1
      If club_count > cmax Then
        cmax = cmax + 50
        ReDim Preserve club_names(cmax) As String
      End If
      club_names(club_count) = cb$
    End If
  End If '   If in LSC
 End If 'if C1 record
Wend
'now filter for legal clubs
For i = 1 To club_count
 key = clb.findKey(club_names(i))
 If key <> 0 Then
   club_names(i) = ""   'erase those which are found
 End If
Next i
'load remainder into a collection and pass it to
'the alias form
Dim colClubs As New Collection
For i = 1 To club_count
  If club_names(i) <> "" Then
    colClubs.Add club_names(i), club_names(i)
  End If
Next i
If colClubs.Count > 0 Then  'bring up alias box
  ClubAlias.setBadClubs colClubs
  ClubAlias.setDB db
  ClubAlias.Show vbModal
  Set alias = ClubAlias.getAliases
  Unload ClubAlias
End If

End Sub
Private Function getClubName(clubrec As Team_ID, LSC$) As String
Dim c$
  c$ = RTrim$(clubrec.TeamCode + clubrec.ExtendedTeamCode)
  LSC$ = Trim$(Left$(c$, 2))
  getClubName = Right$(c$, Len(c$) - 2)
End Function
Private Sub openSDIFile()

sfl = FreeFile
Open sdi_filename For Binary As #sfl Len = Len(dum)
End Sub
Private Sub closeSDIFIle()
Close #sfl
End Sub
Private Function findAlias(club_code As String) As String
On Local Error GoTo noclub
findAlias = alias.Item(club_code)
okclub:
Exit Function

noclub:
  findAlias = "none"
  Resume okclub
End Function
Public Sub readMeet(file$)
Dim found As Boolean, m$
Dim locn$, mname$ 'not used
sdi_filename = file$
openSDIFile
found = False
While Not EOF(sfl) And Not found
  Get #sfl, , dum
  If Left$(dum.dummy, 2) = "B1" Then
    found = True
    LSet meetrec = dum
  End If
Wend
mname$ = Trim$(meetrec.meetName)
locn$ = Trim$(meetrec.City) + ", " + Trim$(meetrec.State)

m$ = meetrec.Startdate

m$ = Left$(m$, 2) + "-" + Mid$(m$, 3, 2) + "-" + Right$(m$, 4)
clDate.setStringDate m$
meet_date = clDate.getDate
closeSDIFIle
End Sub
Public Function meetName() As String
meetName = meet_name
End Function
Public Function meetLocation() As String
meetLocation = meet_location
End Function
Public Function getDate() As Date
getDate = meet_date
End Function
Public Sub setCourse(c$)
Dim crs As New course
crs.setDB db
meet_course = crs.findKey(c$)
End Sub
Public Sub setLSC(LSC As String)
reqLSC = True
thisLSC = LSC
End Sub

Private Sub class_Initialize()
reqLSC = False
End Sub
