VERSION 4.00
Begin VB.Form ImportMeet 
   Caption         =   "Import LSA Meet File"
   ClientHeight    =   5100
   ClientLeft      =   1140
   ClientTop       =   1740
   ClientWidth     =   7455
   Height          =   5580
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   5100
   ScaleWidth      =   7455
   Top             =   1320
   Width           =   7575
   Begin VB.CheckBox requireLSC 
      Caption         =   "Require LSC name"
      Height          =   255
      Left            =   1920
      TabIndex        =   27
      Top             =   3120
      Width           =   1815
   End
   Begin VB.ComboBox cbMeetType 
      Height          =   315
      Left            =   6240
      Style           =   2  'Dropdown List
      TabIndex        =   25
      Top             =   2640
      Width           =   1215
   End
   Begin VB.TextBox teamName 
      Height          =   375
      Left            =   2520
      TabIndex        =   24
      Text            =   " "
      Top             =   4680
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.CheckBox onlyOneteam 
      Caption         =   "Add only one team"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      Top             =   4800
      Width           =   2055
   End
   Begin VB.CheckBox AddUnmatched 
      Caption         =   "Add unmatched Swimmers"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      Top             =   4440
      Width           =   2775
   End
   Begin VB.CheckBox Importsplits 
      Caption         =   "Import splits"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   3480
      Width           =   1575
   End
   Begin VB.CommandButton Cancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   495
      Left            =   1680
      TabIndex        =   19
      Top             =   3840
      Width           =   1095
   End
   Begin VB.CommandButton Import 
      Caption         =   "Begin Import"
      Default         =   -1  'True
      Height          =   495
      Left            =   120
      TabIndex        =   18
      Top             =   3840
      Width           =   1215
   End
   Begin VB.Frame Frame2 
      Caption         =   "Select times to import"
      ForeColor       =   &H00FF0000&
      Height          =   1455
      Left            =   3960
      TabIndex        =   14
      Top             =   3240
      Width           =   1695
      Begin VB.OptionButton Final 
         Caption         =   "Final time"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   960
         Width           =   1215
      End
      Begin VB.OptionButton Prelim 
         Caption         =   "Prelim time"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton Fastest 
         Caption         =   "Fastest time"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select course"
      ForeColor       =   &H00FF0000&
      Height          =   1455
      Left            =   5760
      TabIndex        =   10
      Top             =   3240
      Width           =   1575
      Begin VB.OptionButton Scm 
         Caption         =   "SCM"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton Lcm 
         Caption         =   "LCM"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   600
         Width           =   855
      End
      Begin VB.OptionButton Yds 
         Caption         =   "YDS"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   240
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin VB.TextBox MeetDate 
      Height          =   285
      Left            =   4680
      TabIndex        =   9
      Text            =   " "
      Top             =   2640
      Width           =   1455
   End
   Begin VB.TextBox MeetLocation 
      Height          =   375
      Left            =   4680
      TabIndex        =   5
      Text            =   " "
      Top             =   1800
      Width           =   2415
   End
   Begin VB.TextBox Meetname 
      Height          =   375
      Left            =   4680
      TabIndex        =   4
      Text            =   " "
      Top             =   1080
      Width           =   2535
   End
   Begin VB.FileListBox File1 
      Height          =   2010
      Left            =   2280
      Pattern         =   "*.mt4"
      TabIndex        =   2
      Top             =   840
      Width           =   1575
   End
   Begin VB.DirListBox Dir1 
      Height          =   2055
      Left            =   360
      TabIndex        =   1
      Top             =   840
      Width           =   1575
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
   Begin VB.Label Label5 
      Caption         =   "Meet Type"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   6240
      TabIndex        =   26
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Status 
      Caption         =   " "
      Height          =   255
      Left            =   4680
      TabIndex        =   21
      Top             =   120
      Width           =   2535
   End
   Begin VB.Label Label4 
      Caption         =   "Meet date"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   4800
      TabIndex        =   8
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Meet location"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   4800
      TabIndex        =   7
      Top             =   1560
      Width           =   1935
   End
   Begin VB.Label Label2 
      Caption         =   "Meet name"
      ForeColor       =   &H00FF0000&
      Height          =   375
      Left            =   4800
      TabIndex        =   6
      Top             =   600
      Width           =   2295
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Select Meet (MT4) file from desired directory"
      ForeColor       =   &H00FF0000&
      Height          =   495
      Left            =   1920
      TabIndex        =   3
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "ImportMeet"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Dim meetfile As String
Dim sdiflag As Boolean
Dim sdf As New SDIFile
Dim db As dBase
Dim mtype As New MeetType
Dim reqLSC As Boolean
Dim stp As New Setup
Public Sub setDB(datab As dBase)
Set db = datab
End Sub

Private Sub Cancel_Click()
Unload ImportMeet
Screen.MousePointer = vbDefault
End Sub

Private Sub Dir1_Change()
File1.path = Dir1.path
End Sub

Private Sub Drive1_Change()
Dir1.path = Drive1.Drive
End Sub
Public Sub setsdi()
sdiflag = True
File1.Pattern = "*.cl2;*.sdi;*.sdf;*.txt"
Label1.Caption = "Select SDI (cl2) file from desired directory"
End Sub
Public Sub setLSA()
sdiflag = False
File1.Pattern = "*.mt4"
Label1.Caption = "Select Meet (MT4) file from desired directory"
End Sub

Private Sub File1_Click()
Dim mname$, mlocn$, mdate As Single, mcrs$
Dim F As Integer, dt As New Dates
meetfile = File1.path + "\" + File1.filename
If Not sdiflag Then
 F = FreeFile
 Open meetfile For Input As #F
 Line Input #F, mname$    'skip "Swim 4.0" line
 Line Input #F, mname$
 Line Input #F, mlocn$
 Input #F, mdate
 Line Input #F, mcrs$
 Close #F
 dt.setSDate mdate
Else
  sdf.readMeet (meetfile)
  mname$ = sdf.meetName
  mlocn$ = sdf.meetLocation
  dt.setDDate sdf.getDate
End If
meetName.Text = mname$
meetLocation.Text = mlocn$
MeetDate.Text = dt.formatDate
Select Case mcrs$
  Case "YDS"
    YDS.Value = True
  Case "LCM"
    LCM.Value = True
  Case "SCM"
    SCM.Value = True
End Select
End Sub

Private Sub Form_Load()
'sdiflag = False
'Dim stp As New Setup
reqLSC = False
requireLSC.Caption = "Require LSC=" + stp.getLSC()
mtype.setDB db
mtype.opentable
While Not mtype.EndFile
  cbMeetType.AddItem mtype.getNext
Wend
If cbMeetType.ListCount > 0 Then
  cbMeetType.ListIndex = 0
End If
End Sub

Private Sub import_Click()
Dim m5 As New Meet5Data
Dim locn$, mname$
Dim error As Boolean, ans As Integer

error = False
If requireLSC.Value = 1 Then reqLSC = True
locn$ = Trim$(meetLocation.Text)
mname$ = Trim$(meetName.Text)
If Len(locn$) < 2 Then
  error = True
  MsgBox "You must enter a meet location"
End If
If Len(mname$) < 2 Then
  error = True
  MsgBox "You must enter a meet name"
End If
If Not error Then
 db.BeginTrans          'begin transaction
 If Not sdiflag Then
  m5.setDB db
  m5.setMeetname meetName.Text
  m5.setDate MeetDate.Text
  m5.setLocation meetLocation.Text
  m5.setMeetType cbMeetType.ListIndex + 1
  If YDS.Value Then m5.setCourse ("YDS")
  If LCM.Value Then m5.setCourse ("LCM")
  If SCM.Value Then m5.setCourse ("SCM")
  If Fastest.Value Then m5.importBoth
  If prelim.Value Then m5.importPrelims
  If final.Value Then m5.importFinals
  m5.setSplits (Importsplits.Value = 1)
  m5.import meetfile
 Else
  sdf.setDB db
  sdf.setLocation meetLocation.Text
  sdf.setDescription meetName.Text
  If YDS.Value Then sdf.setCourse ("YDS")
  If LCM.Value Then sdf.setCourse ("LCM")
  If SCM.Value Then sdf.setCourse ("SCM")

  If Fastest.Value Then sdf.importBoth
  If prelim.Value Then sdf.importPrelims
  If final.Value Then sdf.importFinals
  sdf.setLSC (stp.getLSC)
  sdf.import meetfile
 End If
 ans = MsgBox("Do you want to confirm this database entry?" + Chr$(13) + "Click No to roll back to previous state", vbYesNo, "Confirm update to database")
 If ans = vbYes Then
   db.Commit
 Else
   db.RollBack
 End If
Set m5 = Nothing
Set sdf = Nothing
 Unload ImportMeet
End If 'if no errors
End Sub

Private Sub onlyOneteam_Click()
If onlyOneteam.Value = 1 Then
  Teamname.Visible = True
Else
  Teamname.Visible = False
End If
End Sub

Private Sub outLSC_Click()

End Sub
