VERSION 5.00
Begin VB.Form viewEntries 
   Caption         =   "View meet entries"
   ClientHeight    =   5370
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   9540
   LinkTopic       =   "Form1"
   ScaleHeight     =   5370
   ScaleWidth      =   9540
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Save 
      Caption         =   "Save"
      Height          =   375
      Left            =   2640
      TabIndex        =   7
      ToolTipText     =   "Save with new scratches"
      Top             =   4800
      Width           =   1095
   End
   Begin VB.CommandButton btUnScratch 
      Caption         =   "<--unScr"
      Enabled         =   0   'False
      Height          =   375
      Left            =   8640
      TabIndex        =   6
      ToolTipText     =   "unScratch highligted swimmer"
      Top             =   1320
      Width           =   855
   End
   Begin VB.CommandButton btScratch 
      Caption         =   "<--Scr"
      Enabled         =   0   'False
      Height          =   375
      Left            =   8640
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Sratch highlighted swimmer"
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton btClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   3960
      TabIndex        =   4
      ToolTipText     =   "Clsoe without saving scratches"
      Top             =   4800
      Width           =   1215
   End
   Begin VB.CommandButton btLoad 
      Caption         =   "Read in squads"
      Height          =   375
      Left            =   120
      TabIndex        =   3
      ToolTipText     =   "Begin reading in squads"
      Top             =   2640
      Width           =   1575
   End
   Begin VB.ListBox lsSquads 
      Height          =   1815
      Left            =   0
      MultiSelect     =   1  'Simple
      TabIndex        =   2
      ToolTipText     =   "Select squads to read in"
      Top             =   480
      Width           =   1815
   End
   Begin VB.ListBox lsEntries 
      Height          =   2595
      Left            =   5400
      TabIndex        =   1
      ToolTipText     =   "Select swimmer to scratch"
      Top             =   480
      Width           =   3015
   End
   Begin VB.ListBox lsEvents 
      Height          =   4155
      Left            =   2160
      TabIndex        =   0
      ToolTipText     =   "Select event to view"
      Top             =   480
      Width           =   2895
   End
End
Attribute VB_Name = "viewEntries"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private mt As Meet
Private entries As clsEntries
Dim swlist() As Swimmer
Dim tlist() As kidEntry
Dim squad_coln As New Collection
Dim path As String
Private sq As New Squads
Private db As Database
Private stp As New Setupdata
Private Sub btClose_Click()
Unload Me
End Sub
Public Sub setDB(datab As Database)
Set db = datab
End Sub
Private Sub btLoad_Click()
Dim fl As New file, i As Integer

Set entries = Nothing
Set entries = New clsEntries
Screen.MousePointer = vbHourglass
For i = 0 To lsSquads.ListCount - 1
  If lsSquads.Selected(i) Then
    path = mt.getPath
    fl.setFile mt.getPath + "\" + lsSquads.List(i) + ".ini"
    squad_coln.add lsSquads.List(i)
    entries.setMeet mt
    entries.setDB db
    entries.readEntry fl
  End If
Next i
Screen.MousePointer = vbDefault
btLoad.Enabled = False
lsEvents.Enabled = True
End Sub

Private Sub btScratch_Click()
Dim i As Integer, ken As kidEntry
i = lsEntries.ListIndex
If i >= 0 Then
    Set ken = tlist(i + 1)
    ken.setScratch True
End If
lsEvents_Click
i = i + 1
If i < lsEntries.ListCount Then
  lsEntries.ListIndex = i
End If
End Sub

Private Sub btUnScratch_Click()
Dim i As Integer, ken As kidEntry
i = lsEntries.ListIndex
If i >= 0 Then
    Set ken = tlist(i + 1)
    ken.setScratch False
End If
lsEvents_Click
lsEntries.ListIndex = i
End Sub

Private Sub Form_Load()
Dim S$, fl As New file
S$ = stp.getMeetFile

fl.setFile S$
S$ = Dir(fl.pathName + "*.ini")
While (Len(S$) > 0)
  lsSquads.AddItem Left$(S$, Len(S$) - 4)
  S$ = Dir$
Wend
End Sub
Public Sub setMeet(met As Meet)
Dim ev As clsEvents
Dim count As Integer, i As Integer
Set mt = met

For i = 1 To mt.eventCount
 Set ev = mt.getEvent(i)
 lsEvents.AddItem Str$(i) + " " + ev.sexString + ev.AgeString + Chr$(9) + Str$(ev.Distance) + " " + ev.stroke
Next i
lsEvents.Enabled = False
End Sub

Private Sub lsEntries_Click()
btScratch.Enabled = True
btUnScratch.Enabled = True
End Sub

Private Sub lsEntries_KeyPress(KeyAscii As Integer)
Dim i As Integer
i = lsEntries.ListIndex
If i >= 0 Then
    If KeyAscii = Asc("S") Or KeyAscii = Asc("s") Then
        btScratch_Click
    End If
    If KeyAscii = Asc("U") Or KeyAscii = Asc("u") Then
        btUnScratch_Click
    End If
lsEntries.ListIndex = i
End If
End Sub

Private Sub lsEvents_Click()
Dim evnum As Integer
Dim swcol As Collection
Dim sw As Swimmer, tim As New times
Dim b As Boolean, t As Single, i As Integer, j As Integer, max As Integer
Dim ken As kidEntry

evnum = lsEvents.ListIndex + 1
'btScratch.Enabled = False
'btUnScratch.Enabled = False

Set swcol = entries.getEntries(evnum)
lsEntries.clear
ReDim swlist(swcol.count) As Swimmer
ReDim tlist(swcol.count) As kidEntry
'copy into array
j = 1
max = swcol.count \ 2
For i = 1 To max
  Set swlist(i) = swcol(j)
  Set tlist(i) = swcol(j + 1)
  j = j + 2
Next i
'sort into ascending order
For i = 1 To max
  For j = i To max
    If tlist(i).getTime > tlist(j).getTime Then
      Set ken = tlist(i)
      Set tlist(i) = tlist(j)
      Set tlist(j) = ken
      Set sw = swlist(i)
      Set swlist(i) = swlist(j)
      Set swlist(j) = sw
    End If
  Next j
Next i
For i = 1 To max
  Set sw = swlist(i)
  Set ken = tlist(i)
  tim.setSingle ken.getTime
  If ken.isScratched Then
    tim.setSingle tim.SCRATCH
  End If
  lsEntries.AddItem sw.Nickname + " " + sw.LastName + Chr$(9) + tim.getFormatted
Next i
End Sub

Private Sub Save_Click()
Dim S As Integer, squad_key As Integer
Dim ini As New Profile

Dim tcnt As Integer, i As Integer
Dim sw As Swimmer

For S = 1 To squad_coln.count
ini.setFilename path + "\" + squad_coln(S) + ".ini"
sq.setDB db
squad_key = sq.getSquadKey(squad_coln(S))
'write all entries into ini-style file with time proofs

'first write out meet details
ini.putProfile "Meet", "Name", mt.Meetname
ini.putProfile "Meet", "Date", Format$(mt.MeetDate, "mm-dd-yyyy")

'ini.putProfile "Meet", "Squads", sq.getSquadList

'write out each swimmer's entries
tcnt = 0
For i = 1 To entries.count
  Set sw = entries.getSwimmer(i)
  If sw.getSquadKey = squad_key Then
    sw.setDB db
    tcnt = tcnt + 1
    sw.writeEntry path + "\" + squad_coln(S) + ".ini", tcnt
  End If
Next i
ini.putProfile "Meet", "EntryCount", Str$(tcnt)

Next S

End Sub
