VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsEntries"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private entries As New Collection
Dim ini As New Profile
Dim fl As file
Private db As Database
Private mt As Meet
Private pr As clsPrinters
Private stp As New Setupdata
Private agegroups As New Collection
Private Sexes() As String
Private sexcount As Integer
Private event_list As New Collection
Private swimmerList As New Collection
Private namecol As Single       'end of name column
Private agecol As Single        'end of age column
Private pmessage As String
Private splash_fee As Single
Private distance_fee As Single
Private relay_fee As Single
Private swimmer_fee As Single

Private relEnt As RelayEntries 'passed in from outside for printing
Private squad_String As String  'list of squads for printout
Private lb As New Labels
Private prf As New Proofs
Private agarray() As AgeGroup
Private Landscape As Boolean
Private rOnlyCount As Integer

Private sqds As New Collection
Private swmr_events As New Collection
Private nameCol_width As Single
Private htFile As String ''name of html file
Private isHtml As Boolean 'if tue we are writing a file
Private htf As Integer
Private agrp As New AgeGroup
Public Sub setHtml(file As String)
Dim fl As New file
fl.setFile stp.getMeetFile

htFile = fl.pathName + file
htf = FreeFile

Open htFile For Output As #htf
isHtml = True
End Sub
Public Sub setPrintmode()
htFile = ""
isHtml = False
End Sub
Public Sub setNameColWidth(w As Single)
nameCol_width = w
stp.NameColumnWidth = w
End Sub
Public Function getNameColWidth() As Single
getNameColWidth = stp.NameColumnWidth
End Function
Public Sub setSplashFee(f As Single)
splash_fee = f
End Sub
Public Sub setDistanceFee(f As Single)
distance_fee = f
End Sub
Public Sub setRelayFee(f As Single)
relay_fee = f
End Sub
Public Sub setSwimmerFee(f As Single)
swimmer_fee = f
End Sub

Public Sub setDB(datab As Database)
Set db = datab
stp.setDB db
'stp.openTable
End Sub
Public Sub setFile(fil As file)
Set fl = fil
End Sub
Public Sub setMeet(met As Meet)
Set mt = met
End Sub
Public Function getCount() As Integer
getCount = entries.count
End Function

Public Function getSwimmer(i As Integer) As Swimmer
Set getSwimmer = entries(i)
End Function
Public Function add(Sw As Swimmer)
entries.add Sw, Str$(Sw.getKidKey)
End Function
Public Function isScratched(kidkey As Integer) As Boolean
Dim Sw As Swimmer
On Local Error GoTo nokid
Set Sw = entries(Str$(kidkey))
isScratched = Not Sw.hasUnscratchedEvents
Exit Function

All_scratched:
 isScratched = True
 Exit Function
nokid:
  Resume All_scratched
End Function
Public Function getSquads() As String
'returns a comma delimited string of all the squads entered
getSquads = ini.getProfile("Meet", "Squads", "")
End Function
Public Function readEntry(fil As file) As Boolean
Dim count As Integer, i As Integer
Dim Sw As Swimmer
On Local Error GoTo multiswim

If fil.exists Then
ini.setFilename fil.getFile 'tell profile reader filename
count = val(ini.getProfile("Meet", "EntryCount", "0"))
For i = 1 To count
  Set Sw = New Swimmer
  Sw.setDB db       'database
  Sw.setFile fil    'ini file name
  Sw.setMeet mt, True    'meet object
  Sw.readEntry i    'read entry from ini file
  entries.add Sw, Str$(Sw.getKidKey)     'add to list of swimmers
Next i
readEntry = True
Else
  readEntry = False
End If
Exit Function

multiswim:
  MsgBox Sw.FirstName + " " + Sw.LastName + " is entered in two squads." + Chr$(13) + "Check the entry carefully"
  Resume Next
End Function
Public Function count() As Long
count = entries.count
End Function
Public Function getEntries(evnum As Integer) As Collection
Dim Sw As Swimmer, i As Integer, t As Single
Dim ken As kidEntry
'returns a collection of swimmers who are
'entered in this event
Set swmr_events = Nothing
Set swmr_events = New Collection
For i = 1 To entries.count
  Set Sw = entries(i)
  If Sw.isInEvent(evnum, ken) Then
    swmr_events.add Sw
    swmr_events.add ken
  End If
Next i
Set getEntries = swmr_events
End Function
Private Sub printEventHeader()
If isHtml Then
  printHTEventHeader
Else
  printpEventHeader
End If
End Sub
Private Sub emptyCell()
Print #htf, "<td>-</td>"
End Sub
Private Sub htBreak()
Print #htf, "<br>";
End Sub
Private Sub printHTEventHeader()
Dim S As Integer, a As Integer, e As Integer
Dim ag As AgeGroup, senior As Boolean
Dim ev As clsEvents

Dim column As Single
Dim found As Boolean
Dim tm As New times
Dim wstring As String, numwidth As Integer
Dim oldx As Integer
Dim pev As printEvent
Dim slowFound As Boolean, fastFound As Boolean
'only print out COT if any are non zero
        found = False
        e = 1
        While e <= event_list.count And Not found
          Set pev = event_list(e)
          Set ev = pev.getEvent
          slowFound = (ev.slowcut > 0)
          fastFound = (ev.fastcut > 0)
          e = e + 1
        Wend

Print #htf, "<table border>"
Print #htf, "<tr>";
emptyCell 'name
emptyCell 'age
For e = 1 To event_list.count
Print #htf, "<td>";
    Set pev = event_list(e)
    Set ev = pev.getEvent
    Print #htf, Str$(ev.eventnumber);: htBreak
    Print #htf, Str$(ev.Distance);: htBreak
    Print #htf, ev.stroke;: htBreak
    If slowFound Then
    tm.setSingle ev.slowcut
    Print #htf, tm.getFormatted;: htBreak
    End If
    If fastFound Then
    tm.setSingle ev.fastcut
    Print #htf, tm.getFormatted;
    htBreak
    End If
Next e
Print #htf, "</td>"
End Sub
Private Sub printpEventHeader()
Dim S As Integer, a As Integer, e As Integer
Dim ag As AgeGroup, senior As Boolean
Dim ev As clsEvents

Dim column As Single
Dim found As Boolean
Dim tm As New times
Dim wstring As String, numwidth As Integer
Dim oldx As Integer
Dim pev As printEvent

pr.Xinch = agecol
        
        'print out event numbers
        For e = 1 To event_list.count
         Set pev = event_list(e)
         Set ev = pev.getEvent
         oldx = pr.X
         pr.X = pr.X + 5 'leadves room for vertical bar
         pr.lPrint Str$(ev.eventnumber)
         pr.X = oldx + pev.width
         pr.vBar
        Next e
        pr.newLine
        
        'event distances
        pr.Xinch = agecol
        For e = 1 To event_list.count
         Set pev = event_list(e)
         Set ev = pev.getEvent
         oldx = pr.X
         pr.X = pr.X + 5 'leadves room for vertical bar
         pr.lPrint Str$(ev.Distance)
         pr.X = oldx + pev.width
         pr.vBar
        Next e
        pr.newLine
        
        'event strokenames
        pr.Xinch = agecol
        For e = 1 To event_list.count
          Set pev = event_list(e)
          Set ev = pev.getEvent
          oldx = pr.X
          pr.X = pr.X + 5 'leadves room for vertical bar
          pr.lPrint ev.stroke
          pr.X = oldx + pev.width
         pr.vBar
        Next e
        pr.newLine
        
        'only print out COT if any are non zero
        found = False
        e = 1
        While e <= event_list.count And Not found
          Set pev = event_list(e)
          Set ev = pev.getEvent
          found = (ev.slowcut > 0)
          e = e + 1
        Wend
        If found Then
        'event slow cuts
            pr.Xinch = agecol
            For e = 1 To event_list.count
              Set pev = event_list(e)
              Set ev = pev.getEvent
                tm.setSingle ev.slowcut
                oldx = pr.X
                pr.X = pr.X + 5 'leadves room for vertical bar
                pr.lPrint " " + tm.getFormatted
                pr.X = oldx + pev.width
                pr.vBar
                Next e
            pr.newLine
        End If
        pr.Xinch = agecol
         'only print out COT if any are non zero
        found = False
        e = 1
        While e <= event_list.count And Not found
          Set pev = event_list(e)
          Set ev = pev.getEvent
          found = (ev.fastcut > 0)
          e = e + 1
        Wend
        If found Then
        'event slow cuts
            pr.Xinch = agecol
            For e = 1 To event_list.count
              Set pev = event_list(e)
              Set ev = pev.getEvent
                tm.setSingle ev.fastcut
                oldx = pr.X
                pr.X = pr.X + 5 'leadves room for vertical bar
                pr.lPrint " " + tm.getFormatted
                pr.X = oldx + pev.width
                pr.vBar
                Next e
            pr.newLine
        End If
        pr.Xinch = agecol
        pr.drawLineHere pr.width, pr.Y
        pr.Xinch = agecol
      
End Sub
Public Sub setLandscape()
Landscape = True
End Sub
Public Sub setPortrait()
Landscape = False
End Sub
Public Sub printEntry(prt As clsPrinters, showid As Boolean, omit_times As Boolean, showproofs As Boolean, onepage As Boolean, showNames As Boolean)
Dim S As Integer, a As Integer, e As Integer
Dim ag As AgeGroup, senior As Boolean
Dim ev As clsEvents
Dim i As Integer, j As Integer

Dim column As Single
Dim found As Boolean
Dim tm As New times
Dim wstring As String, numwidth As Integer
Dim oldx As Integer
Dim pev As printEvent
Dim Sw As Swimmer
Dim agi As AgeGroup, agmax As Integer

Screen.MousePointer = vbHourglass
Set pr = prt
'Set entries = Nothing
'Set entries = New Collection
pr.setPageNum 1

namecol = nameCol_width           'inches to end of name block
agecol = 0.25 + namecol 'inches to end of age block

If Landscape Then
    pr.setLandscape 'Print horizontally
Else
  pr.setPortrait
End If
printFirstHeader    'print header for front page
findAgeGroups       'get all the age groups

'print out message to parents
printHeaderMessage
'now being printing them out
For S = 1 To 3
  For a = 1 To agegroups.count
      Set ag = agegroups(a)
      If anyInAgeSex(agegroups.Item(a).maxage, ag.isSenior, Sexes(S)) Then
        build_EventList ag.maxage, Sexes(S)
         Set pev = event_list(1)
         Set ev = pev.getEvent
         If Not isHtml Then
            pr.HLine
            pr.newLine
            pr.testPage (8)
            pr.setSubHeadFont
            pr.Centerit ev.AgeString + " " + ev.sexString
            pr.setPageFont
            pr.HLine
        Else
          Print #htf, "<center><h3>"
          Print #htf, ev.AgeString + " " + ev.sexString;
          Print #htf, "</h3></center>"
        End If
        'event numbers
        'Now print out each swimmer's entries
      buildSwimmerList ag.maxage, ag.minage, Sexes(S)
        findColumnWidths    'extra room for nonconforming & bonus
        printEventHeader
        If Not isHtml Then
            pr.Xinch = agecol
            pr.drawLineHere pr.width, pr.Y
        End If
        
      
      printSwimmerlist ag, showid, omit_times, showproofs
     If onepage Then pr.newPage
     End If
  Next a
Next S
'print out relays
If isHtml Then
  relEnt.setHtml htf
End If
relEnt.printEntry pr, mt.MeetDate, showNames
printRelayOnly

'now print out counts
countsAndProofs showproofs
If isHtml Then
  Print #htf, "</html>"
  Close #htf
Else
    pr.endDoc
End If
Screen.MousePointer = vbDefault
End Sub
Private Sub countsAndProofs(showproofs As Boolean)
If isHtml Then
  HTcountsAndProofs showproofs
Else
  pcountsAndProofs showproofs
End If
End Sub
Private Sub HTcountsAndProofs(showproofs As Boolean)
Print #htf, "<h2>Total Swims and Fees</h2>"

printCounts
End Sub
Private Sub pcountsAndProofs(showproofs As Boolean)
pr.newLine
pr.setSubHeadFont
pr.lPrintcr "Total Swims and Fees"
pr.setPageFont
printCounts
'if we have proofs, print them out as well
    If showproofs Then
        pr.newPage
        prf.setDB db
        prf.setPrinter pr
        prf.printMeets
    End If
'print out proofs of calculated relay entries
pr.newPage
relEnt.printProof pr

End Sub
Private Sub printRelayOnly()
If isHtml Then
  printHTRelayOnly
Else
  printpRelayOnly
End If

End Sub
Private Sub printHTRelayOnly()
Dim i As Integer, found As Boolean, Sw As Swimmer
'print relay only swimmers
found = False
rOnlyCount = 0
i = 1
While i <= entries.count And Not found
  Set Sw = entries(i)
  found = Sw.relayOnly
  i = i + 1
Wend

If found Then
Print #htf, "<h2>"
    Print #htf, "Relay Only Swimmers";
    Print #htf, "</h2>"
    Print #htf, "<table border>"
    For i = 1 To entries.count
         Set Sw = entries(i)
        If Sw.relayOnly Then
         rOnlyCount = rOnlyCount + 1
        Print #htf, "<tr>";
            stCell
            Print #htf, Sw.getID;
            endCell
            stCell
            Print #htf, Sw.Nickname + " " + Sw.LastName;
            endCell
            Print #htf, "</tr>"
        End If
    Next i
    Print #htf, "</table>"
End If


End Sub
Private Sub printpRelayOnly()
Dim i As Integer, found As Boolean, Sw As Swimmer
'print relay only swimmers
found = False
rOnlyCount = 0
i = 1
While i <= entries.count And Not found
  Set Sw = entries(i)
  found = Sw.relayOnly
  i = i + 1
Wend

If found Then
    pr.newLine
    pr.setSubHeadFont
    pr.lPrintcr "Relay Only Swimmers"
    pr.setPageFont
    For i = 1 To entries.count
        Set Sw = entries(i)
        If Sw.relayOnly Then
            rOnlyCount = rOnlyCount + 1
            pr.lPrint Sw.getID
            pr.Tabbit 20
            pr.lPrintcr Sw.Nickname + " " + Sw.LastName
        End If
    Next i
End If

End Sub
Private Sub printHeaderMessage()
If pmessage <> "" Then
If isHtml Then
  printHTHeaderMessage
Else
  printpHeaderMessage
End If
End If
End Sub
Private Sub printHTHeaderMessage()
Print #htf, "<hl>"
Print #htf, pmessage
Print #htf, "<hl>"
End Sub
Private Sub printpHeaderMessage()
Dim S$, i As Integer
Dim t$
If pmessage <> "" Then
    S$ = pmessage
    pr.HLine
    pr.newLine
    i = InStr(S$, Chr$(13))
    While Len(S$) > 0 And i > 0
      If i > 0 Then
        t$ = Left$(S$, i - 1)
        pr.lPrintcr t$
        S$ = Right$(S$, Len(S$) - i)
      End If
      i = InStr(S$, Chr$(13))
    Wend
    If Len(S$) > 0 Then
        pr.lPrintcr S$
    End If
    pr.HLine
    pr.newLine
End If

End Sub
Private Function printCounts()
If isHtml Then
  printHTCounts
Else
  printpCounts
End If
End Function
Private Function printHTCounts()
Dim ag As AgeGroup
Dim a As Integer, S As Integer
Dim sum As Single
Dim sfee As Single, efee As Single, scount As Integer, ecount As Integer
Dim grfee As Single, brfee As Single, dcount As Integer
'print out count in each age group and sex
Print #htf, "<table border>"
Print #htf, "<tr>";
emptyCell
stCell
    Print #htf, "Distance evts";
endCell
stCell
    Print #htf, "Swmrs";
endCell
stCell
    Print #htf, "Events";
endCell
stCell
    Print #htf, "Swmr fees";
endCell
stCell
    Print #htf, "<b>Total fees</b>";
endCell
Print #htf, "</tr>"
For a = 1 To agegroups.count
  Set ag = agegroups(a)     'this is where the counts are kept
  'ag.clear
  For S = 1 To 3
   If ag.getCount(Sexes(S)) > 0 Then
    Print #htf, "<tr>";
    stCell
    Print #htf, ag.AgeString + " " + ag.sexString(Sexes(S))
    endCell
    
    stCell
    dcount = ag.getDistanceCount(Sexes(S))
    Print #htf, Str$(dcount)     'distance events
    endCell
    stCell
    scount = ag.getCount(Sexes(S))
    sfee = swimmer_fee * scount
    Print #htf, Str$(scount)
    endCell
    stCell
    ecount = ag.getEventCount(Sexes(S))
    efee = splash_fee * ecount + distance_fee * dcount
    Print #htf, Str$(ecount)
    endCell
    stCell
    Print #htf, Format$(sfee, "$####.00")
    endCell
    stCell
    Print #htf, Format$(efee, "$####.00")
    endCell
    sum = sum + sfee + efee
    Print #htf, "</tr>"
   End If
  Next S
Next a
'print out relays
Print #htf, "<tr>";
stCell
    Print #htf, "Women's Relays"
endCell
emptyCell
stCell
Print #htf, Str$(relEnt.getGirlRelayCount)
endCell
emptyCell
emptyCell
stCell
grfee = relEnt.getGirlRelayCount * relay_fee
Print #htf, Format$(grfee, "$####.00")
endCell
Print #htf, "</tr>"
Print #htf, "<tr>";
stCell
Print #htf, "Men's Relays"
endCell
emptyCell
stCell
Print #htf, Str$(relEnt.getBoyRelayCount)
endCell
emptyCell
emptyCell
stCell
brfee = relEnt.getBoyRelayCount * relay_fee
Print #htf, Format$(brfee, "$####.00")
endCell
Print #htf, "</tr>"

sum = sum + brfee + grfee
Print #htf, "<tr>";
stCell
Print #htf, "Total Fees"
endCell
emptyCell
emptyCell
emptyCell
emptyCell
stCell
Print #htf, Format$(sum, "$####.00");
endCell
Print #htf, "</tr>"
Print #htf, "</table>"
End Function
Private Function printpCounts()
Dim ag As AgeGroup
Dim a As Integer, S As Integer
Dim sum As Single
Dim sfee As Single, efee As Single, scount As Integer, ecount As Integer
Dim grfee As Single, brfee As Single, dcount As Integer
Dim ronlyfee As Single
'print out count in each age group and sex
pr.Tabbit 30
pr.lPrint "Distance evts"
pr.Tabbit 40
pr.lPrint "Swmrs"
pr.Tabbit 50
pr.lPrint "Events"
pr.Tabbit 60
pr.lPrint "Swmr fees"
pr.Tabbit 70
pr.lPrintcr "Total fees"
For a = 1 To agegroups.count
  Set ag = agegroups(a)     'this is where the counts are kept
  'ag.clear
  For S = 1 To 3
   If ag.getCount(Sexes(S)) > 0 Then
    pr.lPrint ag.AgeString + " " + ag.sexString(Sexes(S))
    pr.Tabbit 30
    dcount = ag.getDistanceCount(Sexes(S))
    pr.lPrint Str$(dcount)      'distance events
    pr.Tabbit 40
    scount = ag.getCount(Sexes(S))
    sfee = swimmer_fee * scount
    pr.lPrint Str$(scount)
    pr.Tabbit 50
    ecount = ag.getEventCount(Sexes(S))
    efee = splash_fee * ecount + distance_fee * dcount
    pr.lPrint Str$(ecount)
    pr.Tabbit 60
    pr.lPrint Format$(sfee, "$####.00")
    pr.Tabbit 70
    pr.lPrintcr Format$(efee, "$####.00")
    sum = sum + sfee + efee
    
   End If
  Next S
Next a
'print out relays
pr.lPrint "Women's Relays"
pr.Tabbit 40
pr.lPrint Str$(relEnt.getGirlRelayCount)
pr.Tabbit 70
grfee = relEnt.getGirlRelayCount * relay_fee
pr.lPrintcr Format$(grfee, "$####.00")

pr.lPrint "Men's Relays"
pr.Tabbit 40
pr.lPrint Str$(relEnt.getBoyRelayCount)
pr.Tabbit 70
brfee = relEnt.getBoyRelayCount * relay_fee
pr.lPrintcr Format$(brfee, "$####.00")
pr.lPrint "Relay only swimmers"
pr.Tabbit 40
pr.lPrint Str$(rOnlyCount)
ronlyfee = rOnlyCount * swimmer_fee
pr.Tabbit 70
pr.lPrintcr Format$(ronlyfee, "$####.00")

sum = sum + brfee + grfee + ronlyfee
pr.setBold
pr.lPrint "Total Fees"
pr.Tabbit 50
pr.lPrintcr Format$(sum, "$####.00")
End Function
Private Function printSwimmerlist(ag As AgeGroup, showid As Boolean, omit_times As Boolean, showproof As Boolean)
If isHtml Then
  printHTSwimmerlist ag, showid, omit_times, showproof
Else
  printpSwimmerlist ag, showid, omit_times, showproof
End If
End Function
Private Sub printHTSwimmerlist(ag As AgeGroup, showid As Boolean, omit_times As Boolean, showproof As Boolean)
Dim i As Integer, Sw As Swimmer, e As Integer
Dim S As Integer, ecnt As Integer
Dim pev As printEvent
Dim ken As kidEntry
Dim tm As New times
Dim oldx As Long
Dim nm$, att$
Dim found As Boolean

For i = 1 To swimmerList.count
  
  ecnt = 0
  
  Set Sw = swimmerList(i)
  For S = 1 To Sw.entryCount
    Set ken = Sw.getEntry(S)
    If Not ken.isScratched Then
      ecnt = ecnt + 1
    End If
  Next S
  If ecnt > 0 Or Sw.relayOnly Then
    ag.Incr Sw
  If Sw.isAttached Then
    att$ = ""
  Else
    att$ = " UN"
  End If
  nm$ = Sw.Nickname + " " + Sw.LastName + att$
  Print #htf, "<tr>";
  stCell
    Print #htf, nm$;
    If showid Or omit_times Then        'show uSS number
        break
        Print #htf, Sw.getID;
    End If
  endCell
  stCell
    Print #htf, Str$(Sw.getAge)
  endCell
  End If
For e = 1 To event_list.count
    Set pev = event_list(e)
    found = False
    For S = 1 To Sw.entryCount
     Set ken = Sw.getEntry(S)
     If ken.Eventnum = pev.evnum Then
       found = True
       If Not ken.isScratched Then
        tm.setSingle ken.getTime
'        If Not omit_times Then
           stCell
            Print #htf, tm.getFormatted;
            If showproof Then
                If Not ken.isScratched Then
                    break
                    prf.addKey ken.getMeetKey
                    Print #htf, " #" + Trim$(Str$(ken.getMeetKey))
                End If
            End If
            endCell
 '       Else
  '        emptyCell
  '      End If
       Else
         emptyCell
       End If
     'Else
     '  emptyCell
     End If
    Next S
  If Not found Then
    emptyCell
  End If
  Next e
  Print #htf, "</tr>"
 Next i
Print #htf, "</table>"
End Sub
Private Sub stCell()
Print #htf, "<td>";
End Sub
Private Sub endCell()
Print #htf, "</td>";
End Sub
Private Sub break()
Print #htf, "<br>";
End Sub
Private Sub printpSwimmerlist(ag As AgeGroup, showid As Boolean, omit_times As Boolean, showproof As Boolean)
Dim i As Integer, Sw As Swimmer, e As Integer
Dim S As Integer, ecnt As Integer
Dim pev As printEvent
Dim ken As kidEntry
Dim tm As New times
Dim oldx As Long
Dim nm$, att$

'
'now print results
pr.HLine
For i = 1 To swimmerList.count
  pr.X = 0
  ecnt = 0
  
  Set Sw = swimmerList(i)
  For S = 1 To Sw.entryCount
    Set ken = Sw.getEntry(S)
    If Not ken.isScratched Then
      ecnt = ecnt + 1
    End If
  Next S
  If ecnt > 0 Or Sw.relayOnly Then
    ag.Incr Sw
  If Sw.isAttached Then
    att$ = ""
  Else
    att$ = " UN"
  End If
  nm$ = Sw.Nickname + " " + Sw.LastName + att$
  pr.Xinch = nameCol_width        'see if there is room on one line
  If pr.textWidth(nm$) >= pr.X Then
    pr.leftSide
    pr.lPrintcr Sw.Nickname
    pr.lPrint Sw.LastName + att$
    
  Else
    pr.leftSide
    pr.lPrint nm$
  End If
  pr.Xinch = nameCol_width
  pr.vBar
  
  pr.lPrint Str$(Sw.getAge)
  pr.Xinch = agecol
  pr.vBar
  
  For e = 1 To event_list.count
    Set pev = event_list(e)
    oldx = pr.X
        
    For S = 1 To Sw.entryCount
     Set ken = Sw.getEntry(S)
     If ken.Eventnum = pev.evnum Then
       If Not ken.isScratched Then
        tm.setSingle ken.getTime
        If Not omit_times Then
            pr.lPrint " " + tm.getFormatted
            If ken.getCourseKey <> mt.courseKey Then
              pr.lPrint Left$(ken.getCourse, 1)
            End If
            If ken.getBonus Then
              pr.lPrint "B"
            End If
        End If
       End If
     End If
    Next S
    
    pr.X = oldx + pev.width
    pr.vBar
  Next e
  pr.Xinch = agecol
  
  pr.newLine
  If showid Or omit_times Then        'show uSS number
    pr.lPrint Sw.getID
    pr.Xinch = nameCol_width
    pr.vBar
    pr.Xinch = agecol
    pr.vBar
    For e = 1 To event_list.count
     Set pev = event_list(e)
     oldx = pr.X
     If showproof Then
       
       For S = 1 To Sw.entryCount       'finds meet key to print out
        Set ken = Sw.getEntry(S)
        If ken.Eventnum = pev.evnum Then
         If Not ken.isScratched Then
          prf.addKey ken.getMeetKey
          pr.lPrint " #" + Trim$(Str$(ken.getMeetKey))
         End If
       End If
       Next S
     End If

     
     pr.X = oldx + pev.width
     pr.vBar
    Next e
    pr.newLine
  End If
  pr.HLine
  If Not pr.testPage(3) Then
        printEventHeader
  End If
  End If
Next i
pr.HLine
End Sub
Private Sub build_EventList(maxage As Integer, Sex$)
'first empty the current collection
Dim count As Integer, i As Integer
Dim ev As clsEvents
Dim pev As printEvent

count = event_list.count
While count > 0
  event_list.remove count
  count = event_list.count
Wend

'now construct array of event numbers in this age range
For i = 1 To mt.eventCount
  Set ev = mt.getEvent(i)
  If ((maxage = agrp.senior_Max) And (ev.isSenior Or ev.isOver)) Or (ev.maxage = maxage) Then
    If ev.Sex = Sex$ And Not ev.isRelay Then
      Set pev = New printEvent
      pev.setEvent ev, pr
      event_list.add pev
    End If
  End If
Next i
  
End Sub
Private Sub printFirstHeader()
If isHtml Then
  printHTFirstHeader
Else
  printpFirstHeader
End If
End Sub
Private Sub printHTFirstHeader()
Print #htf, "<center>"
Print #htf, "<h1>";
Print #htf, stp.Teamname + " - " + stp.TeamInitials;
Print #htf, "</h1>"

Print #htf, "<h2>";
Print #htf, stp.Address1 + ", " + stp.Address2;
Print #htf, "</h2>"

Print #htf, stp.teamTown + ", " + stp.TeamState + " " + stp.TeamZip
Print #htf, "<br><b>"
Print #htf, stp.TeamEmail + "<br>"
Print #htf, "Entries in " + mt.Meetname + " " + Format$(mt.MeetDate, "mm-dd-yyyy") + " " + mt.location

Print #htf, "<br>"
Print #htf, "</center>"

Print #htf, squad_String
Print #htf, "<br>Contact: "
Print #htf, "</b>"
Print #htf, stp.TeamContactName + " -" + stp.teamphone

End Sub
Private Sub printpFirstHeader()
pr.setHeaderFont
pr.Centerit stp.Teamname + " - " + stp.TeamInitials
pr.setSubHeadFont
pr.Centerit stp.Address1 + ", " + stp.Address2
pr.setPageFont
pr.Centerit stp.teamTown + ", " + stp.TeamState + " " + stp.TeamZip
pr.Centerit stp.TeamEmail
pr.lPrintcr ""
pr.setBold
pr.Centerit "Entries in " + mt.Meetname + " " + Format$(mt.MeetDate, "mm-dd-yyyy") + " " + mt.location
pr.lPrintcr squad_String
pr.lPrint "Contact: "
pr.setPlain
pr.lPrintcr stp.TeamContactName + " -" + stp.teamphone
End Sub
Private Function findAgeGroups()
Dim e As Integer, a As Integer
Dim found As Boolean
Dim evnt As clsEvents
Dim ag As AgeGroup
Dim i As Integer, j As Integer, agmax As Integer
Dim agi As AgeGroup

For e = 1 To mt.eventCount
 Set evnt = mt.getEvent(e)
 found = False
 For a = 1 To agegroups.count
   Set ag = agegroups(a)
   ag.clear
'   If evnt.minage = ag.minage And evnt.maxage = ag.maxage Then
   If evnt.maxage = ag.maxage Then
    found = True
   End If
 Next a
 If Not found Then
  Set ag = New AgeGroup
  ag.clear
  ag.maxage = evnt.maxage
  ag.minage = evnt.minage
  agegroups.add ag
 End If
Next e
'sort age groups into order
agmax = agegroups.count
ReDim agarray(agmax) As AgeGroup
For i = 1 To agmax
  Set agarray(i) = agegroups(i)
Next i
For i = 1 To agegroups.count
  For j = i To agegroups.count
    If agarray(i).maxage > agarray(j).maxage Then
      Set agi = agarray(i)
      Set agarray(i) = agarray(j)
      Set agarray(j) = agi
    End If
  Next j
Next i
Set agegroups = Nothing
Set agegroups = New Collection
For i = 1 To agmax
  agegroups.add agarray(i)
Next i

findAgeGroups = agegroups.count

End Function

Private Sub Class_Initialize()
ReDim Sexes(3) As String
Sexes(1) = "F"
Sexes(2) = "M"
Sexes(3) = "N"
pmessage = ""
isHtml = False
End Sub
Public Sub setPMessage(S As String)
pmessage = S
End Sub

Private Function anyInAgeSex(ByVal maxage As Integer, ByVal senior As Boolean, Sex$)
Dim i As Integer, j As Integer
Dim found As Boolean
Dim Sw As Swimmer
Dim ev As clsEvents

found = False
i = 1
While Not found And i <= entries.count
  Set Sw = entries(i)
  For j = 1 To Sw.entryCount
    Set ev = mt.getEvent(Sw.getEntry(j).Eventnum)
    If ((ev.isSenior And senior) Or (ev.maxage = maxage)) And (ev.Sex = Sex$) Then
      found = True
    End If
  Next j
  i = i + 1
Wend
anyInAgeSex = found

End Function
Private Function buildSwimmerList(maxage As Integer, minage As Integer, sx$)
Dim i As Integer, j As Integer, k As Integer
Dim found As Boolean
Dim Sw As Swimmer
Dim evnum As Integer
Dim pev As printEvent
Dim scratched As Boolean
Dim swarray() As Swimmer, swimax As Integer

clearSwimmerList
For i = 1 To entries.count
  Set Sw = entries(i)
  found = False
  j = 1
  While j <= Sw.entryCount And Not found
    evnum = Sw.getEntry(j).Eventnum
    scratched = Sw.getEntry(j).isScratched
    If Not scratched Then
        k = 1
        While k <= event_list.count And Not found
            Set pev = event_list(k)
            If evnum = pev.evnum Then
            found = True
          End If
        k = k + 1
        Wend
    End If
  j = j + 1
  Wend
  If found Then swimmerList.add entries(i)
  If Sw.relayOnly Then
   If (minage < Sw.getAge) And (Sw.getAge < maxage) And (Sw.Sex = sx$) Then
        swimmerList.add entries(i)
    End If
  End If
Next i
'sort into alphabetical order
swimax = swimmerList.count
ReDim swarray(swimmerList.count) As Swimmer
For i = 1 To swimax
Set swarray(i) = swimmerList(i)
Next i
For i = 1 To swimax
  For j = i To swimax
    If swarray(i).LastName > swarray(j).LastName Then
      Set Sw = swarray(i)
      Set swarray(i) = swarray(j)
      Set swarray(j) = Sw
    End If
  Next j
Next i
Set swimmerList = Nothing
Set swimmerList = New Collection
For i = 1 To swimax
  swimmerList.add swarray(i)
Next i


End Function
Private Sub clearSwimmerList()
Dim count As Integer

count = swimmerList.count
While count > 0
  swimmerList.remove count
  count = swimmerList.count
Wend
End Sub
Public Sub setRelayEntries(relentr As RelayEntries)
Set relEnt = relentr
End Sub

Public Sub setSquads(sq$)
squad_String = sq$
End Sub
Public Sub printLabels(showevents As Boolean)
Dim i As Integer, S As Integer
Dim Sw As Swimmer, ken As kidEntry
Dim label As Collection, ev As clsEvents
Dim tm As New times

For i = 1 To entries.count
 Set Sw = entries(i)
 If Sw.hasEvents Then
    For S = 1 To Sw.entryCount
        Set label = New Collection
        Set ken = Sw.getEntry(S)
        If Not ken.isScratched Then
            tm.setSingle ken.getTime
            If showevents Then
                label.add "Event:" + Str$(ken.Eventnum) + "   " + Sw.Nickname + " " + Sw.LastName + "   " + tm.getFormatted
            Else
                label.add Sw.Nickname + " " + Sw.LastName
            End If
            Set ev = mt.Events(ken.Eventnum)
            label.add ev.AgeString + "   " + Str$(Sw.getAge) + "   " + stp.TeamInitials
            If showevents Then
                label.add ev.Strokename + "   " + mt.Meetname
            Else
                label.add mt.Meetname
            End If
            label.add Sw.getID + "   " + mt.location
            lb.printLabel label
        End If
    Next S
   
 End If
Next i
lb.endDoc
End Sub
Public Sub printLongForm(prt As clsPrinters, showid As Boolean, omit_times As Boolean, showproofs As Boolean, onepage As Boolean, showNames As Boolean)
If isHtml Then
  printHTLongForm prt, showid, omit_times, showproofs, onepage, showNames
Else
  printpLongForm prt, showid, omit_times, showproofs, onepage, showNames
End If
End Sub
Public Sub printHTLongForm(prt As clsPrinters, showid As Boolean, omit_times As Boolean, showproofs As Boolean, onepage As Boolean, showNames As Boolean)
Dim S As Integer, a As Integer, e As Integer
Dim ag As AgeGroup, senior As Boolean
Dim ev As clsEvents
Dim i As Integer, j As Integer
Dim Sw As Swimmer, found As Boolean
Dim sq As New Squads
Dim column As Single, scnt As Integer
Dim tm As New times
Dim wstring As String, numwidth As Integer
Dim oldx As Integer, ewidth As Integer
Dim pev As New printEvent
Dim agi As AgeGroup, agmax As Integer, att$, nm$, sx$
Dim ken As kidEntry
Set pr = New clsPrinters

findAgeGroups       'used only for event report at bottom
printFirstHeader    'print header for front page

'print out message to parents
printHeaderMessage

'construct squad key list
For i = 1 To entries.count
 Set Sw = entries(i)
 found = False
 j = 1
 While j <= sqds.count And Not found
   found = (Sw.getSquadKey = sqds(j))
   j = j + 1
 Wend
 If Not found Then
   sqds.add Sw.getSquadKey
 End If
Next i

sq.setDB db
sq.buildTable db
'print out by squad
For j = 1 To sqds.count
  sx$ = "F"
  For scnt = 1 To 2
    Print #htf, "<h3>" + sq.sqname(sqds(j));
  If sx$ = "F" Then
    Print #htf, " Girls";
  Else
    Print #htf, " Boys";
  End If
  Print #htf, "</h3>"
  Print #htf, "<HLine>"
  
  Print #htf, "<table border>"
  
  For i = 1 To entries.count
    Set Sw = entries(i)
    If Sw.getSquadKey = sqds(j) And Sw.hasEvents And Sw.Sex = sx$ Then
      If Sw.isAttached Then
        att$ = ""
      Else
          att$ = " UN"
     End If
  nm$ = Sw.Nickname + " " + att$        'first name and attached status
  Print #htf, "<td>";
  stCell
  Print #htf, nm$;
  break
  Print #htf, Sw.LastName;
  break
  Print #htf, Sw.getID
  endCell
  'print age
  stCell
  Print #htf, Str$(Sw.getAge)
  endCell
  
  'top row is event numbers
    For S = 1 To Sw.entryCount
     Set ken = Sw.getEntry(S)
     Set ev = mt.getEvent(ken.Eventnum)
'     pev.setEvent ev, pr
     If Not ken.isScratched Then
        stCell
         Print #htf, Str$(ken.Eventnum)
         break
         Print #htf, Str$(ken.dist)
         break
         Print #htf, ken.Strokename
         break
         tm.setSingle ken.getTime
         Print #htf, tm.getFormatted
        endCell
     End If
    Next S
    Print #htf, "</tr>"
    End If
   Next i
   If sx$ = "F" Then sx$ = "M"      'go on to next sex
   Print #htf, "</table>"
   Next scnt
Next j

'print out relays
  relEnt.setHtml htf
  relEnt.printEntry pr, mt.MeetDate, showNames
  printRelayOnly        'relay only swimmers
  'print out swimmer counts and proofs
  countAges
  
  countsAndProofs showproofs
Print #htf, "</html>"
Close #htf
End Sub
Public Sub printpLongForm(prt As clsPrinters, showid As Boolean, omit_times As Boolean, showproofs As Boolean, onepage As Boolean, showNames As Boolean)
Dim S As Integer, a As Integer, e As Integer
Dim ag As AgeGroup, senior As Boolean
Dim ev As clsEvents
Dim i As Integer, j As Integer
Dim Sw As Swimmer, found As Boolean
Dim sq As New Squads
Dim column As Single, scnt As Integer
Dim tm As New times
Dim wstring As String, numwidth As Integer
Dim oldx As Integer, ewidth As Integer
Dim pev As New printEvent
Dim agi As AgeGroup, agmax As Integer, att$, nm$, sx$
Dim ken As kidEntry

Screen.MousePointer = vbHourglass
Set pr = prt
namecol = nameCol_width           'inches to end of name block
agecol = 0.25 + namecol 'inches to end of age block

If Landscape Then
    pr.setLandscape 'Print horizontally
Else
  pr.setPortrait
End If
pr.setPageNum 1     'reset paqge number each time
findAgeGroups       'used only for event report at bottom
printFirstHeader    'print header for front page

'print out message to parents
printHeaderMessage

'construct squad key list
For i = 1 To entries.count
 Set Sw = entries(i)
 found = False
 j = 1
 While j <= sqds.count And Not found
   found = (Sw.getSquadKey = sqds(j))
   j = j + 1
 Wend
 If Not found Then
   sqds.add Sw.getSquadKey
 End If
Next i

sq.setDB db
sq.buildTable db
'print out by squad
For j = 1 To sqds.count
  sx$ = "F"
  For scnt = 1 To 2
  pr.setSubHeadFont
  pr.lPrint sq.sqname(sqds(j))
  If sx$ = "F" Then
    pr.lPrintcr " Girls"
  Else
    pr.lPrintcr " Boys"
  End If
  pr.HLine
  pr.setPageFont
  'pr.X = 0
  pr.setPageFont
  For i = 1 To entries.count
    Set Sw = entries(i)
    If Sw.getSquadKey = sqds(j) And Sw.hasEvents And Sw.Sex = sx$ Then
      If Sw.isAttached Then
        att$ = ""
      Else
          att$ = " UN"
     End If
  nm$ = Sw.Nickname + " " + att$        'first name anbd attached status
  pr.lPrint nm$
  pr.Xinch = nameCol_width
  pr.vBar
  'print age
  pr.lPrint Str$(Sw.getAge)
  pr.Xinch = agecol
  pr.vBar
  'top row is event numbers
    For S = 1 To Sw.entryCount
     oldx = pr.X
     Set ken = Sw.getEntry(S)
     Set ev = mt.getEvent(ken.Eventnum)
     pev.setEvent ev, pr
     If Not ken.isScratched Then
         pr.lPrint Str$(ken.Eventnum)
     End If
     ewidth = pev.width
     pr.X = oldx + ewidth
     pr.vBar
    Next S
    pr.newLine
    
    'second row is last name and distances
    pr.lPrint Sw.LastName
    pr.Xinch = nameCol_width
    pr.vBar
    pr.lPrint " " + Sw.Sex
    pr.Xinch = agecol
    pr.vBar
    For S = 1 To Sw.entryCount
     oldx = pr.X
     Set ken = Sw.getEntry(S)
     If Not ken.isScratched Then
         pr.lPrint Str$(ken.dist)
     End If
     pr.X = oldx + ewidth
     pr.vBar
    Next S
    pr.newLine
        
    'next row is ID# and stroke names
    pr.lPrint Sw.getID
    pr.Xinch = nameCol_width
    pr.vBar
    pr.Xinch = agecol
    pr.vBar
    For S = 1 To Sw.entryCount
     oldx = pr.X
     Set ken = Sw.getEntry(S)
     If Not ken.isScratched Then
         pr.lPrint ken.Strokename
     End If
     pr.X = oldx + ewidth
     pr.vBar
    Next S
    pr.newLine
    
    'last row is seed times
    pr.Xinch = nameCol_width
    pr.vBar
    pr.Xinch = agecol
    pr.vBar
    For S = 1 To Sw.entryCount
     oldx = pr.X
     Set ken = Sw.getEntry(S)
     If Not ken.isScratched Then
         tm.setSingle ken.getTime
         pr.lPrint tm.getFormatted
     End If
     pr.X = oldx + ewidth
     pr.vBar
    Next S
    pr.newLine
    pr.HLine
    'pr.X = 0
    End If
    Next i
   If sx$ = "F" Then sx$ = "M"      'go on to next sex
   Next scnt
   If onepage Then pr.newPage
  Next j
  
  'print out relays
  relEnt.setPrintmode
  relEnt.printEntry pr, mt.MeetDate, showNames
  printRelayOnly        'relay only swimmers
  'print out swimmer counts and proofs
  countAges
  pr.testPage 8
  countsAndProofs showproofs
  pr.endDoc
  Screen.MousePointer = vbDefault
End Sub
Private Sub countAges()
Dim S As Integer, a As Integer
Dim ag As AgeGroup
Dim i As Integer, j As Integer, ecnt As Integer
Dim Sw As Swimmer, ken As kidEntry

'count members of each age group
For S = 1 To 3
  For a = 1 To agegroups.count
      Set ag = agegroups(a)
      If anyInAgeSex(agegroups.Item(a).maxage, ag.isSenior, Sexes(S)) Then
        build_EventList ag.maxage, Sexes(S)
              
      'Now calcuate events per swimmer in each age group
      buildSwimmerList ag.maxage, ag.minage, Sexes(S)
      End If
      For i = 1 To swimmerList.count
        ecnt = 0
        Set Sw = swimmerList(i)
        For j = 1 To Sw.entryCount
            Set ken = Sw.getEntry(j)
            If Not ken.isScratched Then
                ecnt = ecnt + 1
            End If
        Next j
        If ecnt > 0 Or Sw.relayOnly Then
            ag.Incr Sw
        End If
      Next i
  Next a
Next S


End Sub
Public Sub clear()
Set entries = Nothing
Set entries = New Collection
End Sub
Private Sub findColumnWidths()
Dim i As Integer, S As Integer, ecnt As Integer, e As Integer
Dim pev As printEvent
Dim ken As kidEntry
Dim Sw As Swimmer
'scan through for non conforming times or bonus events
'leave room in column to mark them
For i = 1 To swimmerList.count
  pr.X = 0
  ecnt = 0
  For e = 1 To event_list.count
    Set pev = event_list(e)
    Set Sw = swimmerList(i)
    For S = 1 To Sw.entryCount
      Set ken = Sw.getEntry(S)
      If ken.Eventnum = pev.evnum Then
        If ken.getCourseKey <> mt.courseKey Then
            pev.setXCourse True
        End If
        If ken.getBonus Then
            pev.setBonus True
        End If
      End If
    Next S
  Next e
Next i
End Sub
Public Sub printUSSNumberList(prt As clsPrinters)
Dim a As Integer, S As Integer, Sw As Swimmer, i As Integer
Dim spnt As Integer, smax As Integer, j As Integer
ReDim slist(entries.count) As Swimmer
Screen.MousePointer = vbHourglass

Set pr = prt
pr.setPageNum 1
pr.setPortrait

printFirstHeader    'print header for front page
For S = 1 To 3
  pr.setSubHeadFont
  pr.lPrintcr ""
  Select Case Sexes(S)
    Case "F"
      pr.lPrintcr "Female Swimmers"
    Case "M"
      pr.lPrintcr "Male Swimmers"
  End Select
    pr.newLine
    pr.setPageFont
    spnt = 1        'list pointer
    For i = 1 To entries.count
      Set Sw = entries(i)
      If Sw.Sex = Sexes(S) And Sw.hasEvents Then
        Set slist(spnt) = Sw
        spnt = spnt + 1
      End If
    Next i
    smax = spnt - 1     'count into list
    'now alphabetize
    For i = 1 To smax
      For j = i To smax
        If slist(i).LastName > slist(j).LastName Then
          Set Sw = slist(i)
          Set slist(i) = slist(j)
          Set slist(j) = Sw
        End If
      Next j
    Next i
    'print out list
    For i = 1 To smax
      Set Sw = slist(i)
      pr.lPrint Sw.LastName + ", " + Sw.Nickname
      pr.Tabbit 30
      pr.lPrintcr Sw.getID
      
    Next i
Next S
pr.endDoc
Screen.MousePointer = vbDefault
End Sub
