VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form PrintTimes 
   Caption         =   "Print Swimmer Times"
   ClientHeight    =   5190
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   7830
   LinkTopic       =   "Form1"
   ScaleHeight     =   5190
   ScaleWidth      =   7830
   StartUpPosition =   1  'CenterOwner
   Begin MSComDlg.CommonDialog cDlg 
      Left            =   7200
      Top             =   4680
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton btTimestds 
      Caption         =   "Time standards..."
      Height          =   495
      Left            =   5160
      TabIndex        =   14
      Top             =   1080
      Width           =   1335
   End
   Begin VB.Frame Frame2 
      Caption         =   "Times"
      Height          =   1815
      Left            =   3480
      TabIndex        =   10
      Top             =   2400
      Width           =   2775
      Begin VB.CheckBox OnePerPage 
         Caption         =   "One swimmer per page"
         Height          =   255
         Left            =   480
         TabIndex        =   16
         Top             =   1320
         Width           =   2175
      End
      Begin VB.CheckBox ckLandscape 
         Caption         =   "Landscape mode"
         Enabled         =   0   'False
         Height          =   255
         Left            =   480
         TabIndex        =   13
         ToolTipText     =   "Print horizontally"
         Top             =   960
         Width           =   1695
      End
      Begin VB.OptionButton allMeets 
         Caption         =   "Show all events"
         Height          =   375
         Left            =   120
         TabIndex        =   12
         ToolTipText     =   "Show every meet"
         Top             =   600
         Width           =   1935
      End
      Begin VB.OptionButton bestTimes 
         Caption         =   "Show best times"
         Height          =   375
         Left            =   120
         TabIndex        =   11
         ToolTipText     =   "Show only best times for spec'd courses"
         Top             =   240
         Value           =   -1  'True
         Width           =   1935
      End
   End
   Begin VB.TextBox sinceDate 
      Height          =   375
      Left            =   2760
      TabIndex        =   9
      Text            =   "1-1-1990"
      Top             =   1080
      Width           =   1455
   End
   Begin VB.ListBox squadlist 
      Height          =   1620
      Left            =   360
      MultiSelect     =   1  'Simple
      TabIndex        =   6
      Top             =   600
      Width           =   2055
   End
   Begin VB.Frame Frame1 
      Caption         =   "Courses"
      ForeColor       =   &H00FF0000&
      Height          =   1575
      Left            =   360
      TabIndex        =   2
      Top             =   2400
      Width           =   2175
      Begin VB.CheckBox opSCM 
         Caption         =   "SCM"
         Height          =   375
         Left            =   240
         TabIndex        =   5
         Top             =   960
         Width           =   1335
      End
      Begin VB.CheckBox opLCM 
         Caption         =   "LCM"
         Height          =   375
         Left            =   240
         TabIndex        =   4
         Top             =   600
         Width           =   1335
      End
      Begin VB.CheckBox opYDS 
         Caption         =   "YDS"
         Height          =   375
         Left            =   240
         TabIndex        =   3
         Top             =   240
         Width           =   1335
      End
   End
   Begin VB.CommandButton Cancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   495
      Left            =   5040
      TabIndex        =   1
      Top             =   4320
      Width           =   1095
   End
   Begin VB.CommandButton Printit 
      Caption         =   "Print"
      Enabled         =   0   'False
      Height          =   495
      Left            =   1440
      TabIndex        =   0
      Top             =   4320
      Width           =   1095
   End
   Begin VB.Label status 
      Caption         =   " "
      Height          =   255
      Left            =   2760
      TabIndex        =   17
      Top             =   4920
      Width           =   3255
   End
   Begin VB.Label lbTmstd 
      Caption         =   "no time standards used"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   4680
      TabIndex        =   15
      Top             =   1800
      Width           =   2655
   End
   Begin VB.Label Label2 
      Caption         =   "Meets since"
      ForeColor       =   &H00FF0000&
      Height          =   375
      Left            =   2880
      TabIndex        =   8
      Top             =   600
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Squads"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   360
      TabIndex        =   7
      Top             =   120
      Width           =   1695
   End
End
Attribute VB_Name = "PrintTimes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private db As Database
Private sq As New Squads
Private bestQueryOpen As Boolean, qQuadOpen As Boolean
Private bqrec As Recordset, squadrec As Recordset
Private pr As New clsPrinters
Private tm As New times
Private crs As New course
Private yrec As Recordset, mrec As Recordset, srec As Recordset
Private kds As New kids
Private ini As New Profile
Private tmstds As String
Private timestds As New TimeStandards
Private timstds_flag As Boolean
Private stp As New Setupdata

Public Sub setDB(datab As Database)
Set db = datab
kds.setDB db
kds.openTable
End Sub

Private Sub allMeets_Click()
ckLandscape.Enabled = True
End Sub

Private Sub bestTimes_Click()
ckLandscape.Enabled = False
End Sub
Private Function getMeetsPerKid(kidkey As Long, courseKey As Integer) As Recordset
Dim query$, dt$

If IsDate(sinceDate.Text) Then
 dt$ = sinceDate.Text
Else
 dt$ = "1-1-1980"
End If
query$ = "SELECT DISTINCTROW Meets.MeetKey, Meets.MeetDate, Meets.MeetName, Meets.ResultCourse " & _
"FROM Strokes INNER JOIN (Meets INNER JOIN (Kids INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey) ON Meets.MeetKey = SwimEvents.meetKey) ON Strokes.strokeKey = SwimEvents.strokeKey " & _
"Where (((Meets.MeetDate) > #" + dt$ + "#) And ((Meets.ResultCourse) = " + Str$(courseKey) + ") And ((kids.kidkey) = " + Str$(kidkey) + ")) " & _
"ORDER BY Meets.MeetDate;"

Set getMeetsPerKid = db.OpenRecordset(query$, dbOpenDynaset)

End Function

Private Sub btTimestds_Click()
cDlg.Filter = "Time standards|Time*.mdb"
cDlg.ShowOpen
If Len(cDlg.filename) > 0 Then
  tmstds = cDlg.filename
  lbTmstd.Caption = tmstds
  timestds.setFile tmstds
  timstds_flag = True
   stp.TimeStandards = tmstds
End If

End Sub

Private Sub Cancel_Click()
Unload Me
End Sub

Private Sub Form_Load()
bestQueryOpen = False
sq.setDB db
sq.buildTable db
While Not sq.endFile
 squadlist.AddItem sq.SquadName
 sq.moveNext
Wend
tmstds = stp.TimeStandards
If tmstds <> "no time standards" Then
  timstds_flag = True
Else
  timstds_flag = False
End If
lbTmstd.Caption = tmstds
End Sub

Private Sub Printit_Click()
On Local Error GoTo prcancl
cDlg.CancelError = True
cDlg.ShowPrinter
Me.MousePointer = vbHourglass
If bestTimes.Value Then
  printBestTimes
Else
  printAllTimes
End If

prexit:
Me.MousePointer = vbDefault
Unload Me
Exit Sub

prcancl:
  Resume prexit
End Sub
Private Sub printAllTimes()
Dim S As Integer, c As Integer, age As Integer
Dim i As Integer, tabpos As Integer, imin As Integer
Dim k As Integer, r As Integer
Dim rec As Recordset
Dim kmeets As New kidMeets, showcourse As Boolean
Dim sdate As Date, dt$

kmeets.setDB db
If ckLandscape.Value = 1 Then
  pr.setLandscape
End If
pr.setPageNum 1

For S = 0 To squadlist.ListCount - 1
 If squadlist.Selected(S) Then
 
 pr.setHeaderFont
 pr.lPrintcr "Time records for -- " + squadlist.List(S) + " " + date$
 pr.setHeader squadlist.List(S)   'for following pages
 pr.newLine
 getKidsInSquad (S + 1) 'squad rec is s+1
 pr.setPageFont
 
 kds.setPrinter pr
 If IsDate(sinceDate.Text) Then
     dt$ = sinceDate.Text
 Else
    dt$ = "1-1-1980"
 End If
sdate = CVDate(dt$)
 While Not squadrec.EOF
  If squadrec![Active] Then
   kds.kidkey = squadrec![kidkey]
   kds.PrintTimes sdate, opYds.Value = 1, opLCM.Value = 1, opSCM.Value = 1
   If OnePerPage.Value = 1 Then
     pr.newPage
   End If
  End If     'if active
 
 squadrec.moveNext
 Wend
 squadrec.Close
 End If
Next S
pr.endDoc
End Sub
Private Sub printMeets(kmeets As kidMeets, c As Integer)
Dim r As Integer, k As Integer
Dim tabpos As Integer, colsleft As Integer
Dim kfirst As Integer, klast As Integer
Dim numcols As Integer
 If pr.isLandscape Then
   numcols = 16
 Else
   numcols = 10
 End If

kfirst = 1
klast = kmeets.meetCount
If klast > numcols Then
  klast = numcols
End If

While kfirst <= kmeets.meetCount
'print out the meet name
k = kfirst
kmeets.MoveFirst
tabpos = 0
  While k <= klast
    If tabpos = 0 Then
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    pr.lPrint Left$(LCase$(kmeets.getMeetName()), 8)
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
pr.newLine
'print out the meet date and course (Y,L or S)
k = kfirst
kmeets.MoveTo k
tabpos = 0
  While k <= klast
    If tabpos = 0 Then
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    pr.lPrint Format$(kmeets.getMeetDate(), "mmddyy")
    pr.lPrint LCase$(Left$(crs.getCourseString(c), 1))
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
pr.newLine
'print out the actual times
k = kfirst
r = 1
kmeets.MoveTo k
While r < kmeets.rowCount
  tabpos = 0
  k = kfirst
  kmeets.MoveTo k
  
  While k <= klast
    If tabpos = 0 Then
      pr.lPrint kmeets.getRowLabel(r)
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    pr.lPrint kmeets.getColumn(r)
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
  r = r + 1
  pr.newLine
  tabpos = 0
 Wend
 pr.newLine     'blank line between courses
kfirst = klast + 1
colsleft = kmeets.meetCount - kfirst
If colsleft > numcols Then
  colsleft = numcols
End If
klast = kfirst + colsleft
Wend
End Sub
Private Function getBest(kidkey As Long, courseKey As Long) As Recordset
Dim qry$

'this query gets the best times for a given course
qry$ = "SELECT DISTINCTROW Kids.KidKey, Kids.IDNumber, SwimEvents.Distance, Swimevents.strokekey,Strokes.strokeName, SwimEvents.Distance, Min(SwimEvents.swimtime) AS MinOfswimtime " & _
"FROM (Meets INNER JOIN (Kids INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey) ON Meets.MeetKey = SwimEvents.meetKey) INNER JOIN Strokes ON SwimEvents.strokeKey = Strokes.strokeKey " & _
"GROUP BY Kids.KidKey,kIDS.idNumber, Meets.ResultCourse, SwimEvents.Distance, swimevents.strokekey, Strokes.strokeName, SwimEvents.strokeKey, SwimEvents.Distance " & _
"Having(((kids.kidkey) = " + Str$(kidkey) + ") And ((Meets.ResultCourse) = " + Str$(courseKey) + "))  " & _
"ORDER BY SwimEvents.strokeKey, SwimEvents.Distance;"

Set getBest = db.OpenRecordset(qry$, dbOpenDynaset)

End Function
Private Sub squadlist_Click()
Printit.Enabled = True
End Sub
Private Function printKidName(rec As Recordset) As Integer
'returns age
Dim age As Integer, todate As Date
todate = CVDate(date$)
pr.testPage (14)
    pr.setBold
    pr.lPrint rec![Nickname] & "" + " " + rec![lname] & "" + " " + rec![Sex] & "" + " " + Format$(rec![birthday], "mm-dd-yyyy") + "--" + rec![IdNumber]
    age = val(Format$(todate - rec![birthday], " yy"))
    pr.lPrintcr "   " + Str$(age)
    pr.setPlain
printKidName = age
End Function
Private Sub printBestTimes()
Dim S As Integer
Dim tabpos As Integer, todate As Date
Dim age As Integer, std As String
On Local Error GoTo 0

'prints out best times of each squad selected
'using each course selected
pr.setPageNum (1)

For S = 0 To squadlist.ListCount - 1
 If squadlist.Selected(S) Then
 
 pr.setHeaderFont
 pr.lPrintcr "Best times -" + squadlist.List(S) + " " + date$
 pr.setHeader squadlist.List(S)   'for following pages
 pr.newLine
 getKidsInSquad (S + 1) 'squad rec is s+1
 pr.setPageFont
 While Not squadrec.EOF
  If squadrec![Active] Then
    age = printKidName(squadrec)
    
    If opYds.Value Then Set yrec = getBest(squadrec![kidkey], 1)
    If opLCM.Value Then Set mrec = getBest(squadrec![kidkey], 2)
    If opSCM.Value Then Set srec = getBest(squadrec![kidkey], 3)
    tabpos = 10
    pr.Tabbit tabpos
    pr.setItalic
    If opYds.Value Then
        pr.lPrint "SC Yards"
        tabpos = tabpos + 35
        pr.Tabbit tabpos
    End If
  
    If opLCM.Value Then
        pr.lPrint "LC Meters"
        tabpos = tabpos + 35
        pr.Tabbit tabpos
    End If
  
    If opSCM.Value Then pr.lPrint "SC Meters"
    pr.setPlain
    pr.newLine
    'print out each course until all done
    While Not allDone
        tabpos = 10
         If opYds.Value Then
            If Not yrec.EOF Then
                If age > stp.getAge25s And yrec![Distance] = 25 Then
                  yrec.moveNext
                End If
             End If
            If Not yrec.EOF Then
                pr.Tabbit tabpos
                tm.setSingle yrec![minofswimtime]
                pr.lPrint Str$(yrec![Distance]) + " " + yrec![Strokename] & ""
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
               ' pr.lPrint " " + Format$(yrec![MeetDate], "Short Date") + " " + Left$(yrec![Meetname], 6)
                If timstds_flag Then
                  timestds.setAge age
                  timestds.setCourseKey 1
                  timestds.setSex squadrec![Sex] & ""
                  std = timestds.getTimeStandard(tm.getSingle, yrec![strokeKey], yrec![Distance])
                  pr.lPrint " " + std
                End If
            End If
        tabpos = tabpos + 35
        pr.Tabbit tabpos
        End If
    
        If opLCM.Value Then
            If Not mrec.EOF Then
                tm.setSingle mrec![minofswimtime]
                pr.lPrint Str$(mrec![Distance]) + " " + mrec![Strokename]
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
                If timstds_flag Then
                  timestds.setAge age
                  timestds.setCourseKey 2
                  timestds.setSex squadrec![Sex] & ""
                  std = timestds.getTimeStandard(tm.getSingle, mrec![strokeKey], mrec![Distance])
                  pr.lPrint " " + std
                End If
            End If
            tabpos = tabpos + 35
            pr.Tabbit tabpos
        End If
    
        If opSCM.Value Then
            If Not srec.EOF Then
                If age > stp.getAge25s And srec![Distance] = 25 Then
                  srec.moveNext
                End If
               If Not srec.EOF Then
                tm.setSingle srec![minofswimtime]
                pr.lPrint Str$(srec![Distance]) + " " + srec![Strokename] & ""
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
                If timstds_flag Then
                  timestds.setAge age
                  timestds.setCourseKey 3
                  timestds.setSex squadrec![Sex] & ""
                  std = timestds.getTimeStandard(tm.getSingle, srec![strokeKey], srec![Distance])
                  pr.lPrint " " + std
                End If
              End If
            End If
            tabpos = tabpos + 35
            pr.Tabbit tabpos
        End If
    
        pr.newLine
        moreYards           'increment in subroutine
        moreLCMeters        'to test for existence
        moreSCMeters
    Wend
    pr.newLine
    If OnePerPage.Value = 1 Then
      pr.newPage
    End If
  End If
  squadrec.moveNext
 Wend
 squadrec.Close
 pr.newPage
 End If
 
Next S
pr.endDoc
End Sub
Private Function moreYards()
If opYds.Value Then
  If Not yrec.EOF Then
    yrec.moveNext
  End If
End If
End Function
Private Function moreLCMeters()
If opLCM.Value Then
  If Not mrec.EOF Then
    mrec.moveNext
  End If
End If
End Function
Private Function moreSCMeters()
If opSCM.Value Then
  If Not srec.EOF Then
    srec.moveNext
  End If
End If
End Function

Private Function allDone() As Boolean
Dim ydone As Boolean, mdone As Boolean, sdone As Boolean

sdone = True
ydone = True
mdone = True
If opYds.Value Then
  ydone = yrec.EOF
End If
If opLCM.Value Then
  mdone = mrec.EOF
End If
If opSCM.Value Then
  sdone = srec.EOF
End If
allDone = sdone And ydone And mdone
End Function

Private Sub getKidsInSquad(squadKey As Integer)
Dim qry$

qry$ = "SELECT DISTINCTROW Kids.Sex, Kids.Nickname, Kids.Lname, Kids.KidKey, Kids.IDNumber,Kids.Birthday, Kids.Active, Kids.Attached " & _
"From kids Where (((kids.Active)=True) AND ((kids.SquadKey)=" + Str(squadKey) + ")) ORDER BY Kids.Sex, Kids.Lname;"
Set squadrec = db.OpenRecordset(qry$, dbOpenSnapshot)
End Sub

Public Sub setStatus(S$)
Status.Caption = S$
Status.Refresh
End Sub

