Attribute VB_Name = "meet5include"
'*************** meet4.bi    include file
'==========================================================================
' SwimMeet 4.0 Record Definitions File
'==========================================================================
' The eventx structure contains the description of a single event
' at a meet: age, stroke, distance and cut times:
Type EVENTX
evname As String * 6    'alternate nume 1A, 1B, etc
evlink As String * 80   'combined seeding
minage As Integer
maxage As Integer
final  As Integer       'TRUE if finals, false if Timed Finals
stroke As Integer       'name of stroke
dist As Integer         'distance in yds or meters
sex As String * 1       'M or F
slowcut As Single       'slowest allowed time
fastcut As Single       'fastest allowed time
End Type

'==========================================================================
Type recSWIMMER
 frname As String * 20          'first name
 lname As String * 30           'last name
 Attached As Integer            'TRUE if attached
 age As Integer                 'age on first day of meet
 sex As String * 2              'sec: M, F or N
 bday As Single                 'birthday in yymmdd format
 init As String * 4             'initials
 team As String * 6             'team symbol
 LSC As String * 4              'lo-Cal swimming committee
 eventpoint As Integer          'index into event array to first event
End Type
'==========================================================================
Type RELAYENTRANTS
  entrids(4) As Integer
End Type
'==========================================================================
Type ENTRYREC
  evnum As Integer              'event number in meet
  seed As Single                'seed time
  result As Single              'result time
  backupr As Single             'result time backup
  final As Single               'final time
  backupf As Single             'final time backup
  swimoff As Single             'swimoff time
  backups As Single             'swimoff backup
  entrpnt As Integer            'entrants file for relays
  splpnt As Integer             'splits file pointer
  escratch As String * 1        'scratch from entry/prelims
  fscratch As String * 1        'scratch from finals
  unofficial As String * 1           '1 if unofficial, 2 if nonconforming time
  seedCourse As String * 1      'Y, M or S of entry time
  att As String * 1             '1 if attached
  eplace As String * 1          'place in trials
  fplace As String * 1          'place in finals
  points As Integer             'number of points scores * 100
  eheat As String * 1           'heat in trials
  elane As String * 1           'lane in trials
  DisqualR As String * 1        '1 if dqed in trials
  DisqualF As String * 1        '1 if dqed in finals
  fheat As String * 1           'heat in finals
  flane As String * 1           'lane in finals
  nextpnt As Integer            'pointer to next entry or -1 if no more
End Type
'=========================================================================
Type ENTRY4
  evnum As Integer              'event number in meet
  seed As Single                'seed time
  result As Single              'result time
  final As Single               'final time
  entrpnt As Integer            'entrants file for relays
  splpnt As Integer             'splits file pointer
  escratch As String * 1        'scratch from entry/prelims
  fscratch As String * 1        'scratch from finals
  unoff As String * 1           '1 if unofficial, 2 if nonconforming time
  att As String * 1             '1 if attached
  eplace As String * 1          'place in trials
  fplace As String * 1          'place in finals
  points As Integer             'number of points scores * 100
  eheat As String * 1           'heat in trials
  elane As String * 1           'lane in trials
  fheat As String * 1           'heat in finals
  flane As String * 1           'lane in finals
  nextpnt As Integer            'pointer to next entry or -1 if no more
End Type
'===============================================================
'The MEETDESC structure contains the facts about a meet:
' name, filename, location, date, number of sessions, number of events
' last eventx in each session, number of heats in finals
' and data used during program printout, including page and column info:
Type MEETDESC
meetfile As String * 50
meetlocation As String * 50
Meetname As String * 80
meetsubtitle As String * 80
header As String * 80
sfl As Integer          'swimmer file handle
efl As Integer          'entry record file handle
rfl As Integer          'relay names record file
spfl As Integer         'split file handle
printfile As Integer    'output to printer or file

'directories and paths for finding files
basedir As String * 40  'directory of meet4 exe files
meetdir As String * 40  'directory of last opened meet file
webdir As String * 40   'directory where web pages are created

'Timing system COM port setup
comports As Integer     'total number of ports
useport(2) As Integer   'port numbers to use for timing
curport As Integer      'current com port
comport(2) As Integer   'handles for com ports
Timing_system As Integer    'type of timing system
log_timingsystem As Integer       'start logging data if true
numTiming_systems As Integer '2 if 2 Colorado's
Alternate_systems As Integer ' True if alternate with events

print_to_file As Integer 'TRUE if "File" selected in setup
printout_order As Integer
'lpt2 As Integer          'vestigial
printer_1 As Integer    'vestigial
printer_2 As Integer    'vestigial
'print_dev1 As String * 6 'printer device number
'print_dev2 As String * 6'printer device number
'print_name1 As String * 75  'printer name
'print_name2 As String * 75  'printer name
'print_driver1 As String * 10
'print_driver2 As String * 10
'pdev(2) As PrintDevice

FINALS As Integer       'TRUE if Prelims/Finals
timefile As Integer     'timer file for each split and race
timerec As Integer      'record currently read in
lastrec As Integer      'number of last record in timer file
racenumber As Integer   'race number used by Colorado system
lanes As Integer        'number of lanes in pool
heats As Integer        'number of heats in finals
date As Single          'date
course As String * 3    'LCM or YDS
meas  As String * 2     'YD or M
evtype As Integer       'trail, result, final or scratch
evprice As Single       'price of individual events
relprice As Single      'price of relay events
timedfinalprice As Single         'price of individual timed final events
distanceprice As Single  'price of distance events
swimmerprice As Single  'surcharge per swimmer
numevents As Integer    'number of events
enum As Integer         'number of entries in events() array
nswim As Integer        'number of swimmers in swmr() array
sponsors As Integer     '1 if sponsors file used
records As Integer       '1 if records file used
dualscore As Integer    'true if only 2 relays can score

leftsex As String * 1   'sex of odd numbered events
numsessions As Integer  'number of sessions
sesstart(1 To 20) As Integer    'start event of each sessions
sessend(1 To 20)  As Integer  'array of last events in sessions
sessex(1 To 20) As String * 1 ' sex of session, M,F,N
sesnames(1 To 20) As String * 25

linecnt As Integer
page As Integer
column As Integer
hometeam As String * 60 'name of home swim team
address As String * 80
Phone As String * 30
LSC As String * 50      'local swimming committee
symbol As String * 6    'team initials
fore As Integer         'foreground color
bkgnd As Integer        'background color
finalheatname(1 To 4) As String * 50
recordname(1 To 4)  As String * 50
tf10u As Integer        'swim 10&u as timed finals
tfrelay As Integer      'swim relays as timed finals
tfdist As Integer       'swim 1000/1650 as timed finals
splitrelays As Integer  '1 heat at night
splitdist As Integer    '1 heat at night
places As Integer       'number of places to score
relayplaces As Integer  'number of relay places to score

'label parameters
labellines As Integer   'number of lines on labels
twocols As Integer      'TRUE if 2 columns of LABELS (not heat sheets)
labelflag As Integer    'TRUE if 5-inch labels
lblplaces As Integer    'number of places that get awards

grelcnt As Integer      'girls relay counter
gevcnt As Integer       'girls event counter
g10ucnt As Integer      '10u event count
brelcnt As Integer      'boys relay counter
bevcnt As Integer       'boys event counter
b10ucnt As Integer      '10u event count
swimdim As Integer      'current dimension of swmr array
entrdim As Integer      'currnet dimension of entries() array
splitcount As Integer   'number of splits already printed
maxevents As Integer
copies As Integer       'number of copies to print out
printsplits As Integer  'whether to print out splits
relaysplits As Integer  'print relay splits even if not others
longteam As Integer     'whether to use long team names

score(1 To 48) As Integer
rscore(1 To 48) As Integer
'pgheader As FontData      'font info on page headers
'subhead As FontData     'font info on subheads
'pagefont As FontData    'font info on main page text
'labelfont As FontData
'fonts(4) As FontData
End Type
'==========================================================================
Type SPLITREC
  times As Single           'times for each lane
  Class As Integer          'RSPLIT, BACKUP, FSPLIT, or SWIMOFF
  nextpnt As Integer        'ptr to next or 0
End Type
'==========================================================================
Type SWIMMER3
 frname As String * 20          'first name
 lname As String * 30           'last name
 index As Integer
 Attached As Integer
 age As Integer
 sex As String * 2
 bday As Single
 init As String * 4
 team As String * 6
 firstevent As Integer
 eventcount As Integer
 relaycount As Integer
 swimrecbyte As Long
 firstrecordbyte As Long
End Type

Type ENTRYREC3
  evnum As Integer              'event number in meet
  rplace As Integer             'place in trials
  points As Integer             'points scored * 100
  seed As Single                'seed time
  result As Single              'result time
  final As Single               'final time
  split As Single               'one split
  entrants(1 To 4) As Integer   'for relays
  escratch As String * 1        'scratch from entry/prelims
  fscratch As String * 1        'scratch from finals
End Type


Type SPLITLIST
  splitcount As Integer
  splittype As Integer          'race, backup
End Type

'Structure used to pass Team address information
Type TeamAddr
title As String * 80
init As String * 6
add1 As String * 80
Add2 As String * 80
contact As String * 80
coach As String * 80
LSC As String * 2
Phone As String * 20
tmtown As String * 30
city As String * 30
State As String * 8
Zip As String * 12

End Type

'===================================================================
Type C4000
  event As String * 1
  heat As String * 1
  inbackup As String * 1
  insplits As String * 1
  racenumber As Integer
  seconds As String * 1
  minutes As String * 1
  hours As String * 1
  weekday As String * 1
  month As String * 1
  day As String * 1
  year As String * 1
  lengths As String * 1
  lanes As String * 1
  timesperlane As String * 1
  reserv1 As String * 11
  reserv2 As String * 11
  res1 As Integer
  res2 As Integer
  res3 As Integer
  cres As String * 3
End Type
'===================================================================
' KeyCode (KeyDown, KeyUp)
Const KEY_BACK = 8
Const KEY_TAB = 9
Const KEY_CLEAR = 12
Const KEY_RETURN = 13           ' Enter key
Const KEY_SHIFT = 16
Const KEY_CONTROL = 17
Const KEY_MENU = 18             ' Alt key
Const KEY_PAUSE = 19
Const KEY_CAPITAL = 20          ' Caps lock key
Const KEY_ESCAPE = 27
Const KEY_SPACE = 32
Const KEY_PRIOR = 33            ' Page up key
Const KEY_NEXT = 34             ' Page down key
Const KEY_END = 35
Const KEY_HOME = 36
Const KEY_LEFT = 37
Const KEY_UP = 38
Const KEY_RIGHT = 39
Const KEY_DOWN = 40
Const KEY_SELECT = 41
Const KEY_PRINT = 42
Const KEY_EXECUTE = 43
Const KEY_SNAPSHOT = 44
Const KEY_INSERT = 45
Const KEY_DELETE = 127          ' Delete key returns 46 in Visual Basic for Windows.
Const KEY_HELP = 47


Const KEY_F1 = 112
Const KEY_F2 = 113
Const KEY_F3 = 114
Const KEY_F4 = 115
Const KEY_F5 = 116
Const KEY_F6 = 117
Const KEY_F7 = 118
Const KEY_F8 = 119
Const KEY_F9 = 120
Const KEY_F10 = 121
Const KEY_F11 = 122
Const KEY_F12 = 123
'================ MSGBOX parameters======================
Const MB_OK = 0                         ' OK button only
Const MB_OKCANCEL = 1                   ' OK and Cancel buttons
Const MB_ABORTRETRYIGNORE = 2           ' Abort, Retry, and Ignore buttons
Const MB_YESNOCANCEL = 3                ' Yes, No, and Cancel buttons
Const MB_YESNO = 4                      ' Yes and No buttons
Const MB_RETRYCANCEL = 5                ' Retry and Cancel buttons

Const MB_DEFBUTTON1 = 0                 ' First button is default
Const MB_DEFBUTTON2 = 256               ' Second button is default
Const MB_DEFBUTTON3 = 512               ' Third button is default

' MSGBOX return values
Const IDOK = 1                          ' OK button pressed
Const IDCANCEL = 2                      ' Cancel button pressed
Const IDABORT = 3                       ' Abort button pressed
Const IDRETRY = 4                       ' Retry button pressed
Const IDIGNORE = 5                      ' Ignore button pressed
Const IDYES = 6                         ' Yes button pressed
Const IDNO = 7                          ' No button pressed

'==========================================================================
Const ENTER = 13                'CR returns from getkey
Global Const LFKEY = 10                'Line Feed
Const ESCKEY = 27               'value returned from Esc
Const TABKEY = 9
Global Const CRKEY = 13
Const BTBKEY = 15
Const BSPKEY = 8
Const FORMKEY = 12
Const MODAL = 1

Global Const FREE = 1, BACK = 2, BREAST = 3, FLY = 4, IM = 5, RELAY = 6, MEDRELAY = 7, DIVING = 8
Global Const FLOAT = 9, WALK = 10, UNASSISTED = 11, ASSISTED = 12
Global Const VARSITY = 100, JV = 110, OPENMEET = 120
'CONST FALSE = 0, TRUE = -1
'Global Const YDS = 0, LCM = 1, SCM = 2
Global Const UNSCRATCH = 40000, SCRATCH = 30000, DQ = 20000, NT = 10000, UNOFFIC = 9000
Global Const BACKUP = 1, RSPLIT = 2, FSPLIT = 3, swimoff = 4
Global Const TRIALS = 1, RESULTS = 2, FINALS = 3, TIMETRIALS = 4, FINALRESULTS = 5, FINALSPROG = 6
Global Const IBMGRAPH = 1, EPSON = 2, IBMPRO = 3, SEIKOSHA = 4, HPLASER = 5, NOPRINTER = 6
Global Const C4000 = 1, C3000 = 2, DAK1000 = 4, DAK6000 = 8
'--------------------------------------------------------------------------
'$DYNAMIC
Global Const EVMAX = 250                'maximum events in meet
Global Const SWMAX = 900              'total number of swimmers in meet
Global Const TMAX = 5000               'maximum number of individula entries in meet
'CONST SWMAX = 300              'total number of swimmers in meet
'CONST TMAX = 1400               'maximum number of individula entries in meet

Global Const ENTMAX = 250             'maximum number in a single event
Global Const TMMAX = 250               'maximum number on a single team
'CONST TMMAX = 150               'maximum number on a single team

Global Const TIMEORDER = 0, AGEGRPORDER = 1, HEATORDER = 2


