VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Meet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"course"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'Class clsMeet
'contains description of swim meet
Dim prf As New Profile
Private meetRoot As String          'root filename
Private Meet_Name As String      'Name of meet
Private meetlocation As String  'location
Private Meet_Date As Date        'starting date
Private MeetCourse As String    'Yds, Lcm or Scm
Private meetSessions As New Collection
Private Evnts As New Collection
Private mt_finals As Boolean
Private mt_tf10u As Boolean
Private mt_tfdist As Boolean
Private mt_tfrelay As Boolean
Private meet_typekey As Long
Private meetClass As String
Private agegroups As New Collection
Private mtp As New MeetType
Private agrp As New AgeGroup
'debugging data *****
Private flog As New fdebug
'********************
Private f As Integer 'file handle
Dim fl As New file
Dim db As Database
'local variable(s) to hold property value(s)
Private mvareventPrice As Long 'local copy
Private mvarrelayPrice As Single 'local copy
Private mvardistancePrice As Single 'local copy
Private crs As New course
'local variable(s) to hold property value(s)
Private mvarperSwimmerPrice As Single 'local copy
Private meet_exists As Boolean

Public Property Let perSwimmerPrice(ByVal vData As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.perSwimmerPrice = 5
    mvarperSwimmerPrice = vData
    prf.putProfile "Meet", "perSwimmerPrice", Str$(vData)
End Property
Public Property Get perSwimmerPrice() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.perSwimmerPrice
    perSwimmerPrice = val(prf.getProfile("Meet", "perSwimmerPrice", "1"))
End Property
Public Property Let distanceprice(ByVal vData As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.distancePrice = 5
    mvardistancePrice = vData
    prf.putProfile "Meet", "distancePrice", Str$(vData)
End Property
Public Property Get distanceprice() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.distancePrice
   distanceprice = val(prf.getProfile("Meet", "distancePrice", "5"))
End Property
Public Property Let relayprice(ByVal vData As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.relayPrice = 5
    mvarrelayPrice = vData
    prf.putProfile "Meet", "relayPrice", Str$(vData)
End Property
Public Property Get relayprice() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.relayPrice
    relayprice = val(prf.getProfile("Meet", "relayPrice", "4"))

End Property
Public Property Let eventPrice(ByVal vData As Single)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.eventPrice = 5
    mvareventPrice = vData
    prf.putProfile "Meet", "eventPrice", Str$(vData)
End Property
Public Property Get eventPrice() As Single
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.eventPrice
    eventPrice = val(prf.getProfile("Meet", "eventPrice", "2"))

End Property
Public Function findAgeGroups() As Collection
Dim e As Integer, a As Integer
Dim found As Boolean
Dim evnt As clsEvents
Dim ag As AgeGroup

For e = 1 To Evnts.count
 Set evnt = getEvent(e)
 found = False
 For a = 1 To agegroups.count
   Set ag = agegroups(a)
   If evnt.minage = ag.minage And evnt.maxage = ag.maxage Then
    found = True
   End If
 Next a
 If Not found Then
  Set ag = New AgeGroup
  ag.maxage = evnt.maxage
  ag.minage = evnt.minage
  agegroups.add ag
 End If
Next e
Set findAgeGroups = agegroups

End Function
Property Let Meetname(S As String)
Meet_Name = S
End Property
Public Function getDate() As Date
getDate = Meet_Date
End Function
Public Sub setDB(datab As Database)
Set db = datab
End Sub
Property Let meetTypeKey(key As Long)
meet_typekey = key
End Property
Property Get Meetname() As String
 Meetname = Meet_Name
End Property
Property Get course() As String
course = MeetCourse
End Property
Property Let course(S As String)
Dim key As Integer
key = crs.getKey(S)
If key > 0 And key < 3 Then
  'coursekey = key
  MeetCourse = crs.getCourseString(key)
End If

End Property
Property Get courseKey() As Long
courseKey = crs.getKey(MeetCourse)
End Property
Property Let courseKey(key As Long)
If key > 0 And key < 3 Then
'  coursekey = key
  MeetCourse = crs.getCourseString(key)
End If
End Property
Property Get location() As String
location = meetlocation
End Property
Property Let location(S As String)
meetlocation = S
End Property
Public Function readMeet5(path$) As Integer
Dim ev As clsEvents
Dim i As Integer, j As Integer
Dim session As clsSession
Dim d$, yr$, syr As Single
 On Local Error GoTo keyerr
Set Evnts = Nothing
Set Evnts = New Collection
open_file path$
'flog.dprint "file opened:" + path
Dim meet_tag As String
meet_tag = GetLine
If meet_tag = "Swim 4.0" Then   'verfiy file type
 i = meetSessions.count
 While i > 0
  meetSessions.remove i
  i = meetSessions.count
 Wend
'flog.dprint "Sessions=" + Str$(Sessions.count)
 Meet_Name = Trim$(GetLine)         'read meet name
 meetlocation = Trim$(GetLine)     'and location
 
 Dim mdate As Long
 mdate = GetLine        'date in form yymmdd
 yr$ = Trim$(Str$(mdate \ 10000))
 syr = val(yr$)
  If syr > 80 Then
    syr = syr + 1900
  Else
    syr = syr + 2000
  End If
 d$ = Str$((mdate Mod 10000) \ 100) + "-" + Trim$(Str$(mdate Mod 100)) + "-" + Trim$(Str$(syr))
 Meet_Date = CDate(d$)
 MeetCourse = Trim$(UCase$(GetLine))
 
 Dim sesline As String, sescount As Integer
 sesline = GetLine
 i = InStr(sesline, "Sessions:")
 If i > 0 Then
  sesline = Right(sesline, Len(sesline) - i - 9)
  sescount = val(sesline)
  For j = 1 To sescount
   Set session = New clsSession
   session.SessionName = GetLine
   sesline = Trim$(GetLine)
   session.lastEvent = val(sesline)
   i = InStr(sesline, " ")
   session.sex = Trim$(Right$(sesline, Len(sesline) - i))
   meetSessions.add session, session.SessionName
  Next j
 End If
 'Read in events to end of file
 'and create a collection of them
 i = 1
 While Not EOF(f)
   Set ev = New clsEvents
   ev.eventnumber = val(GetLine)
   ev.Name = ev.eventnumber
   ev.courseKey = crs.getKey(MeetCourse)
   'If ev.Eventnumber = 0 Then
    ev.eventnumber = i
   'End If
   i = i + 1
   ev.sex = GetLine
   ev.minage = val(GetLine)
   ev.maxage = val(GetLine)
   If ev.maxage = 25 Then
     ev.maxage = agrp.senior_Max
   End If
   ev.Distance = val(GetLine)
   ev.stroke = GetLine
   ev.slowcut = val(GetLine)
   ev.fastcut = val(GetLine)
   ev.final = val(GetLine)
   ev.Links = GetLine
   Evnts.add ev, Str$(ev.eventnumber)
 Wend
 Close #f
 End If
fexit:
 Exit Function
 
keyerr:
  If Err.Number = 457 Then 'duplicate session names
    Resume Next
  Else
    MsgBox Err.Description
    Resume fexit
    End If
 'flog.dprint Str$(i) + " events"
End Function
Public Sub resetFilename(root$)
  Dim path As String, basepath As String
  Dim i As Integer, stp As New Setupdata
  meetRoot = root
  If fl.pathName = "" Then
    path = App.path + "\Meets\"
    If Len(Dir$(path, vbDirectory)) = 0 Then
      ChDrive Left$(App.path, 1)
      ChDir App.path
      MkDir "Meets"
    End If
  Else
      path = Left$(fl.pathName, Len(fl.pathName) - 1)
  End If
  i = Len(path)
  While Mid$(path, i, 1) <> "\" And i > 0
    i = i - 1
  Wend
  If i > 0 Then
    basepath = Left$(path, i)
    ChDrive Left$(basepath, 1)
    ChDir basepath
    If Len(Dir$(basepath + root$, vbDirectory)) = 0 Then
      MkDir root$
    End If
    path = basepath + root$
    ChDir path
    fl.setFile path + "\" + root + ".mt4"
    prf.setFilename path + "\" + root + ".mt6"
  End If
End Sub
Public Sub setFilename(path$)
fl.setFile path$ + ".mt4"
prf.setFilename path + ".mt6"
End Sub
Public Sub readMeet(path$)
Dim evnt As clsEvents
Dim evcnt As Integer, i As Integer, c As Integer
Dim para$, ageclass As String, fin As String
Dim extn As String
Dim prfile As New file
Dim sescount As Integer
Dim ses As clsSession

fl.setFile path$
extn = fl.Extension
'read in either mt4 or mt6 format files
prf.setFilename fl.pathName & fl.rootName & ".mt6"
prfile.setFile fl.pathName & fl.rootName & ".mt6"
meet_exists = False
If (UCase$(extn) = "MT4") And fl.exists Then
  'flog.dprint "mt4 found:" + path$
  meet_exists = True
  readMeet5 path
End If
If (UCase$(extn) = "MT6") And fl.exists Then
    Set meetSessions = Nothing
    meet_exists = True
    Set meetSessions = New Collection
    Meet_Name = prf.getProfile("Meet", "Name", "")
    Meet_Date = CVDate(prf.getProfile("Meet", "Date", date))
    meetlocation = prf.getProfile("Meet", "Location", "here")
    MeetCourse = prf.getProfile("Meet", "SeedCourse", "YDS")
    meetClass = prf.getProfile("Meet", "MeetType", "AgeGroup")
    evcnt = val(prf.getProfile("Meet", "EventCount", "0"))
    ' read in sessions
    sescount = val(prf.getProfile("Meet", "Numsessions", 1))
    For i = 1 To sescount
      Set ses = New clsSession
      ses.SessionName = prf.getProfile("Session" + Str$(i), "Name", "Session 1")
      ses.lastEvent = val(prf.getProfile("Session" + Str$(i), "LastEvent", "1"))
      ses.sex = prf.getProfile("Session" + Str$(i), "Sex", "N")
      meetSessions.add ses
    Next i
'Set Evnts = Null
    Set Evnts = New Collection
    For i = 1 To evcnt
        para$ = "Event" + Str$(i)
        Set evnt = New clsEvents
        evnt.eventnumber = i
        evnt.Name = prf.getProfile(para, "Name", Str$(i))
        evnt.sex = prf.getProfile(para, "Sex", "F")
        evnt.Distance = prf.getProfile(para, "Distance", "100")
        evnt.stroke = prf.getProfile(para, "Stroke", "free")
        If meetClass = "AgeGroup" Then
           ageclass = prf.getProfile(para, "AgeClass", "AgeGroup")
           If ageclass = "AgeGroup" Then
             evnt.minage = val(prf.getProfile(para, "Minage", 0))
             evnt.maxage = val(prf.getProfile(para, "Maxage", 0))
           Else
             evnt.minage = 0
             evnt.maxage = agrp.senior_Max
           End If
        End If
    For c = 1 To 3
        evnt.setSlowCut c, val(prf.getProfile(para, "SlowCut " + crs.getCourseString(c), "0"))
        evnt.setFastCut c, val(prf.getProfile(para, "FastCut " + crs.getCourseString(c), "0"))
    Next c
        fin = prf.getProfile(para, "Finals", "true")
        If fin = "true" Then
            evnt.final = True
        Else
            evnt.final = False
        End If
        Evnts.add evnt, Str$(i)
    Next i
End If
If Not prfile.exists Then
  'flog.dprint "saving meet6 file"
  saveMeet      'create .mt6 file for later use
End If
End Sub
Public Function exists() As Boolean
exists = meet_exists
End Function
Public Sub saveMeet()
Dim i As Integer, c As Integer
'uses existing data in prf object
Dim para$
Dim evnt As clsEvents
Dim meetPath As String
Dim ses As clsSession

mtp.setDB db
mtp.openTable

If meetSessions.count = 0 Then
  Set ses = New clsSession
  ses.lastEvent = Evnts.count
  ses.SessionName = "all"
  ses.sex = "N"
  meetSessions.add ses
End If

'prf.setFilename CurDir$ + "\" + Meet_Name + ".mt6"
'flog.dprint "saving profile:" + Meet_Name
prf.putProfile "Meet", "Name", Meet_Name
prf.putProfile "Meet", "Date", Format$(Meet_Date, "mm-dd-yyyy")
prf.putProfile "Meet", "Location", meetlocation
prf.putProfile "Meet", "SeedCourse", MeetCourse
'meetClass = mtp.getTypeName(meet_typekey)
prf.putProfile "Meet", "MeetType", meetClass
'flog.dprint "saving event count:" + Str$(Evnts.count)
prf.putProfile "Meet", "EventCount", Str$(Evnts.count)
'flog.dprint "saving mt6 data"   '***********
If Evnts.count > 0 Then
    prf.putProfile "Meet", "Numsessions", Str$(meetSessions.count)
Else
    prf.putProfile "Meet", "Numsessions", "0"
End If
For i = 1 To meetSessions.count
  Set ses = meetSessions(i)
 prf.putProfile "Session" + Str$(i), "Name", ses.SessionName
 prf.putProfile "Session" + Str$(i), "Sex", ses.sex
 prf.putProfile "Session" + Str$(i), "LastEvent", Str$(ses.lastEvent)
Next i

For i = 1 To Evnts.count
    para$ = "Event" + Str$(i)
    Set evnt = Evnts(i)
    prf.putProfile para, "Name", evnt.Name
    prf.putProfile para, "Sex", evnt.sex
    prf.putProfile para, "Distance", Str$(evnt.Distance)
    prf.putProfile para, "Stroke", evnt.stroke
    If meetClass = "AgeGroup" Then
        If evnt.minage = 0 And evnt.maxage = agrp.senior_Max Then
            prf.putProfile para, "AgeClass", "Senior"
        Else
            prf.putProfile para, "AgeClass", "AgeGroup"
        End If
    End If
    prf.putProfile para, "Minage", Str$(evnt.minage)
    prf.putProfile para, "Maxage", Str$(evnt.maxage)
    For c = 1 To 3
    prf.putProfile para, "SlowCut " + crs.getCourseString(c), Str$(evnt.getSlowCut(c))
    prf.putProfile para, "FastCut " + crs.getCourseString(c), Str$(evnt.getFastCut(c))
    Next c
    If evnt.final Then
      prf.putProfile para, "Finals", "true"
    Else
      prf.putProfile para, "Finals", "false"
    End If
    
Next i
'flog.dprint "Saving meet5 file "
saveMeet5
End Sub
Public Sub saveMeet5()
Dim i As Integer
Dim file$, f As Integer, S$
Dim evnt As clsEvents
Dim meetPath As String
Dim fil As New file

file$ = fl.getFile
'flog.dprint "Saving:" + file$
f = FreeFile
If fl.Extension <> "mt4" Then
  file$ = fl.pathName + fl.rootName + ".mt4"
End If
'If (file$ <> "") And fl.exists Then
fil.setFile file$
If (file$ <> "") Then
 If fil.exists Then
Open file$ For Output As #f
Print #f, "Swim 4.0"
Print #f, Meet_Name
Print #f, meetlocation
Print #f, Format$(Meet_Date, "yymmdd")
Print #f, MeetCourse
Print #f, "Sessions: 0"
For i = 1 To Evnts.count
    Set evnt = Evnts(i)
    Print #f, evnt.Name
    Print #f, evnt.sex
    Print #f, evnt.minage
    If evnt.maxage = agrp.senior_Max Then
      Print #f, 25
    Else
        Print #f, evnt.maxage
    End If
    Print #f, evnt.Distance
    S$ = evnt.stroke
    If UCase$(S$) = "FREE RELAY" Then
      S$ = "RELAY"
    End If
    Print #f, S$
    Print #f, evnt.slowcut
    Print #f, evnt.fastcut
    If evnt.final Then
      Print #f, 1
    Else
      Print #f, 0
    End If
    Print #f, 0         'links
    
Next i
Close #f
End If
End If
End Sub
Property Get tfrelay() As Boolean
tfrelay = mt_tfrelay
End Property
Private Sub open_file(path$)
  f = FreeFile
  fl.setFile path$
  If fl.exists Then
    Open path$ For Input As #f
  End If
End Sub
Private Function GetLine() As String
Dim S$
 Line Input #f, S$
 GetLine = S$
End Function
Public Function eventCount() As Integer
  eventCount = Evnts.count
End Function
Public Function eventName(i As Integer) As String
Dim ev As clsEvents
If i > 0 And i <= Evnts.count Then
  
  Set ev = Evnts.Item(Str$(i))    'Evnts.Item(Str$(i)).Name
  eventName = ev.sex + " " + ev.AgeString() + " " + Str$(ev.Distance) + " " + ev.Strokename
End If
End Function
Public Function getEvent(i As Integer) As clsEvents
If i > 0 And i <= Evnts.count Then
    Set getEvent = Evnts.Item(i)
End If
End Function
Property Get finals() As Boolean
finals = mt_finals
End Property
Property Get tf10u() As Boolean
tf10u = mt_tf10u
End Property
Property Get MeetDate() As Date
MeetDate = Meet_Date
End Property
Property Let MeetDate(d As Date)
Meet_Date = d
End Property

Private Sub Class_Initialize()
meet_exists = False

End Sub

Private Sub Class_Terminate()
Set meetSessions = Nothing
Set Evnts = Nothing
End Sub
Public Function AgeStr$(min As Integer, max As Integer)
Dim ag$, stmin$, stmax$
AgeStr$ = agrp.age_String(min, max)

End Function
Property Get Events(Index As Integer) As clsEvents
Set Events = Evnts(Index)
End Property
Public Sub deleteEvent(Index As Integer)
Dim i As Integer, max As Integer
max = Evnts.count - 1
ReDim evts(max) As clsEvents
Evnts.remove Index
For i = 1 To max
  Set evts(i) = Evnts(i)
  evts(i).eventnumber = i
  evts(i).Name = Str$(i)
Next i
Set Evnts = Nothing
Set Evnts = New Collection
For i = 1 To max
  Evnts.add evts(i)
Next i

End Sub
Public Function tfdist() As Boolean
tfdist = mt_tfdist
End Function
Public Sub Addevent(sx$, minage As Integer, maxage As Integer, dist As Integer, strokeKey As Integer, slowcut As Single, fastcut As Single, final As Boolean)
Dim evt As New clsEvents
evt.Distance = dist
evt.sex = sx$
evt.strokeKey = strokeKey
evt.minage = minage
evt.maxage = maxage
evt.slowcut = slowcut
evt.fastcut = fastcut
evt.final = final
evt.eventnumber = Evnts.count + 1
evt.Name = Str$(Evnts.count + 1)
Evnts.add evt
End Sub
Public Function getPath() As String
getPath = fl.pathName
End Function
Public Function getFile() As file
Set getFile = fl
End Function
Public Sub setDate(dt As Date)
Meet_Date = dt
End Sub
Public Function numsessions() As Integer
numsessions = meetSessions.count
End Function
Public Function sessionNames(i As Integer)
Dim ses As clsSession
Set ses = meetSessions(i)
sessionNames = ses.SessionName
End Function
Public Function lastEvent(i As Integer)
Dim ses As clsSession
Set ses = meetSessions(i)
lastEvent = ses.lastEvent
End Function
Public Function sessionSex(i As Integer)
Dim ses As clsSession
Set ses = meetSessions(i)
sessionSex = ses.sex
End Function
Public Sub setSessions(S As Collection)
Set meetSessions = S
End Sub
Public Function getSession(i As Integer) As clsSession
Set getSession = meetSessions(i)
End Function
Public Sub insertEvent(e As Integer, ev As clsEvents)
Dim i As Integer, max As Integer

max = Evnts.count + 1
ReDim evlist(max) As clsEvents

For i = 1 To e - 1
 Set evlist(i) = Evnts(i)
Next i
Set evlist(e) = ev
For i = e To Evnts.count
 Set evlist(i + 1) = Evnts(i)
Next i
Set Evnts = Nothing
Set Evnts = New Collection
For i = 1 To max
  'Debug.Print i, evlist(i).Distance
  evlist(i).eventnumber = i
  Evnts.add evlist(i)
Next i
End Sub
