VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Labels"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Dim par As Parents
Dim Bill As Bills

Dim label_Printer As Printer
Dim label_Font As Font
Dim two_cols As Boolean
Dim label_count As Integer

Dim labelDevice As String
Dim labelDriver As String
Dim labelPort As String
Dim stp As New Setupdata
Dim pr_saved As Printer

Dim left_flag As Boolean    'false if left label
'bookmarks for 2 label records
Dim top_margin As Integer
Dim label_cols As Integer
Dim column_count As Integer
Dim margin As Integer   'left edge of current label
Const Twips_Per_Inch = 1440#
Const Labelrows_perpage = 10

Public Sub setParBills(p As Parents, b As Bills)
Set par = p
Set Bill = b
End Sub

Private Sub Class_Initialize()
Dim prn As Printer
labelDevice = stp.getProfile("Labels", "Printername", Printer.DeviceName)
labelDriver = stp.getProfile("Labels", "Driver", Printer.DriverName)
labelPort = stp.getProfile("Labels", "Port", Printer.port)
Set label_Font = read_font(stp.getProfile("Labels", "Font", Printer.FontName + ",0,0"))

Set label_Printer = Printer     'set default
For Each prn In Printers
  If prn.DeviceName = labelDevice And prn.DriverName = labelDriver Then
    Set label_Printer = prn
  End If
Next prn
two_cols = False
push_printer
On Local Error GoTo nobin
Printer.PaperBin = vbPRBNTractor
Printer.Font.Name = label_Font.Name
Printer.Font.Size = label_Font.Size
Printer.Font.Bold = label_Font.Bold
Printer.Font.Italic = label_Font.Italic
top_margin = 0.55 * Twips_Per_Inch
Printer.CurrentY = top_margin
left_flag = True
label_cols = stp.getLabelColumns
column_count = 1
Exit Sub

nobin:
  two_cols = True
  Resume Next
End Sub

Private Function read_font(S$) As Font
Dim i As Integer
Dim fnt As New StdFont
'converts string in form
' Fontname, fontsize, bold, italic
'into values in font structure

fnt.Name = get_token$(S$)
If Trim$(fnt.Name) = "" Then
  fnt.Name = Printer.FontName
End If
Dim sz As Integer
sz = val(get_token$(S$))
If sz <= 0 Then
  sz = 10
End If
fnt.Size = sz
fnt.Bold = val(get_token$(S$)) <> 0
fnt.Italic = val(S$) <> 0
Set read_font = fnt
End Function

Property Let labelFont(fn As Font)
 Set label_Font = fn
write_font_info
End Property

Property Let labelPrinter(pr As Printer)
 Set label_Printer = pr
 labelDevice = pr.DeviceName
 labelDriver = pr.DriverName
 labelPort = pr.port
 stp.putProfile "Labels", "Printername", labelDevice
 stp.putProfile "Labels", "Driver", labelDriver
 stp.putProfile "Labels", "Port", labelPort
End Property

Property Get labelFont() As Font
Set labelFont = label_Font
End Property

Property Get labelPrinter() As Printer
Set labelPrinter = label_Printer
End Property

Private Function get_token$(S$)
'removes one comma-delimited token from the string
Dim i As Integer

i = InStr(S$, ",")
If i > 0 Then
  get_token$ = Left$(S$, i - 1)
  S$ = Right$(S$, Len(S$) - i)
Else
  get_token = S$
End If
End Function

Private Sub write_font_info()
'Converts into comma-delimited font string for ini-file
Dim ans As Integer, S$
S$ = Trim$(label_Font.Name) + "," + Str$(label_Font.Size)
S$ = S$ + "," + Str$(label_Font.Bold) + "," + Str$(label_Font.Italic)
stp.putProfile "Labels", "Font", S$

End Sub
Private Sub setLabelPosition()
If label_cols = 2 Then
  If left_flag Then
     left_flag = False
     margin = 0.25 * Twips_Per_Inch
  Else
    margin = 4.25 * Twips_Per_Inch
    label_count = label_count + 1
    left_flag = True
  End If
Else
  Select Case column_count
   Case 1:
     margin = 0.25 * Twips_Per_Inch
   Case 2:
     margin = 3# * Twips_Per_Inch
   Case 3:
     margin = 5.75 * Twips_Per_Inch
  End Select
  column_count = column_count + 1
  If column_count > 3 Then
    column_count = 1
    label_count = label_count + 1
  End If
End If

End Sub
Public Sub printLabel(label As Collection)

Dim i As Integer
If two_cols Then            'measn laser labels
  setLabelPosition
  'Printer.CurrentY = top_margin
  For i = 1 To label.count
   Printer.CurrentX = margin
   Printer.Print label.Item(i);
   Printer.CurrentY = Printer.CurrentY + Printer.textHeight("X")
  Next i
  
    If label_count < 10 Then
      Printer.CurrentY = label_count * Twips_Per_Inch + top_margin
    Else
      Printer.newPage
      Printer.CurrentY = top_margin
      label_count = 0
      left_flag = True
    End If
  Else
  For i = 1 To label.count
    Printer.Print label.Item(i)
  Next i
  Printer.newPage
End If

End Sub
Private Sub push_printer()
Set pr_saved = Printer
If Printer.DeviceName <> label_Printer.DeviceName Then
Set Printer = label_Printer
End If
End Sub

Private Sub pop_printer()
'Set Printer = pr_saved
End Sub

Public Sub saveProfile()
stp.putProfile "Labels", "Printername", Printer.DeviceName
stp.putProfile "Labels", "Driver", Printer.DriverName
stp.putProfile "Labels", "Port", Printer.port
write_font_info

End Sub
Public Sub endDoc()
 Printer.endDoc
 pop_printer
End Sub
