VERSION 1.0 CLASS
BEGIN
  MultiUse = 0   'False
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Kids"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"

Option Explicit

Private db As Database
Private krec As Recordset
Private par_key As Long
Private qry$
Private adding As Boolean
Private sq As New Squads
Private kids As TableDef
Private bill_num As Integer
Private opened As Boolean
Private pr As clsPrinters
Private kmeets As New kidMeets
Private crs As New course
Private yrec As Recordset, mrec As Recordset, srec As Recordset
Private stp As New Setupdata
Private max25s As Integer
Private found As Boolean

Public Function setPrinter(prs As clsPrinters)
Set pr = prs
End Function
Public Function getTableName() As String
getTableName = "Kids"
End Function

Public Sub createTable()
Dim ind As New Indexer
ind.makeTable db, "Kids"

ind.createKey "KidKey"
ind.createLong "ParentKey"
ind.createText "Frname", 15
ind.createText "Lname", 16
ind.createText "Nickname", 15
ind.createText "Initial", 1
ind.createText "All_Initials", 3
ind.createDateField "Birthday"
ind.createText "Sex", 1

ind.createBoolean "Active"
ind.createBoolean "Attached"
ind.createDateField "Regdate"
ind.createDateField "Startdate"
ind.createText "Citizen", 3
ind.createBoolean "MedicalRel"
ind.createBoolean "ConductCode"
ind.createText "IDNumber", 16
ind.createLong "SquadKey"
ind.createBoolean "Billstat"
ind.createInteger "Billnum"
ind.createInteger "CatKey1"
ind.createInteger "CatKey2"
ind.createInteger "CatKey3"


ind.makeIndex "KidKey", True
ind.makeIndex "Lname", False
ind.makeIndex "SquadKey", False
ind.makeIndex "Billnum", False
ind.makeIndex "Frname", False
ind.addTable
upgrade_60_62
End Sub
Public Sub upgrade_60_62()
Dim ind As New Indexer
Dim tbl As TableDef
Dim fld As Field

ind.openTable db, "Kids"
ind.createText "Middle", 15
ind.createBoolean "Registered"
ind.createBoolean "JrHi"
ind.createBoolean "SrHi"
ind.createBoolean "YMCA"
ind.createBoolean "College"
ind.createBoolean "Summer"
ind.createBoolean "Masters"
ind.createBoolean "Disabled"
ind.createBoolean "WaterPolo"

ind.createBoolean "African"
ind.createBoolean "Asian"
ind.createBoolean "Caucasian"
ind.createBoolean "Hispanic"
ind.createBoolean "NativeAmerican"
ind.createBoolean "Other"
ind.createBooleanTrue "UsCitizen"
ind.createBoolean "DualCitizen"
ind.createBoolean "OtherFINA"
ind.createBoolean "Decline"
Set krec = db.OpenRecordset("Kids", dbOpenTable)
While Not krec.EOF
    krec.Edit
    If Left$(UCase$(krec![Citizen] & ""), 2) = "US" Then
        krec![UScitizen] = True
    End If
    krec![Middle] = krec![Initial]
    krec.update
  
  krec.moveNext
Wend
krec.Close
End Sub
Public Sub setDB(datab As Database)
Set db = datab
sq.setDB db
kmeets.setDB db
End Sub
Public Sub setParentkey(key As Long)
par_key = key
krec![parentkey] = par_key
End Sub
Property Get parentkey() As Long
parentkey = par_key
End Property
Property Let parentkey(pkey As Long)
par_key = pkey
qry$ = "SELECT DISTINCTROW Kids.ParentKey, kids.kidkey, Kids.Frname, Kids.Nickname, Kids.Lname, Kids.Initial, Kids.All_Initials, Kids.Birthday, Kids.Sex, Kids.Active, Kids.Attached, Kids.Regdate, Kids.Startdate, Kids.Citizen, Kids.MedicalRel, Kids.ConductCode, Kids.IDNumber, Kids.SquadKey, Kids.Billstat, kids.billnum " + _
"From Kids WHERE (Kids.ParentKey=" + Str$(pkey) + ");"
Set krec = db.OpenRecordset(qry$, dbOpenDynaset)
End Property
Public Sub deleteAll()
Dim evrec As Recordset, brec As Recordset
Dim kidkey As Integer
If Not krec.BOF Then
  While Not krec.EOF
    kidkey = krec![kidkey]
    qry$ = "select * from SwimEvents where KidKey=" + Str$(kidkey)
    Set evrec = db.OpenRecordset(qry$, dbOpenDynaset)
    While Not evrec.EOF
      evrec.delete
      evrec.moveNext
    Wend
    evrec.Close
    qry$ = "select * from Bills where KidKey=" + Str$(kidkey)
    Set brec = db.OpenRecordset(qry$, dbOpenDynaset)
    While Not brec.EOF
      brec.delete
      brec.moveNext
    Wend
    brec.Close
    krec.delete
    krec.moveNext
  Wend
End If
End Sub
Property Get frname() As String
frname = testnull(krec![frname])
End Property
Property Let frname(ByVal S As String)
Dim j As Integer

If Len(S) > 0 Then
    If Right$(S, 1) = "." Then
        S = Left$(S, Len(S) - 1)
    End If
    j = Len(S) - 1
    If j > 0 Then
      If Mid$(S, j, 1) = " " Then
      Initial = Right(S, 1)
        S$ = Left$(S, j - 1)
      End If
    End If
End If
krec![frname] = makenull(S)
End Property
Property Get Nickname() As String
Nickname = testnull(krec![Nickname])
End Property
Property Let Nickname(S As String)
krec![Nickname] = makenull(S)
End Property
Property Get LastName() As String
LastName = testnull(krec![lname])
End Property
Property Let LastName(S As String)
krec![lname] = Left$(makenull(S), 16)
End Property
Property Get EOF() As Boolean
EOF = krec.EOF
End Property
Public Sub MoveFirst()
 If krec.RecordCount > 0 Then
 krec.MoveFirst
 par_key = krec![parentkey]
 End If
End Sub
Public Sub moveNext()
 krec.moveNext
If Not krec.EOF Then par_key = krec![parentkey]
End Sub
Public Sub find(fr As String)
Dim crit$
crit$ = "nickname='" + fr + "'"
krec.FindFirst crit$
End Sub
Property Get Sex() As String
Sex = testnull(krec![Sex])
End Property
Public Sub delete()
Dim frec As Recordset, query$
kidkey = krec![kidkey]
query$ = "Select * from SwimEvents where kidkey=" + Str$(kidkey)
Set frec = db.OpenRecordset(query, dbOpenDynaset)
While Not frec.EOF
  frec.delete
  frec.moveNext
Wend
frec.Close
query$ = "Select * from Bills where kidkey=" + Str$(kidkey)
Set frec = db.OpenRecordset(query, dbOpenDynaset)
While Not frec.EOF
  frec.delete
  frec.moveNext
Wend
frec.Close
krec.delete
End Sub
Property Let Sex(S As String)
If (S = "M") Or (S = "F") Then
  krec![Sex] = S
End If
  
End Property
Property Get Initial() As String
Initial = testnull(krec![Initial])
End Property
Property Let Initial(S As String)
If Len(S) > 0 Then
 krec![Initial] = Left$(S, 1)
Else
 krec![Initial] = Null
End If
End Property
Public Sub Edit()
    krec.Edit
End Sub
Public Sub update()
Dim fr$
krec![parentkey] = par_key
fr$ = krec![frname]
krec.update
krec.Bookmark = krec.LastModified
End Sub
Public Sub updateRecord()
krec.update
krec.Bookmark = krec.LastModified

End Sub
Property Get all_initials() As String
all_initials = testnull(krec![all_initials])
End Property
Property Let all_initials(S As String)
If S = "NULL" Then
    krec![all_initials] = ""
Else
    krec![all_initials] = makenull(S)
End If
End Property
Property Get birthday() As Date
birthday = krec![birthday]
End Property
Property Let birthday(d As Date)
krec![birthday] = d
End Property
Property Get Attached() As Boolean
Attached = krec![Attached]
End Property
Property Let Attached(b As Boolean)
krec![Attached] = b
End Property
Property Get Active() As Boolean
If krec![Active] <> 0 Then
    Active = True
Else
   Active = False
End If
End Property
Property Let Active(b As Boolean)
krec![Active] = b
End Property
Property Let billnum(bl As Integer)
  krec![billnum] = bl
End Property
Property Get billnum() As Integer
billnum = krec![billnum]
End Property
Property Get Billstat() As Boolean
 Billstat = krec![Billstat]
End Property
Property Let Billstat(b As Boolean)
 krec![Billstat] = b
End Property
Public Function findKeybyName(lname As String, fname As String) As Long
Dim fkey As Long, qry$
Dim rec As Recordset, rec_count As Integer
Dim ufname As String, substr As Integer
fkey = 0
qry$ = "Select * from Kids where lname=" + Chr$(34) + lname + Chr$(34)
Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
rec_count = 0
While Not rec.EOF And fkey = 0
  rec_count = rec_count + 1
  ufname = UCase(fname$)
  substr = InStr(UCase$(rec![Nickname]), ufname)
  If (UCase$(rec![frname]) = ufname) Or (UCase$(rec![Nickname]) = ufname) Or (substr > 0) Then
    fkey = rec![kidkey]
  Else
    rec.moveNext
  End If
Wend

findKeybyName = fkey
rec.Close
End Function
Public Function findKey(lname As String, fname As String, ByVal bnum As Integer) As Integer
Dim fkey As Long, dt As Date

bnum = Abs(bnum)
Set krec = db.OpenRecordset("kids", dbOpenTable)
krec.Index = "billnum"
krec.Seek "=", bnum
If krec.NoMatch Then
  krec.Index = "Lname"
  krec.Seek "=", lname
  If krec.NoMatch Then
    fkey = 0
  End If
  If fkey <> 0 Then
    If UCase$(krec![frname]) <> UCase$(frname) Then
        fkey = 0
    End If
  End If
  If fkey <> 0 Then
    findKey = krec![kidkey]
  End If
Else
  fkey = krec![kidkey]
End If
findKey = fkey
End Function
Property Get Regdate() As Date
Regdate = krec![Regdate] '& ""
End Property
Property Let Regdate(d As Date)
krec![Regdate] = d
End Property
Property Get StartDate() As Date
Dim dt As Date
If IsDate(krec![StartDate] & "") Then
    StartDate = krec![StartDate] & ""
Else
  StartDate = CVDate("1-1-1980")
End If
End Property
Property Let StartDate(d As Date)
krec![StartDate] = d
End Property
Property Get Citizen() As String
Citizen = testnull(krec![Citizen])
End Property
Property Let Citizen(S As String)
krec![Citizen] = makenull(S)
End Property
Property Get squadKey() As Long
squadKey = krec![squadKey]
End Property
Property Let squadKey(sq As Long)
krec![squadKey] = sq
End Property
Property Get Medicalrel() As Boolean
Medicalrel = krec![Medicalrel]
End Property
Property Let Medicalrel(b As Boolean)
krec![Medicalrel] = b
End Property
Property Get conductcode() As Boolean
 conductcode = krec![conductcode]
End Property
Property Let conductcode(b As Boolean)
krec![conductcode] = b
End Property
Public Sub addNew()
krec.addNew
adding = True
End Sub

Private Function makenull(S As String) As Variant
 If S = "" Then
   makenull = Null
 Else
   makenull = Trim$(S)
 End If
End Function
Private Function testnull(S) As String
If IsNull(S) Then
    testnull = ""
Else
    testnull = S
End If
End Function

Property Get IdNumber() As String
'If krec.NoMatch Then
' MsgBox "Swimmer has been deleted"
'End If
On Local Error GoTo nokid
 If Not krec.EOF Then
 IdNumber = krec![IdNumber] & ""
 Else
 IdNumber = "0000000000"
 End If
idx:
 Exit Property
nokid:
 IdNumber = "0000000000"
 Resume Next
End Property
Property Let IdNumber(S As String)
 krec![IdNumber] = makenull(S)
End Property
Property Get Size() As Long
Size = krec.RecordCount
End Property
Public Function getTable() As TableDef
Set getTable = kids
End Function
Property Get kidkey() As Long
kidkey = krec![kidkey]
End Property
Public Sub MoveLast()
If Not krec.BOF Then
    krec.MoveLast
    par_key = krec![parentkey]
    End If
End Sub
Public Function count() As Integer
If Not krec.BOF Then
    krec.MoveLast
    krec.MoveFirst
    count = krec.RecordCount
Else
  count = 0
End If
End Function
Property Get squad() As String
Dim sqkey As Integer
sqkey = krec![squadKey]
squad = sq.sqname(sqkey)
End Property
Public Sub openTable()
If Not opened Then
    Set krec = db.OpenRecordset("Kids", dbOpenTable)
    opened = True
    If Not krec.BOF Then
      If Not IsNull(krec![parentkey]) Then
        par_key = krec![parentkey]
      End If
    End If
End If
End Sub
Public Sub closeTable()
If opened Then
    If Not krec.BOF Then krec.Close
    opened = False
End If
End Sub

Public Function getName(key As Long) As String
openTable
krec.Index = "kidkey"
krec.Seek "=", key
If Not krec.NoMatch Then
    getName = krec![frname] + " " + krec![lname]
    found = True
Else
    getName = ""
    found = False
End If
End Function
Public Function getSDIName(key As Long) As String
openTable
krec.Index = "kidkey"
krec.Seek "=", key
If Not krec.NoMatch Then
    getSDIName = krec![lname] + ", " + krec![frname]
    found = True
Else
    getSDIName = ""
    found = False
End If
End Function

Public Function findSwimmer(lname$, frname$, init$, cbirth$, USSID As String, found As Boolean) As Recordset

Dim rec As Recordset, qry$, dt As Date, sdt$
Dim fbirth As String, gotQuery As Boolean

found = False
gotQuery = False
If Trim(USSID) <> "" Then
  qry$ = "select * from kids where kids.idnumber=" + Chr$(34) + USSID + Chr$(34)
  Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
  gotQuery = True
End If
If Trim$(cbirth$) <> "" And Trim(USSID) = "" Then
    sdt$ = Left(cbirth, 2) + "-" + Mid$(cbirth$, 3, 2) + "-" + Right$(cbirth, 2)
    If IsDate(sdt$) Then
        dt = CVDate(sdt$)
        fbirth = Format(dt, "mm-dd-yyyy")
        qry$ = "select * from kids where kids.birthday=#" + fbirth$ + "#;"
        Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
        gotQuery = True
    End If
End If
If (Trim$(cbirth) = "" And Trim(USSID) = "") Or (Not gotQuery) Then
  qry$ = "select * from kids where kids.lname=" + Chr$(34) + lname$ + Chr$(34)
  Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
End If
While Not rec.EOF And Not found
  If UCase$(Trim$(lname$)) = UCase$(rec![lname]) _
  And UCase$(Trim$(init$)) = UCase$(rec![all_initials] & "") Then
      found = True
      Set findSwimmer = rec
      If (Trim$(init$) = "") Then
        If UCase$(Trim$(frname$)) <> UCase$(rec![frname]) Then
          found = False
        End If
      End If
  End If
  If Not found Then
    If UCase$(Trim$(lname$)) = UCase$(rec![lname]) _
    And (UCase$(Trim$(frname$)) = UCase$(rec![frname]) _
    Or UCase$(Trim$(frname$)) = UCase$(rec![Nickname])) _
    Then
      found = True
         Set findSwimmer = rec
    End If
  End If
  If Not found Then
    If UCase$(Trim$(lname$)) = UCase$(rec![lname]) _
    And InStr(UCase$(rec![frname]), UCase$(Trim$(frname$))) > 0 Then
       found = True
       Set findSwimmer = rec
    End If
  End If
  If Not found Then rec.moveNext
Wend
' if still not found, look by last name in case bday was wrong
If Not found And (Asc(lname$) <> 0) Then
  qry$ = "select * from kids where kids.lname=" + Chr$(34) + lname$ + Chr$(34) + ";"
  Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
  While Not rec.EOF And Not found
    If UCase$(Trim$(lname$)) = UCase$(rec![lname]) _
        And UCase$(Trim$(frname$)) = UCase$(rec![frname] & "") Then
      found = True
      Set findSwimmer = rec
  End If
  If Not found Then
    If UCase$(Trim$(lname$)) = UCase$(rec![lname]) _
        And UCase$(Trim$(frname$)) = UCase$(rec![frname]) _
        Or UCase$(Trim$(frname$)) = UCase$(rec![Nickname]) _
    Then
      found = True
      Set findSwimmer = rec
    End If
  End If
  If Not found Then rec.moveNext
  Wend
 End If

End Function
Public Function fuzzyLastNames(fzname$) As Recordset
Dim qry$
qry$ = "select * from Kids where kids.lname like " + Chr$(34) + fzname$ + "*" + Chr(34) + ";"
Set fuzzyLastNames = db.OpenRecordset(qry$, dbOpenDynaset)

End Function
Public Function findLastNames(lname$) As Recordset
Dim qry$
qry$ = "select * from Kids where kids.lname =" + Chr$(34) + lname$ + Chr(34) + ";"
Set findLastNames = db.OpenRecordset(qry$, dbOpenDynaset)
End Function
Property Let kidkey(key As Long)
openTable
krec.Index = "Kidkey"
krec.Seek "=", key
End Property

Private Sub Class_Initialize()
opened = False
max25s = stp.getAge25s
End Sub
Public Sub PrintTimes(sd As Date, opYds As Boolean, opLCM As Boolean, opSCM As Boolean)
Dim age As Integer, c As Integer, showcourse As Boolean
Dim rec  As Recordset, brec As Recordset
  If krec![Active] Then
   age = printKidName(krec)
   pr.setPlain
  For c = 1 To 3        '3 courses
   showcourse = False
   If c = 1 And opYds Then
     Set brec = getBest(kidkey, c, sd)
     Set rec = getMeetsPerKid(sd, c)
     showcourse = True
   End If
   If c = 2 And opLCM Then
     Set brec = getBest(kidkey, c, sd)
     Set rec = getMeetsPerKid(sd, c)
     showcourse = True
   End If
   If c = 3 And opSCM Then
     Set brec = getBest(kidkey, c, sd)
     Set rec = getMeetsPerKid(sd, c)
     showcourse = True
   End If
   'now lets get all those meet times into an array of recordsets
    kmeets.clear krec![kidkey], age
    kmeets.addBest brec
   If showcourse Then
    While Not rec.EOF
     kmeets.add rec![meetKey]
     rec.moveNext
    Wend
   End If
  kmeets.buildStrokelist
  'print out all meets in columns of 10
 If showcourse And kmeets.meetCount > 0 Then
        printMeets kmeets, c
 End If
 Next c
 End If     'if active

End Sub
Private Function getMeetsPerKid(sinceDate As Date, courseKey As Integer) As Recordset
Dim query$, dt$

dt$ = Format$(sinceDate, "mm-dd-yyyy")
query$ = "SELECT DISTINCTROW Meets.MeetKey, Meets.MeetDate, Meets.MeetName, Meets.ResultCourse " & _
"FROM Strokes INNER JOIN (Meets INNER JOIN (Kids INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey) ON Meets.MeetKey = SwimEvents.meetKey) ON Strokes.strokeKey = SwimEvents.strokeKey " & _
"Where (((Meets.MeetDate) > #" + dt$ + "#) And ((Meets.ResultCourse) = " + Str$(courseKey) + ") And ((kids.kidkey) = " + Str$(kidkey) + ")) " & _
"ORDER BY Meets.MeetDate;"

Set getMeetsPerKid = db.OpenRecordset(query$, dbOpenDynaset)

End Function
Private Function printKidName(rec As Recordset) As Integer
'returns age
Dim age As Integer, todate As Date, S$
todate = CVDate(date$)
pr.testPage (14)
    pr.setSubHeadFont
    S$ = rec![Nickname] + " " + rec![lname]
    pr.lPrint S$ + " " + rec![Sex] + " " + Format$(rec![birthday], "mm-dd-yyyy")
    'PrintTimes.setStatus s$
    age = val(Format$(todate - rec![birthday], " yy"))
    pr.lPrintcr "   " + Str$(age)
    pr.setPageFont
    pr.lPrintcr IdNumber
    pr.newLine
printKidName = age
End Function

Private Sub printMeets(kmeets As kidMeets, c As Integer)
Dim r As Integer, k As Integer
Dim tabpos As Integer, colsleft As Integer
Dim kfirst As Integer, klast As Integer
Dim numcols As Integer
 If pr.isLandscape Then
   numcols = 15
 Else
   numcols = 10
 End If

kfirst = 1
klast = kmeets.meetCount
If klast > numcols Then
  klast = numcols
End If

While kfirst <= kmeets.meetCount
'print out the meet name
k = kfirst
kmeets.MoveFirst
tabpos = 0
  While k <= klast
    If tabpos = 0 Then
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    If k > 1 Then
     pr.lPrint Left$(LCase$(kmeets.getMeetName()), 8)
    Else
     pr.lPrint "Best"
    End If
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
pr.newLine
'print out the meet date and course (Y,L or S)
k = kfirst
kmeets.MoveTo k
tabpos = 0
  While k <= klast
    If tabpos = 0 Then
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    If k > 1 Then
      pr.lPrint Format$(kmeets.getMeetDate(), "mmddyy")
    End If
    pr.lPrint UCase$(Left$(crs.getCourseString(c), 1))
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
pr.newLine
'print out the actual times
k = kfirst
r = 1
kmeets.MoveTo k
While r <= kmeets.rowCount
  tabpos = 0
  k = kfirst
  kmeets.MoveTo k
  
  While k <= klast
    If tabpos = 0 Then
      pr.lPrint kmeets.getRowLabel(r)
      tabpos = tabpos + 15
      pr.Tabbit tabpos
    End If
    pr.lPrint kmeets.getColumn(r)
    tabpos = tabpos + 8
    pr.Tabbit tabpos
    k = k + 1
    kmeets.MoveTo k
  Wend
  r = r + 1
  pr.newLine
  tabpos = 0
 Wend
 pr.newLine     'blank line between courses
 pr.testPage 18
kfirst = klast + 1
colsleft = kmeets.meetCount - kfirst
If colsleft > numcols Then
  colsleft = numcols
End If
klast = kfirst + colsleft
Wend
End Sub
Private Function getBest(kidkey As Long, ByVal courseKey As Long, since As Date) As Recordset
Dim qry$, dt$
dt$ = Format$(since, "mm-dd-yyyy")

'this query gets the best times for a given course
qry$ = "SELECT DISTINCTROW Kids.KidKey, SwimEvents.Distance, swimevents.strokekey, Strokes.strokeName, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime, Meets.MeetDate " & _
"FROM (Meets INNER JOIN (Kids INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey) ON Meets.Meetkey = SwimEvents.meetKey) INNER JOIN Strokes ON SwimEvents.strokeKey = Strokes.strokeKey " & _
"Where (((kids.kidkey) = " + Str$(kidkey) + ") And ((Meets.MeetDate) > #" + dt$ + "#) And ((Meets.ResultCourse) = " + Str$(courseKey) + ")) " & _
"ORDER BY SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime;"


Set getBest = db.OpenRecordset(qry$, dbOpenDynaset)

End Function
Public Sub printBestTimes(dt$)
Dim S As Integer
Dim tabpos As Integer, todate As Date
Dim age As Integer, sd As Date, dist As Integer, skey As Integer

Dim tm As New times

'prints out best times of each squad selected
'using each course selected
If IsDate(dt$) Then
  sd = CVDate(dt$)
Else
  sd = CVDate("1-1-1980")
End If
 pr.setSubHeadFont
 pr.Centerit stp.Teamname
 pr.setPageFont
 pr.Centerit stp.teamTown + ", " + stp.TeamState + " " + stp.TeamZip
 
 pr.Centerit "Best times " + date$

  pr.setPageFont
 
    age = printKidName(krec)
    Set yrec = getBest(krec![kidkey], 1, sd)
    Set mrec = getBest(krec![kidkey], 2, sd)
    Set srec = getBest(krec![kidkey], 3, sd)
    tabpos = 10
    pr.Tabbit tabpos + 12
    pr.setItalic
    'If opYds.Value Then
        pr.lPrint "SC Yards"
        tabpos = tabpos + 20
        pr.Tabbit tabpos + 12
    'End If
  
    'If opLCM.Value Then
        pr.lPrint "LC Meters"
        tabpos = tabpos + 20
        pr.Tabbit tabpos + 12
    'End If
  
    'If opSCM.Value Then
      pr.lPrint "SC Meters"
     pr.setPlain
    pr.newLine
    'print out each course until all done
    While Not allDone
        tabpos = 10
         If Not yrec.EOF Then
                If age > max25s And yrec![Distance] = 25 Then
                 While yrec![Distance] = 25 And Not yrec.EOF
                  yrec.moveNext
                 Wend
                End If
            If Not yrec.EOF Then
                pr.Tabbit tabpos
                tm.setSingle yrec![swimTime]
                dist = yrec![Distance]
                skey = yrec![strokeKey]
                pr.lPrint Str$(yrec![Distance]) + " " + yrec![Strokename]
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
                skipOver yrec, dist, skey
            End If
        tabpos = tabpos + 20
        pr.Tabbit tabpos
        End If
    
        'If opLCM.Value Then
            If Not mrec.EOF Then
                tm.setSingle mrec![swimTime]
                dist = mrec![Distance]
                skey = mrec![strokeKey]
                pr.lPrint Str$(mrec![Distance]) + " " + mrec![Strokename]
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
                skipOver mrec, dist, skey
            End If
            tabpos = tabpos + 20
            pr.Tabbit tabpos
     '   End If
    
    '    If opSCM.Value Then
            If Not srec.EOF Then
                If age > max25s And srec![Distance] = 25 Then
                  srec.moveNext
                End If
                tm.setSingle srec![swimTime]
                dist = srec![Distance]
                skey = srec![strokeKey]
                pr.lPrint Str$(srec![Distance]) + " " + srec![Strokename]
                pr.Tabbit tabpos + 12
                pr.rightAlign "29:59.99", tm.getFormatted
                skipOver srec, dist, skey
            End If
            tabpos = tabpos + 20
            pr.Tabbit tabpos
     '   End If
    
        pr.newLine
        'moreYards           'increment in subroutine
        'moreLCMeters        'to test for existence
        'moreSCMeters
    Wend
    pr.newLine
'  End If
 
 pr.endDoc

 
End Sub
Private Sub skipOver(drec As Recordset, dist As Integer, skey As Integer)
Dim quitFlag As Boolean
'skips on to next stroke or distance
quitFlag = False
If Not drec.EOF Then
    While Not quitFlag
    If Not drec.EOF Then
        If drec![Distance] <> dist Or drec![strokeKey] <> skey Then
          quitFlag = True
        Else
          drec.moveNext
        End If
    End If
    If drec.EOF Then quitFlag = True
    Wend
End If
End Sub
Private Function moreYards()
'If opYds.Value Then
  If Not yrec.EOF Then
    yrec.moveNext
  End If
'End If
End Function
Private Function moreLCMeters()
'If opLCM.Value Then
  If Not mrec.EOF Then
    mrec.moveNext
  End If
'End If
End Function
Private Function moreSCMeters()
'If opSCM.Value Then
  If Not srec.EOF Then
    srec.moveNext
  End If
'End If
End Function

Private Function allDone() As Boolean
Dim ydone As Boolean, mdone As Boolean, sdone As Boolean

sdone = True
ydone = True
mdone = True
'If opYDS.Value Then
  ydone = yrec.EOF
'End If
'If opLCM.Value Then
  mdone = mrec.EOF
'End If
'If opSCM.Value Then
  sdone = srec.EOF
'End If
allDone = sdone And ydone And mdone
End Function

Public Function getAllTimes() As Recordset
Dim rec As Recordset
Dim qry$

qry$ = "SELECT Kids.KidKey, Meets.MeetDate, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime, SwimEvents.courseKey, SwimEvents.SplitEventKey " & _
"FROM Kids INNER JOIN (Meets INNER JOIN SwimEvents ON Meets.Meetkey = SwimEvents.meetKey) ON Kids.KidKey = SwimEvents.kidKey " & _
"Where (((kids.kidkey) = " + Str$(kidkey) + ") And ((SwimEvents.swimtime) < 10000 And (SwimEvents.swimtime) > 0)) " & _
"ORDER BY SwimEvents.strokeKey, SwimEvents.courseKey;"

Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
Set getAllTimes = rec
End Function
