VERSION 5.00
Begin VB.Form Improved 
   Caption         =   "Print times from meet"
   ClientHeight    =   4455
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   6660
   LinkTopic       =   "Form1"
   ScaleHeight     =   4455
   ScaleWidth      =   6660
   StartUpPosition =   3  'Windows Default
   Begin VB.OptionButton btImproved 
      Caption         =   "Improved times"
      Height          =   375
      Left            =   5280
      TabIndex        =   8
      Top             =   840
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton btAll 
      Caption         =   "All times"
      Height          =   375
      Left            =   5280
      TabIndex        =   7
      Top             =   1320
      Width           =   1215
   End
   Begin VB.CommandButton Cancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4800
      TabIndex        =   5
      Top             =   3240
      Width           =   975
   End
   Begin VB.CommandButton Printit 
      Caption         =   "Print"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3600
      TabIndex        =   4
      Top             =   3240
      Width           =   855
   End
   Begin VB.ListBox lsSquads 
      Height          =   2010
      Left            =   3360
      MultiSelect     =   1  'Simple
      TabIndex        =   2
      Top             =   720
      Width           =   1815
   End
   Begin VB.ListBox lsMeets 
      Height          =   3180
      Left            =   240
      TabIndex        =   0
      Top             =   720
      Width           =   2895
   End
   Begin VB.Label Status 
      Height          =   375
      Left            =   3240
      TabIndex        =   6
      Top             =   3960
      Width           =   2775
   End
   Begin VB.Label Label2 
      Caption         =   "From swimmers in selected squads"
      ForeColor       =   &H00C00000&
      Height          =   375
      Left            =   3600
      TabIndex        =   3
      Top             =   240
      Width           =   1695
   End
   Begin VB.Label label1 
      Caption         =   "Print improved times at selected meet"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2655
   End
End
Attribute VB_Name = "Improved"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private db As Database
Private sq As New Squads
Private mts As New Meets
Private pr As New clsPrinters
Private strk As New stroke
Private tm As New times
Public Sub setDB(datab As Database)
Set db = datab
sq.setDB db
mts.setDB db
End Sub

Private Sub Cancel_Click()
Unload Me
End Sub

Private Sub Form_Load()
Dim i As Integer

sq.openFile
sq.MoveFirst
While Not sq.endFile
  lsSquads.AddItem sq.SquadName
  i = lsSquads.ListCount - 1
  lsSquads.ItemData(i) = sq.squadkey
  sq.moveNext
Wend

mts.openSorted
While Not mts.EOF
  lsMeets.AddItem Format$(mts.MeetDate, "Short date") + " " + mts.Meetname
  i = lsMeets.ListCount - 1
  lsMeets.ItemData(i) = mts.getMeetKey
  mts.moveNext
Wend

End Sub

Private Sub lsMeets_Click()
printit.Enabled = True
End Sub

Private Sub Printit_Click()
Dim qry$, mdate$, sqry$
Dim meetKey As Long, i As Integer, S As Integer
Dim squadkey As Integer
Dim swrec As Recordset, resrec As Recordset, courseKey As Integer

Screen.MousePointer = vbHourglass
pr.setHeaderFont
If btImproved.Value Then
    pr.Centerit "Swimmers achieving best times"
Else
    pr.Centerit "Times for swimmers in this meet"
End If
pr.setSubHeadFont
i = lsMeets.ListIndex
meetKey = lsMeets.ItemData(i)
pr.Centerit mts.getName(meetKey) + " - " + Format$(mts.getDate(meetKey), "Short date")
mdate$ = "#" + Format$(mts.getDate(meetKey), "Short date") + "#"
courseKey = mts.getCourse(meetKey)
pr.newLine
pr.setPageFont

If btImproved.Value Then
'loop through squads
For S = 0 To lsSquads.ListCount - 1
 If lsSquads.Selected(S) Then
  squadkey = lsSquads.ItemData(S)
  sqry$ = "Select * from Kids where squadkey=" + Str$(squadkey)
  Set swrec = db.OpenRecordset(sqry, dbOpenDynaset)
  While Not swrec.EOF
    Status.Caption = swrec![Nickname] + " " + swrec![lname]
    Status.Refresh
    If btImproved.Value Then
        qry$ = "SELECT Kids.KidKey, Kids.Nickname, Kids.Lname, SwimEvents.meetKey, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime, SwimEvents.place, Swimevents.points, Kids.SquadKey, Meets.MeetName, Meets.MeetDate " & _
        "FROM Kids INNER JOIN (Meets INNER JOIN SwimEvents ON Meets.Meetkey = SwimEvents.meetKey) ON Kids.KidKey = SwimEvents.kidKey " & _
        "Where (((kids.kidkey) = " + Str$(swrec![kidkey]) + ") And ((Meets.MeetDate) <= " + mdate$ + ")) And (Swimevents.coursekey = " + Str$(courseKey) + ") " & _
        "ORDER BY Kids.Lname, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime;"
        Set resrec = db.OpenRecordset(qry$, dbOpenDynaset)
        printBest resrec, meetKey
    End If
  swrec.moveNext
  Wend
  swrec.Close
 End If
Next S
Else
    For S = 0 To lsSquads.ListCount - 1
    If lsSquads.Selected(S) Then
        squadkey = lsSquads.ItemData(S)
          qry$ = "SELECT kids.kidkey, Kids.Nickname, Kids.Lname, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime, SwimEvents.Place, SwimEvents.Points, Kids.SquadKey, SwimEvents.meetKey " & _
        "FROM Kids INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey " & _
        "Where (((SwimEvents.swimtime) > 0) And ((kids.squadKey) = " + Str$(squadkey) + ") And ((SwimEvents.meetKey) = " + Str$(meetKey) + ")) " & _
        "ORDER BY Kids.Lname, Kids.Kidkey, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.swimtime;"
        Set resrec = db.OpenRecordset(qry$, dbOpenDynaset)
        printAllTimes resrec, meetKey
     End If
   Next S
    
End If
pr.endDoc
Screen.MousePointer = vbDefault

End Sub
Private Sub printBest(rec As Recordset, meetKey As Long)
Dim lastStroke As Integer, lastDist As Integer
Dim namePrinted As Boolean, Quit As Boolean
Dim newsecs As Single, oldsecs As Single, diff As Single

lastStroke = 0
lastDist = 0
namePrinted = False
While Not rec.EOF
  If rec![strokeKey] <> lastStroke Or rec![Distance] <> lastDist Then
    lastStroke = rec![strokeKey]
    lastDist = rec![Distance]
    If rec![meetKey] = meetKey Then 'best time done if first
      If Not namePrinted Then
        pr.testPage 7
        pr.setBold
        pr.lPrintcr rec![Nickname] + " " + rec![lname]
        namePrinted = True
        pr.setPlain
      End If
      pr.lPrint Str$(lastDist)
      pr.Tabbit 7
      pr.lPrint strk.getStrokeName(rec![strokeKey])
      pr.Tabbit 20
      tm.setSingle rec![swimTime]
      pr.lPrint tm.getFormatted
      If rec![place] > 0 Or rec![points] > 0 Then
        pr.lPrint " " + Str$(rec![place]) + " " + Str$(rec![points])
      End If
      newsecs = tm.getSeconds(tm.getSingle)
      Quit = False
      Do
        rec.moveNext
        Quit = rec.EOF
        If Not rec.EOF Then Quit = rec![meetKey] <> meetKey
      Loop Until Quit
      If Not rec.EOF Then
        If rec![strokeKey] = lastStroke And rec![Distance] = lastDist Then
            'compute percent improvement
            tm.setSingle rec![swimTime]
            oldsecs = tm.getSeconds(tm.getSingle)
            diff = oldsecs - newsecs
            pr.Tabbit 30
            pr.lPrint Format$(diff / oldsecs, "###.00%")
            pr.Tabbit 40
            pr.lPrint "( " + tm.getFormatted
            pr.Tabbit 50
            pr.lPrint rec![Meetname]
            pr.Tabbit 65
            pr.lPrint Format$(rec![MeetDate], "Short date") + " )"
        End If
      End If
    pr.newLine
    End If
  End If
If Not rec.EOF Then rec.moveNext
Wend
If namePrinted Then pr.newLine
rec.Close
End Sub
Private Sub printAllTimes(rec As Recordset, meetKey As Long)
Dim lastStroke As Integer, lastDist As Integer
Dim namePrinted As Boolean, Quit As Boolean
Dim newsecs As Single, oldsecs As Single, diff As Single
Dim oldkey As Integer

lastStroke = 0
lastDist = 0
namePrinted = False
oldkey = 0
While Not rec.EOF
'  If rec![strokekey] <> lastStroke Or rec![Distance] <> lastDist Then
    lastStroke = rec![strokeKey]
    lastDist = rec![Distance]
    'If rec![meetKey] = meetKey Then 'best time done if first
      If oldkey <> rec![kidkey] Then
      'If Not namePrinted Then
        pr.testPage 7
        pr.setBold
        pr.lPrintcr rec![Nickname] + " " + rec![lname]
        namePrinted = True
        oldkey = rec![kidkey]
        pr.setPlain
      End If
      pr.lPrint Str$(lastDist)
      pr.Tabbit 7
      pr.lPrint strk.getStrokeName(rec![strokeKey])
      pr.Tabbit 20
      tm.setSingle rec![swimTime]
      pr.lPrint tm.getFormatted
      If rec![place] > 0 Or rec![points] > 0 Then
        pr.lPrint " " + Str$(rec![place]) + " " + Str$(rec![points])
      End If
      newsecs = tm.getSeconds(tm.getSingle)
'      rec.moveNext
     
    pr.newLine
'    End If
 ' End If
 rec.moveNext
Wend
If namePrinted Then pr.newLine
rec.Close

End Sub

