VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "AgeGroup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'this object represents one age group in the meet
Private min_age As Integer
Private max_age As Integer

Private fswimmer As Integer
Private mswimmer As Integer
Private nswimmer As Integer
Private fevcount As Integer
Private mevcount As Integer
Private nevcount As Integer
'distance event counters
Private fdist As Integer
Private mdist As Integer
Private ndist As Integer
Private Const seniorMax = 99, varsity_meet = 100, J_v = 110, Open_Meet = 120
Function senior_Max() As Integer
senior_Max = seniorMax
End Function
Public Function VARSITY() As Integer
VARSITY = varsity_meet
End Function
Public Function parseSDIAge(sage As String)
Dim smin$, smax$
If Len(sage) < 4 Then
  sage = Space$(4 - Len(sage)) + sage
End If

smin = Left$(sage, 2)
smax = Right(sage, 2)
If smin = "UN" Then
  minage = 0
Else
  minage = val(smin)
End If

If smax = "OV" Then
  maxage = senior_Max
Else
  maxage = val(smax)
End If
End Function
Public Function JV() As Integer
JV = J_v
End Function
Public Function OPENMEET() As Integer
OPENMEET = Open_Meet
End Function
Public Function age_String(min As Integer, max As Integer) As String
min_age = min
max_age = max
age_String = AgeString
End Function
Property Let minage(a As Integer)
min_age = a
End Property
Property Get minage() As Integer
minage = min_age
End Property
Property Let maxage(a As Integer)
max_age = a
End Property
Property Get maxage() As Integer
maxage = max_age
End Property
Public Sub parseAge(agString$)
Dim i As Integer
If UCase$(agString) = "SENIOR" Then
  minage = 0
  maxage = senior_Max
End If
If UCase$(agString) = "VARSITY" Then
  minage = 0
  maxage = VARSITY
End If
If UCase$(agString) = "JV" Then
  minage = 0
  maxage = JV
End If
If UCase$(agString) = "OPEN" Then
  minage = 0
  maxage = OPENMEET
End If
i = InStr(agString, "-")
If i <= 0 Then
  i = InStr(agString, ",")
End If
If i > 0 Then
  minage = val(Left$(agString, i - 1))
  maxage = val(Right$(agString, Len(agString) - i))
End If
i = InStr(agString, "/O")
If i > 0 Then
  minage = val(Left$(agString, i - 1))
  maxage = senior_Max
End If
i = InStr(agString, "&U")
If i > 0 Then
  minage = 0
  maxage = val(Left(agString, i - 1))
End If

    
End Sub
Public Function isSenior() As Boolean
If max_age = senior_Max And min_age = 0 Then
  isSenior = True
Else
  isSenior = False
End If
End Function
Public Function isOver() As Boolean
If max_age = senior_Max And min_age <> 0 Then
  isOver = True
Else
  isOver = False
End If

End Function
Private Sub Class_Initialize()
fswimmer = 0
mswimmer = 0
nswimmer = 0
fevcount = 0
mevcount = 0
nevcount = 0
End Sub
Public Sub Incr(Sw As Swimmer)
 
Select Case Sw.Sex
 Case "F"
  If Not Sw.isCounted Then fswimmer = fswimmer + 1
  fevcount = fevcount + Sw.scratchedEntrycount
  fdist = fdist + Sw.scratchedDistanceCount
 Case "M"
  If Not Sw.isCounted Then mswimmer = mswimmer + 1
  mevcount = mevcount + Sw.scratchedEntrycount
  mdist = mdist + Sw.scratchedDistanceCount
 Case "N"
  If Not Sw.isCounted Then nswimmer = nswimmer + 1
  nevcount = nevcount + Sw.scratchedEntrycount
  ndist = ndist + Sw.scratchedDistanceCount

End Select
End Sub
Public Function getCount(sx$) As Integer
 Select Case sx$
   Case "F"
   getCount = fswimmer
   Case "M"
    getCount = mswimmer
   Case "N"
    getCount = nswimmer
 End Select
End Function
Public Function getEventCount(sx$) As Integer
 Select Case sx$
   Case "F"
   getEventCount = fevcount
   Case "M"
   getEventCount = mevcount
   Case "N"
   getEventCount = nevcount
 End Select

End Function
Public Function getDistanceCount(sx$) As Integer
 Select Case sx$
   Case "F"
   getDistanceCount = fdist
   Case "M"
   getDistanceCount = mdist
   Case "N"
   getDistanceCount = ndist
 End Select

End Function

Public Function AgeString()
 If min_age = 0 Then
   If max_age <> senior_Max Then
     AgeString = Str$(max_age) + "&U"
   Else '0-SENIOR_MAX represents Senior Events
     AgeString = " Senior "
   End If
   If max_age = varsity_meet Then
     AgeString = "Varsity"
   End If
   If max_age = J_v Then
     AgeString = "Junior Varsity"
   End If
   If max_age = OPENMEET Then
     AgeString = "Open"
   End If
 Else
   If max_age = 25 Then max_age = senior_Max    'meet 57 conversion
   If max_age = senior_Max Or max_age = VARSITY Then
     'xx-SENIOR_MAX represent "xx and Over"
     AgeString = Str$(min_age) + "/O"
   Else
     AgeString = Str$(min_age) + "-" + Str$(max_age)
   End If
   
 End If
 If min_age = max_age Then
  AgeString = Str$(max_age) + " yr old"
 End If
End Function
Public Function sexString(ByVal sx$) As String

Select Case sx$
  Case "F"
    If max_age > 18 Then
      sx$ = "Women"
    Else
      sx$ = "Girls"
    End If
  Case "M"
  If max_age > 18 Then
      sx$ = "Men"
    Else
      sx$ = "Boys"
    End If
  Case "N"
    sx$ = "Swimmers"
End Select
sexString = sx$
End Function
Public Function matchEvent(ev As clsEvents) As Boolean
Dim found As Boolean
matchEvent = (ev.maxage = max_age)
If ev.maxage = 25 And max_age = 99 Then
  matchEvent = True
End If
If (ev.isSenior And isSenior) Then matchEvent = True
If (ev.isOver And isOver) Then matchEvent = True

End Function
Public Function matchEventSex(ev As clsEvents, Sex As String) As Boolean
matchEventSex = (ev.Sex = Sex) And matchEvent(ev)
End Function
Public Sub clear()
fswimmer = 0
mswimmer = 0
nswimmer = 0
fevcount = 0
mevcount = 0
nevcount = 0
fdist = 0
mdist = 0
ndist = 0
End Sub
