VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "printPage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'prints entire pages in 1,2 or 3 columns
Private pageLines As New Collection
Private pr As clsPrinters
Private numCols As Integer
Private pLine As New PrintLine
Private doHeaders As Boolean 'whether to put header on each page
Const Page_Font = 0, Subhead_font = 1, Header_Font = 2
Const TwipsPerInch = 1440
Private left_margin As Single, top_margin As Single, bot_margin As Single
Private colHeight As Single, fontHeight As Single, pageHeight As Single
Private cHeight As Single
Private headerString As String, subheadString As String
Private widowSpace As Single
Private top_y As Single   'header or not
Private column_width As Single
Private stp As New SetupData
Private c As Integer
Private page_count As Integer
Public Sub setHeader(head$, subheader$)
headerString = head$
subheadString = subheader$

pr.setHeader head$
If Len(headerString) > 0 Then
  doHeaders = True
Else
  doHeaders = False
End If
End Sub

Public Sub setLeftMargin(lmarg As Single)
'left_margin = lmarg

End Sub
Public Sub setMargins(top As Single, bot As Single)
top_margin = top
bot_margin = bot
pageHeight = pr.height / TwipsPerInch - top - bot
End Sub
Public Sub setPrinter(prs As clsPrinters)
Set pr = prs
pageHeight = pr.height / TwipsPerInch - top_margin - bot_margin
End Sub
Public Sub setColumns(cols As Integer)
numCols = cols
End Sub
Public Sub lPrint(s As String, tb As Integer)
'accumulate height
cHeight = pLine.setPrint(pr, s, tb)
End Sub
Private Sub lprint_break(s As String, tb As Integer)
'accumulate height
cHeight = pLine.setPrint(pr, s, tb)
pLine.setBreak True

End Sub
Public Sub setFont(pr As clsPrinters, typ As Integer)
pLine.setHeadType pr, typ
End Sub
Public Sub lPrintcr(s As String, tb As Integer)
If Len(s) > 0 Then
  lPrint s, tb
End If
colHeight = colHeight + cHeight
pageLines.add pLine
Set pLine = New PrintLine
If colHeight >= (pageHeight * (numCols + 1)) Then
    newPage False
    colHeight = 0
End If
End Sub
Public Sub lprintBreak(s As String, tb As Integer)
If Len(s) > 0 Then
  lprint_break s, tb
End If
colHeight = colHeight + cHeight
pageLines.add pLine
Set pLine = New PrintLine

If colHeight >= (pageHeight * (numCols + 1)) Then
    newPage False
    colHeight = 0
End If
End Sub
Private Sub flushColumns()
Dim c1 As Integer, Quit As Boolean
Dim i As Integer, hsum As Single

For c1 = c To numCols - 1
 Quit = False
i = 1
hsum = top_margin + bot_margin
While Not Quit And i <= pageLines.count
 Set pLine = pageLines(i)
 If pLine.getHeaderType = 0 Then
   hsum = hsum + pLine.getHeight
 End If
 If (pageHeight - hsum) < 0.3 Then
   Quit = True
 End If
 If Not Quit And pLine.getHeaderType > 0 Then
   hsum = hsum + pLine.getHeight
 End If
 If pLine.getBreak And (pageHeight - hsum) < widowSpace Then
   Quit = True
   If pLine.getBreak Then i = i - 1
 End If
 If Not Quit Then i = i + 1
Wend
If i > pageLines.count Then i = pageLines.count
'If quit Or flush Then
  print_column c1 * column_width, i
'End If
pr.YInch = top_y


Next c1
End Sub
Public Sub newPage(flush As Boolean)
Dim i As Integer, Quit As Boolean
Dim pLine As PrintLine
Dim hsum As Single
top_y = 0

'If flush Then
'  flushColumns
'End If
top_y = 0
If doHeaders Then
  pr.setHeaderFont
  pr.YInch = 0
  pr.Centerit headerString
  pr.setSubHeadFont
  pr.Centerit subheadString
  pr.HLine
  pr.newLine
  top_y = pr.YInch
End If

For c = 0 To numCols - 1
Quit = False
i = 1
'hsum = top_y + top_margin + bot_margin
hsum = top_y + bot_margin
pageHeight = pr.height / TwipsPerInch - hsum
While Not Quit And i <= pageLines.count
 Set pLine = pageLines(i)
 If pLine.getHeaderType = 0 Then
   hsum = hsum + pLine.getHeight
 End If
 If (pageHeight - hsum) < 0.3 Then
   Quit = True
 End If
 If Not Quit And pLine.getHeaderType > 0 Then
   hsum = hsum + pLine.getHeight
 End If
 If pLine.getHeaderType > 0 And (pageHeight - hsum) < widowSpace Then
   Quit = True
   If pLine.getHeaderType > 0 Then i = i - 1
 End If
 If Not Quit Then i = i + 1
Wend
If i > pageLines.count Then i = pageLines.count
If Quit Then
  print_column left_margin + c * column_width, i
End If
If Not Quit And flush Then
  print_column left_margin + c * column_width, i
End If
pr.YInch = top_y

Next c
If flush And pageLines.count > 0 Then
  nextPage
  newPage (True)
'End If
Else
nextPage
End If
End Sub
Public Sub nextPage()
setFont pr, 0
colHeight = 0
'If page_count >= 0 Then
'pr.Y = top_y + pageHeight * TwipsPerInch
pr.Y = pr.height - 5 * pr.textHeight("LSA")
pr.lPrintcr "LSA SwimMeet 6.6"
pr.newPage
'If page_count > 0 Then
'    page_count = pageLines.count
'Else
' page_count = -1
'End If
'End If
End Sub
Public Sub endDoc()
newPage True
pr.endDoc
End Sub
Private Function print_column(lmargin As Single, ByVal max As Integer) As Index
Dim i As Integer
Dim pLine As PrintLine
Dim tempCol As Collection
i = 1
While i <= pageLines.count And (pageHeight - pr.YInch) > 0.3
  Set pLine = pageLines(i)
  pLine.lPrintcr pr, lmargin
  i = i + 1
Wend
max = i - 1
'now move up remainder of lines for next column
Set tempCol = pageLines
Set pageLines = Nothing
Set pageLines = New Collection
For i = max + 1 To tempCol.count
  pageLines.add tempCol(i)
Next i
End Function
Public Function tabTextWidth(txt As String) As Single
Dim w As Single
w = pr.textWidth(txt)
w = w / pr.textWidth("9")       'convert to tab units
tabTextWidth = w
End Function

Private Sub Class_Initialize()
top_margin = 0.5
bot_margin = 0.5
left_margin = 0
numCols = 2
doHeaders = False
colHeight = 0
widowSpace = 1#
column_width = 4
End Sub
Public Sub setPageNum(pnnum As Integer)
pr.setPageNum pnnum
End Sub
Public Function getPageNum() As Integer
getPageNum = pr.getPageNum
End Function
