VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsPrinters"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const Twips_Per_Inch = 1440#

Dim Header_Font As Font
Dim Subhead_font As Font
Dim Page_Font As Font

Dim curFont As Font
Dim stp As New SetupData
Dim page_Printer As Printer

Dim pageDevice As String
Dim pageDriver As String
Dim pagePort As String

Dim header As String    'page header
Dim PAGE As Integer
Dim centerhead As Boolean
Private left_margin As Single   'in twips
Private pwidth As Integer        'in twips
Private pheight As Integer
Private colors() As Long
Private colorMode As Boolean        'true if attempt color
Private pFnt As StdFont
Public Sub setColorList(c() As Long)
Dim i As Integer
For i = 0 To UBound(c)
  colors(i) = c(i)
Next i

End Sub
Public Sub setColorMode(b As Boolean)
colorMode = b
End Sub
Private Sub setColorLine(Index As Integer)
'switches colors to dotted lines if printer is not color
If Printer.colorMode = vbPRCMMonochrome Or Not colorMode Then
  Printer.DrawStyle = Index
End If
If colors(Index) = vbBlack Then
  Printer.DrawStyle = 0
End If
End Sub
Public Sub setHeader(s$)
header = s
End Sub
Public Sub setCenterHead(c As Boolean)
centerhead = c
End Sub
Public Function height() As Integer
height = Printer.height
End Function
Public Function width() As Integer
width = Printer.width

End Function
Public Sub printHeader()
setFont Header_Font
If centerhead Then
  Centerit header
Else
  Printer.Print header
End If
setFont Page_Font
Printer.Print   'extra line after header
End Sub
Public Function testPage(n As Integer) As Boolean
'does page eject if not enough lines left
Dim h As Integer, lines As Integer

h = height - Printer.CurrentY       'allows for driver non-printing area
lines = h / Printer.textHeight("X")
If lines <= n + 5 Then
  newPage
  testPage = False  'needed new page
Else
  testPage = True  'did not do page eject
End If
End Function
Property Get pagePrinter() As Printer
Set pagePrinter = page_Printer
End Property
Public Sub setFonts()
Printerdata.setprinters Me
Printerdata.Show vbModal
End Sub
Property Let pagePrinter(pr As Printer)
Set page_Printer = pr
Set Printer = pr
Call stp.putProfile("Printer", "Printername", Printer.DeviceName)
Call stp.putProfile("Printer", "Driver", Printer.DriverName)
Call stp.putProfile("Printer", "Port", Printer.port)

End Property
Public Sub setHeaderFont()
setFont HeaderFont
End Sub
Property Get HeaderFont() As Font
 Set HeaderFont = Header_Font
End Property
Property Let HeaderFont(f As Font)
 Set Header_Font = f
 Call write_font_info("Header", f)
End Property
Property Get subHeadFont() As Font
 Set subHeadFont = Subhead_font
End Property
Property Let subHeadFont(f As Font)
 Set Subhead_font = f
 Call write_font_info("Subhead", f)
End Property
Property Get PageFont() As Font
 Set PageFont = Page_Font
End Property
Property Let PageFont(f As Font)
 Set Page_Font = f
 Call write_font_info("Page", f)
End Property
Public Sub setSubHeadFont()
setFont Subhead_font
End Sub
Public Sub setPageFont()
setFont Page_Font
End Sub
Public Function getFont() As Font
Set getFont = pFnt
End Function
Property Let X(t As Long)
  Printer.CurrentX = t
End Property
Property Get X() As Long
X = Printer.CurrentX
End Property
Property Let Y(t As Long)
  Printer.CurrentY = t
End Property
Property Get Y() As Long
Y = Printer.CurrentY
End Property
Property Get YInch() As Single
YInch = Printer.CurrentY / Twips_Per_Inch
End Property
Property Let YInch(Y As Single)
Printer.CurrentY = Y * Twips_Per_Inch
End Property

Property Let Xinch(X As Single)
Printer.CurrentX = X * Twips_Per_Inch + left_margin
End Property
Property Get Xinch() As Single
 Xinch = Printer.CurrentX / Twips_Per_Inch
End Property
Public Sub setFont(fon As Font)
Printer.Font.Name = fon.Name
Printer.Font.Size = fon.Size
Printer.Font.Bold = fon.Bold
Printer.Font.Italic = fon.Italic
Set pFnt = fon
End Sub
Public Sub Centerit(s As String)
Dim w As Integer, tw As Integer

w = Printer.width
tw = Printer.textWidth(s)
If w > tw Then
 Printer.CurrentX = (w - tw) / 2
End If
Printer.Print s
End Sub
Public Sub Tabbit(n As Integer)
Dim tabpos As Single
 tabpos = n * Printer.textWidth("n") + left_margin
 Printer.CurrentX = tabpos
End Sub
Private Function read_font(s$) As Font
Dim i As Integer
Dim fnt As New StdFont
'converts string in form
' Fontname, fontsize, bold, italic
'into values in font structure

On Local Error GoTo ferr
fnt.Name = get_token$(s$)
If Trim$(fnt.Name) = "" Then
  fnt.Name = Printer.FontName
End If
fnt.Size = val(get_token$(s$))
If fnt.Size <= 0 Then
  fnt.Size = 10
End If
fnt.Bold = get_token$(s$)
fnt.Italic = s$

rfexit:
    Set read_font = fnt
Exit Function

ferr:
  fnt.Name = "Arial"
  fnt.Size = 10
  'fd.dprint "err=" + Str$(Err) + " " + fnt.Name
  
  Resume rfexit
End Function

Function get_token$(s$)
'removes one comma-delimited token from the string
Dim i As Integer

i = InStr(s$, ",")
If i > 0 Then
  get_token$ = Left$(s$, i - 1)
  s$ = Right$(s$, Len(s$) - i)
Else
  get_token = s$
End If
End Function
Private Sub write_font_info(ftype As String, fnt As Font)
'Converts into comma-delimited font string for ini-file
Dim ans As Integer, s$
s$ = Trim$(fnt.Name) + "," + Str$(fnt.Size)
s$ = s$ + "," + Str$(fnt.Bold) + "," + Str$(fnt.Italic)
stp.putProfile "Printer", ftype, s$

End Sub

Private Sub Class_Initialize()
Dim prn As Printer

'fd.dprint "initializing printer class"
pageDevice = stp.getProfile("Printer", "Printername", Printer.DeviceName)
pageDriver = stp.getProfile("Printer", "Driver", Printer.DriverName)
pagePort = stp.getProfile("Printer", "Port", Printer.port)
left_margin = val(stp.getProfile("Printer", "LeftMargin", "0.5")) * Twips_Per_Inch

'set default values in case there is no match
Set page_Printer = Printer

For Each prn In Printers
  If prn.DeviceName = pageDevice And prn.DriverName = pageDriver Then
    Set page_Printer = prn
    Set Printer = prn
  End If
Next prn

'fd.dprint "printer found:" + Printer.DeviceName + Printer.DriverName + Printer.port
Set Header_Font = read_font(stp.getProfile("Printer", "HeaderFont", Printer.Font.Name + ",10,0,0"))
'fd.dprint "header read" + Header_Font.Name
Set Subhead_font = read_font(stp.getProfile("Printer", "SubHeadFont", Printer.Font.Name + ",10,0,0"))
'fd.dprint "subhead read" + Subhead_font.Name
Set Page_Font = read_font(stp.getProfile("Printer", "PageFont", Printer.Font.Name + ",10,0,0"))

'fd.dprint "fonts read" + Page_Font.Name
'set default width and height - based on Lexmark 4039
On Local Error GoTo perr
pwidth = Printer.width - 800
pheight = Printer.height - 700
presume:
PAGE = 1
'fd.dprint "printer initialized"
ReDim colors(20) As Long
Exit Sub

perr:
 'fd.dprint "err=" + Str$(Err)
 pwidth = 11440
 pheight = 15140
 Resume presume
End Sub
Public Sub setDevice(device As String, driver As String, port As String)
Dim prn As Printer

pageDevice = device
pageDriver = driver
pagePort = port
'set default values in case there is no match
Set page_Printer = Printer

For Each prn In Printers
  If prn.DeviceName = pageDevice And prn.DriverName = pageDriver Then
    Set page_Printer = prn
    Set Printer = prn
  End If
Next prn

End Sub
Public Sub saveProfile()
stp.putProfile "Printer", "Printername", Printer.DeviceName
stp.putProfile "Printer", "Driver", Printer.DriverName
stp.putProfile "Printer", "Port", Printer.port
write_font_info "HeaderFont", Header_Font
write_font_info "SubheadFont", Subhead_font
write_font_info "PageFont", Page_Font
End Sub
Public Sub lPrint(s As String)
 Printer.Print s;
End Sub
Public Sub setLeftMargin(inches As Single)
left_margin = inches * Twips_Per_Inch
Call stp.putProfile("Printer", "LeftMargin", Str$(inches))
End Sub
Public Sub lPrintcr(s As String)
 testPage 1         'check for new page
 Printer.Print s
 setLeft
End Sub
Private Sub setLeft()
Printer.CurrentX = left_margin
End Sub
Public Sub rightAlign(template$, tx$)
Dim X As Integer, tw As Integer, w As Integer

'prints tx to right of column of width of template
X = Printer.CurrentX
tw = Printer.textWidth(template$)
w = Printer.textWidth(tx$)
If tw > w Then
  Printer.CurrentX = X + tw - w
End If
lPrint (tx$)
End Sub
Public Sub rightPrint(s$)
Dim w As Integer, tw As Integer
w = Printer.width
tw = Printer.textWidth(s$)
Printer.CurrentX = w - tw - 1000
Printer.Print s$
End Sub
Public Sub newPage()
Printer.newPage
PAGE = PAGE + 1
rightPrint "Page" + Str$(PAGE)
printHeader
Printer.CurrentX = left_margin
End Sub
Public Sub psett(X As Integer, Y As Integer, c As Integer)
setColorLine c
Printer.PSet (X, Y), colors(c)
End Sub
Public Sub pCircle(X As Integer, Y As Integer, w As Integer, c As Integer)
setColorLine c
Printer.Circle (X, Y), w, colors(c)
End Sub
Public Sub pLine(X As Integer, Y As Integer, c As Integer)
'note c is the index to the color
setColorLine c
Printer.Line -(X, Y), colors(c)
End Sub
Public Sub drawLine(x1 As Integer, y1 As Integer, x2 As Integer, y2 As Integer, c As Integer)
setColorLine c
Printer.Line (x1, y1)-(x2, y2), colors(c)
End Sub
Public Sub drawMarginLine(ByVal x1 As Integer, ByVal y1 As Integer, ByVal x2 As Integer, ByVal y2 As Integer)
x1 = x1 + left_margin
x2 = x2 + left_margin
Printer.Line (x1, y1)-(x2, y2)
End Sub
Public Sub setPageNum(n As Integer)
PAGE = n
End Sub
Public Sub endDoc()
Printer.endDoc
End Sub
Public Sub setLandscape()
 Printer.Orientation = vbPRORLandscape
 pwidth = Printer.width - 800
 pheight = Printer.height - 800

End Sub
Public Sub setPortrait()
 Printer.Orientation = vbPRORPortrait
 pwidth = Printer.width - 800
 pheight = Printer.height - 800

End Sub
Public Sub setBold()
 Printer.FontBold = True
End Sub
Public Sub setItalic()
  Printer.FontItalic = True
End Sub
Public Sub setUnderline()
  Printer.FontUnderline = True
End Sub
Public Sub setPlain()
 Printer.FontBold = False
 Printer.FontItalic = False
 Printer.FontUnderline = False
End Sub
Public Sub HLine()
Dim Y As Integer
Y = Printer.CurrentY
Printer.Line (0, Y)-(width, Y)
Printer.CurrentY = Y + 10
setLeft
End Sub
Public Sub Calibrate()
Dim sp As Integer, w As Integer, h As Integer
Dim xc As Integer, yc As Integer

'draws lines to determine actual borders of printable area
w = Printer.width
h = Printer.height
xc = w / 2 - 200
yc = h / 2 - 200
For sp = 0 To 1000 Step 100
  Printer.Line (xc, sp)-(xc + 400, sp)
  Printer.Line (xc, h - sp)-(xc + 400, h - sp)
  Printer.Line (sp, yc)-(sp, yc + 400)
  Printer.Line (w - sp, yc)-(w - sp, yc + 400)
Next sp
Printer.endDoc
End Sub
Public Function textWidth(s$) As Integer
textWidth = Printer.textWidth(s$)
End Function
Public Function textHeight(s$) As Integer
textHeight = Printer.textHeight(s$)
End Function
Public Sub vBar()
Dim cX As Long, cY As Long, h As Integer
h = Printer.textHeight("X")
cX = Printer.CurrentX
cY = Printer.CurrentY
 'draws vertical bar one line height
Printer.Line (cX, cY)-(cX, cY + h)
Printer.CurrentY = cY
Printer.CurrentX = cX + 5
End Sub
Public Sub uvBar()
Dim cX As Long, cY As Long, h As Integer
h = Printer.textHeight("X")
cX = Printer.CurrentX
cY = Printer.CurrentY
 'draws vertical bar one line height
Printer.Line (cX, cY)-(cX, cY - h)
Printer.CurrentY = cY
Printer.CurrentX = cX + 5
End Sub

Public Sub newLine()
   testPage 1         'check for new page
  Printer.Print
  setLeft
  
End Sub
Public Sub drawInchLine(fx As Single, fy As Single, px As Single, py As Single)
Dim X As Long, Y As Long

X = px * Twips_Per_Inch
Y = py * Twips_Per_Inch
Printer.Line (Printer.CurrentX, Printer.CurrentY)-(X, Y)

End Sub
Public Sub XYInch(px As Single, py As Single)
Dim X As Long, Y As Long

X = px * Twips_Per_Inch
Y = py * Twips_Per_Inch

Printer.CurrentX = X
Printer.CurrentY = Y
End Sub
Public Sub drawInchXLine(px As Single)
Dim X As Long
X = px * Twips_Per_Inch
Printer.Line (Printer.CurrentX, Printer.CurrentY)-(X, Printer.CurrentY)
End Sub
Public Sub drawLineHere(px As Long, py As Long)
 Dim oldx As Long, oldy As Long
 
 oldx = Printer.CurrentX
 oldy = Printer.CurrentY
 Printer.Line -(px, py)
End Sub
Public Function isLandscape() As Boolean
isLandscape = (Printer.Orientation = vbPRORLandscape)
End Function
Public Sub leftSide()
Printer.CurrentX = left_margin
End Sub
