VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Team"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private db As Database
Private rec As Recordset
Private f As Integer
Private opened As Boolean

Public Sub setDB(datab As Database)
Set db = datab
End Sub

Public Sub createTable(datab As Database)
Dim inx As New Indexer

Set db = datab
inx.makeTable db, "Teams"
inx.createKey "TeamKey"
inx.makeIndex "TeamKey", True
inx.createText "TeamCode", 10
inx.makeIndex "TeamCode", False
inx.createText "TeamShort", 20
inx.createText "TeamName", 35
inx.createText "LSC", 2
inx.createText "Coach", 25
inx.createText "Contact", 25
inx.createText "Address", 25
inx.createText "Address2", 25
inx.createText "Mailtown", 25
inx.createText "TeamTown", 25
inx.createText "MailState", 2
inx.createText "TeamState", 2
inx.createText "Zip", 12
inx.createText "Phone", 15
inx.createText "Fax", 15
inx.createText "Email", 30

inx.addTable
opened = False
End Sub
Public Sub importTeams(path$)
Dim s$, fld As Field
Dim fl As New file
'imports data from team list text file
Set rec = db.OpenRecordset("Teams", dbOpenTable)
f = FreeFile
fl.setFile path + "teamlist.dat"
If fl.exists Then
Open path + "teamlist.dat" For Input As #f
While Not EOF(f)
  rec.AddNew
  getLine rec![teamcode]
  getLine rec![Teamname]
  getLine rec![contact]
  getLine rec![coach]
  getLine rec![Phone]
  getLine rec![address]
  getLine rec![Address2]
  getLine rec![mailTown]
  getLine rec![teamTown]
  
  getLine rec![mailState]
  rec![teamState] = Left$(s$, 2)
  getLine rec![Zip]
  rec.update
  Line Input #f, s$       'asterisks
Wend
Close #f
End If
rec.Close
End Sub
Private Sub getLine(fld As Field)
Dim s$
Line Input #f, s$
fld = Left$(Trim$(s$), fld.Size)
End Sub
Public Sub openTable()
Dim qry$
If Not opened Then
   qry$ = "Select * from teams order by teams.teamcode"
    Set rec = db.OpenRecordset(qry, dbOpenDynaset)
    opened = True
End If
End Sub
Public Function getTeamKey(t$) As Long
openTable

rec.FindFirst "TeamCode=""" + Trim$(t$) + """"
If rec.NoMatch Then
  getTeamKey = 0
Else
  getTeamKey = rec![teamkey]
End If
End Function
Public Function getTeamName(tcode As String) As String
rec.FindFirst "TeamCode=""" + Trim$(tcode) + """"
If rec.NoMatch Then
  getTeamName = ""
Else
  getTeamName = rec![Teamname]
End If

End Function
Public Function getAddTeamKey(t$) As Long
Dim key As Long
key = getTeamKey(t$)
If key = 0 Then
  rec.AddNew
  rec![teamcode] = t$
  rec.update
  'rec.Bookmark = rec.LastUpdated
  rec.Bookmark = rec.LastModified
  key = rec![teamkey]
End If
getAddTeamKey = key
End Function
Public Sub MoveNext()
rec.MoveNext
End Sub
Public Function tmEOF() As Boolean
tmEOF = rec.EOF
End Function
Property Get teamcode() As String
teamcode = rec![teamcode]
End Property
Property Let teamcode(s$)
rec.Edit
rec![teamcode] = s$
rec.update
End Property
Property Get Teamname() As String
Teamname = rec![Teamname] & ""
End Property
Property Let Teamname(s$)
rec.Edit
rec![Teamname] = s$
rec.update
End Property

Property Get teamkey() As Long
teamkey = rec![teamkey]
End Property
Property Let teamkey(key As Long)
openTable
rec.FindFirst "Teamkey=" + Str$(key)
End Property

Public Sub closeRec()
If opened Then rec.Close
opened = False
End Sub
Public Function AddTeam(teamcode As String, Teamname$, shortName$, lsc$) As Integer
Dim key As Integer, found As Boolean
Dim f As Field, flds As Fields

Set flds = rec.Fields
Set f = flds("teamname")
'prevent duplicate entries
key = getTeamKey(teamcode)
If key > 0 Then
  found = (lsc$ = rec![lsc])
End If
If key = 0 Or ((key <> 0) And Not found) Then
openTable
rec.AddNew
rec![teamcode] = UCase$(teamcode)
rec![Teamname] = Left$(Teamname, f.Size)
Set f = flds("TeamShort")
rec![TeamShort] = Left(shortName, f.Size)
rec![lsc] = Left(UCase$(lsc), 2)
rec.update
rec.Bookmark = rec.LastModified
AddTeam = rec![teamkey]
Else
  AddTeam = key
End If
End Function
Public Sub moveFirst()
If opened Then rec.Close
opened = False
openTable
End Sub
Public Sub setAddress(add1$, Add2$, Town$, State$, Zip$)
rec.Edit
rec![address] = add1$
rec![Address2] = Add2$
rec![mailTown] = Town$
rec![teamTown] = Town$
rec![mailState] = Left$(Trim$(State$), 2)
rec![teamState] = rec![mailState]
rec![Zip] = Zip$
rec.update
End Sub
Public Sub setContact(cont$, coach$, Phone$, fax$, EMail$)
Dim f As Field, flds As Fields

Set flds = rec.Fields
rec.Edit
rec![contact] = cont$
Set f = flds("coach")

rec![coach] = Left$(coach$, f.Size)
rec![Phone] = Phone
rec![fax] = fax
rec![EMail] = EMail
rec.update
End Sub
Public Sub setTeamTown(tmtown$, tmstate$)
rec.Edit
rec![teamTown] = tmtown
rec![teamState] = Left$(Trim$(tmstate), 2)
rec.update
End Sub
Public Function add1() As String
add1 = rec![address] & ""
End Function
Public Function Add2() As String
Add2 = rec![Address2] & ""
End Function
Public Function mailTown() As String
mailTown = rec![mailTown] & ""
End Function
Public Function mailState() As String
mailState = rec![mailState] & ""
End Function
Public Function ZipCode() As String
ZipCode = rec![Zip] & ""
End Function
Public Function Phone() As String
Phone = rec![Phone] & ""
End Function
Public Function fax() As String
fax = rec![fax] & ""
End Function
Public Function EMail() As String
EMail = rec![EMail] & ""
End Function
Property Get shortName() As String
shortName = rec![TeamShort] & ""
End Property
Property Let shortName(s$)
rec.Edit
rec![TeamShort] = s$
rec.update
End Property
Public Function coachName() As String
Dim ch$
ch$ = rec![coach] & ""
If Len(ch$) = 0 Then
  ch$ = "the coach"
End If
coachName = ch
End Function
Public Function teamTown() As String
teamTown = rec![teamTown] & ""
End Function
Public Function teamState() As String
teamState = rec![teamState] & ""
End Function
Property Get lsc() As String
lsc = rec![lsc] & ""
End Property
Property Let lsc(s$)
rec.Edit
rec![lsc] = UCase$(Left$(s$, 2))
rec.update
End Property
Public Function contact() As String
contact = rec![contact] & ""
End Function
Public Sub DeleteTeam(teamkey As Integer)
rec.FindFirst "TeamKey=" + Str$(teamkey)
If Not rec.NoMatch Then
  rec.delete
End If
End Sub
Public Sub printClubs(pr As clsPrinters)
Dim query$, rec As Recordset
query$ = "SELECT Teams.TeamCode, Teams.TeamName, Teams.TeamTown, Teams.TeamState " & _
"From Teams ORDER BY Teams.TeamCode;"
Set rec = db.OpenRecordset(query, dbOpenDynaset)
pr.setHeaderFont
pr.Centerit "Participating Clubs"
pr.newLine
pr.setPageFont
While Not rec.EOF
  pr.lPrint rec![teamcode] & ""
  pr.Tabbit 10
  pr.lPrint rec![Teamname] & ""
  pr.Tabbit 40
  pr.lPrint rec![teamTown] & ", "
  pr.lPrintcr rec![teamState] & ""
  rec.MoveNext
Wend
rec.Close
pr.endDoc
End Sub
Public Sub printPhoneList(pr As clsPrinters)
Dim query$, rec As Recordset
query$ = "SELECT Teams.TeamCode, Teams.TeamName, Teams.TeamTown, Teams.phone, Teams.TeamState " & _
"From Teams ORDER BY Teams.TeamCode;"
Set rec = db.OpenRecordset(query, dbOpenDynaset)
pr.setHeaderFont
pr.Centerit "Participating Clubs"
pr.newLine
pr.setPageFont
While Not rec.EOF
  pr.lPrint rec![teamcode] & ""
  pr.Tabbit 10
  pr.lPrint rec![Teamname] & ""
  pr.Tabbit 40
  pr.lPrint rec![Phone]
  pr.Tabbit 55
  pr.lPrint rec![teamTown] & ", "
  pr.lPrintcr rec![teamState] & ""
  rec.MoveNext
Wend
rec.Close
pr.endDoc

End Sub

Public Sub ClubsToClipboard()
Dim query$, rec As Recordset
Dim tb$, cr$, clip$
tb$ = Chr$(9)
cr$ = Chr$(13) + Chr$(10)
clip$ = ""

query$ = "SELECT Teams.TeamCode, Teams.TeamName, Teams.TeamTown, Teams.TeamState " & _
"From Teams ORDER BY Teams.TeamCode;"
Set rec = db.OpenRecordset(query, dbOpenDynaset)
While Not rec.EOF
  clip = clip + rec![teamcode] & tb$
  clip = clip + rec![Teamname] & tb$
    clip = clip + rec![teamTown] & ", "
  clip = clip + rec![teamState] & cr$
  rec.MoveNext
Wend
rec.Close
Clipboard.clear
Clipboard.setText clip$
End Sub

