VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Scoring"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private db As Database
Private rec As Recordset
Private vec As Collection
Private grid As TDBGrid
Private evnum As Integer
Private pr As New clsPrinters
Private ev As New Events
Private fRec As Recordset, mrec As Recordset, srec As Recordset
Private svec As Collection
Private two_based_results As Boolean
Private three_based_results As Boolean
Private tm As times
Private dtm As New DTimes
Private mt As New Meet
Private stp As New SetupData
Private splts As New splits
Private dosplits As Boolean
Private recrds As New records
Private recCol As Collection
Private strk As New stroke
Private team_list() As String   'array of teams counted for sweep prevention
Private team_counts() As Integer 'array of team counts
Private team_max As Integer     'max dimension of above 2 arrays
Private teamCount As Integer    'total teams in array at the moment
Private maxSweep As Integer     'number of places allowed for a single team
Private rela As New RelayNames
Private rnames As Collection
Private sKids As Collection
Private agfile As file
Private alist As AgeGroupList
Const INDIV_SCORE = 1
Const RELAY_SCORE = 2

Public Sub setDB(datab As Database)
Set db = datab
mt.setDB db
ev.setDB db
splts.setDB db
recrds.setDB db
rela.setDB db
End Sub
Public Sub setGrid(grd As TDBGrid)
Set grid = grd
End Sub
Public Sub createTable(datab As Database)
Dim inx As New Indexer
Dim place As Integer
setDB datab

inx.makeTable db, "Scoring"
inx.createKey "ScoringKey"
inx.createInteger "Place"
inx.createInteger "ScoreType"
inx.createSingle "Points"
inx.createInteger "ScoreNameKey"
inx.makeIndex "ScoringKey", True
inx.makeIndex "Place", False

inx.addTable
inx.makeTable db, "ScoresType"
inx.createKey "ScoresTypeKey"

inx.createText "ScoreTypeName", 20
inx.makeIndex "ScoresTypeKey", True

inx.addTable

'openTable
Set rec = db.OpenRecordset("ScoresType", dbOpenTable)
rec.AddNew
rec![ScoreTypeName] = "Individual"
rec.update
rec.AddNew
rec![ScoreTypeName] = "Relay"
rec.update
rec.Close
makeScoreNames
End Sub
Private Sub openTable()
Set rec = db.OpenRecordset("Scoring", dbOpenTable)
End Sub
Public Sub import(path$)
Dim prf As New Profile
Dim tk As New Tokenizer
Dim place As Integer
Dim stp As New SetupData
Dim s$, sc$

openTable
'import from meet5 ini-file

prf.setFilename path$ + "Meet5.ini"
s$ = prf.getProfile("Score", "Scores", "")
tk.setString s$
place = 1
sc$ = tk.nextToken
While sc$ <> ""
  rec.AddNew
  rec![points] = val(sc$)
  rec![scoreType] = INDIV_SCORE       'individual score type
  rec![place] = place
  sc$ = tk.nextToken
  place = place + 1
  rec.update
Wend

s$ = prf.getProfile("Score", "RelayScores", "")
tk.setString s$
place = 1
sc$ = tk.nextToken
While sc$ <> ""
  rec.AddNew
  rec![points] = val(sc$)
  rec![scoreType] = RELAY_SCORE       'relay score type
  rec![place] = place
  sc$ = tk.nextToken
  place = place + 1
  rec.update
Wend


End Sub
Public Function getIndividualScores(scoreClass As Integer) As Collection
Set getIndividualScores = get_individual_Scores(scoreClass)
rec.Close
End Function
Private Function get_individual_Scores(scoreClass As Integer) As Collection
Dim qry$, pt As Single
qry$ = "SELECT * From Scoring Where (((Scoring.ScoreType) = 1)) AND (Scoring.ScoreNameKey=" + Str$(scoreClass) + ") ORDER BY Scoring.ScoringKey;"
Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
Set vec = New Collection
While Not rec.EOF
  pt = rec![points]
  vec.add pt
  rec.moveNext
Wend
Set get_individual_Scores = vec

End Function
Public Function getRelayScores(scoreClass As Integer) As Collection
Set getRelayScores = get_Relay_Scores(scoreClass)
rec.Close
End Function
Private Function get_Relay_Scores(scoreClass As Integer) As Collection
Dim qry$, pt As Single
qry$ = "SELECT * From Scoring Where (((Scoring.ScoreType) = 2)) and(Scoring.ScoreNameKey=" + Str$(scoreClass) + " )ORDER BY Scoring.ScoringKey;"

Set rec = db.OpenRecordset(qry$, dbOpenDynaset)
Set vec = New Collection
While Not rec.EOF
  pt = rec![points]
  vec.add pt
  rec.moveNext
Wend
Set get_Relay_Scores = vec

End Function
Public Sub putIndividualScores(indScore As Collection, scoreClass As Integer)
Dim i As Integer

get_individual_Scores scoreClass
If Not rec.BOF Then
rec.moveFirst
While Not rec.EOF
  rec.delete
  rec.moveNext
Wend
End If
For i = 1 To indScore.count
 rec.AddNew
 rec![points] = indScore(i)
 rec![place] = i
 rec![scoreType] = INDIV_SCORE
 rec![Scorenamekey] = scoreClass
 rec.update
Next i
rec.Close
End Sub
Public Sub putRelayScores(relScore As Collection, scoreClass As Integer)
Dim i As Integer

get_Relay_Scores scoreClass
If Not rec.BOF Then rec.moveFirst
While Not rec.EOF
  rec.delete
  rec.moveNext
Wend
For i = 1 To relScore.count
 rec.AddNew
 rec![points] = relScore(i)
 rec![place] = i
 rec![scoreType] = RELAY_SCORE
 rec![Scorenamekey] = scoreClass
 rec.update
Next i
rec.Close
End Sub
Public Sub doScoring(ev_num As Integer, doScore As Boolean)
Dim scr As String
Dim level As Integer

scr = stp.getScoreLevel
Select Case scr
  Case "Single"
    level = 1
  Case "TwoLevel"
    level = 2
  Case "ThreeLevel"
    level = 3
  Case "TwoFlights"
    level = 4
End Select

evnum = ev_num
 ev.getEvent (evnum)

If level = 1 Then
  singleScore doScore
End If
If level = 2 Then
  twoLevScore
End If
If level = 3 Then
  threeLevScore
End If
If level = 4 Then   'two flights
'  twoflightscore
End If

End Sub
Public Sub printSwimoff(ev_num As Integer, copies As Integer)
Dim evnum As Integer, query$, c As Integer

evnum = ev_num
 ev.getEvent (evnum)
For c = 1 To copies
pr.setHeaderFont
pr.lPrintcr "Event:" + Str$(evnum) + " --" + ev.getEventString(False)
printRecords evnum
pr.setSubHeadFont
ev.setEventKey evnum
dtm.setStrokeKey ev.strokeKey   'diving printed without colons
pr.lPrintcr "Results of Swimoff"
query$ = "SELECT Swimmer.Frname, Swimmer.attached, results.resultKey, Results.DQ, Swimmer.Lname, Swimmer.AgeClass,Results.Result, Results.Backup, Entry.Points, Teams.TeamCode " & _
"FROM (Swimmer INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 4) And ((Entry.EventKey) = " + Str$(evnum) + ") AND ((Entry.Unofficial)=False)) "

    ev.setEventKey evnum
    query = query + "ORDER BY Results.DQ DESC , Results.Result;"
    Set fRec = db.OpenRecordset(query$, dbOpenDynaset)
   printGroup fRec, "", True
  pr.newPage
Next c
pr.endDoc
End Sub
Public Sub printPrelimResults(ev_num As Integer, copies As Integer, do_splits As Boolean, byAge As Boolean)
Dim scr As String, cap1 As String, cap2 As String, cap3 As String
Dim level As Integer, c As Integer


dosplits = do_splits
If byAge Then
  printPrelimsByAge ev_num, copies, do_splits
Else
scr = stp.getScoreLevel
Select Case scr
  Case "Single"
    level = 1
  Case "TwoLevel"
    level = 2
  Case "ThreeLevel"
    level = 3
  Case "TwoFlights"
    level = 4
End Select
 cap1 = stp.getScoreGroupName(1)
 cap2 = stp.getScoreGroupName(2)
 cap3 = stp.getScoreGroupName(3)

evnum = ev_num
 ev.getEvent (evnum)
 
For c = 1 To copies
pr.setHeaderFont
pr.lPrintcr "Event:" + ev.getEventLabel + " --" + ev.getEventString(False)
printRecords evnum
pr.setSubHeadFont
ev.setEventKey evnum
dtm.setStrokeKey ev.strokeKey   'diving printed without colons
pr.lPrintcr "Preliminary/Timed Final Results"
If level = 1 Then
  singleScore (Not ev.final And ev.Scoring)
  'If Not ev.final And ev.Scoring Then
  printGroup fRec, "", dosplits
  pr.newPage
  'End If
End If
If level = 2 Then
  twoLevScore
  printGroup fRec, cap1, dosplits
  printGroup srec, cap2, dosplits
  pr.newPage

End If
If level = 3 Then
  threeLevScore
  printGroup fRec, cap1, dosplits
  printGroup mrec, cap2, dosplits
  printGroup srec, cap3, dosplits
  pr.newPage

End If
If level = 4 Then   'two flights
'  twoflightscore
End If
Next c
pr.endDoc
End If
End Sub
Private Sub printPrelimsByAge(evnum As Integer, ncopies As Integer, dosplits As Boolean)
Dim query As String
Dim rec As Recordset
Dim c As Integer, a As Integer
Dim minage As Integer, maxage As Integer
Dim agrp As AgeGroup
Dim sex$
Dim ageList As Collection

ev.setEventKey evnum

For c = 1 To ncopies
'pr.setSubHeadFont
'pr.lPrintcr ""
'pr.lPrintcr header$



    pr.setHeaderFont
    pr.lPrintcr "Event:" + Str$(evnum) + " --" + ev.getEventString(False)
    printRecords evnum
    pr.setSubHeadFont
    ev.setEventKey evnum
    dtm.setStrokeKey ev.strokeKey   'diving printed without colons
    pr.lPrintcr "Preliminary/Timed Final Results"
    pr.setPageFont
    sex$ = "F"
    If ev.isRelay(evnum) Then
      Set ageList = alist.getRelayAges
     Else
       Set ageList = alist.getIndivAges
     End If
    
    Do
    For a = 1 To ageList.count
      Set agrp = ageList(a)
      query = "SELECT Entry.EventKey, Swimmer.Frname, Swimmer.Attached, Teams.TeamCode, Swimmer.Lname, Swimmer.Sex, Swimmer.AgeClass,  Results.resultkey, Results.Result, Results.DQ, Results.Scratch, Entry.Points " & _
    "FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
    "Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((Swimmer.sex) = """ + sex$ + """) And ((Swimmer.ageclass) >= " + Str$(agrp.minage) + " And (Swimmer.ageclass) <= " + Str$(agrp.maxage) + ")  And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1)) " & _
    "ORDER BY Swimmer.Sex, Results.Result, Results.DQ DESC;"

    Set rec = db.OpenRecordset(query, dbOpenDynaset)
    printAgeGroup rec, "", dosplits, agrp.minage, agrp.maxage
    rec.Close
    Next a
    If sex$ = "M" Then sex$ = "Q"
    If sex$ = "F" Then sex = "M"
    Loop Until sex = "Q"
    pr.newPage
'    rec.Close
  Next c

pr.endDoc

End Sub
Public Sub printFinalResults(evnum As Integer, copies As Integer, do_splits As Boolean)
Dim qry$, qryd$, pnts$, Lanes As Integer, nm$
Dim svec As Collection
Dim heat As Integer, i As Integer, j As Integer, c As Integer, s As Integer
Dim done As Boolean
Dim lastresult As Single
Dim col As Collection

ev.setEventKey evnum

qry$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Seeding.Heat, Results.DQ, Results.Result, Results.resultkey, Entry.EventKey, Results.Scratch, Entry.Points, Seeding.Lane " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Seeding.heat) > 0) And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((Seeding.lane) <= 10) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Seeding.Heat DESC , Results.DQ DESC , Results.Result;"

qry$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Seeding.Heat, Results.place, Results.DQ, Results.Result, Results.ResultKey, Entry.EventKey, Entry.Points, Seeding.Lane, Results.Scratch " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Seeding.heat) > 0) And ((Entry.eventkey) = " + Str$(evnum) + ") And ((Seeding.lane) <= 10) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Seeding.Heat DESC , Results.DQ DESC , Results.Scratch DESC, Results.Result;"


If ev.strokeKey = strk.getDiving Then
qry$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Seeding.Heat,Results.place, Results.DQ, Results.Result, Results.ResultKey, Entry.EventKey, Results.Scratch, Entry.Points " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Results.DQ DESC , Results.Result DESC;"
End If


Set fRec = db.OpenRecordset(qry$, dbOpenDynaset)
If ev.isRelay(evnum) Then
  Set svec = getRelayScores(ev.getScoreClass)
Else
    Set svec = getIndividualScores(ev.getScoreClass)
End If
Lanes = stp.getLanes
heat = stp.Finalheats
i = 1
j = 1
While Not fRec.EOF
  fRec.Edit
  fRec![points] = 0
  fRec.update
  fRec.moveNext
Wend
fRec.moveFirst

While Not fRec.EOF
 If fRec![heat] = heat And Not fRec![DQ] And Not fRec![SCRATCH] Then
   If i <= svec.count Then
    fRec.Edit
    fRec![points] = svec(i)
    fRec![place] = i
    fRec.update
   End If
 End If
 fRec.moveNext
 i = i + 1
 j = j + 1
 If Not fRec.EOF Then
   If fRec![heat] <> heat Then
     heat = fRec![heat]
   End If
 End If
  If j > Lanes Then
   j = 1
   'heat = heat - 1
   i = (stp.Finalheats - heat) * Lanes + 1
 End If

Wend
'Rescore if diving
 If ev.strokeKey = strk.getDiving Then
    scoreDiving fRec, svec, evnum
  Else
   'check for ties and pervert the scoring accoringly
  tieFinalRecs (evnum)
End If
'now print out results
If ev.strokeKey = strk.getDiving Then
  printDivingFinal evnum, fRec, copies
Else
For c = 1 To copies
pr.setHeaderFont
ev.getEvent (evnum)
pr.Centerit "Final Results - Event: " + Str$(evnum) + " " + ev.getEventString(False)
printRecords evnum
'pr.newLine
pr.setPageFont
fRec.moveFirst

heat = stp.Finalheats
i = 1
lastresult = 0
While heat > 0 And Not fRec.EOF
  nm$ = stp.getFinalHeatName(heat)
  pr.setSubHeadFont
  pr.newLine
  pr.lPrintcr nm$
  pr.setPageFont
  done = fRec.EOF
  If Not done Then
    done = fRec![heat] <> heat
  End If
 While Not done
  If Not fRec![SCRATCH] Then
  If Not fRec![DQ] Then
   If lastresult <> fRec![result] Then
      pr.lPrint Format$(i, "### ")
    Else
      pr.lPrint "Tie"
    End If
  End If
  lastresult = fRec![result]
  pr.Tabbit 4
  'pr.lPrint recrds.getRecChar(fRec![result])
  pr.Tabbit 5
  pr.lPrint fRec![Frname] + " " + fRec![Lname]
  pr.Tabbit 30
  pr.lPrint getTeamCode(fRec) 'fRec![teamcode]
  pr.Tabbit 40
  
  If Not fRec![DQ] Then
    tm.setSingle fRec![result]
    pr.lPrint tm.getFormatted
  Else
    pr.lPrint "DQ"
  End If
  pr.Tabbit 50
  If (fRec![points] > 0) Then pr.lPrint Str$(fRec![points])
  pr.lPrintcr ""
  If do_splits And Not fRec![DQ] Then
    Set col = splts.getSplits(fRec![resultKey])
    pr.Tabbit 7
    For s = 1 To col.count
      tm.setSingle col(s)
      pr.lPrint tm.getFormatted + " "
      If (s \ 4) * 4 = s Then
        If s < col.count Then pr.lPrintcr ""
        If s < col.count Then
            pr.Tabbit 7
        End If
      End If
    Next s
    If col.count > 0 Then pr.lPrintcr ""
End If
    If ev.isRelay(evnum) Then 'print relay names
   Set rnames = rela.getRelayNameAges(fRec![resultKey])
   If rnames.count > 0 Then
    pr.Tabbit 7
    End If
   For j = 1 To rnames.count
     pr.lPrint rnames(j)
     Select Case j
       Case 1, 3
         pr.lPrint ", "
       Case 2
         pr.lPrintcr ","
         pr.Tabbit 7
       Case 4
         pr.lPrintcr ""
     End Select
   Next j
   'If rnames.count = 0 Then
   '  pr.lPrintcr ""
'End If
  End If
End If
  fRec.moveNext
  i = i + 1
  done = fRec.EOF
  If Not done Then
    done = fRec![heat] <> heat
  End If

 Wend
 heat = heat - 1
 i = (stp.Finalheats - heat) * Lanes + 1
 lastresult = 0

Wend
pr.newPage
Next c
End If
fRec.Close
pr.endDoc
End Sub
Private Sub scoreDiving(fRec As Recordset, svec As Collection, evnum As Integer)
 scoreRec fRec, svec, evnum, True
End Sub
Private Sub printDivingFinal(evnum As Integer, fRec As Recordset, copies As Integer)
Dim tm As times
Dim dtm As New DTimes
Dim c As Integer, i As Integer
Dim lastresult As Single

Set tm = dtm
dtm.setStrokeKey strk.getDiving
For c = 1 To copies
pr.setHeaderFont
ev.getEvent (evnum)
pr.Centerit "Final Results - Event: " + Str$(evnum) + " " + ev.getEventString(False)
printRecords evnum
'pr.newLine
pr.setPageFont
fRec.moveFirst

i = 1
lastresult = 0
While Not fRec.EOF
  
  pr.setPageFont
   
   If Not fRec![DQ] Then
   If lastresult <> fRec![result] Then
      pr.lPrint Format$(i, "### ")
    Else
      pr.lPrint "Tie"
    End If
  End If
  lastresult = fRec![result]
  pr.Tabbit 4
  pr.Tabbit 5
  pr.lPrint fRec![Frname] + " " + fRec![Lname]
  pr.Tabbit 30
  pr.lPrint getTeamCode(fRec) 'fRec![teamcode]
  pr.Tabbit 40
  
  If Not fRec![DQ] Then
    tm.setSingle fRec![result]
    pr.lPrint tm.getFormatted
  Else
    pr.lPrint "DQ"
  End If
  pr.Tabbit 50
  If (fRec![points] > 0) Then pr.lPrint Str$(fRec![points])
  pr.lPrintcr ""
  
  fRec.moveNext
  i = i + 1
  
  

 
Wend
pr.newPage
Next c

End Sub
Private Sub singleScore(doScore As Boolean)
Dim query$

'If doScore Then
query$ = "SELECT Swimmer.Frname, Swimmer.attached, results.resultKey, Results.DQ, results.place, Swimmer.Lname, Swimmer.AgeClass,Results.Result, Results.Backup, Entry.Points, Teams.TeamCode " & _
"FROM (Swimmer INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2) And ((Entry.EventKey) = " + Str$(evnum) + ") AND ((Entry.Unofficial)=False)) "

query$ = "SELECT Swimmer.Frname, Swimmer.Attached, Results.ResultKey, Results.DQ, Results.Place, Swimmer.Lname, Swimmer.AgeClass, Results.Result, Results.Backup, Entry.Points, Teams.TeamCode, Seeding.Heat, Seeding.Lane " & _
"FROM ((Swimmer INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"Where (((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2) And ((Entry.eventkey) = " + Str$(evnum) + ") And ((Entry.unofficial) = False) And ((Seeding.heat) > 0) And ((Seeding.lane) > 0)) "
'"ORDER BY Results.DQ DESC , Results.Result;"


ev.setEventKey evnum
If ev.strokeKey <> strk.getDiving Then
    query = query + "ORDER BY Results.DQ DESC , Results.Result;"
Else
    query = query + "ORDER BY Results.DQ DESC , Results.Result DESC;"
End If

If ev.final And doScore Then
query$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached, results.place, Teams.TeamCode, Seeding.Heat, Results.DQ, Results.Result, Results.resultkey, Entry.EventKey, Results.Scratch, Entry.Points, Seeding.Lane " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Seeding.heat) > 0) And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((Seeding.lane) <= 10) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Seeding.Heat DESC , Results.DQ DESC , Results.Result;"

 If ev.strokeKey = strk.getDiving Then
  query$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached,results.place,  Teams.TeamCode, Seeding.Heat, Results.DQ, Results.Result, Results.ResultKey, Entry.EventKey, Results.Scratch, Entry.Points " & _
  "FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
  "Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 3)) " & _
  "ORDER BY Results.DQ DESC , Results.Result DESC;"
 End If
End If

If ev.final And doScore Then
  scoreFinal query
Else
 Set fRec = db.OpenRecordset(query$, dbOpenDynaset)
  ev.setEventKey evnum
 getScores evnum
 scoreRec fRec, svec, evnum, doScore
End If
'End If
End Sub
Private Sub getScores(evnum As Integer)
If ev.isRelay(evnum) Then
    Set svec = getRelayScores(ev.getScoreClass)
Else
    Set svec = getIndividualScores(ev.getScoreClass)
End If
End Sub
Private Sub twoLevScore()
Dim fastq$, slowq$
If two_based_results Then
fastq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname,Swimmer.AgeClass,results.place,  Swimmer.Attached, Teams.TeamCode, Results.Result, Results.Scratch, results.DQ, results.resultKey, Entry.points " & _
"FROM Events INNER JOIN ((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) ON Events.EventKey = Entry.EventKey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((RESULTS.result) < [Events].[slowcut]) And ((RESULTS.SCRATCH) = False) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.Result;"

slowq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname,Swimmer.AgeClass,results.place,  Swimmer.Attached, Teams.TeamCode, Results.Result, Results.Scratch, results.resultKey, results.DQ, Entry.points " & _
"FROM Events INNER JOIN ((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) ON Events.EventKey = Entry.EventKey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((RESULTS.result) >= [Events].[slowcut]) And ((RESULTS.SCRATCH) = False) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.Result;"
Else

fastq$ = "SELECT Events.EventKey, results.resultKey, Swimmer.Frname, Swimmer.Lname, results.place, Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Results.Result, Results.Scratch, Results.DQ, Entry.points, Entry.SeedTime " & _
"FROM Events INNER JOIN ((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) ON Events.EventKey = Entry.EventKey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.seedTime) < [Events].[slowcut]) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.DQ DESC ,Results.Result;"

slowq$ = "SELECT Events.EventKey, results.resultKey, Swimmer.Frname, Swimmer.Lname,results.place,  Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Results.Result, Results.Scratch, Results.DQ, Entry.points, Entry.SeedTime " & _
"FROM Events INNER JOIN ((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) ON Events.EventKey = Entry.EventKey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.seedTime) >= [Events].[slowcut]) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.DQ DESC ,Results.Result;"

End If

Set fRec = db.OpenRecordset(fastq$, dbOpenDynaset)
Set srec = db.OpenRecordset(slowq$, dbOpenDynaset)

ev.setEventKey evnum
getScores evnum
scoreRec fRec, svec, evnum, True
scoreRec srec, svec, evnum, True


End Sub
Private Sub threeLevScore()
Dim fastq$, midq$, slowq$
Dim i As Integer

If three_based_results Then
fastq$ = "SELECT Events.EventKey, Swimmer.Frname, results.resultKey, Swimmer.Lname, Swimmer.AgeClass,Teams.TeamCode, Results.Result, Results.DQ,results.place,  Events.FastCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Events.EventKey)=" + Str$(evnum) + ") AND ((Results.Result)<[events].[fastcut]) AND ((Entry.Unofficial)=False)) ORDER BY Results.Result;"

midq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass,Teams.TeamCode, Results.Result, Results.DQ, results.resultKey, results.place, Events.FastCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((RESULTS.result) >= [Events].[fastcut] And (RESULTS.result) <= [Events].[slowcut]) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.Result;"

slowq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Teams.TeamCode, Results.Result, Results.DQ, results.resultKey, results.place, Events.FastCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Events.EventKey) =" + Str$(evnum) + " ) And ((RESULTS.result) > [Events].[slowcut] And (RESULTS.result) < 10000) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.Result; "


Else
fastq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass,results.place,  Teams.TeamCode, Results.result, results.resultKey, Results.DQ,  Events.FastCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Events.EventKey)=" + Str$(evnum) + ") AND ((entry.seedtime)<[events].[fastcut]) AND ((Entry.Unofficial)=False)) ORDER BY Results.Result;"

midq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, results.place, Teams.TeamCode, Results.result, results.resultKey,   Results.DQ, Events.FastCut, Events.SlowCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Events.EventKey) = " + Str$(evnum) + ") And ((Entry.seedTime) > [Events].[fastcut] And (Entry.seedTime) <= [Events].[slowcut]) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.DQ DESC ,Results.result;"

slowq$ = "SELECT Events.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, results.place, Teams.TeamCode, Results.result, results.resultKey, Results.DQ, Events.FastCut, Entry.points " & _
"FROM (((Events INNER JOIN Entry ON Events.EventKey = Entry.EventKey) INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Events.EventKey) =" + Str$(evnum) + " ) And ((Entry.seedtime) > [Events].[slowcut] And (RESULTS.result) < 10000) AND ((Entry.Unofficial)=False)) " & _
"ORDER BY Results.DQ DESC ,Results.Result; "

End If
Set fRec = db.OpenRecordset(fastq$, dbOpenDynaset)
Set mrec = db.OpenRecordset(midq$, dbOpenDynaset)
Set srec = db.OpenRecordset(slowq$, dbOpenDynaset)
ev.setEventKey evnum
getScores evnum

scoreRec fRec, svec, evnum, True
scoreRec mrec, svec, evnum, True
scoreRec srec, svec, evnum, True

End Sub
Private Sub printGroup(rec As Recordset, header$, dosplits As Boolean)
Dim i As Integer, j As Integer, col As Collection, s As Integer, oldTime As Single
Dim lastresult As Single, place As Integer

Set rnames = Nothing
Set rnames = New Collection
pr.setSubHeadFont
pr.lPrintcr ""
pr.lPrintcr header$
pr.setPageFont
i = 1
If Not rec.BOF Then rec.moveFirst
oldTime = 0
While Not rec.EOF
 If rec![result] = oldTime And rec![result] <> tm.NT And Not rec![DQ] Then
   place = i - 1
   pr.lPrint "Tie "
 Else
  place = i
  pr.lPrint Format$(i, "### ")
  End If
  rec.Edit
  rec![place] = place
  rec.update
  pr.Tabbit 4
  If Not rec![DQ] Then pr.lPrint recrds.getThisRecChar(rec![result])
  pr.Tabbit 5
  pr.lPrint rec![Frname] + " " + rec![Lname] + " "
  If Not ev.isRelay(evnum) Then
    pr.lPrint Str$(rec![ageclass])
  End If
  pr.Tabbit 33
  pr.lPrint getTeamCode(rec) 'rec![teamcode]
  pr.Tabbit 43
  
  If Not rec![DQ] Then
    tm.setSingle rec![result]
    
    pr.lPrint tm.getFormatted
  Else
    pr.lPrint "DQ"
  End If
  pr.Tabbit 53
  If rec![points] > 0 And Not ev.final Then
     pr.lPrint Str$(rec![points])
  End If
  'flag possible swimoffs
  If ev.Finalheats > 1 Then
   If ev.final And rec![result] = oldTime And i = (stp.getLanes + 1) Then
    pr.Tabbit 60
    pr.lPrint "Possible swimoff"
   End If

  End If
  If ev.Finalheats > 2 Then
   If ev.final And rec![result] = oldTime And i = (2 * stp.getLanes + 1) Then
    pr.Tabbit 60
    pr.lPrint "Possible swimoff"
   End If
   If Not rec![DQ] Then oldTime = rec![result]
  End If
  i = i + 1
  pr.lPrintcr ""
  If dosplits Then
    Set col = splts.getSplits(rec![resultKey])
    pr.Tabbit 7
    For s = 1 To col.count
      tm.setSingle col(s)
      pr.lPrint tm.getFormatted + " "
      If (s \ 4) * 4 = s Then
        If s < col.count Then pr.lPrintcr ""
        If s < col.count Then
            pr.Tabbit 7
        End If
      End If
    Next s
    If col.count > 0 Then pr.lPrintcr ""
  End If
   If ev.isRelay(evnum) Then 'print relay names
   Set rnames = rela.getRelayNameAges(rec![resultKey])
   If rnames.count > 0 Then
        pr.Tabbit 8
   End If
   For j = 1 To rnames.count
     pr.lPrint rnames(j)
     Select Case j
       Case 1, 3
         pr.lPrint ", "
       Case 2
         pr.lPrintcr ","
         pr.Tabbit 8
       Case 4
         pr.lPrintcr ""
     End Select
   Next j
  End If
  If Not rec![DQ] Then
    oldTime = rec![result]
  End If
  rec.moveNext
Wend
pr.newLine
End Sub
Private Sub printAgeGroup(rec As Recordset, header$, dosplits As Boolean, minage As Integer, maxage As Integer)
Dim i As Integer, j As Integer, col As Collection, s As Integer, oldTime As Single
Dim lastresult As Single
Dim printed As Boolean, Quit As Boolean

printed = False
Set rnames = Nothing
Set rnames = New Collection
Quit = rec.EOF
If Not Quit Then
  Quit = rec![ageclass] > maxage
End If
If Not Quit Then
  pr.lPrintcr Str$(minage) + " - " + Str$(maxage)
End If
i = 1
'If Not rec.BOF Then rec.moveFirst
oldTime = 0

  While Not Quit
  printed = True
 If rec![result] = oldTime And rec![result] <> tm.NT And Not rec![DQ] Then
   pr.lPrint "Tie "
 Else
  pr.lPrint Format$(i, "### ")
  End If
  
  pr.Tabbit 4
  If Not rec![DQ] Then pr.lPrint recrds.getThisRecChar(rec![result])
  pr.Tabbit 5
  pr.lPrint rec![Frname] + " " + rec![Lname] + " "
  If Not ev.isRelay(evnum) Then
    pr.lPrint Str$(rec![ageclass])
  End If
  pr.Tabbit 33
  pr.lPrint getTeamCode(rec) 'rec![teamcode]
  pr.Tabbit 43
  
  If Not rec![DQ] Then
    tm.setSingle rec![result]
    
    pr.lPrint tm.getFormatted
  Else
    pr.lPrint "DQ"
  End If
  pr.Tabbit 53
  If rec![points] > 0 And Not ev.final Then
     pr.lPrint Str$(rec![points])
  End If
  'flag possible swimoffs
  If ev.Finalheats > 1 Then
   If ev.final And rec![result] = oldTime And i = (stp.getLanes + 1) Then
    pr.Tabbit 60
    pr.lPrint "Possible swimoff"
   End If

  End If
  If ev.Finalheats > 2 Then
   If ev.final And rec![result] = oldTime And i = (2 * stp.getLanes + 1) Then
    pr.Tabbit 60
    pr.lPrint "Possible swimoff"
   End If
   If Not rec![DQ] Then oldTime = rec![result]
  End If
  i = i + 1
  pr.lPrintcr ""
  If dosplits Then
    Set col = splts.getSplits(rec![resultKey])
    pr.Tabbit 3
    For s = 1 To col.count
      tm.setSingle col(s)
      pr.lPrint tm.getFormatted + " "
      If (s \ 4) * 4 = s Then
        If s < col.count Then pr.lPrintcr ""
        If s < col.count Then
            pr.Tabbit 3
        End If
      End If
    Next s
    If col.count > 0 Then pr.lPrintcr ""
  End If
   If ev.isRelay(evnum) Then 'print relay names
   Set rnames = rela.getRelayNames(rec![resultKey])
   If rnames.count > 0 Then
        pr.Tabbit 4
   End If
   For j = 1 To rnames.count
     pr.lPrint rnames(j)
     Select Case j
       Case 1, 3
         pr.lPrint ", "
       Case 2
         pr.lPrintcr ","
         pr.Tabbit 4
       Case 4
         pr.lPrintcr ""
     End Select
   Next j
  End If
  If Not rec![DQ] Then
    oldTime = rec![result]
  End If
  rec.moveNext
  Quit = rec.EOF
If Not Quit Then
  Quit = rec![ageclass] > maxage
End If

  Wend

If printed Then pr.newLine
End Sub

Private Function getTeamCode(trec As Recordset)
Dim t$
If Not trec![Attached] Then
  t$ = "un"
Else
  t$ = ""
End If
t$ = t$ + trec![teamcode]
getTeamCode = t$
End Function
Private Sub tieFinalRecs(evnum As Integer)
Dim tieCount As Integer, oldBook As Variant
Dim psum As Single, oldTime As Single, match As Boolean
Dim newBook As Variant, tiePoints As Single
Dim i As Integer, query As String, screc As Recordset, heats As Integer, heat As Integer

heats = stp.Finalheats
For heat = 1 To heats
query = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Swimmer.Attached, Teams.TeamCode, Seeding.Heat, Results.DQ, Results.Result, Entry.EventKey, Results.Scratch, Entry.Points, Seeding.Lane " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Seeding.heat) = " + Str(heat) + ") And ((Entry.eventkey) = " + Str(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((Seeding.lane) <= 10) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Seeding.Heat DESC , Results.DQ DESC , Results.Result;"

Set screc = db.OpenRecordset(query, dbOpenDynaset)

If Not screc.BOF Then
    screc.moveFirst
    'split points for ties
    tieCount = 1
    psum = screc![points]
    oldBook = screc.Bookmark
    If Not IsNull(screc![result]) Then
        oldTime = screc![result]
    Else
        oldTime = 0
    End If
    screc.moveNext

    While Not screc.EOF
     
    If Not screc.EOF Then
    match = (screc![result] = oldTime) And (oldTime < tm.NT)
    If Not match Then
      oldBook = screc.Bookmark
    End If
    While match
      tieCount = tieCount + 1
      psum = psum + screc![points]
      screc.moveNext
      match = False
      If Not screc.EOF Then
        match = (screc![result] = oldTime) And (oldTime <> tm.NT)
      End If
    Wend
    End If
    If tieCount > 1 Then
      If Not screc.EOF Then
        newBook = screc.Bookmark
      End If
        screc.Bookmark = oldBook
        tiePoints = psum / tieCount
        For i = 1 To tieCount
            screc.Edit
            screc![points] = tiePoints
            screc.update
            screc.moveNext
        Next i
'        screc.MovePrevious
    End If
    
    If Not screc.EOF Then
        tieCount = 1
        psum = screc![points]
        oldBook = screc.Bookmark
        If Not IsNull(screc![result]) Then
            oldTime = screc![result]
        Else
            oldTime = 0
        End If
        screc.moveNext
    End If
    Wend
End If
screc.Close
Next heat

End Sub
Private Sub scoreFinal(qry$)
'Dim fRec As Recordset
Dim Lanes As Integer, heat As Integer, i As Integer, j As Integer

Set fRec = db.OpenRecordset(qry$, dbOpenDynaset)

Set svec = getIndividualScores(ev.getScoreClass)
Lanes = stp.getLanes
heat = stp.Finalheats
i = 1
j = 1
While Not fRec.EOF
  fRec.Edit
  fRec![points] = 0
  fRec.update
  fRec.moveNext
Wend
If Not fRec.BOF Then fRec.moveFirst

While Not fRec.EOF
 If fRec![heat] = heat And Not fRec![DQ] Then
   If i <= svec.count Then
    fRec.Edit
    fRec![points] = svec(i)
    fRec.update
   End If
 End If
 fRec.moveNext
 i = i + 1
 j = j + 1
 If j > Lanes Then
   j = 1
   heat = heat - 1
 End If
Wend
'Rescore if diving
 If ev.strokeKey = strk.getDiving Then
    scoreDiving fRec, svec, evnum
  Else
   'check for ties and pervert the scoring accoringly
  tieFinalRecs (evnum)
End If

End Sub
Public Sub scoreRec(screc As Recordset, svec As Collection, ev_num As Integer, doScore As Boolean)
Dim i As Integer, tcnt As Integer
Dim tieCount As Integer, oldTime As Single
Dim psum As Single, tiePoints As Single
Dim oldBook As Variant, newBook As Variant, match As Boolean
Dim totalTeams As Integer

evnum = ev_num
clearTeamCounts
If ev.isRelay(evnum) Then
    maxSweep = stp.getMaxRelayScore
Else
    maxSweep = stp.getMaxIndScore
End If
If maxSweep = 0 Then
  maxSweep = 5000 'arbitrarily large
End If

i = 1
'zero out current scores
While Not screc.EOF
  screc.Edit
  screc![points] = 0
  screc.update
  screc.moveNext
Wend
If doScore Then
If Not screc.BOF Then screc.moveFirst
While Not screc.EOF
  tcnt = countTeam(screc![teamcode])
  screc.moveNext
Wend
totalTeams = teamCount
clearTeamCounts
If Not screc.BOF Then screc.moveFirst
'insert new scores
While Not screc.EOF
 If Not screc![DQ] Then
  tcnt = countTeam(screc![teamcode])
  If (i <= svec.count) And ((tcnt <= maxSweep) Or (totalTeams = 1)) Then
   screc.Edit
   screc![points] = svec.Item(i)
   i = i + 1
   screc.update
  End If
 End If
 screc.moveNext
Wend
If Not screc.BOF Then
    screc.moveFirst
    'split points for ties
    tieCount = 1
    psum = screc![points]
    oldBook = screc.Bookmark
    If Not IsNull(screc![result]) Then
        oldTime = screc![result]
    Else
        oldTime = 0
    End If
    screc.moveNext

    While Not screc.EOF
    
    If Not screc.EOF Then
    match = (screc![result] = oldTime) And (oldTime < tm.NT)
    While match
      tieCount = tieCount + 1
      psum = psum + screc![points]
      screc.moveNext
      match = False
      If Not screc.EOF Then
        match = (screc![result] = oldTime) And (oldTime <> tm.NT)
      End If
    Wend
    End If
    If tieCount > 0 And Not screc.EOF Then
        newBook = screc.Bookmark
        screc.Bookmark = oldBook
        tiePoints = psum / tieCount
        For i = 1 To tieCount
            screc.Edit
            screc![points] = tiePoints
            screc.update
            screc.moveNext
        Next i
'        screc.MovePrevious
    End If
    
    If Not screc.EOF Then
        tieCount = 1
        psum = screc![points]
        oldBook = screc.Bookmark
        If Not IsNull(screc![result]) Then
            oldTime = screc![result]
        Else
            oldTime = 0
        End If
        screc.moveNext
    End If
    Wend
End If
End If
End Sub

Private Sub printRecords(evnum As Integer)
Dim i As Integer, rh As RecordHolder
pr.setPageFont
Set recCol = recrds.getRecords(evnum)
For i = 1 To recCol.count
  Set rh = recCol(i)
  pr.lPrintcr rh.getName + ": " + rh.getHolder + " " + rh.getTimeString
Next i
End Sub

Private Sub Class_Initialize()
Dim f As Integer, i As Integer
Dim s As String, min As Integer, max As Integer
Dim ag As AgeGroup
Set tm = dtm    'now can exhibit both types
team_max = 100
ReDim team_list(team_max) As String
ReDim team_counts(team_max) As Integer
Set alist = New AgeGroupList
alist.init
End Sub
Private Sub makeScoreNames()
Dim inx As New Indexer, srec As Recordset
inx.makeTable db, "ScoreNames"
inx.createKey "ScoreNameKey"
inx.createText "ScoreName", 40
inx.makeIndex "ScoreNameKey", True
inx.addTable

Set srec = db.OpenRecordset("ScoreNames", dbOpenTable)
srec.AddNew
srec![scoreName] = "Default"
srec.update
srec.Close


End Sub
Public Sub update657()
Dim inx As New Indexer
inx.openTable db, "Scoring"
inx.createInteger "ScoreNameKey"
makeScoreNames
End Sub
Public Function AddScoreName(nm As String)
Dim srec As Recordset, lkey As Integer
Set srec = db.OpenRecordset("ScoreNames", dbOpenTable)
srec.AddNew
srec![scoreName] = nm
srec.update
srec.Bookmark = srec.LastModified
lkey = srec![Scorenamekey]
srec.Close
AddScoreName = lkey
End Function
Private Sub clearTeams()
Dim i As Integer
teamCount = 0
For i = 1 To team_max
  team_counts(i) = 0
Next i

End Sub
Private Function clearTeamCounts()
teamCount = 0
ReDim team_counts(team_max) As Integer
ReDim team_list(team_max) As String
End Function
Private Function countTeam(tcode As String)
Dim i As Integer, j As Integer, found As Boolean
'returns the number of times this team appears
If maxSweep > 0 Then
 i = 1
 While i <= teamCount And Not found
  If team_list(i) = tcode Then
    team_counts(i) = team_counts(i) + 1
    found = True
    countTeam = team_counts(i)
  End If
  i = i + 1
 Wend
 If Not found Then
    If teamCount = team_max Then
       team_max = team_max + 50
       ReDim Preserve team_counts(team_max) As Integer
       ReDim Preserve team_list(team_max) As String
    End If
    teamCount = teamCount + 1
    team_list(teamCount) = tcode
    team_counts(teamCount) = 1
    countTeam = 1
 End If
Else
 countTeam = 0  'don't even count if not zero sweep counter
End If
End Function

Public Function TeamScore(minage As Integer, maxage As Integer, evmax As Integer) As Collection
Dim i As Integer, j As Integer, Quit As Boolean
Dim rec As Recordset, query$, sKid As ScoreKid, max As Integer

If minage = 0 And maxage = 100 Then
query$ = "SELECT Events.EventKey, Entry.Points, Results.raceType, Results.Result, Results.Scratch, Swimmer.Sex, Teams.TeamCode, Teams.TeamShort, Swimmer.AgeClass " & _
"FROM ((Events INNER JOIN (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) ON Events.EventKey = Entry.EventKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((Events.eventkey) <= " + Str$(evmax) + ") And ((Entry.points) > 0) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 3) And ((RESULTS.result) < 10000) And ((RESULTS.SCRATCH) = False) And ((Events.Scoring) = True) And ((Entry.unofficial) = False) And ((Events.TimeTrial) = False) And ((Swimmer.Attached) = True)) " & _
"ORDER BY Teams.TeamCode;"


Else
query$ = "SELECT Teams.TeamCode, Teams.Teamshort, Results.raceType, Swimmer.Frname, Swimmer.Lname, Entry.Points, Entry.EventKey, Events.TimeTrial, Events.Scoring, Events.Minage, Events.Maxage, Swimmer.Sex " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Events ON Entry.EventKey = Events.EventKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 3) AND ((Entry.EventKey)<=" + Str$(evmax) + ")And ((Entry.points) > 0) And ((Events.TimeTrial) = False) And ((Events.Scoring) = True) And ((Events.minage) = " + Str$(minage) + ") And ((Events.maxage) = " + Str$(maxage) + ") And ((Entry.unofficial) = False) " & _
"AND ((Swimmer.Attached)=True) AND ((Results.Scratch)=False) ORDER BY Teams.TeamCode;"
End If



'compute and sort scores
Set rec = db.OpenRecordset(query$, dbOpenDynaset)
Set sKids = New Collection
While Not rec.EOF
  Set sKid = New ScoreKid

    sKid.team = rec![teamcode]
    sKid.shortName = rec![TeamShort] & ""
    If sKid.shortName = "" Then
      sKid.shortName = rec![teamcode]
    End If
    sKid.sum = 0
  Quit = False
  While Not Quit
     Quit = (sKid.team <> rec![teamcode])
     If Not Quit Then sKid.addSum rec![points]
     If Not Quit Then
        rec.moveNext
   End If
     Quit = rec.EOF Or Quit
     If Quit Then sKids.add sKid
   Wend
Wend
ReDim akids(sKids.count) As ScoreKid
For i = 1 To sKids.count
Set akids(i) = sKids(i)
Next i
For i = 1 To sKids.count
 For j = i To sKids.count
   If akids(i).sum < akids(j).sum Then
     Set sKid = akids(i)
     Set akids(i) = akids(j)
     Set akids(j) = sKid
   End If
 Next j
Next i
max = sKids.count
Set sKids = Nothing
Set sKids = New Collection
For i = 1 To max
  sKids.add akids(i)
Next i
Set TeamScore = sKids
End Function
