VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "RelayEntries"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private db As Database
Private mt As Meet
Private entries As clsEntries
Private agegroups As New Collection
Private evnt As Events
Private relay_events As New Collection  'all relays in the meet
Private relay_entries As New Collection 'colln of relay event entries(rev)
'Private rev As RelayEventEntry      'current event entry-colln of individual events and times
Private tm As New times
Private Rowmax As Integer           'number of rows to refresh
Private haveEntry As Boolean
Private subq$                   'query phrase for selected squads
Private strk As New stroke
Private freeRec As Recordset, backRec As Recordset, flyRec As Recordset, breastRec As Recordset
'Private uk As New KidsUsed
'rivate sq As Squads            'set in calling class-contains list of squads to be used
Private kds As New kids
Private isHtml As Boolean
Private htf As Integer
Private kidEntries As clsEntries 'individual entries for checkin scratches
Private Sw As Swimmer
Public Sub setSquads(sqd As Squads)
Set sq = sqd
End Sub
Public Sub computeRelays(entries As clsEntries)
Dim query$

Dim courseKey As Integer, strokeKey As Integer
Dim mdate$, Sex$

Set kidEntries = entries
courseKey = mt.courseKey
mdate$ = "#" + Format$(mt.MeetDate, "mm-dd-yyyy") + "#"

query$ = makeStrokeQuery(strk.getFree, mdate$, courseKey)
Set freeRec = db.OpenRecordset(query$, dbOpenDynaset)
If evnt.strokeKey = strk.getFreeRelay Then
  make_free_relays
Else
  make_medley_relays mdate$, courseKey
End If
End Sub
Private Sub make_medley_relays(mdate$, courseKey%)
ReDim rtests(4) As RelayEntry
Dim rent As RelayEntry
Dim min As Single, j As Integer, jsave As Integer, t As Single
Dim count As Integer

uk.clear

Dim i As Integer
    Set backRec = db.OpenRecordset(makeStrokeQuery(strk.getBack, mdate$, courseKey), dbOpenDynaset)
    Set breastRec = db.OpenRecordset(makeStrokeQuery(strk.getBreast, mdate$, courseKey), dbOpenDynaset)
    Set flyRec = db.OpenRecordset(makeStrokeQuery(strk.getFly, mdate$, courseKey), dbOpenDynaset)

count = rev.count       'this is the number to computer
rev.clear               'erase collection and recreate it
For i = 1 To count
    resetRecs
    makeBkBrstFlyFree rtests(1)
    makeBrstFlyFreeBk rtests(2)
    makeFlyFreeBkBrst rtests(3)
    makeFreeBkBrstFly rtests(4)

    min = 10000
    For j = 1 To 4
    Set rent = rtests(j)
    t = rent.getTime
    If t < min Then
        min = t
        jsave = j
    End If
    Next j
    
    Set rent = rtests(jsave)
    If Not (rent Is Nothing) Then
    For j = 1 To 4
        uk.Addkid rent.getKidKey(j)
    Next j
    rent.setName Chr$(Asc("A") + i - 1)
    rev.addEntry rent
    End If
Next i
backRec.Close
freeRec.Close
flyRec.Close
breastRec.Close
End Sub
Private Sub resetRecs()
If Not freeRec.EOF Then freeRec.moveFirst
If Not backRec.BOF Then backRec.moveFirst
If Not breastRec.BOF Then breastRec.moveFirst
If Not flyRec.BOF Then flyRec.moveFirst
End Sub
Private Sub makeBkBrstFlyFree(rent As RelayEntry)
resetRecs
Set rent = New RelayEntry
tryBack rent, 1
tryBreast rent, 2
tryFly rent, 3
tryFree rent, 4

End Sub
Private Sub makeBrstFlyFreeBk(rent As RelayEntry)

resetRecs
Set rent = New RelayEntry

tryBreast rent, 1
tryFly rent, 2
tryFree rent, 3
tryBack rent, 4

End Sub
Private Sub makeFlyFreeBkBrst(rent As RelayEntry)

resetRecs
Set rent = New RelayEntry

tryFly rent, 1
tryFree rent, 2
tryBack rent, 3
tryBreast rent, 4

End Sub
Private Sub makeFreeBkBrstFly(rent As RelayEntry)

resetRecs
Set rent = New RelayEntry

tryFree rent, 1
tryBack rent, 2
tryBreast rent, 3
tryFly rent, 4
End Sub

Private Sub tryBreast(rent As RelayEntry, posn As Integer)
Dim found As Boolean, key As Integer
found = False
While Not found And Not breastRec.EOF
    key = breastRec![kidkey]
    
    If Not uk.isUsed(key) And Not kidEntries.isScratched(key) Then
         found = rent.addEntry(posn, breastRec![kidkey], breastRec![minofswimtime], strk.getBreast)
    End If
  If Not found Then breastRec.MoveNext
Wend

End Sub
Public Sub tryFly(rent As RelayEntry, posn As Integer)
Dim found As Boolean, key As Integer
found = False
If Not flyRec.BOF Then
While Not found And Not flyRec.EOF
  key = flyRec![kidkey]
  If Not uk.isUsed(key) And Not kidEntries.isScratched(key) Then
      found = rent.addEntry(posn, flyRec![kidkey], flyRec![minofswimtime], strk.getFly)
  End If
  If Not found Then flyRec.MoveNext
Wend
End If
End Sub
Public Sub tryFree(rent As RelayEntry, posn As Integer)
Dim found As Boolean, key As Integer

found = False
If Not freeRec.BOF Then
While Not found And Not freeRec.EOF
    key = freeRec![kidkey]
    If Not uk.isUsed(key) And Not kidEntries.isScratched(key) Then
    found = rent.addEntry(4, freeRec![kidkey], freeRec![minofswimtime], strk.getFree)
  End If
    If Not found Then freeRec.MoveNext
Wend
End If
End Sub
Public Sub tryBack(rent As RelayEntry, posn As Integer)
Dim found As Boolean, key As Integer

found = False
While Not found And Not backRec.EOF
    key = backRec![kidkey]
      If Not uk.isUsed(key) And Not kidEntries.isScratched(key) Then
        found = rent.addEntry(4, backRec![kidkey], backRec![minofswimtime], strk.getBack)
      End If
  If Not found Then backRec.MoveNext
Wend

End Sub
Public Sub HTprintEntry()
Dim S As Integer, a As Integer, i As Integer, j As Integer
Dim evt As clsEvents, revt As RelayEventEntry
Dim ag As AgeGroup, maxcount As Integer, m As Integer
Dim agerelays As New Collection
Dim rent As RelayEntry
Dim tb As Integer, evnum As Integer
ReDim sx$(3)

Set relay_events = Nothing
Set relay_events = New Collection

For i = 1 To mt.eventcount
   Set evt = mt.getEvent(i)
   If evt.isRelay Then
     evt.used = False
     relay_events.add evt
   End If
 Next i


sx$(1) = "F"
sx$(2) = "M"
sx$(3) = "N"
Print #htf, "<h3>Relay Entries</h3>"
For a = 1 To agegroups.count
  Set ag = agegroups(a)
  For S = 1 To 3
  'clear out agerelays collection
  i = agerelays.count
  While i > 0
    agerelays.Remove i
    i = agerelays.count
  Wend
  'find max number of relays in that age group and sex
  maxcount = 0
   For i = 1 To relay_events.count
      Set evt = relay_events(i)
      If ag.matchEvent(evt) And evt.Sex = sx(S) And Not evt.used Then
        For j = 1 To relay_entries.count
          Set revt = relay_entries(j)
          If revt.getEventNumber = evt.eventnumber Then
            agerelays.add revt
            If maxcount < revt.count Then
              maxcount = revt.count
            End If
          End If
        Next j
     End If
   Next i
   'having determined the relays and put them in the agerelays collection
   ' we can now print them out
'   pr.testPage (maxcount + 2)
 ' If maxcount > 0 Then pr.newLine
  ' pr.setBold
  Print #htf, "<table border>"
  Print #htf, "<tr>"
   tb = 0
   For j = 1 To agerelays.count
     Set revt = agerelays(j)
     evnum = revt.getEventNumber
     Set evt = mt.getEvent(evnum)
     evt.used = True
     stCell
     Print #htf, Str$(evnum) + ". " + evt.AgeString + Str$(evt.Distance) + " " + evt.stroke;
     endCell
   Next j
   Print #htf, "</tr>"
   
   tb = 0
   For m = 1 To maxcount
        Print #htf, "<tr>";
        For j = 1 To agerelays.count
        Set revt = agerelays(j)
        If m <= revt.count Then
            Set rent = revt.getRelayEntry(m)
            tm.setSingle rent.getTime
            stCell
            Print #htf, rent.getName + ". " + tm.getFormatted;
            endCell
        Else
          emptyCell
        End If
        Next j
     tb = 0
     Print #htf, "</tr>";
   Next m
   Print #htf, "</table>"
   'If maxcount > 0 Then pr.newLine
  Next S
Next a
End Sub
Public Sub printEntry(pr As clsPrinters)
If isHtml Then
  HTprintEntry
Else
  pprintEntry pr
End If
End Sub
Public Sub pprintEntry(pr As clsPrinters)
Dim S As Integer, a As Integer, i As Integer, j As Integer
Dim evt As clsEvents, revt As RelayEventEntry
Dim ag As AgeGroup, maxcount As Integer, m As Integer
Dim agerelays As New Collection
Dim rent As RelayEntry
Dim tb As Integer, evnum As Integer
ReDim sx$(3)

Set relay_events = Nothing
Set relay_events = New Collection

For i = 1 To mt.eventcount
   Set evt = mt.getEvent(i)
   If evt.isRelay Then
     evt.used = False
     relay_events.add evt
   End If
 Next i


sx$(1) = "F"
sx$(2) = "M"
sx$(3) = "N"
For a = 1 To agegroups.count
  Set ag = agegroups(a)
  For S = 1 To 3
  'clear out agerelays collection
  i = agerelays.count
  While i > 0
    agerelays.Remove i
    i = agerelays.count
  Wend
  'find max number of relays in that age group and sex
  maxcount = 0
   For i = 1 To relay_events.count
      Set evt = relay_events(i)
      If ag.matchEvent(evt) And evt.Sex = sx(S) And Not evt.used Then
        For j = 1 To relay_entries.count
          Set revt = relay_entries(j)
          If revt.getEventNumber = evt.eventnumber Then
            agerelays.add revt
            If maxcount < revt.count Then
              maxcount = revt.count
            End If
          End If
        Next j
     End If
   Next i
   'having determined the relays and put them in the agerelays collection
   ' we can now print them out
   pr.testPage (maxcount + 2)
  If maxcount > 0 Then pr.newLine
   pr.setBold
   tb = 0
   For j = 1 To agerelays.count
     Set revt = agerelays(j)
     evnum = revt.getEventNumber
     Set evt = mt.getEvent(evnum)
     evt.used = True
     pr.lPrint Str$(evnum) + ". " + evt.AgeString + Str$(evt.Distance) + " " + evt.stroke
     tb = tb + 25
     pr.Tabbit tb
   Next j
   pr.setPlain
   If agerelays.count > 0 Then pr.newLine
   tb = 0
   For m = 1 To maxcount
        For j = 1 To agerelays.count
        Set revt = agerelays(j)
        If m <= revt.count Then
            Set rent = revt.getRelayEntry(m)
            tm.setSingle rent.getTime
            pr.lPrint rent.getName + ". " + tm.getFormatted
        End If
        tb = tb + 25
        pr.Tabbit tb
        Next j
     pr.newLine
     tb = 0
   Next m
   If maxcount > 0 Then pr.newLine
  Next S
Next a
End Sub
Private Sub make_free_relays()
Dim i  As Integer, j As Integer, sum As Single
Dim rent As RelayEntry

If Not freeRec.BOF Then freeRec.moveFirst
For i = 1 To rev.count
    sum = 0
    Set rent = rev.getRelayEntry(i)
    For j = 1 To 4
      If Not freeRec.EOF Then
      sum = sum + tm.getSeconds(freeRec![minofswimtime])
      rent.addEntry j, freeRec![kidkey], freeRec![minofswimtime], strk.getFree
      freeRec.MoveNext
      End If
    Next j
    rent.setTime tm.getMinutes(sum)         'reconvert to minutes
    rent.setName Chr$(Asc("A") + i - 1)
Next i
End Sub
Private Function makeStrokeQuery(strokeKey As Integer, mdate$, courseKey%) As String
Dim minage As Integer, maxage As Integer, Sex$, dist As Integer
Dim subquery$

Sex$ = evnt.Sex
minage = evnt.minage
maxage = evnt.maxage
dist = evnt.Distance / 4

'subquery$ = "((kids.squadkey) = 2 Or (kids.squadkey) = 3 Or (kids.squadkey) = 4) "
subquery$ = sq.getQueryString   'constructed "kids.squadkey Or" string

makeStrokeQuery = "SELECT DISTINCTROW Min(SwimEvents.swimtime) AS MinOfswimtime, Kids.KidKey, Kids.Nickname, Kids.Lname " & _
"FROM (Kids INNER JOIN Squads ON Kids.SquadKey = Squads.SquadKey) INNER JOIN SwimEvents ON Kids.KidKey = SwimEvents.kidKey " & _
"GROUP BY Kids.KidKey, Val(Format$(" + mdate$ + "-[Birthday]," + Chr$(34) + "yy" + Chr$(34) + ")), Kids.Nickname, Kids.SquadKey, Kids.Lname, SwimEvents.strokeKey, SwimEvents.Distance, SwimEvents.courseKey, Squads.SquadName, Kids.Sex, Kids.Active, Kids.Attached " & _
"Having ((min(SwimEvents.swimtime) > 0)) And ((min(SwimEvents.swimtime) < 10000)) And ((val(Format$(" + mdate$ + " - [birthday], " + Chr$(34) + "yy" + Chr$(34) + "))) >= " + Str$(minage) + ") And ((val(Format$(" + mdate$ + " - [birthday], " + Chr$(34) + "yy" + Chr$(34) + "))) <=" + Str$(maxage) + ") And " & _
subquery$ & _
"AND ((Kids.Active)=True) AND ((Kids.Attached)=True) and ((SwimEvents.strokekey) = " + Str$(strokeKey) + ") And ((SwimEvents.Distance) = " + Str$(dist) + ") And ((SwimEvents.coursekey) = " + Str$(courseKey) + ") And ((kids.sex) = " + Chr$(34) + Sex$ + Chr$(34) + ") " & _
"ORDER BY Min(SwimEvents.swimtime);"

End Function
Public Sub setSquadQuery(subquery$)
 subq$ = subquery$
End Sub
Public Sub setDB(datab As Database)
Set db = datab
kds.setDB db
End Sub
Public Sub setMeet(met As Meet)
Dim fl As New file
Set mt = met
End Sub
Public Sub setEntries(ent As clsEntries)
Set entries = ent

End Sub
'*** APEX Migration Utility Code Change ***
'Public Sub readEx(ByVal RowBuf As TrueDBGrid.RowBuffer, StartLocation As Variant, ByVal Offset As Long, ApproximatePosition As Long)
Public Sub readEx(ByVal RowBuf As TrueDBGrid50.RowBuffer, StartLocation As Variant, ByVal Offset As Long, ApproximatePosition As Long)
'fills in the requested rows.
'The columns are relay name and tme
Dim i As Integer, count As Integer, ken As kidEntry, e As Integer
 Dim ColIndex As Integer, j As Integer
 Dim RowsFetched As Integer
 Dim NewPosition As Long, Bookmark As Variant
 
RowsFetched = 0
If haveEntry Then
    Rowmax = rev.count

    For i = 0 To RowBuf.RowCount - 1
        ' Get the bookmark of the next available row
        Bookmark = GetRelativeBookmark(StartLocation, Offset + i)
        If IsNull(Bookmark) Then Exit For
        ' Place the record data into the row buffer
        For j = 0 To RowBuf.ColumnCount - 1
            ColIndex = RowBuf.ColumnIndex(i, j)
            RowBuf.value(i, j) = GetUserData(Bookmark, ColIndex)
        Next j
        RowBuf.Bookmark(i) = Bookmark   ' Set the bookmark for the row
        RowsFetched = RowsFetched + 1   ' Increment the count of fetched rows
    Next i
    ' Tell the grid how many rows  were fetched
    ' Set the approximate scroll bar position.  Only
    ' nonnegative values of IndexFromBookmark() are valid.
    NewPosition = IndexFromBookmark(StartLocation, Offset)
    If NewPosition >= 0 Then
       ApproximatePosition = NewPosition
    End If
End If
RowBuf.RowCount = RowsFetched   'return number found(may be 0)
End Sub
Private Function GetUserData(Bookmark As Variant, Index As Integer)
Dim i As Integer, count As Integer, rent As RelayEntry, e As Integer

  count = val(Bookmark)
  Set rent = rev.getRelayEntry(count + 1)
  
  Select Case Index
  Case 0
   GetUserData = rent.getName
  Case 1
    tm.setSingle rent.getTime
    GetUserData = tm.getFormatted
  
End Select
End Function
'*** APEX Migration Utility Code Change ***
'Public Sub writeData(ByVal RowBuf As TrueDBGrid.RowBuffer, Rownum As Variant)
Public Sub writeData(ByVal RowBuf As TrueDBGrid50.RowBuffer, Rownum As Variant)
Dim scr As Boolean
Dim rent As RelayEntry
If Not IsNull(RowBuf.value(0, 1)) Then
    Set rent = rev.getRelayEntry(Rownum + 1)
    rent.setTime val(RowBuf.value(0, 1))
    RowBuf.RowCount = 1
End If

'RowBuf.Bookmark(Rownum) = Null
End Sub
Public Sub fillAgeRelays(lsrelAgegroup As ListBox, ageIndex As Integer)
'fills list box with all relays in that age group
Dim i As Integer
Dim ev As clsEvents
Dim ag As AgeGroup

lsrelAgegroup.clear
i = relay_events.count
While i >= 1
 relay_events.Remove i
 i = relay_events.count
Wend
 
Set ag = agegroups(ageIndex)
  For i = 1 To mt.eventcount
   
   Set ev = mt.getEvent(i)
   If ev.isRelay And ag.matchEvent(ev) Then
    lsrelAgegroup.AddItem Format$(i, "## ") + ev.Sex + Chr$(9) + ev.AgeString + Str$(ev.Distance) + Chr$(9) + ev.stroke
    relay_events.add ev
   End If
 Next i

End Sub
Public Sub fillAgeGroups(lsAgeGrp As ListBox)
Dim i  As Integer
Dim ag As AgeGroup
'fills list box with all age groups
Set agegroups = mt.findAgeGroups
 For i = 1 To agegroups.count
   Set ag = agegroups(i)
   lsAgeGrp.AddItem ag.AgeString
 Next i
End Sub
Public Sub loadAgeGroups()
'you must call this before printing unless it was filled
'using the list box filler above
Set agegroups = mt.findAgeGroups
End Sub
Public Sub setEvent(Index As Integer)
 
 haveEntry = False      'no entry yet for this event
 Set evnt = relay_events(Index)
 On Local Error GoTo no_set
 Set rev = relay_entries(Str$(evnt.eventnumber))
 haveEntry = True

set_exit:
 Exit Sub

no_set:
  Resume set_exit       'no entries in this event yet
End Sub
Public Function getEntrants() As Integer
Dim i As Integer, count As Integer
Dim Sw As Swimmer

count = 0
For i = 1 To entries.count
  Set Sw = entries.getSwimmer(i)
  If Sw.matchAgeSex(evnt) And (Sw.hasUnscratchedEvents Or Sw.relayOnly) Then
   count = count + 1
  End If
Next i
getEntrants = count
End Function
Public Sub createRelays(num As Integer)
Dim i As Integer
Dim rent As RelayEntry
Dim nm$

On Local Error GoTo not_exist
'the relay events collection is indexed by event number
'each member is a collection of entries into that event
'Each entry contains a time and name (A through Z)
Set rev = relay_entries(Str$(evnt.eventnumber))
relay_entries.Remove Str$(evnt.eventnumber)

'entries_made:
'haveEntry = True
'Exit Sub

' if entry list for this relay does not yet exist
' the exception dumps us here

make_entry:
nm$ = "A"        'start with A-relay
Set rev = New RelayEventEntry  'all entries to this event
rev.setEventNumber evnt.eventnumber
For i = 1 To num
 Set rent = New RelayEntry
 rent.setName nm$   'letters A through Z
 rent.setTime tm.NT     'start with no time
 rev.addEntry rent  'add entry to collection
 nm$ = nextChar(nm$)
Next i
relay_entries.add rev, Str$(evnt.eventnumber)

haveEntry = True
Exit Sub

not_exist:       'most commonly we create the entry here
  Resume make_entry
End Sub
Private Function nextChar(S$)
Dim a As Integer
'returns next alphabetic character
a = Asc(S$) + 1
nextChar = Chr$(a)
End Function
Public Function getEntryCount() As Integer
'If haveEntry Then
On Local Error GoTo nogetent
  Set rev = relay_entries(Str$(evnt.eventnumber))
  getEntryCount = rev.count
  Exit Function
errext:
  getEntryCount = 0
  Exit Function
nogetent:
  Resume errext
End Function
Public Function count() As Integer
  count = relay_entries.count
End Function
Private Function GetRelativeBookmark(Bookmark As Variant, Offset As Long) As Variant
    ' GetRelativeBookmark is used to get a bookmark for a
    ' row that is a specified number of rows away from the
    ' given row.  Offset specifies the number of rows to
    ' move.  A positive Offset indicates that the desired
    ' row is after the one referred to by Bookmark, and a
    ' negative Offset means it is before the one referred
    ' to by Bookmark.
    
    Dim Index As Long
    
    ' Compute the row index for the desired row
    Index = IndexFromBookmark(Bookmark, Offset)
    If Index < 0 Or Index >= Rowmax Then
        ' Index refers to a row before the first or after
        ' the last, so just return Null.
        GetRelativeBookmark = Null
    Else
        GetRelativeBookmark = MakeBookmark(Index)
    End If
End Function

Private Function IndexFromBookmark(Bookmark As Variant, Offset As Long) As Long
    Dim Index As Long
    
    If IsNull(Bookmark) Then
        If Offset < 0 Then
            ' Bookmark refers to EOF.  Since (RowMax - 1)
            ' is the index of the last record, we can use
            ' an index of (RowMax) to represent EOF.
            Index = Rowmax + Offset
        Else
            ' Bookmark refers to BOF.  Since 0 is the index
            ' of the first record, we can use an index of
            ' -1 to represent BOF.
            Index = -1 + Offset
        End If
    Else
        ' Convert string to long integer
        Index = val(Bookmark) + Offset
    End If
    
    ' Check to see if the row index is valid:
    '   (0 <= Index < RowMax).
    ' If not, set it to a large negative number to
    ' indicate that it is invalid.
    If Index >= 0 And Index < Rowmax Then
       IndexFromBookmark = Index
    Else
       IndexFromBookmark = -9999
    End If
End Function


Private Function MakeBookmark(Index As Long) As Variant
     
    MakeBookmark = CStr(Index)
End Function
Public Sub saveRelays(ini As Profile)
Dim i As Integer
Dim rev As RelayEventEntry

ini.putProfile "Meet", "Relays", Str$(relay_entries.count)
For i = 1 To relay_entries.count
  Set rev = relay_entries(i)
  rev.saveentry i, ini
Next i

End Sub
Public Sub readRelays(fl As file)
Dim i As Integer
Dim rev As RelayEventEntry
Dim count As Integer
Dim ini As New Profile

ini.setFilename fl.getFile
count = val(ini.getProfile("Meet", "Relays", "0"))
Set relay_entries = Nothing
Set relay_entries = New Collection
For i = 1 To count
  Set rev = New RelayEventEntry
  rev.readEntry i, ini
  relay_entries.add rev, Str$(rev.getEventNumber)
Next i
'haveEntry = True
End Sub
Public Function getRevEntry(i As Integer) As RelayEventEntry
Set getRevEntry = relay_entries(i)
End Function
Private Function getSexCount(sx$) As Integer
 Dim count As Integer, i As Integer
 Dim revt As RelayEventEntry
 Dim evt As clsEvents
 count = 0
 
 For i = 1 To relay_entries.count
   Set revt = relay_entries(i)
   Set evt = mt.getEvent(revt.getEventNumber)
   If evt.Sex = sx$ Then
     count = count + revt.count
   End If
 Next i
 getSexCount = count

End Function
Public Function delete(Bkmark As Variant)
Dim row As Integer
row = val(Bkmark) + 1
rev.deleteEntry (row)
End Function

 Public Function getGirlRelayCount() As Integer
 getGirlRelayCount = getSexCount("F")
 End Function
 Public Function getBoyRelayCount() As Integer
 getBoyRelayCount = getSexCount("M")
 End Function
 Public Function getNeuterRelayCount() As Integer
 getNeuterRelayCount = getSexCount("N")
 End Function
Public Sub printProof(pr As clsPrinters)
Dim i As Integer, j As Integer, leg As Integer
Dim revt As RelayEventEntry, rent As RelayEntry, rLeg As RelayLeg
Dim tm As New times, found As Boolean

found = False

For i = 1 To relay_entries.count
  Set revt = relay_entries(i)
  For j = 1 To revt.count
    Set rent = revt.getRelayEntry(j)
    If rent.legCount = 4 Then
      found = True
    End If
  Next j
Next i

If found Then       'print only if ther are some proofs
kds.openTable
pr.setSubHeadFont
pr.lPrintcr "Proofs of computed relays"
pr.newLine
pr.setPageFont
For i = 1 To relay_entries.count
  Set revt = relay_entries(i)
  For j = 1 To revt.count
    Set rent = revt.getRelayEntry(j)
    If rent.legCount = 4 Then
     pr.lPrint Str$(revt.getEventNumber) + " " + mt.Eventname(revt.getEventNumber) + " "
      tm.setSingle rent.getTime
      pr.lPrintcr rent.getName + " " + tm.getFormatted
      For leg = 1 To 4
       Set rLeg = rent.getLeg(leg)
       tm.setSingle rent.getTime
       tm.setSingle rLeg.getTime
       pr.lPrint kds.getName(rLeg.getKidKey) + " " + tm.getFormatted + ";  "
      Next leg
      pr.newLine
    End If
    
  Next j
Next i
End If
End Sub
Public Sub setHtml(ht As Integer)
isHtml = True
htf = ht
End Sub
Public Sub setPrintmode()
isHtml = False
End Sub
Private Sub stCell()
Print #htf, "<td>";
End Sub
Private Sub endCell()
Print #htf, "</td>";
End Sub
Private Sub break()
Print #htf, "<br>";
End Sub

Private Sub emptyCell()
Print #htf, "<td>-</td>"
End Sub

