VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Seeding"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private db As Database
Private rtype As New racetype
Private rec As Recordset
Dim Lanes As Integer
Dim stp As New SetupData
Dim laneList As Collection
Dim fullanes As Integer
Dim sdRec As Recordset
Private opened As Boolean
Private res As New RESULTS
Private mt As New Meet
Private lastLanes As Integer
Private tmpSd As tmpSeed
Dim ev As New Events
Public Sub setDB(datab As Database)
Set db = datab
res.setDB db
mt.setDB db
ev.setDB db
ev.openTable
Set tmpSd = New tmpSeed
tmpSd.init db
End Sub
Public Sub createTable(datab As Database)
Dim inx As New Indexer
Set db = datab

inx.makeTable db, "Seeding"
inx.createKey "SeedKey"
inx.makeIndex "SeedKey", True

inx.createLong "ResultKey"
inx.makeIndex "ResultKey", False
inx.createInteger "Heat"
inx.createInteger "Lane"
'inx.createInteger "RaceType"
inx.addTable
End Sub
Public Sub openTable()
If Not opened Then
  Set rec = db.OpenRecordset("Seeding", dbOpenTable)
  'opened = True
End If
End Sub
Public Function getFinalEvent(evnum As Integer) As Recordset
Dim fquery$, query$, seedQuery$, sq$, fRec As Recordset, rkey As Long
Dim trec As Recordset, tqry$, skey As Long, t As Single, squery$, hQuery$
Dim pqry$, fQry$, hrec As Recordset
Dim rtyp As Integer

rtyp = rtype.FIN

Lanes = stp.getLanes
openTable
mt.openTable
'------------
'Gte current result records and if zero result, then delete them
'Prevents accumulation of duplicate results
'---------------
squery$ = "SELECT Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Result " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  If trec![result] = 0 Then
    trec.delete
  End If
  trec.moveNext
Wend
trec.Close
'----------
'Get current seeding records and delete them
'----------
squery$ = "SELECT  Seeding.SeedKey " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  skey = trec![seedKey]
  rec.Index = "Seedkey"
  rec.Seek "=", skey
  While Not rec.NoMatch
    rec.delete
    rec.Seek "=", skey
  Wend
  trec.moveNext
Wend

trec.Close
'----------------
'Get all the prelim results that could go to finals
'----------------
pqry = "SELECT Swimmer.SwimmerKey, Results.Result, Entry.Entrykey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) < 3) And ((RESULTS.SCRATCH) = False) And ((RESULTS.DQ) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.Result;"

Set trec = db.OpenRecordset(pqry, dbOpenDynaset)
'----------------
'get results records for finals
'----------------
fQry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.entrykey, Entry.EventKey, Results.Result, Results.raceType, Results.PrelimSeed, Results.result,Results.resultkey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Entry.EventKey)=" + Str$(evnum) + ") AND ((Results.raceType)=" + Str$(rtyp) + "));"
Set fRec = db.OpenRecordset(fQry, dbOpenDynaset)

'go through prelims and make sure there is a finals result rec for each
While Not trec.EOF
 skey = trec![swimmerKey]
 fRec.FindFirst "Swimmerkey=" + Str$(skey)
 If fRec.NoMatch Then
  rkey = res.addRecord(rtype.FIN, trec![entrykey], trec![result], mt.coursekey)
 Else
   rkey = fRec![resultKey]
 End If
  rec.Index = "Resultkey"
  rec.Seek "=", rkey
  If rec.NoMatch Then
    rec.AddNew
    rec![resultKey] = rkey
    rec.update
  End If
 
 trec.moveNext
Wend
fRec.Close
trec.Close

hQuery$ = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.resultkey, Seeding.Heat, Seeding.Lane, Results.Scratch " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.PrelimSeed) > 0 And (RESULTS.PrelimSeed) < 10000) And ((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed, Seeding.Heat, Seeding.Lane;"

fquery = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Resultkey " & _
"FROM ((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) ORDER BY Results.PrelimSeed;"



 Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
 'make sure it contains the prelim result times
 tqry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.EventKey, Results.Result, Results.raceType " & _
  "FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
  "Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 2)) " & _
  "ORDER BY Results.Result;"

  Set trec = db.OpenRecordset(tqry, dbOpenDynaset)
  While Not trec.EOF
    skey = trec![swimmerKey]
    fRec.FindFirst "swimmerkey=" + Str$(skey)
    t = trec![result]
    If Not fRec.NoMatch Then
     fRec.Edit
     fRec![PrelimSeed] = t
     fRec.update
    End If
    trec.moveNext
  Wend
  trec.Close

fRec.Close
'add in seeding records for each possible race
'Set hrec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
Set getFinalEvent = fRec
While Not fRec.EOF
 rec.Index = "resultkey"
 rec.Seek "=", fRec![resultKey]
 If rec.NoMatch Then
  rec.AddNew
  rec![resultKey] = fRec![resultKey]
  rec![heat] = 0
  rec![lane] = 0
  rec.update
 End If
  fRec.moveNext
Wend
fRec.Close
Set fRec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set getFinalEvent = fRec
End Function
Public Function getFinalEventFromSemis(evnum As Integer) As Recordset
Dim fquery$, query$, seedQuery$, sq$, fRec As Recordset, rkey As Long
Dim trec As Recordset, tqry$, skey As Long, t As Single, squery$, hQuery$
Dim pqry$, fQry$, hrec As Recordset
Dim rtyp As Integer

rtyp = rtype.FIN

Lanes = stp.getLanes
openTable
mt.openTable
'------------
'Gte current result records and if zero result, then delete them
'Prevents accumulation of duplicate results
'---------------
squery$ = "SELECT Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Result " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  If trec![result] = 0 Then
    trec.delete
  End If
  trec.moveNext
Wend
trec.Close
'----------
'Get current seeding records and delete them
'----------
squery$ = "SELECT  Seeding.SeedKey " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  skey = trec![seedKey]
  rec.Index = "Seedkey"
  rec.Seek "=", skey
  While Not rec.NoMatch
    rec.delete
    rec.Seek "=", skey
  Wend
  trec.moveNext
Wend

trec.Close
'----------------
'Get all the semifinal results that could go to finals
'----------------
pqry = "SELECT Swimmer.SwimmerKey, Results.Result, Entry.Entrykey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) =" + Str$(rtype.SemiFinal) + ") And ((RESULTS.SCRATCH) = False) And ((RESULTS.DQ) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.Result;"

Set trec = db.OpenRecordset(pqry, dbOpenDynaset)
'----------------
'get results records for finals
'----------------
fQry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.entrykey, Entry.EventKey, Results.Result, Results.raceType, Results.PrelimSeed, Results.result,Results.resultkey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Entry.EventKey)=" + Str$(evnum) + ") AND ((Results.raceType)=" + Str$(rtyp) + "));"
Set fRec = db.OpenRecordset(fQry, dbOpenDynaset)

'go through prelims and make sure there is a finals result rec for each
While Not trec.EOF
 skey = trec![swimmerKey]
 fRec.FindFirst "Swimmerkey=" + Str$(skey)
 If fRec.NoMatch Then
  rkey = res.addRecord(rtype.FIN, trec![entrykey], trec![result], mt.coursekey)
 Else
   rkey = fRec![resultKey]
 End If
  rec.Index = "Resultkey"
  rec.Seek "=", rkey
  If rec.NoMatch Then
    rec.AddNew
    rec![resultKey] = rkey
    rec.update
  End If
 
 trec.moveNext
Wend
fRec.Close
trec.Close

hQuery$ = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.resultkey, Seeding.Heat, Seeding.Lane, Results.Scratch " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.PrelimSeed) > 0 And (RESULTS.PrelimSeed) < 10000) And ((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed, Seeding.Heat, Seeding.Lane;"

fquery = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Resultkey " & _
"FROM ((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) ORDER BY Results.PrelimSeed;"



 Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
 'make sure it contains the prelim result times
 tqry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.EventKey, Results.Result, Results.raceType " & _
  "FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
  "Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) =" + Str(rtype.SemiFinal) + ")) " & _
  "ORDER BY Results.Result;"

  Set trec = db.OpenRecordset(tqry, dbOpenDynaset)
  While Not trec.EOF
    skey = trec![swimmerKey]
    fRec.FindFirst "swimmerkey=" + Str$(skey)
    t = trec![result]
    If Not fRec.NoMatch Then
     fRec.Edit
     fRec![PrelimSeed] = t
     fRec.update
    End If
    trec.moveNext
  Wend
  trec.Close

fRec.Close
'add in seeding records for each possible race
'Set hrec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
Set getFinalEventFromSemis = fRec
While Not fRec.EOF
 rec.Index = "resultkey"
 rec.Seek "=", fRec![resultKey]
 If rec.NoMatch Then
  rec.AddNew
  rec![resultKey] = fRec![resultKey]
  rec![heat] = 0
  rec![lane] = 0
  rec.update
 End If
  fRec.moveNext
Wend
fRec.Close
Set fRec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set getFinalEventFromSemis = fRec
End Function

Public Function getSemiEvent(evnum As Integer) As Recordset
Dim fquery$, query$, seedQuery$, sq$, fRec As Recordset, rkey As Long
Dim trec As Recordset, tqry$, skey As Long, t As Single, squery$, hQuery$
Dim pqry$, fQry$, hrec As Recordset
Dim rtyp As Integer

rtyp = rtype.SemiFinal

Lanes = stp.getLanes
openTable
mt.openTable
'------------
'Gte current result records and if zero result, then delete them
'Prevents accumulation of duplicate results
'---------------
squery$ = "SELECT Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Result " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  If trec![result] = 0 Then
    trec.delete
  End If
  trec.moveNext
Wend
trec.Close
'----------
'Get current seeding records and delete them
'----------
squery$ = "SELECT  Seeding.SeedKey " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((RESULTS.SCRATCH) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed;"
Set trec = db.OpenRecordset(squery, dbOpenDynaset)
While Not trec.EOF
  skey = trec![seedKey]
  rec.Index = "Seedkey"
  rec.Seek "=", skey
  While Not rec.NoMatch
    rec.delete
    rec.Seek "=", skey
  Wend
  trec.moveNext
Wend

trec.Close
'----------------
'Get all the prelim results that could go to finals
'----------------
pqry = "SELECT Swimmer.SwimmerKey, Results.Result, Entry.Entrykey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((RESULTS.racetype) < 3) And ((RESULTS.SCRATCH) = False) And ((RESULTS.DQ) = False) And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.Result;"

Set trec = db.OpenRecordset(pqry, dbOpenDynaset)
'----------------
'get results records for finals
'----------------
fQry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.entrykey, Entry.EventKey, Results.Result, Results.raceType, Results.PrelimSeed, Results.result,Results.resultkey " & _
"FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Entry.EventKey)=" + Str$(evnum) + ") AND ((Results.raceType)=" + Str$(rtyp) + "));"
Set fRec = db.OpenRecordset(fQry, dbOpenDynaset)

'go through prelims and make sure there is a finals result rec for each
While Not trec.EOF
 skey = trec![swimmerKey]
 fRec.FindFirst "Swimmerkey=" + Str$(skey)
 If fRec.NoMatch Then
  rkey = res.addRecord(rtype.SemiFinal, trec![entrykey], trec![result], mt.coursekey)
 Else
   rkey = fRec![resultKey]
 End If
  rec.Index = "Resultkey"
  rec.Seek "=", rkey
  If rec.NoMatch Then
    rec.AddNew
    rec![resultKey] = rkey
    rec.update
  End If
 
 trec.moveNext
Wend
fRec.Close
trec.Close

hQuery$ = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.resultkey, Seeding.Heat, Seeding.Lane, Results.Scratch " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.PrelimSeed) > 0 And (RESULTS.PrelimSeed) < 10000) And ((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) " & _
"ORDER BY Results.PrelimSeed, Seeding.Heat, Seeding.Lane;"

fquery = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.Entrykey, Results.PrelimSeed, Results.raceType, Results.Scratch, Results.Resultkey " & _
"FROM ((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.racetype) = " + Str$(rtyp) + ") And ((Entry.eventkey) = " + Str$(evnum) + ")) ORDER BY Results.PrelimSeed;"



 Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
 'make sure it contains the prelim result times
 tqry = "SELECT Swimmer.SwimmerKey, Swimmer.Frname, Swimmer.Lname, Entry.EventKey, Results.Result, Results.raceType " & _
  "FROM (Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
  "Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 2)) " & _
  "ORDER BY Results.Result;"

  Set trec = db.OpenRecordset(tqry, dbOpenDynaset)
  While Not trec.EOF
    skey = trec![swimmerKey]
    fRec.FindFirst "swimmerkey=" + Str$(skey)
    t = trec![result]
    If Not fRec.NoMatch Then
     fRec.Edit
     fRec![PrelimSeed] = t
     fRec.update
    End If
    trec.moveNext
  Wend
  trec.Close

fRec.Close
'add in seeding records for each possible race
'Set hrec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set fRec = db.OpenRecordset(fquery, dbOpenDynaset)
Set getSemiEvent = fRec
While Not fRec.EOF
 rec.Index = "resultkey"
 rec.Seek "=", fRec![resultKey]
 If rec.NoMatch Then
  rec.AddNew
  rec![resultKey] = fRec![resultKey]
  rec![heat] = 0
  rec![lane] = 0
  rec.update
 End If
  fRec.moveNext
Wend
fRec.Close
Set fRec = db.OpenRecordset(hQuery, dbOpenDynaset)
Set getSemiEvent = fRec
End Function


Private Function convertRaceType(evnum As Integer) As Recordset
Dim query$, fRec As Recordset

  query = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Result, Entry.EventKey, Entry.Entrykey,results.racetype " & _
    "FROM (Entry INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
    "Where(((Entry.EventKey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 1) And ((RESULTS.SCRATCH) = False)) Or (((RESULTS.racetype) = 2) And ((RESULTS.DQ) = False) And ((RESULTS.SCRATCH) = False)) " & _
    "ORDER BY Results.Result;"
    Set fRec = db.OpenRecordset(query, dbOpenDynaset)
    While Not fRec.EOF
      fRec.Edit
      fRec![racetype] = 2    'prelim of prelim-finak
      fRec.update
      fRec.moveNext
    Wend
    fRec.Close
    query = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Result, Entry.EventKey, Entry.Entrykey " & _
    "FROM (Entry INNER JOIN Swimmer ON Entry.SwimmerKey = Swimmer.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
    "Where(((Entry.EventKey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 2) And ((RESULTS.SCRATCH) = False)) Or (((RESULTS.racetype) = 2) And ((RESULTS.DQ) = False) And ((RESULTS.SCRATCH) = False)) " & _
    "ORDER BY Results.Result;"
    Set fRec = db.OpenRecordset(query, dbOpenDynaset)
    
Set convertRaceType = fRec
End Function
Public Function getEvent(evnum As Integer, final As Boolean, ftoslow As Boolean, del As Boolean, mheats As Integer) As Recordset
Dim query$, rtyp As Integer, seedQuery$, sq$, sqWhere As String
Dim trec As Recordset, skey As Long
Lanes = stp.getLanes
'-----------------
'Delete any old seeding to prevent accidental duplicates
'-----------------
If del Then
query$ = "SELECT Entry.EventKey, Results.raceType, Seeding.SeedKey " & _
"FROM (Entry INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"WHERE (((Entry.EventKey)=" + Str$(evnum) + ")  AND "

'If final Then
 ' query = query + "(Results.raceType)=2);"
'Else
  query = query + "((Results.raceType)=1 Or (Results.raceType)=2));"
'End If

Set trec = db.OpenRecordset(query$, dbOpenDynaset)
openTable
rec.Index = "SeedKey"
While Not trec.EOF
  skey = trec![seedKey]
  rec.Seek "=", skey
  If Not rec.NoMatch Then
    rec.delete
  End If
  trec.moveNext
Wend
If Not trec.BOF Then trec.Close
End If


  rtyp = rtype.tf
  sq$ = "(RESULTS.racetype) = " + Str$(rtype.tf) + " Or (RESULTS.racetype) = " + Str$(rtype.prelim) + ")"

seedQuery$ = "SELECT Entry.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Teams.TeamCode, Entry.SeedTime, Entry.SeedCourse, Entry.Bonus, Results.Scratch, Results.raceType, Seeding.Heat, Seeding.Lane " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"Where (((Entry.EventKey) = " + Str$(evnum) + ") AND (Entry.bonus=false) AND "

   ' seedQuery = seedQuery + "ORDER BY Entry.SeedTime, Entry.Bonus DESC ;"
   mt.openTable
   tmpSd.clearTable
   Select Case mt.coursekey
     Case 1
       'sqWhere = "((Entry.SeedCourse) In (1,2,3)) And ((RESULTS.SCRATCH) = False) And (" + sq$ + ") "
       tmpSd.addCourse evnum, 1, False
       tmpSd.addCourse evnum, 2, False
       tmpSd.addCourse evnum, 3, False
       tmpSd.addCourse evnum, 1, True
       tmpSd.addCourse evnum, 2, True
       tmpSd.addCourse evnum, 3, True
     Case 2  'lcm
       'sqWhere = "((Entry.SeedCourse) In (2,1,3)) And ((RESULTS.SCRATCH) = False) And (" + sq$ + ") "
        tmpSd.addCourse evnum, 2, False
       tmpSd.addCourse evnum, 3, False
       tmpSd.addCourse evnum, 1, False
       tmpSd.addCourse evnum, 2, True
       tmpSd.addCourse evnum, 3, True
       tmpSd.addCourse evnum, 1, True


     Case 3 'scm
       'sqWhere = "((Entry.SeedCourse) In (3, 2,1)) And ((RESULTS.SCRATCH) = False) And (" + sq$ + ") "
       tmpSd.addCourse evnum, 3, False
       tmpSd.addCourse evnum, 2, False
       tmpSd.addCourse evnum, 1, False
       tmpSd.addCourse evnum, 3, True
       tmpSd.addCourse evnum, 2, True
       tmpSd.addCourse evnum, 1, True

   End Select
   
    'seedQuery = seedQuery + sqWhere + "order by Entry.Bonus DESC ,  Entry.SeedTime;"
    seedQuery = seedQuery + sqWhere + "order by  Entry.SeedTime;"
   



'try to get seeded records first
'Set sdRec = db.OpenRecordset(seedQuery$, dbOpenDynaset)
Set sdRec = tmpSd.getSeeding
'seedEvent evnum, final, ftoslow
If sdRec.BOF Then
query = "SELECT Entry.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Teams.TeamCode, Entry.SeedTime, Entry.SeedCourse, Entry.Bonus, Results.Resultkey, Results.Scratch, Results.raceType " & _
"FROM ((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Entry.EventKey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And " + sq$

'If ftoslow Then
'    query = query + "ORDER BY Entry.SeedTime DESC, Entry.Bonus;"
'Else
    query = query + "ORDER BY Entry.SeedTime, Entry.Bonus DESC ;"
'End If

query$ = "SELECT Entry.EventKey, Swimmer.Frname, Swimmer.Lname, Swimmer.AgeClass, Teams.TeamCode, Entry.SeedTime, Entry.SeedCourse, Entry.Bonus, Results.ResultKey, Results.Scratch, Results.raceType " & _
"FROM ((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey " & _
"Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2)) " & _
"ORDER BY Entry.SeedTime, Entry.Bonus DESC;"


Set sdRec = db.OpenRecordset(query$, dbOpenDynaset)
openTable
While Not sdRec.EOF
  rec.AddNew
  rec![resultKey] = sdRec![resultKey]
'  rec![racetype] = rtyp
  rec.update
  sdRec.moveNext
Wend
'rec.Close

End If
Set sdRec = tmpSd.getSeeding 'db.OpenRecordset(seedQuery, dbOpenDynaset)
If final Then
  circleSeed sdRec
Else
  straightSeed sdRec, ftoslow, mheats
End If
tmpSd.copyTempSeeding 'put back
'scratch the swimmers in negative heats
 If Not sdRec.BOF Then sdRec.moveFirst
While Not sdRec.EOF
    If sdRec![heat] <= 0 Then
        sdRec.Edit
        sdRec![SCRATCH] = True
        sdRec.update
        'rec.moveNext
    End If
 sdRec.moveNext
Wend
Set getEvent = sdRec
End Function
Public Sub deleteSeeding(evnum As Integer)
Dim qry$, srec As Recordset, skey As Long

qry$ = "SELECT Seeding.SeedKey, Entry.EventKey " & _
"FROM Entry INNER JOIN (Seeding INNER JOIN Results ON Seeding.ResultKey = Results.ResultKey) ON Entry.Entrykey = Results.Entrykey " & _
"WHERE (((Entry.EventKey)=" + Str$(evnum) + "));"
Set srec = db.OpenRecordset(qry$, dbOpenDynaset)
While Not srec.EOF
  skey = srec![seedKey]
  deleteSeed skey
  srec.moveNext
Wend
End Sub
Private Sub deleteSeed(skey As Long)
rec.Index = "seedkey"
rec.Seek "=", Str$(skey)
If Not rec.NoMatch Then
  rec.delete
End If

End Sub
Public Function seedEvent(evnum As Integer, final As Boolean, ftoslow As Boolean, maxHeats As Integer) As Recordset

Set rec = getEvent(evnum, final, ftoslow, True, maxHeats)
If final Then
  circleSeed rec
Else
  straightSeed rec, ftoslow, maxHeats
End If
tmpSd.copyTempSeeding 'put back
'scratch the swimmers in negative heats
'scratchNegHeats (evnum)

End Function
Private Sub scratchNegHeats(evnum As Integer)
Dim query$
Dim rec As Recordset
query = "SELECT Swimmer.Frname, Swimmer.Attached, Results.ResultKey, Results.DQ, Results.Place, Swimmer.Lname, Swimmer.AgeClass, Results.Result, Results.Backup, Entry.Points, Teams.TeamCode, Results.Scratch, Results.raceType, Seeding.Heat, Seeding.Lane " & _
"FROM ((Swimmer INNER JOIN (Results INNER JOIN Entry ON Results.Entrykey = Entry.Entrykey) ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"Where (((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2) And ((Entry.eventkey) = " + Str$(evnum) + ") And ((Entry.unofficial) = False)) " & _
"ORDER BY Results.DQ DESC , Results.Result;"

Set rec = db.OpenRecordset(query, dbOpenDynaset)

 If Not rec.BOF Then rec.moveFirst
While Not rec.EOF
    If rec![heat] <= 0 Then
        rec.Edit
        rec![SCRATCH] = True
        rec.update
        'rec.moveNext
    End If
 rec.moveNext
Wend
rec.Close
End Sub
Private Sub straightSeed(rec As Recordset, ftoslow As Boolean, maxHeats As Integer)
Dim count As Long
Dim heat As Integer, lane As Integer, i As Integer
Dim heatmax As Integer

If Not rec.BOF Then
    rec.MoveLast
    rec.moveFirst
End If
count = rec.RecordCount
fullanes = count \ Lanes
getLaneOrder                   'load collection with seed order
lastLanes = count Mod Lanes
'
heat = 1
If Not rec.EOF Then rec.moveFirst

i = 1
heatmax = count \ Lanes
If lastLanes > 0 Then heatmax = heatmax + 1
heat = heatmax
If maxHeats > 0 Then
  heat = maxHeats   'do fewer if max heats specified
End If
While Not rec.EOF
  seedLane rec, heat, laneList(i)
  i = i + 1
  If i > Lanes Then
    heat = heat - 1
    i = 1
  End If
  rec.moveNext
Wend
'now back up if last heat < 3
If lastLanes < 3 And lastLanes > 0 And heatmax > 1 Then
 lastLanes = 1
 rec.MoveLast
' For i = 1 To lastLanes
'   rec.MovePrevious
' Next i
 i = 3
 While lastLanes <= 3 And Not rec.EOF And Not rec.BOF
   rec.Edit
   rec![heat] = 1
   rec![lane] = laneList(i)
   i = i - 1
   rec.update
   lastLanes = lastLanes + 1
   rec.MovePrevious
 Wend

  
End If

'reverse heat numbers if fastest to slowest
If ftoslow Then
If Not rec.BOF Then rec.moveFirst
While Not rec.EOF
  heat = rec![heat]
  rec.Edit
  rec![heat] = heatmax - heat + 1
  rec.update
  rec.moveNext
Wend
End If

End Sub
Public Sub straight_seedRecord(rc As Recordset, ftoslow As Boolean)
Set rec = rc.Clone
Lanes = stp.getLanes
straightSeed rec, ftoslow, 0
End Sub
Private Sub seedLane(rec As Recordset, heat As Integer, lane As Integer)
If Not rec.EOF Then
rec.Edit

rec![heat] = heat
rec![lane] = lane

rec.update
End If
End Sub
Private Sub seedCircleLane(rec As Recordset, ht As Integer, ln As Integer)
'If rec![heat] >= ht Then
  seedLane rec, ht, ln
'End If
End Sub
Private Sub circleSeed(rec As Recordset)
Dim fl As Integer
straightSeed rec, False, 0     'by default
'now see if there are 3 full heats or more
fl = fullanes
If lastLanes > 0 Then
  fl = fl + 1
End If
Select Case fl
  Case Is >= 3
    doCircle rec, 3
  Case 2
    doCircle rec, 2
End Select

End Sub
Private Sub doCircle(rec As Recordset, numHeats As Integer)
Dim H As Integer, i As Integer, heat As Integer
Dim count As Integer
rec.moveFirst
heat = rec![heat]
For i = 1 To Lanes
    For H = 0 To numHeats - 1
        seedCircleLane rec, heat - H, laneList(i)
        If Not rec.EOF Then rec.moveNext
    Next
Next i
rec.MoveLast
rec.moveFirst
count = rec.RecordCount
lastLanes = count Mod Lanes
lastLanes = 0
''Change in 6.14e to find real size of heat 1 after circle
While Not rec.EOF
  If rec![heat] = 1 Then
    lastLanes = lastLanes + 1
  End If
  rec.moveNext
Wend


If lastLanes < 3 And lastLanes > 0 And numHeats > 1 Then
 lastLanes = 1
 rec.MoveLast
' For i = 1 To lastLanes
'   rec.MovePrevious
' Next i
 i = 3
 While lastLanes <= 3 And Not rec.EOF And Not rec.BOF  '<<<<Note this was changed back in 6.6.14d
   rec.Edit
   rec![heat] = 1
   rec![lane] = laneList(i)
   i = i - 1
   rec.update
   lastLanes = lastLanes + 1
   rec.MovePrevious
 Wend
  
End If


End Sub

Private Sub getLaneOrder()
'creates a collection of lane numbers
Dim s$, i As Integer
Dim tk As New Tokenizer

s$ = stp.getLaneOrder
tk.setString s$
Lanes = stp.getLanes
Set laneList = Nothing
Set laneList = New Collection
For i = 1 To Lanes
  laneList.add val(tk.nextToken)
Next i
End Sub
Private Function odd(Num As Integer) As Boolean
odd = ((Num \ 2) * 2) <> Num
End Function
Public Function defaultSeedOrder(numLanes As Integer) As String
Dim s$, clane As Integer, lane As Integer, i As Integer, incr As Integer
s$ = ""

clane = numLanes \ 2
If odd(numLanes) Then clane = clane + 1
lane = clane
i = 1
incr = 1
s$ = Str$(clane) + ","
Do
    lane = clane + incr
    s$ = s$ + Str$(lane) + ","
    i = i + 1
    If incr > 0 Then
      incr = -incr
    Else
      incr = -incr + 1
    End If
Loop Until i = numLanes
s$ = Left$(s$, Len(s$) - 1)
defaultSeedOrder = s$
End Function

Public Function getRecord(evnum As Integer) As Recordset
Dim query$
'rec.Close

query$ = "SELECT Swimmer.Frname, Swimmer.Lname, Swimmer.Attached, Swimmer.AgeClass,Teams.TeamCode, Entry.SeedTime, Seeding.Heat, Seeding.Lane, Entry.EventKey,Entry.Bonus, Entry.Seedcourse, Results.Scratch " & _
"FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey " & _
"Where (((RESULTS.SCRATCH) = False) And ((Entry.EventKey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2)) " & _
"ORDER BY Seeding.Heat, Seeding.Lane;"


Set getRecord = db.OpenRecordset(query$, dbOpenDynaset)
'Set getRecord = tmpSd.getSeeding

End Function
Public Sub addSeed(resultKey As Long, heat As Integer, lane As Integer)
openTable
'If heat > 0 And lane > 0 Then
    rec.AddNew
    rec![resultKey] = resultKey
    rec![heat] = heat
    rec![lane] = lane
    rec.update
'End If
End Sub
Public Function getSeed(rkey As Long) As Recordset
rec.Index = "resultKey"
rec.Seek "=", rkey
Set getSeed = rec
End Function
Public Sub printSeeding(evnum As Integer, pr As clsPrinters)
Dim rec As Recordset, ht As Integer
Dim tm As New times, fheat As Integer, fheats As Integer
Dim prpage As New printPage
Dim crs As New course

'ev.setDB db
'ev.openTable

prpage.setPrinter pr
ev.getEvent evnum
prpage.setHeader "Event " + Str$(evnum) + " -- " + ev.getEventString(False), Time$
prpage.setFont pr, 0

Set rec = getRecord(evnum)
rec.MoveLast
fheats = 0
fheat = 0
If Not ev.final Then
    fheats = ev.Finalheats
    If Not rec.EOF Then
          fheat = rec![heat]
    End If
End If
rec.moveFirst

ht = 0
While Not rec.EOF
  If ht <> rec![heat] Then
    ht = rec![heat]
    'pr.testPage stp.getLanes + 2
    prpage.setFont pr, 1
    prpage.lPrintcr "", 1
    prpage.setFont pr, 1
    If ht = fheats Then
        prpage.lPrintcr "Swum at Finals", 0
    End If
    prpage.lPrintcr "Heat" + Str$(ht), 1
    'prpage.setFont pr, 1
  End If
  prpage.setFont pr, 0
  prpage.lPrint Str$(rec![lane]), 1
  prpage.lPrint rec![Frname] + " " + rec![Lname], 4
  prpage.lPrint rec![teamcode], 20
  If Not rec![SCRATCH] Then
    tm.setSingle rec![seedTime]
    prpage.lPrint tm.getFormatted, 27
    If rec![bonus] Then prpage.lPrint "B", 36
    If rec![seedCourse] <> mt.coursekey Then
        prpage.lPrint crs.getShortCourseString(rec![coursekey]), 37
    End If
  Else
    prpage.lPrint "Scratch", 27
  End If
  prpage.lPrintcr "", 38
  rec.moveNext
 Wend
 rec.Close
 prpage.endDoc
End Sub
Public Function getScoreBoardSeeding(evnum As Integer, prelim As Boolean)
Dim qry$
Dim sdRec As Recordset
If prelim Then
qry = "SELECT Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Seeding.Heat, Entry.EventKey, Seeding.Lane, Entry.SeedTime, Results.Scratch, Results.raceType " & _
"FROM (((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2)) " & _
"ORDER BY Seeding.Heat, Seeding.Lane;"
Else
qry = "SELECT Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Seeding.Heat, Entry.EventKey, Seeding.Lane, Entry.SeedTime, Results.Scratch, Results.raceType " & _
"FROM (((Swimmer INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
"Where (((Entry.eventkey) = " + Str$(evnum) + ")and (seeding.heat>0) and(seeding.lane<=10) And ((RESULTS.SCRATCH) = False) And ((RESULTS.racetype) = 3)) " & _
"ORDER BY Seeding.Heat, Seeding.Lane;"

End If
Set getScoreBoardSeeding = db.OpenRecordset(qry, dbOpenDynaset)

End Function
Public Sub writeSeedFile(evnum As Integer, filename$)
Dim f As Integer, lane As Integer, heat As Integer, i As Integer
Dim sdRec As Recordset
Set sdRec = getScoreBoardSeeding(evnum, True)
f = FreeFile
Open filename For Output As #f
ev.setEventKey evnum
Print #f, Trim$(Str$(evnum)) + " " + ev.getEventString(False)
heat = 1
While Not sdRec.EOF
For i = 1 To 10
 If Not sdRec.EOF Then
   If sdRec![lane] = i And sdRec![heat] = heat Then
    Print #f, getName(sdRec); Tab(23); sdRec![teamcode]
    If Not sdRec.EOF Then sdRec.moveNext
   Else
     Print #f,
     If sdRec![lane] = 0 Then sdRec.moveNext
   End If
  End If
Next i
heat = heat + 1
Wend
sdRec.Close
Close #f
End Sub
Public Sub writeSeedFileFromRec(sdRec As Recordset, evnum As Integer, filename$)
Dim f As Integer, lane As Integer, heat As Integer, i As Integer

f = FreeFile
Open filename For Output As #f
'ev.setDB db
'ev.openTable
ev.setEventKey evnum
Print #f, Trim$(Str$(evnum)) + " " + ev.getEventString(False)
heat = 1
sdRec.moveFirst
While Not sdRec.EOF
For i = 1 To 10
 If Not sdRec.EOF Then
   If sdRec![lane] = i And sdRec![heat] = heat Then
    Print #f, getName(sdRec); Tab(23); sdRec![teamcode]
    If Not sdRec.EOF Then sdRec.moveNext
   Else
     Print #f,
   End If
   'If Not sdrec.EOF Then sdrec.MoveNext
  End If
 
Next i
heat = heat + 1
Wend
'sdRec.Close
Close #f
End Sub
Private Function getName(sdRec As Recordset) As String
Dim fr$, ln$, nm$
fr$ = Trim$(sdRec![Frname])
ln$ = Trim$(sdRec![Lname])
nm$ = fr$ + " " + ln$
nm$ = ln + ", " + fr$
If Len(nm$) > 20 Then
   nm = Left$(Left$(fr, 1) + " " + ln, 20)
   nm$ = Left$(nm$, 20)
End If
getName = nm
End Function
Public Sub printTimers(evnum As Integer, finalflag As Boolean, pr As clsPrinters, semiFinals As Boolean)
Dim query$, rec As Recordset, lane As Integer, heat As Integer
Dim tim As New times, Quit As Boolean
Dim prpage As New printPage

'prpage.setPrinter pr
ev.getEvent evnum
'prpage.setHeader "", ""
'print out one lane per sheet
pr.setPageNum 1
For lane = 1 To stp.getLanes
 If finalflag Then
 query = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Scratch, Teams.TeamCode, Entry.SeedTime, Results.ResultKey, Seeding.Lane, Seeding.Heat " & _
 "FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
 "Where (((RESULTS.SCRATCH) = False) And ((Entry.seedTime) > 0) And ((Seeding.lane) = " + Str$(lane) + ") And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 3)) " & _
  "ORDER BY Seeding.Heat;"
  
 query$ = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Scratch, Teams.TeamCode, Entry.SeedTime, Results.ResultKey, Seeding.Lane, Seeding.Heat, Results.Result, Results_1.Result, Results_1.raceType " & _
"FROM Results AS Results_1 INNER JOIN ((((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) ON Results_1.Entrykey = Entry.Entrykey " & _
"Where (((RESULTS.SCRATCH) = False) And ((Entry.seedTime) > 0) And ((Seeding.lane) = " + Str$(lane) + ") And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 3) And ((Results_1.racetype) = 2)) " & _
"ORDER BY Seeding.Heat;"
query = "SELECT Swimmer.Frname, Swimmer.Lname, Teams.TeamCode, Entry.EventKey, Results.raceType, Seeding.Heat, Seeding.Lane, Results_1.raceType, Results.Result " & _
"FROM ((((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Results AS Results_1 ON Entry.Entrykey = Results_1.Entrykey) INNER JOIN Seeding ON Results_1.ResultKey = Seeding.ResultKey " & _
"Where (((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2) And ((Seeding.lane) = " + Str$(lane) + ") And ((Results_1.racetype) = 3) And ((RESULTS.SCRATCH) = False)) " & _
"ORDER BY Seeding.Heat;"

 
 Else
 query = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Scratch, Teams.TeamCode, Entry.SeedTime, Results.ResultKey, Seeding.Lane, Seeding.Heat " & _
 "FROM (((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey " & _
 "Where (((RESULTS.SCRATCH) = False) And ((Entry.seedTime) > 0) And ((Seeding.lane) = " + Str$(lane) + ") And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 1 Or (RESULTS.racetype) = 2)) " & _
  "ORDER BY Seeding.Heat;"
 End If
 
 If semiFinals Then
 query$ = "SELECT Swimmer.Frname, Swimmer.Lname, Results.Scratch, Teams.TeamCode, Entry.SeedTime, Results.ResultKey, Seeding.Lane, Seeding.Heat, Results.Result, Results_1.Result, Results_1.raceType " & _
"FROM Results AS Results_1 INNER JOIN ((((Swimmer INNER JOIN Entry ON Swimmer.SwimmerKey = Entry.SwimmerKey) INNER JOIN Results ON Entry.Entrykey = Results.Entrykey) INNER JOIN Teams ON Swimmer.TeamKey = Teams.TeamKey) INNER JOIN Seeding ON Results.ResultKey = Seeding.ResultKey) ON Results_1.Entrykey = Entry.Entrykey " & _
"Where (((RESULTS.SCRATCH) = False) And ((Entry.seedTime) > 0) And ((Seeding.lane) = " + Str$(lane) + ") And ((Entry.eventkey) = " + Str$(evnum) + ") And ((RESULTS.racetype) = 3) And ((Results_1.racetype) = " + Str$(rtype.SemiFinal) + ")) " & _
"ORDER BY Seeding.Heat;"
 End If
  Set rec = db.OpenRecordset(query$, dbOpenDynaset)
    prpage.setFont pr, 2
    pr.setHeaderFont
    pr.lPrintcr "" 'leave room for clipboard clip
    pr.lPrintcr ""
    pr.YInch = 2#
    If finalflag Then
        pr.Centerit "Lane " + Str$(lane) + " -- Final " + Str$(evnum) + " -- " + ev.getEventString(False)
    Else
        pr.Centerit "Lane " + Str$(lane) + " -- Event " + Str$(evnum) + " -- " + ev.getEventString(False)
    End If
    
    pr.setPageFont
    pr.lPrintcr ""
    pr.lPrintcr ""

    Quit = rec.EOF
    
    'While rec![lane] = lane And Not rec.EOF
    heat = 1
    While Not Quit
        While heat < rec![heat]
          pr.lPrintcr Str$(heat)
          pr.Tabbit 42
          'pr.lPrintcr "_______________   _____________  _____________"
          pr.lPrintcr ""
          heat = heat + 1
        Wend
        If rec![lane] = lane Then
        pr.lPrint Str$(rec![heat]) + " " + rec![Frname] + " " + rec![Lname]
        pr.Tabbit 25
        pr.lPrint rec![teamcode]
        If finalflag Then
            tim.setSingle rec![result]
        Else
            tim.setSingle rec![seedTime]
        End If
        pr.Tabbit 32
        pr.lPrint tim.getFormatted
        pr.Tabbit 42
        pr.lPrintcr "_______________   _____________  _____________"
        pr.lPrintcr ""
        End If
        heat = heat + 1
        rec.moveNext
        Quit = rec.EOF
        If Not Quit Then
            Quit = (rec![lane] <> lane)
        End If
    Wend
    rec.Close
    pr.newPage
Next lane
pr.endDoc

End Sub


