VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Colorado"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private Const BUFINPUT = True
Private c As C4000, c4dat As C4000
'Private useport(2) As Integer
'Private comport(2) As Integer
'Private curport As Integer
Private Lanes As Integer
Dim mres() As Single, mbackups() As Single
Dim stp As New SetupData
Private dateString As String
Private racenumber As Integer
Private comm As MSComm      'referece to comm control
Private connected As Boolean
Private sessionList As New Collection
Private evNum As Integer
Private heat As Integer
Private busy As Boolean
Private error_code As Integer, errorFlag As Boolean
Private splits As New Collection
Public Function GetRace(evNum As Integer, heat As Integer) As Boolean
Dim length As Integer
length = GetCurrentRace(dateString, heat, evNum)
GetRace = (length > 2) Or Not connected
End Function
Public Function setCom(cm As MSComm) As String
Dim version$, length As Integer
Set comm = cm
On Local Error GoTo nocom
If connected And comm.PortOpen Then
  comm.PortOpen = False
End If
connected = True
comm.Settings = "9600,O,8,1"
'comm.CommPort = 2
comm.PortOpen = True      'open the port
comm.Output = makecmd$("W")      'issue Who Are you- get colo version#
version$ = getColComd$(length)
setCom = version$
stex:
  setCom = "Error"
 Exit Function
nocom:
  Resume stex
End Function
Public Function getTimes(i As Integer) As Single
getTimes = mres(i)
End Function
Public Function getBackup(i As Integer) As Single
getBackup = mres(i)
End Function
Public Function getRaceNumber() As Integer
getRaceNumber = racenumber
End Function
Private Function filltimes(dtstr$, times() As Single, backups() As Single, racenumber As Integer)
'Dim c4dat As C4000
Dim length As Integer, s$, i As Integer, place As Integer
Dim start As Single, this As Single, clanes As Integer
'--------------------------------------------------------------------------
 'The Colorado 4000 returns
'a 2-byte count (low byte first)
'a 47-byte race header described by the structure C4000
'For each lane it returns
'  a 1-byte place
'  one or more times as 4-byte long integers in units of 10000ths of a sec
'  If splits are requested, they come first, with the final time the last split
'  If backups are requested, they follow
'--------------------------------------------------------------------------
  'start = Timer
  'this = start
  'While (this - start) < .5
  '  this = Timer
  'Wend
  s$ = getColComd$(length)

  If (length >= Len(c4dat)) Then
      getstruct s$          'into c4dat
     dtstr$ = makedatestring$       'into c4dat
     racenumber = c4dat.racenumber
    clanes = Asc(c4dat.Lanes)
    If clanes > stp.getLanes Then
      clanes = stp.getLanes
    End If
    For i = 1 To clanes
      place = getPlace(s$)
      times(i) = getTime(s$)
      backups(i) = getTime(s$)
    Next i
  End If
filltimes = length      'error return if 0

End Function
Private Sub fixtime(i As Integer, nswim As Integer, times() As Single, backups() As Single)
'----------------------------------------------------------------
'This routine performs time corrections according to USS rules
'It determines the avereage of differences between primary (pad times)
'and one-button backup times. If any differences are > 0.3 sec
'the average difference between the pad and button times in the
'other lanes are added to the button time to obtain the
'corrected pad time.
'If there are no "good" lanes you are instructed to look at the
'watch times for confirmation of the pad times.
'----------------------------------------------------------------
Dim j As Integer, difcnt As Integer
Dim difsum, diff, Correct, ans
   difsum = 0
   difcnt = 0
   For j = 1 To nswim
     If times(j) > 0 And backups(j) > 0 Then
       diff = makesecs(times(j)) - makesecs(backups(j))
       If Abs(diff) <= 0.3 Then
         difsum = difsum + diff
         difcnt = difcnt + 1
       End If
     End If
   Next j
If difcnt > 0 Then
   Correct = difsum / difcnt
Else
   Correct = 0
End If

If (times(i) > 0 And backups(i) > 0) And Abs(makesecs(times(i)) - makesecs(backups(i))) > 0.3 Then 'And correct <> 0 Then
   Dim bl As Long, cl As Long, tl As Long
     bl = backups(i) * 100
     cl = Fix(Correct * 100)
   ans = MsgBox("Correct lane" + Str$(i) + " by adding " + Format$(cl / 100, "#.00") + " to " + Format$(backups(i), "####.00"), vbYesNo, "Pad correction")
   If ans = vbYes Then
     tl = bl + cl
       'times(i) = backups(i) + correct
       times(i) = tl / 100
   Else
      'backups(i) = times(i)
   End If

End If

If (times(i) > 0 And backups(i) > 0) And difcnt <= 1 Then
    Beep
    ans = MsgBox("There are not enough lanes with differences <= 0.3 sec to calculate from" + Chr$(13) + "Compare pads to watch times to determine if corrections are needed")
    
End If

If (backups(i) > 0) And times(i) = 0 Then
   ans = MsgBox("Correct pad by" + Format$(Correct, "#.00"), vbYesNo, "Pad correction")
    If ans = vbYes Then
       times(i) = backups(i) + Correct
    End If
End If

If (times(i) > 0 And backups(i) = 0) Then
   ans = MsgBox("No backup: Compare pad time with watch times!")
End If

End Sub
Public Function isBusy() As Boolean
isBusy = busy
End Function
Public Function GetCurrentRace(dateString$, heat As Integer, evNum As Integer)
Dim c4dat As C4000, errval As Integer
Dim length As Integer, place As Integer, cmd$, newdate As String

   cmd$ = "SBE" + Chr$(heat) + Chr$(evNum)
   ' length = filltimes(dtstr$, times(), backups(), racenumber)
    Call sendColComd(cmd$)
    length = filltimes(dateString$, mres(), mbackups(), racenumber)
    If (length <= 6) Then
      newdate = prevSession
      Do
        sendColComd cmd$
        length = filltimes(dateString$, mres(), mbackups(), racenumber)
      Loop Until length > Len(c4dat) Or dateString = newdate Or length = 0
      If length <= 6 Then
        newdate = nextSession
        Do
          sendColComd cmd$
          length = filltimes(dateString$, mres(), mbackups(), racenumber)
        Loop Until length > Len(c4dat) Or dateString = newdate Or length = 0
     End If
     End If
    GetCurrentRace = length       'error return if 0
End Function
Public Function GetNextRace() As Integer
Dim c4dat As C4000
Dim length As Integer, comd$, errval As Integer

  Call sendColComd("SBN")
  length = filltimes(dateString$, mres(), mbackups(), racenumber)
  GetNextRace = length       'error return if 0

End Function

Private Function getPlace(s$)
Dim place As Integer, length As Integer
If Len(s$) > 0 Then
  place = Asc(s$)
  length = Len(s$)
  s$ = Right$(s$, length - 1)
Else
  place = 0
End If
getPlace = place
End Function

Public Function GetPreviousRace() As Integer
Dim c4dat As C4000
Dim length As Integer, comd$, errval As Integer

  Call sendColComd("SBL")
  length = filltimes(dateString$, mres(), mbackups(), racenumber)
  GetPreviousRace = length       'error return if 0

End Function

Public Function GetRaceByNumber(rNum As Integer) As Integer
Dim c4dat As C4000
Dim length As Integer, low As Integer, high As Integer, rc$
Dim racenumber As Integer, comd$, errval As Integer

  'rc$ = InputBox$("Enter race number")
  'If Len(rc$) > 0 Then
   '  raceNumber = val(rc$)
         low = rNum Mod 256
         high = rNum \ 256
         comm.Output = makecmd$("SBR" + Chr$(low) + Chr$(high))
         length = filltimes(dateString$, mres(), mbackups(), racenumber)
         GetRaceByNumber = length       'error return if 0
     


End Function

Public Sub readSplits()
Dim length As Integer
Dim splitString$
  Call sendColComd("SSC")
  splitString$ = getColComd(length)
  savesplits splitString
End Sub
Public Function getSplits(lane As Integer) As Collection
On Local Error GoTo nosplits
Set getSplits = splits(Str$(lane))
gsexit:
Exit Function

nosplits:
 Set getSplits = New Collection
 'lane = 0
 Resume gsexit
End Function

Private Sub getstruct(s$)
Dim rNum As Single
'-------------------------------------------------------------
' copies values from string into structure and shortens string
'-------------------------------------------------------------
If Len(s$) >= Len(c) Then
c4dat.event = Mid$(s$, 1, 1)
c4dat.heat = Mid$(s$, 2, 1)
c4dat.inbackup = Mid$(s$, 3, 1)
c4dat.insplits = Mid$(s$, 4, 1)
rNum = Asc(Mid$(s$, 6, 1))
rNum = rNum * 256
rNum = rNum + Asc(Mid$(s$, 5, 1))
c4dat.racenumber = rNum Mod 255
c4dat.seconds = Mid$(s$, 7, 1)
c4dat.minutes = Mid$(s$, 8, 1)
c4dat.hours = Mid$(s$, 9, 1)
c4dat.weekday = Mid$(s$, 10, 1)
c4dat.month = Mid$(s$, 11, 1)
c4dat.day = Mid$(s$, 12, 1)
c4dat.year = Mid$(s$, 13, 1)
c4dat.lengths = Mid$(s$, 14, 1)
c4dat.Lanes = Mid$(s$, 15, 1)
c4dat.timesperlane = Mid$(s$, 16, 1)
s$ = Right$(s$, Len(s$) - Len(c4dat))
End If
End Sub

Private Function getTime(s$)

Dim thsec As Long, s4 As String * 4, length As Integer
Dim seconds As Single, minutes As Single, calctime As Single
On Local Error GoTo gterr
length = Len(s$)
s4 = Mid$(s$, 1, 4)             'skip place byte and get 4 time bytes
thsec = Asc(Mid$(s4, 4, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 3, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 2, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 1, 1))
'convert to a long
If Len(s$) >= 4 Then
  s$ = Right$(s$, length - 4)    'strip off 4 bytes
End If
seconds = thsec / 1000
minutes = Int(seconds / 60)
calctime = minutes * 100 + (seconds - 60 * minutes)

gtexit:
getTime = calctime
Exit Function

gterr:
  calctime = 0
  Resume gtexit
End Function


Private Function makedatestring$()
Dim dtstr$, min$, sec$
'     dtstr$ = "Race#" + Str$(c4dat.raceNumber) + " "
'     dtstr$ = dtstr$ + "Event:" + Str$(Asc(c4dat.event)) + " Heat:" + Str$(Asc(c4dat.heat))
heat = Asc(c4dat.heat)
evNum = Asc(c4dat.event)
racenumber = c4dat.racenumber
     dtstr$ = dtstr$ + Str$(Asc(c4dat.month)) + "/" + LTrim$(Str$(Asc(c4dat.day))) + "/" + LTrim$(Str$(Asc(c4dat.year)))
     sec$ = LTrim$(Str$(Asc(c4dat.minutes)))
     If Len(sec$) < 2 Then sec$ = "0" + sec$
     min$ = LTrim$(Str$(Asc(c4dat.seconds)))
     If (Len(min$) < 2) Then min$ = "0" + min$
     dtstr$ = dtstr$ + "  " + Str$(Asc(c4dat.hours)) + ":" + sec$ + ":" + min$
makedatestring$ = dtstr$
End Function

Private Function makesecs(t)
Dim minutes, seconds
  minutes = t \ 100
  seconds = t - (minutes * 100)
makesecs = minutes * 60 + seconds
End Function
Private Sub savesplits(s$)
Dim i As Integer, Lanes As Integer, place As Integer, length As Integer
Dim tlane As Integer, heat As Integer, j As Integer, tl As Integer
Dim t, spldim  As Integer, tlmax As Integer
spldim = 16
Dim split As SPLITREC
Dim rsplitmax As Integer, k As Integer
Dim rsplits As New Collection
tlmax = 0       'maximum number of splits sent for any lane


If Len(s$) > Len(c4dat) Then
  getstruct s$     'into c4dat
  Lanes = Asc(c4dat.Lanes)
  heat = Asc(c4dat.heat)
  Set splits = Nothing
  Set splits = New Collection
  For i = 1 To Lanes
    place = getPlace(s$)
    tlane = Int(Asc(c4dat.timesperlane))    'total lanes sent
    Set rsplits = Nothing
    Set rsplits = New Collection
    'replace one set or other with new ones
    k = 1
    For j = 1 To tlane
      t = getTime(s$)
      If t <> 0 Then
            rsplits.add t
            k = k + 1
      End If
    Next j
    rsplitmax = k - 1
    splits.add rsplits, Str$(i)
    Next i
End If

End Sub


Private Sub Class_Initialize()
'useport(1) = 1
'useport(2) = 2
Lanes = stp.getLanes
ReDim mres(Lanes) As Single, mbackups(Lanes) As Single
End Sub
Public Sub sendColComd(cmd$)
Dim ans As Integer, com$, version$, length As Integer
Dim comadd As Integer, offset, a As Single, b As Single
On Local Error GoTo scolerr

If connected Then

  '''If comm.PortOpen Then      'open the port
'''     comm.PortOpen = False     'close the port
  '''End If
  'comm.CommPort = useport(curport) 'md.comport(md.curport)
  'Open com$ + ":9600,n,8,1" For Random As #md.comport(md.curport) Len = 2048
  'OUT &H3FB, &HB          'program chip to odd parity, 8 bits, 1 stop bit
  'OUT comadd, &HB          'program chip to odd parity, 8 bits, 1 stop bit
  '''comm.Settings = "9600,O,8,1"
  '''comm.PortOpen = True      'open the port
  'comm.Output = makecmd$("W")      'issue Who Are you- get colo version#
  'version$ = getcolcomd$(length)
  '''connected = True
  '''TimingSystem.showStatus version$
  'd.comport(md.curport) = md.useport(1)
End If
If connected Then
comm.Output = makecmd$(cmd$)
End If

scolexit:
Exit Sub

'error handler for COM ports
scolerr:
 If connected Then
  ans = MsgBox("Error " + Str$(Err) + " communicating with Colorado-4000")
 End If
  'close #md.comport(md.curport)
  Resume scolexit

End Sub
Public Function prevSession() As String
Dim length As Integer

sendColComd ("M-")
getstruct getColComd(length)
prevSession = makedatestring

End Function
Public Function nextSession() As String
Dim length As Integer

sendColComd ("M-")
getstruct getColComd(length)
nextSession = makedatestring

End Function

Public Function getSessions() As Collection
Dim dt$, ses$
Set sessionList = Nothing
Set sessionList = New Collection
dt$ = prevSession
dt$ = getRaceString
sessionList.add dt$

ses$ = prevSession
ses$ = getRaceString
While ses$ <> dt$
  sessionList.add ses$
  ses$ = prevSession
  ses$ = getRaceString
Wend
Set getSessions = sessionList

End Function
Public Sub moveToSession(Sesname$)
Dim ses$
ses$ = prevSession
ses$ = getRaceString
While ses$ <> Sesname$
    ses$ = prevSession
    ses = getRaceString
Wend
End Sub
Public Function getDateString() As String
getDateString = makedatestring
End Function
Public Function getRaceString() As String
getRaceString = getDateString + " Race#:" + Str$(racenumber) + " Event:" + Str$(evNum) + " Heat:" + Str$(heat)
End Function
Public Function getEventNumber() As Integer
getEventNumber = evNum
End Function
Public Function getHeatNumber() As Integer
getHeatNumber = heat
End Function
Public Function getNextRaceString() As String
Dim s$, length As Integer
sendColComd "SN"
s$ = getColComd$(length)
getstruct s$
getNextRaceString = getRaceString
End Function
Public Function getPrevRaceString() As String
Dim s$, length As Integer
sendColComd "SL"
s$ = getColComd$(length)
getstruct s$
getPrevRaceString = getRaceString

End Function
Private Function makecmd$(comd$)

Dim checkword As Long, high As String * 1, low As String * 1
Dim count As Integer, buf$, k As Integer, i As Integer, j As Integer

count = Len(comd$)
buf$ = "  " + comd$ + "  " 'add in length and check bytes spaces
k = Len(buf$)
Mid$(buf$, 1, 1) = Chr$(k Mod 256)      'put in count bytes
Mid$(buf$, 2, 1) = Chr$(k \ 256)

'now calculate check word
checkword = &HFFFF
i = 1
While (i <= Len(buf$) - 2)
  checkword = checkword - Asc(Mid$(buf$, i, 1))
  i = i + 1
Wend

j = ((checkword And &HFF00) \ 256) And &HFF
high = Chr$(j)
low = Chr$(checkword And &HFF)

Mid$(buf$, k - 1, 1) = low
Mid$(buf$, k, 1) = high

makecmd$ = buf$                 'return command string
'FOR i = 1 TO LEN(buf$)
'  PRINT HEX$(ASC(MID$(buf$, i, 1)))
'NEXT i
'INPUT a

End Function

Public Function getColComd$(length As Integer)
'--------------------------------------------------------------------------
'The Colorado System 4000 command set assumes that you sent a 2-byte integer
'containing the total; number of bytes, followed by the command string
'followed by a 2-byte check word, where each of the bytes are successively
'subtracted from &hffff
'It returns data with the same count and checksum characteristics
'Every command except the "W" (who are you)_ command returns a 47-byte
'race header of the type C4000
'If times follow, they are 4-byte numbers in lane order as long integers
'in units of 10000ths of a second.
'--------------------------------------------------------------------------
Dim low As String * 1, high As String * 1
Dim count As Long, OK As Integer, st$, i As Integer
Dim ans As Integer, comport As Integer, c4k As C4000
Dim start As Single
'comport = useport(curport)

'On Local Error GoTo colerr
If Not busy Then
OK = False
length = 0
start = Timer
busy = True
'Screen.MousePointer = vbHourglass
Do
  ans = DoEvents()
Loop Until (comm.InBufferCount >= 2) Or ((Timer - start) > 2)
'Screen.MousePointer = vbDefault
If comm.InBufferCount >= 2 Then
   comm.InputLen = 1
   low = comm.Input
   high = comm.Input
   count = Asc(high) * 256 + Asc(low)
   'Debug.Print comm.InBufferCount, count
   If count > 2 Then
     st$ = Space$(count - 2)
   End If
   If count = 6 Then    'this means an error
    errorFlag = True
   Else
    errorFlag = False
   End If
   #If BUFINPUT Then
    comm.InputLen = 0
   #Else
    comm.InputLen = 1
   #End If
   'st$ = comm.Input
#If BUFINPUT Then
  st$ ""
  Do
   st$ = st$ + comm.Input
   ans = DoEvents
  Loop Until Len(s$) >= count
#Else
   Do
     ans = DoEvents()
   Loop Until comm.InBufferCount >= (count - 2)

   For i = 1 To count - 2
      low = comm.Input
     Mid$(st$, i, 1) = low
   Next i
#End If
   If Len(st$) >= 2 Then
     st$ = Left$(st$, Len(st$) - 2)
     length = Len(st$)
     getColComd$ = st$
     OK = True
   Else
     getColComd$ = ""
     length = 0
   End If
Else
  getColComd$ = ""
  length = 0
End If
'Loop Until ok
colexit:
  busy = False
  End If
  Exit Function
colerr:
 Select Case Err
  Case 25, 57
   ans = MsgBox("Communication lost with timing system, check cables")
  Case Else
    ans = MsgBox("Run time error #" + Str$(Err) + " in Get ColComd")
End Select
Resume colexit

End Function

