VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ColoTimer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Implements TimingSys
Private Const BUFINPUT = True
Private c As C4000, c4dat As C4000
'Private useport(2) As Integer
'Private comport(2) As Integer
'Private curport As Integer
Private Lanes As Integer
Dim mres() As Single, mbackups() As Single
Dim stp As New SetupData
Private dateString As String
Private raceNumber As Integer
Private comm As MSComm      'referece to comm control
Private connected As Boolean
Private sessionList As New Collection
Private evnum As Integer
Private heat As Integer
Private busy As Boolean
Private error_code As Integer, errorFlag As Boolean
Private splits As New Collection
Private db As Database
Private dbg As New Dbgr

Private Sub Class_Initialize()
ReDim mres(10) As Single
ReDim mbackups(10) As Single
connected = False
End Sub

Private Sub TimingSys_DownLoadEvents(mt As Meet)
CResult.setColorado Me
CResult.setDB db
CResult.Show vbModal
End Sub

Private Function TimingSys_getBackup(i As Integer) As Single
TimingSys_getBackup = mbackups(i)
End Function

Private Function TimingSys_getCommand(length As Integer) As String
TimingSys_getCommand = getColComd(length)
End Function

Private Function TimingSys_GetCurrentRace(dateString As String, heat As Integer, evnum As Integer) As Variant
Dim c4dat As C4000, errval As Integer
Dim length As Integer, place As Integer, cmd$, newdate As String

   cmd$ = "SBE" + Chr$(heat) + Chr$(evnum)
   ' length = filltimes(dtstr$, times(), backups(), racenumber)
    Call sendColComd(cmd$)
    length = filltimes(dateString$, mres(), mbackups(), raceNumber)
    If (length <= 6) Then
      newdate = TimingSys_prevSession
      Do
        sendColComd cmd$
        length = filltimes(dateString$, mres(), mbackups(), raceNumber)
      Loop Until length > Len(c4dat) Or dateString = newdate Or length = 0 Or length = 2
      If length <= 6 Then
        newdate = TimingSys_nextSession
        Do
          sendColComd cmd$
          length = filltimes(dateString$, mres(), mbackups(), raceNumber)
        Loop Until length > Len(c4dat) Or dateString = newdate Or length = 0 Or length = 2
     End If
     End If
    TimingSys_GetCurrentRace = length       'error return if 0

End Function

Private Function TimingSys_getDateString() As String
TimingSys_getDateString = makedatestring
End Function

Private Function TimingSys_getEventNumber() As Integer
TimingSys_getEventNumber = evnum
End Function

Private Function TimingSys_getHeatNumber() As Integer
TimingSys_getHeatNumber = heat
End Function

Private Function TimingSys_GetNextRace() As Integer
Dim c4dat As C4000
Dim length As Integer, comd$, errval As Integer

  Call sendColComd("SBN")
  length = filltimes(dateString$, mres(), mbackups(), raceNumber)
  TimingSys_GetNextRace = length       'error return if 0


End Function

Private Function TimingSys_getNextRaceString() As String
Dim s$, length As Integer
sendColComd "SN"
s$ = getColComd$(length)
getstruct s$
TimingSys_getNextRaceString = TimingSys_getRaceString

End Function

Private Function TimingSys_GetPreviousRace() As Integer
Dim c4dat As C4000
Dim length As Integer, comd$, errval As Integer

  Call sendColComd("SBL")
  length = filltimes(dateString$, mres(), mbackups(), raceNumber)
  TimingSys_GetPreviousRace = length       'error return if 0

End Function

Private Function TimingSys_getPrevRaceString() As String
Dim s$, length As Integer
sendColComd "SL"
s$ = getColComd$(length)
getstruct s$
TimingSys_getPrevRaceString = TimingSys_getRaceString

End Function

Private Function TimingSys_GetRace(evnum As Integer, heat As Integer) As Boolean
Dim length As Integer
length = TimingSys_GetCurrentRace(dateString, heat, evnum)
TimingSys_GetRace = (length > 2) Or Not connected

End Function

Private Function TimingSys_GetRaceByNumber(rNum As Integer) As Integer
Dim c4dat As C4000
Dim length As Integer, low As Integer, high As Integer, rc$
Dim comd$, errval As Integer

  'rc$ = InputBox$("Enter race number")
  'If Len(rc$) > 0 Then
   '  raceNumber = val(rc$)
         low = rNum Mod 256
         high = rNum \ 256
         comm.Output = makecmd$("SBR" + Chr$(low) + Chr$(high))
         length = filltimes(dateString$, mres(), mbackups(), raceNumber)
         TimingSys_GetRaceByNumber = length       'error return if 0

End Function

Private Function TimingSys_getRaceNumber() As Integer
TimingSys_getRaceNumber = raceNumber
End Function

Private Function TimingSys_getRaceString() As String
TimingSys_getRaceString = getDateString + " Race#:" + Str$(raceNumber) + " Event:" + Str$(evnum) + " Heat:" + Str$(heat)
End Function

Private Function TimingSys_getSessions() As Collection
Dim dt$, ses$
Set sessionList = Nothing
Set sessionList = New Collection
dt$ = TimingSys_prevSession
dt$ = TimingSys_getRaceString
sessionList.add dt$

ses$ = TimingSys_prevSession
ses$ = TimingSys_getRaceString
While ses$ <> dt$
  sessionList.add ses$
  ses$ = TimingSys_prevSession
  ses$ = TimingSys_getRaceString
Wend
Set TimingSys_getSessions = sessionList

End Function

Private Function TimingSys_getSplits(lane As Integer) As Collection
On Local Error GoTo nosplits
Set TimingSys_getSplits = splits(Str$(lane))
gsexit:
Exit Function

nosplits:
 Set TimingSys_getSplits = New Collection
 'lane = 0
 Resume gsexit

End Function

Private Function TimingSys_getThisRace() As Variant
Dim c4dat As C4000
Dim length As Integer, comd$, errval As Integer

  'Call sendColComd("SBC")
  sendColComd "SBE" + Chr$(heat) + Chr$(evnum)
  length = filltimes(dateString$, mres(), mbackups(), raceNumber)
  TimingSys_getThisRace = length       'error return if 0

End Function

Private Function TimingSys_getTimerName() As String
TimingSys_getTimerName = "Colorado IV or V"
End Function

Private Function TimingSys_getTimes(i As Integer) As Single
TimingSys_getTimes = mres(i)
End Function

Private Function TimingSys_hasSessions() As Boolean
TimingSys_hasSessions = True
End Function

Private Function TimingSys_isBusy() As Boolean
TimingSys_isBusy = busy
End Function

Private Sub TimingSys_moveToSession(Sesname As String)
Dim ses$
ses$ = TimingSys_prevSession
ses$ = TimingSys_getRaceString
While ses$ <> Sesname$
    ses$ = TimingSys_prevSession
    ses = TimingSys_getRaceString
Wend

End Sub

Private Function TimingSys_nextSession() As String
Dim length As Integer

sendColComd ("M+")
getstruct getColComd(length)
TimingSys_nextSession = makedatestring

End Function

Private Function TimingSys_prevSession() As String
Dim length As Integer

sendColComd ("M-")
getstruct getColComd(length)
TimingSys_prevSession = makedatestring

End Function

Private Sub TimingSys_readSplits()
Dim length As Integer, low As Integer, high As Integer
Dim splitString$
low = raceNumber Mod 256
high = raceNumber \ 256
'         comm.Output = makecmd$("SSR" + Chr$(low) + Chr$(high))

 Call sendColComd("SSC")
  splitString$ = getColComd(length)
  dbg.printLn Str$(Len(splitString)) + ":" + splitString
  savesplits splitString

End Sub

Private Sub TimingSys_sendCommand(s As String)
sendColComd s
End Sub

Private Function TimingSys_setCom(cm As MSCommLib.IMSComm) As String
Dim version$, length As Integer
Set comm = cm
On Local Error GoTo nocom
If connected And comm.PortOpen Then
  comm.PortOpen = False
End If
connected = True
comm.Settings = "9600,O,8,1"
'comm.CommPort = 2
If Not comm.PortOpen Then
    comm.PortOpen = True       'open the port
End If
comm.Output = makecmd$("W")      'issue Who Are you- get colo version#
version$ = getColComd$(length)
TimingSys_setCom = version$
stex:
  TimingSys_setCom = "Error"
 Exit Function
nocom:
  Resume stex

End Function
Private Function makecmd$(comd$)

Dim checkword As Long, high As String * 1, low As String * 1
Dim count As Integer, buf$, k As Integer, i As Integer, j As Integer

count = Len(comd$)
buf$ = "  " + comd$ + "  " 'add in length and check bytes spaces
k = Len(buf$)
Mid$(buf$, 1, 1) = Chr$(k Mod 256)      'put in count bytes
Mid$(buf$, 2, 1) = Chr$(k \ 256)

'now calculate check word
checkword = &HFFFF
i = 1
While (i <= Len(buf$) - 2)
  checkword = checkword - Asc(Mid$(buf$, i, 1))
  i = i + 1
Wend

j = ((checkword And &HFF00) \ 256) And &HFF
high = Chr$(j)
low = Chr$(checkword And &HFF)

Mid$(buf$, k - 1, 1) = low
Mid$(buf$, k, 1) = high

makecmd$ = buf$                 'return command string
'FOR i = 1 TO LEN(buf$)
'  PRINT HEX$(ASC(MID$(buf$, i, 1)))
'NEXT i
'INPUT a

End Function

Public Function getColComd$(length As Integer)
'--------------------------------------------------------------------------
'The Colorado System 4000 command set assumes that you sent a 2-byte integer
'containing the total; number of bytes, followed by the command string
'followed by a 2-byte check word, where each of the bytes are successively
'subtracted from &hffff
'It returns data with the same count and checksum characteristics
'Every command except the "W" (who are you)_ command returns a 47-byte
'race header of the type C4000
'If times follow, they are 4-byte numbers in lane order as long integers
'in units of 10000ths of a second.
'--------------------------------------------------------------------------
Dim low As String * 1, high As String * 1
Dim count As Long, OK As Integer, st$, i As Integer
Dim ans As Integer, comport As Integer, c4k As C4000
Dim start As Single
'comport = useport(curport)

On Local Error GoTo colerr
If Not busy Then
OK = False
length = 0
start = Timer
busy = True
'Screen.MousePointer = vbHourglass
Do
  ans = DoEvents()
Loop Until (comm.InBufferCount >= 2) Or ((Timer - start) > 2)
'Screen.MousePointer = vbDefault
If comm.InBufferCount >= 2 Then
   comm.InputLen = 1
   low = comm.Input
   high = comm.Input
   count = Asc(high) * 256 + Asc(low)
   'Debug.Print comm.InBufferCount, count
   If count > 2 Then
     st$ = Space$(count - 2)
   End If
   If count = 6 Then    'this means an error
    errorFlag = True
   Else
    errorFlag = False
   End If
   #If BUFINPUT Then
    comm.InputLen = 0
   #Else
    comm.InputLen = 1
   #End If
   'st$ = comm.Input
'#If BUFINPUT Then
'  st$ ""
'  Do
'   st$ = st$ + comm.Input
'   ans = DoEvents
'  Loop Until Len(s$) >= count
'#Else
'   Do
'     ans = DoEvents()
'   Loop Until comm.InBufferCount >= (count - 2) Or errorFlag
'
'   For i = 1 To count - 2
'      low = comm.Input
'     Mid$(st$, i, 1) = low
'   Next i
'#End If
st$ = comm.Input
While Len(st$) < count - 2
  st$ = st$ + comm.Input
Wend
   If Len(st$) >= 2 Then
     st$ = Left$(st$, Len(st$) - 2)
     length = Len(st$)
     getColComd$ = st$
  '   dbg.printLn st$
     OK = True
   Else
     getColComd$ = ""
     length = 0
   End If
Else
  getColComd$ = ""
  length = 0
End If
'Loop Until ok
colexit:
  busy = False
  End If
  Exit Function
colerr:
 Select Case Err
  Case 25, 57
   ans = MsgBox("Communication lost with timing system, check cables")
  Case 340
    Resume Next
  Case Else
    ans = MsgBox("Run time error #" + Str$(Err) + " in Get ColComd")
End Select
Resume colexit

End Function

Public Sub sendColComd(cmd$)
Dim ans As Integer, Com$, version$, length As Integer
Dim comadd As Integer, offset, a As Single, b As Single
On Local Error GoTo scolerr

If connected Then

  '''If comm.PortOpen Then      'open the port
'''     comm.PortOpen = False     'close the port
  '''End If
  'comm.CommPort = useport(curport) 'md.comport(md.curport)
  'Open com$ + ":9600,n,8,1" For Random As #md.comport(md.curport) Len = 2048
  'OUT &H3FB, &HB          'program chip to odd parity, 8 bits, 1 stop bit
  'OUT comadd, &HB          'program chip to odd parity, 8 bits, 1 stop bit
  '''comm.Settings = "9600,O,8,1"
  '''comm.PortOpen = True      'open the port
  'comm.Output = makecmd$("W")      'issue Who Are you- get colo version#
  'version$ = getcolcomd$(length)
  '''connected = True
  '''TimingSystem.showStatus version$
  'd.comport(md.curport) = md.useport(1)
End If
If connected Then
comm.Output = makecmd$(cmd$)
'dbg.printLn cmd$
End If

scolexit:
Exit Sub

'error handler for COM ports
scolerr:
 If connected Then
  ans = MsgBox("Error " + Str$(Err) + " communicating with Colorado-4000")
 End If
  'close #md.comport(md.curport)
  Resume scolexit

End Sub

Private Function filltimes(dtstr$, times() As Single, backups() As Single, raceNumber As Integer)
'Dim c4dat As C4000
Dim length As Integer, s$, i As Integer, place As Integer
Dim start As Single, this As Single
'--------------------------------------------------------------------------
 'The Colorado 4000 returns
'a 2-byte count (low byte first)
'a 47-byte race header described by the structure C4000
'For each lane it returns
'  a 1-byte place
'  one or more times as 4-byte long integers in units of 10000ths of a sec
'  If splits are requested, they come first, with the final time the last split
'  If backups are requested, they follow
'--------------------------------------------------------------------------
  'start = Timer
  'this = start
  'While (this - start) < .5
  '  this = Timer
  'Wend
  s$ = getColComd$(length)

  If (length >= Len(c4dat)) Then
      getstruct s$          'into c4dat
     dtstr$ = makedatestring$       'into c4dat
     raceNumber = c4dat.raceNumber

    For i = 1 To Asc(c4dat.Lanes)
      place = getPlace(s$)
      times(i) = getTime(s$)
      backups(i) = getTime(s$)
    Next i
  End If
filltimes = length      'error return if 0

End Function

Private Sub getstruct(s$)
Dim rNum As Single
'-------------------------------------------------------------
' copies values from string into structure and shortens string
'-------------------------------------------------------------
If Len(s$) >= Len(c) Then
c4dat.event = Mid$(s$, 1, 1)
c4dat.heat = Mid$(s$, 2, 1)
c4dat.inbackup = Mid$(s$, 3, 1)
c4dat.insplits = Mid$(s$, 4, 1)
rNum = Asc(Mid$(s$, 6, 1))
rNum = rNum * 256
rNum = rNum + Asc(Mid$(s$, 5, 1))
c4dat.raceNumber = rNum Mod 255
c4dat.seconds = Mid$(s$, 7, 1)
c4dat.minutes = Mid$(s$, 8, 1)
c4dat.hours = Mid$(s$, 9, 1)
c4dat.weekday = Mid$(s$, 10, 1)
c4dat.month = Mid$(s$, 11, 1)
c4dat.day = Mid$(s$, 12, 1)
c4dat.year = Mid$(s$, 13, 1)
c4dat.lengths = Mid$(s$, 14, 1)
c4dat.Lanes = Mid$(s$, 15, 1)
c4dat.timesperlane = Mid$(s$, 16, 1)
s$ = Right$(s$, Len(s$) - Len(c4dat))
End If
End Sub

Public Function getDateString() As String
getDateString = makedatestring
End Function

Private Function makedatestring$()
Dim dtstr$, min$, sec$
'     dtstr$ = "Race#" + Str$(c4dat.raceNumber) + " "
'     dtstr$ = dtstr$ + "Event:" + Str$(Asc(c4dat.event)) + " Heat:" + Str$(Asc(c4dat.heat))
heat = Asc(c4dat.heat)
evnum = Asc(c4dat.event)
raceNumber = c4dat.raceNumber
     dtstr$ = dtstr$ + Str$(Asc(c4dat.month)) + "/" + LTrim$(Str$(Asc(c4dat.day))) + "/" + LTrim$(Str$(Asc(c4dat.year)))
     sec$ = LTrim$(Str$(Asc(c4dat.minutes)))
     If Len(sec$) < 2 Then sec$ = "0" + sec$
     min$ = LTrim$(Str$(Asc(c4dat.seconds)))
     If (Len(min$) < 2) Then min$ = "0" + min$
     dtstr$ = dtstr$ + "  " + Str$(Asc(c4dat.hours)) + ":" + sec$ + ":" + min$
makedatestring$ = dtstr$
End Function

Private Function getPlace(s$)
Dim place As Integer, length As Integer
If Len(s$) > 0 Then
  place = Asc(s$)
  length = Len(s$)
  s$ = Right$(s$, length - 1)
Else
  place = 0
End If
getPlace = place
End Function

Private Function getTime(s$)

Dim thsec As Long, s4 As String * 4, length As Integer
Dim seconds As Single, minutes As Single, calctime As Single
On Local Error GoTo gterr
length = Len(s$)
s4 = Mid$(s$, 1, 4)             'skip place byte and get 4 time bytes
thsec = Asc(Mid$(s4, 4, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 3, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 2, 1))
thsec = 256 * thsec + Asc(Mid$(s4, 1, 1))
'convert to a long
If Len(s$) >= 4 Then
  s$ = Right$(s$, length - 4)    'strip off 4 bytes
End If
seconds = thsec / 1000
minutes = Int(seconds / 60)
calctime = minutes * 100 + (seconds - 60 * minutes)

gtexit:
getTime = calctime
Exit Function

gterr:
  calctime = 0
  Resume gtexit
End Function

Private Sub TimingSys_setDB(datab As DAO.Database)
Set db = datab
End Sub
Private Sub savesplits(s$)
Dim i As Integer, Lanes As Integer, place As Integer, length As Integer
Dim tlane As Integer, heat As Integer, j As Integer, tl As Integer
Dim t, spldim  As Integer, tlmax As Integer
spldim = 16
Dim split As SPLITREC
Dim rsplitmax As Integer, k As Integer
Dim rsplits As New Collection
tlmax = 0       'maximum number of splits sent for any lane


If Len(s$) > Len(c4dat) Then
  getstruct s$     'into c4dat
  Lanes = Asc(c4dat.Lanes)
  heat = Asc(c4dat.heat)
  Set splits = Nothing
  Set splits = New Collection
  For i = 1 To Lanes
    place = getPlace(s$)
    tlane = Int(Asc(c4dat.timesperlane))    'total lanes sent
    Set rsplits = Nothing
    Set rsplits = New Collection
    'replace one set or other with new ones
    k = 1
    For j = 1 To tlane
      t = getTime(s$)
      If t <> 0 And t < 50000 Then    'prevent huge splits
            rsplits.add t
            k = k + 1
      End If
    Next j
    rsplitmax = k - 1
    splits.add rsplits, Str$(i)
    Next i
End If

End Sub

Private Function TimingSys_usesPorts() As Boolean
TimingSys_usesPorts = True
End Function
