import java.awt.*;
import java.awt.event.*;
// Controls demonstration program
// illustrates the use of checkbox, radio button, push  button
// list box, choice ox, label, edit box and scroll bar
// subclasses panel as image dispplay and as flashing box
//====================================================
public class ControlDemo extends Frame 
implements ActionListener, ItemListener, MouseListener, AdjustmentListener {
    private Image imgBeany;        //imag read in here
    private BlinkPanel blinker;
    private ImgPanel beany;
    private CheckboxGroup group1;
    private Choice choice1;
    private List list1;
    private TextField edit1;
    private Button clearIt;
    private Scrollbar scrollbar1;
    private Label label1;
    private Checkbox check1;
    private Checkbox another;
    private Checkbox Locked;
    private Checkbox passwd;
    private Panel leftPanel, midPanel, rightPanel;

//-----------------------------------------
    public ControlDemo(String title) {
        super(title);
        setFont(new Font("Helvetica",Font.PLAIN,12)); //covers every control
        imgBeany = Toolkit.getDefaultToolkit().getImage("beany.gif");
        setLayout(new GridLayout(1, 3)); 
        leftPanel = new Panel();
        midPanel = new Panel();
        rightPanel = new Panel();
        add(leftPanel);
        add(midPanel);
        add(rightPanel);
        //set up WindowAdapter to catch exit click
        setCloseClick();
        setBackground(Color.lightGray);
        //set window size and location
        setBounds(20, 20, 400,200);

        //left panel holds list box
        //list box will contain all actions performed
        //clicking on list box line copies it to label1
        leftPanel.setLayout(new BorderLayout());
        list1 = new List();
        leftPanel.add("Center", list1);
        list1.setBackground(Color.white);       //default is gray

        //middle panel contains most of the controls in a grid
        midPanel.setLayout (new GridLayout(7, 1));

        //label show current state of edit box and list box select
        label1=new Label("Label");
        midPanel.add(label1);
        //Text field can be normal, locked or in password mode
        edit1 = new TextField(9);
        midPanel.add(edit1);
        Panel ckPanel = new Panel();
        midPanel.add(ckPanel);
        ckPanel.setLayout (new GridLayout(1,2));

        //check boxes not grouped or normal check boxes
        Locked=new Checkbox("L");
        ckPanel.add(Locked);
        Locked.addItemListener (this);

        passwd=new Checkbox("P");
        ckPanel.add(passwd);
        passwd.addItemListener (this);


        //check boxes that are members of group are shown as
        //radio buttons
        group1= new CheckboxGroup();
        check1=new Checkbox("Radio button",group1, false);
        check1.addItemListener (this);
        midPanel.add(check1);

        another=new Checkbox("Another button",group1, false);
        another.addItemListener (this);
        midPanel.add(another);

        Panel midBlink = new Panel();
        midBlink.setLayout (new GridLayout(1,2));
        midPanel.add(midBlink);
        //panel sub classed to make blinking square as separate thread
        blinker=new BlinkPanel();
        blinker.setEnabled(false);
        blinker.setLayout(null);
        midBlink.add(blinker);

        //panel subclassed to display image
        beany = new ImgPanel();
        beany.setLayout(null);
        beany.addMouseListener(this);
        blinker.add(beany);

        beany.setImage(imgBeany);       //tell it what image to display
        rightPanel.add("Center", beany);
        beany.setSize(75,75);

        // set up choice box with colors for blinker
        choice1= new Choice();
        midBlink.add(choice1);
        choice1.addItem("Blue");
        choice1.addItem("Red");
        choice1.setBounds(getInsets().left + 175,getInsets().top + 120,77,23);
        choice1.addItemListener(this);

        rightPanel.setLayout (new BorderLayout());    
        //Clear button clears list box
        clearIt = new Button("Clear");
        Panel bottom = new Panel();
        rightPanel.add("South", bottom);
        bottom.add(clearIt);
        clearIt.addActionListener (this);

        //scroll bar set to 0-99 and moving it put value in list box
        scrollbar1= new Scrollbar(Scrollbar.VERTICAL);
        rightPanel.add("East",scrollbar1);
        scrollbar1.setValues(0,1,0,100);
        scrollbar1.addAdjustmentListener (this);
        show();
    }

//-----------------------------------------
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        scrollValue(evt.getValue ());
    }
//-----------------------------------------
    public void actionPerformed(ActionEvent evt) {
            clickedClearit();
    }
//-----------------------------------------
    public void itemStateChanged(ItemEvent evt) {
        Object obj = evt.getSource();
        if (obj == check1)
            clickedCheck1();
        if (obj == another)
            clickedAnother();
        if (obj == passwd)
            clickedPasswd();
        if (obj == Locked)
            clickedLocked();
        if (obj == choice1)
            selectedChoice1();

    }
//-----------------------------------------
    private void setCloseClick() {
        //create window listener to respond to window close click
        addWindowListener(new WindowAdapter() {
                              public void windowClosing(WindowEvent e) {
                                  System.exit(0);
                              }
                          });
    }

//-----------------------------------------

    public void clickedLocked() {

        edit1.setEditable(! Locked.getState());
        if (Locked.getState())
            label1.setText("Locked");
        else
            label1.setText("Unlocked");
    }
//-----------------------------------------
    public void clickedList1() {
    //set label text equal to list item clicked on
        label1.setText(list1.getSelectedItem());
    }
//-----------------------------------------
    public void clickedPasswd() {
        if (passwd.getState()) {
            edit1.setEchoChar('*');    //sets echo character for passwords
            label1.setText("Password");
        }
        else {
            edit1.setEchoChar('\0');   //turns off password
            label1.setText("Normal Text");
        }

        edit1.requestFocus(); //refreshes text box
    }
//-----------------------------------------
    public void scrollValue(int value) {
        // add current value of scroll bar to list box
        list1.add(new Integer(value).toString());
    }
//-----------------------------------------
    public void clickedAnother() {
        list1.add("Another clicked");
    }
//-----------------------------------------
    public void clickedCheck1() {
        list1.add("Radio clicked");
    }
//-----------------------------------------
    public void selectedChoice1() {
        String c =choice1.getSelectedItem();
        list1.add(c);
        if (c.equals("Blue"))                  //alternate colors
            blinker.setColor(Color.blue);
        else
            blinker.setColor(Color.red);

    }
//-----------------------------------------
    public void mousePressed(MouseEvent evt) {
        list1.add("Beany!");
    }
    public void mouseReleased(MouseEvent evt) {
    }
    public void mouseEntered(MouseEvent evt) {
    }
    public void mouseExited(MouseEvent evt) {
    }
    public void mouseClicked(MouseEvent evt) {
    }
//-----------------------------------------
    public void clickedClearit() {
        //clear list
        list1.removeAll();
    }
//-----------------------------------------
    public static void main(String arg[]) {
        new ControlDemo("Java Controls");
    }
}


