import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.util.*;

public class SearchApplet extends JApplet implements ActionListener {
    private JTextArea sText;
    private JButton[] more;
    private JTextField[] qArray;
    private JComboBox[] choices;
    private JButton search, clear, close;
    private JPanel center;

    
    public void init() {
        
        JPanel jp = new JPanel();   // create interior panel      
        jp.setLayout(new BorderLayout());
        getContentPane().add(jp);

        JPanel top = new JPanel();
        jp.add("North", top);
        top.setLayout(new BorderLayout());
        JLabel lbTop = new JLabel("Enter free text below to search for");
        top.add("North", lbTop);
        sText = new JTextArea(3, 30);
        sText.setBackground (Color.yellow);
        JPanel sp = new JPanel();
        top.add("Center", sp);
        sp.add(sText);
        Border edge = BorderFactory.createBevelBorder (BevelBorder.LOWERED );
        sp.setBorder (edge);
        sText.setBorder (edge);
        JLabel lbBot = new JLabel("You can also enter terms below using modifiers");
        top.add("South", lbBot);
        //bottom half
        center = new JPanel();
        center.setLayout(new GridLayout(3,6, 6, 6));
        jp.add("Center", center);

        //create More buttons
        more = new JButton[2];
        more[0] = new JButton("More...");
        more[1] = new JButton("More...");
        more[0].addActionListener (this);
        more[1].addActionListener (this);
        //create array
        choices = new JComboBox[6];
        Vector vChoice = new Vector();
        vChoice.addElement("And");
        vChoice.addElement("Or");
        vChoice.addElement("But not");
        
        //create combo boxes
        for(int i=0; i<6; i++) {
            choices[i] = new JComboBox(vChoice);
            choices[i].setEditable(false);
        }
        //create text fields
        qArray = new JTextField[9];
        for(int i = 0; i < 9; i++)
            qArray[i] = new JTextField(6);
        
        //add into grid
        int i = 0;
        int j = 0;
        int k = 0;
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(more[k++]);
        
        centerAdd(new JLabel(""));
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(more[k++]);

        centerAdd(new JLabel(""));
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
//hide 2nd and 3rd rows
        set2nd(false);
        set3rd(false);
        
        center.setBorder (edge);

//buttons along the bottom
        search = new JButton("Search");
        clear = new JButton("Clear");
        close = new JButton("Close");
        close.addActionListener (this);

        JPanel bp = new JPanel();
        
        jp.add("South", bp);
        bp.add(search);
        bp.add(clear);
        bp.add(close);
        setBounds(100,100, 500,300);
        setVisible(true);
    }
    //-------------------------
    private void set2nd(boolean b) {
        choices[2].setVisible (b);
        choices[3].setVisible (b);
        qArray[3].setVisible (b);
        qArray[4].setVisible (b);
        more[1].setVisible(b);
    }
    private void set3rd(boolean b) {
        choices[4].setVisible (b);
        choices[5].setVisible (b);
        qArray[5].setVisible (b);
        qArray[6].setVisible (b);
        
    }
    //-------------------------
    private void centerAdd(JComponent c) {
        JPanel p  = new JPanel();
        center.add(p);
        p.add(c);
    }
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        
        if(obj == more[0])
            set2nd(true);
        if(obj == more[1])
            set3rd(true);
        if(obj == close)
            System.exit(0);
    }

    //-------------------------
    static public void main(String[] argv) {
        JxFrame fr = new JxFrame("Search App");
        
        //create the applet
        JApplet app = new SearchApplet();
        fr.getContentPane().setLayout(new BorderLayout());
        fr.getContentPane().add("Center",app);   //add into the frame
        fr.setSize(500, 300);   //define its size
        
        fr.show();      //show the frame
        app.init();     //lay out the applet
        app.start();    //start it
        fr.pack();      //arrange applet inside frame
    }
}
