import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.util.*;

public class SearchApplet extends Applet implements ActionListener {
    private TextArea sText;
    private Button[] more;
    private TextField[] qArray;
    private ComboBox[] choices;
    private Button search, clear, close;
    private Panel center, jp;

    
    public void init() {
        
        jp = new Panel();   // create interior panel      
        jp.setBackground (Color.lightGray );
        jp.setLayout(new BorderLayout());
        add(jp);

        Panel top = new Panel();
        jp.add("North", top);
        top.setLayout(new BorderLayout());
        Label lbTop = new Label("Enter free text below to search for");
        top.add("North", lbTop);
        sText = new TextArea(3, 30);
        sText.setBackground (Color.yellow);
        Panel sp = new Panel();
        top.add("Center", sp);
        sp.add(sText);
        
        Label lbBot = new Label("You can also enter terms below using modifiers");
        top.add("South", lbBot);
        //bottom half
        center = new Panel();
        center.setLayout(new GridLayout(3,6, 2, 2));
        jp.add("Center", center);

        //create More buttons
        more = new Button[2];
        more[0] = new Button("More...");
        more[1] = new Button("More...");
        more[0].addActionListener (this);
        more[1].addActionListener (this);
        //create array
        choices = new ComboBox[6];
        Vector vChoice = new Vector();
        vChoice.addElement("And");
        vChoice.addElement("Or");
        vChoice.addElement("But not");
        
        //create combo boxes
        for(int i=0; i<6; i++) {
            choices[i] = new ComboBox(vChoice);
            
        }
        //create text fields
        qArray = new TextField[9];
        for(int i = 0; i < 9; i++)
            qArray[i] = new TextField(6);
        
        //add into grid
        int i = 0;
        int j = 0;
        int k = 0;
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(more[k++]);
        
        centerAdd(new Label(""));
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(more[k++]);

        centerAdd(new Label(""));
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
        centerAdd(choices[j++]);
        centerAdd(qArray[i++]);
//hide 2nd and 3rd rows
        set2nd(false);
        set3rd(false);
        
   //buttons along the bottom
        search = new Button("Search");
        clear = new Button("Clear");
        close = new Button("Close");
        close.addActionListener (this);

        Panel bp = new Panel();
        
        jp.add("South", bp);
        bp.add(search);
        bp.add(clear);
        bp.add(close);
        setBounds(100,100, 500,300);
        setVisible(true);
        jp.validate();
    }                       
    //-------------------------
    private void set2nd(boolean b) {
        choices[2].setVisible (b);
        choices[3].setVisible (b);
        qArray[3].setVisible (b);
        qArray[4].setVisible (b);
        more[1].setVisible(b);
        jp.validate ();
        repaint();
    }
    private void set3rd(boolean b) {
        choices[4].setVisible (b);
        choices[5].setVisible (b);
        qArray[5].setVisible (b);
        qArray[6].setVisible (b);
        jp.validate ();
        repaint();
        
    }
    //-------------------------
    private void centerAdd(Component c) {
        Panel p  = new Panel();
        center.add(p);
        p.add(c);
    }
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        
        if(obj == more[0])
            set2nd(true);
        if(obj == more[1])
            set3rd(true);
        if(obj == close)
            System.exit(0);
    }

    //-------------------------
    static public void main(String[] argv) {
        XFrame fr = new XFrame("Search App");
        
        //create the applet
        Applet app = new SearchApplet();
        fr.setLayout(new BorderLayout());
        fr.add("Center",app);   //add into the frame
        fr.setSize(500, 300);   //define its size
        
        fr.show();      //show the frame
        app.init();     //lay out the applet
        app.start();    //start it
        fr.pack();      //arrange applet inside frame
    }
}
