import java.awt.*;
import java.awt.event.*;
import java.util.*;
//TempPlot class reads in an array of y-values
//Then it creates an instance of the Plotit class to draw them

public class TempPlot extends XFrame implements ActionListener {
    private Vector plotPoints;      //data stored here
    private TextField numEdit;
    private Label label1;
    private Label counter;
    private Button btStore;
    private Button btPlot;
//--------------------------------------------------
    public TempPlot(String caption) {
        super(caption);
        setBackground(Color.lightGray );
        //layout using border layout for top line
        //and Grid Layout for panel inserted in center
        setLayout(new BorderLayout());
        label1 = new Label("Enter temperature");
        add("North", label1);
        Panel p0 = new Panel(); //put panel in center
        add("Center", p0);
        
        //create 2 x 2 Grid with 20pixel gaps
        p0.setLayout(new GridLayout(1,3, 20, 20));        
        
        //entry field
        numEdit = new TextField(13);        
        numEdit.addActionListener (this);
        Panel tp = new Panel();
        p0.add(tp);
        tp.add(numEdit);          

        //counter label
        counter = new Label("0 points ");//store push button    //label in 2
        p0.add(counter);        //
        
        //panel for push buttons
        Panel bp = new Panel();
        add("South", bp);
        //store push button
        btStore = new Button("Store");    
        btStore.addActionListener (this);
        bp.add(btStore);                  

        //plot push button
        btPlot = new Button("Plot");      
        btPlot.addActionListener (this);
        bp.add(btPlot);                    

        //create vector for data
        plotPoints = new Vector();      
        setSize(250,150);
        setVisible(true);
        //request focus does not work before setVisible method
        numEdit.requestFocus();           //set focus to edit field
    }
//--------------------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        
        if (obj == btPlot) 
            clickedPlot();          //plot button starts plot
        else
           clickedStore();           //store button adds point
    }
//--------------------------------------------------

    public void clickedStore() {   //create Float object from fp data 
        Float temp = new Float(numEdit.getText());
        plotPoints.addElement(temp);     //add to vector
        //change label to show new number of points
        counter.setText(new String().valueOf(plotPoints.size()) + " points");
        numEdit.setText("");       //clear entry field
        numEdit.requestFocus();    //reset focus here
    }
//--------------------------------------------------
    public void clickedPlot() {
        Plotit pl = new Plotit(plotPoints);  //create instance of plot form
        pl.setVisible(true);                 //and display it
    }
//--------------------------------------------------
    public static void main(String argv[]) {
        new TempPlot("Temperature plotter");
    }
}




