import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class PlotPanel extends Panel {
//this panel class plots an array within its boundaries
//and draws an outline in black
    private Vector plotpnts;
    private float xmin, xmax, ymin, ymax;
    private int pwidth, pheight;
    private int pleft, ptop;
    private float xscale, yscale;
//-------------------------------------------------
    public PlotPanel (Vector pl) {
        plotpnts = pl;         //save vector inside object
    }
//-------------------------------------------------
    public void setBounds(int xpos, int ypos, int width, int height) {
        Dimension sz;
        setBackground(Color.white );
        xmin = 1;
        xmax = plotpnts.size();
        ymin = 1e35f;
        ymax= -1e35f;
        //find max and min to scale plot
        for (int i = 0; i < plotpnts.size(); i++) {
            float y = ((Float)plotpnts.elementAt(i)).floatValue();
            if ( y > ymax)
                ymax = y;
            if (y < ymin)
                ymin = y;
        }
        //compute scale for plots
        xscale = width/((xmax-1));
        yscale = height/(-(ymax - ymin));
        super.setBounds(xpos, ypos, width, height);
    }
//-------------------------------------------------
    public float getYmin() {
        return ymin;
    }
//-------------------------------------------------
    public float getYmax() {
        return ymax;
    }
//-------------------------------------------------
    public void paint (Graphics g) {
        float x, y;
        int xpix, ypix, xold=0, yold=0;
//draw black rectangle for border
        g.setColor(Color.black);
        Dimension sz = getSize();       //get window size
        g.drawRect(0,0,sz.width-1,sz.height-1);
//plot data in blue
        g.setColor(Color.blue);
        for (int i=0; i< plotpnts.size(); i++) {
            x = i + 1;
            //get each floating value from Vector
            y = ((Float)plotpnts.elementAt(i)).floatValue();
            //convert to pixel values
            xpix = (int)((x -xmin) * xscale ) ;
            ypix = (int)((y- ymin) * yscale ) + sz.height ;
            if (i>0)
                g.drawLine(xold, yold, xpix, ypix);
            xold = xpix;      //save for next line
            yold = ypix;
        }
    }
}

