import java.awt.*;
import java.awt.event.*;

public class TimerBox extends XFrame implements Ticker, ActionListener {
    private Button start, stop, close;  //three buttons
    private Panel blinkPanel;
    private Timer timer;
    private Color color;
//------------------------------------
    public TimerBox() {
        super ("Timed Display Blinker"); //title bar
        setBackground(Color.lightGray );
        setLayout(new BorderLayout());
        //create buttons
        start = new Button("Start");    //and buttons
        stop = new Button("Stop");
        close = new Button("Close");
        start.addActionListener (this);
        stop.addActionListener (this);
        close.addActionListener (this);
        
        blinkPanel = new Panel();           //create blinking
        add("Center", blinkPanel);

        Panel botPanel = new Panel();
        add("South", botPanel);                    //panel
        botPanel.add(start);
        botPanel.add(stop);                 //add buttons to panel
        botPanel.add(close);
        
        setBounds (100, 100, 250,200);
        color = Color.red;              //initial color
        blinkPanel.setBackground(color);    //of blinking panel
        setVisible(true);
        
    }
//------------------------------------------
    public void tick() {
//called by Timer class
        if (color == Color.blue)
            color = Color.red;
        else
            color = Color.blue;
        blinkPanel.setBackground(color);
        blinkPanel.repaint();
    }
//------------------------------------------
    public void actionPerformed (ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == start) {        //start button
            timer = new Timer(this, 200);       //create timer
            timer.start();                //begin timer ticking
            start.setEnabled(false);              //turn off start button
           }
        else
            if (obj == stop) {         //stop button
            timer.stopTimer();      //stop timer
            start.setEnabled(true);               //turn on start button
            }
        else
            if (obj == close) {       //close button
            System.exit(0);               //program exit
            
        }        
    }
//------------------------------------
    public static void main(String argv[]) {
        new TimerBox();
    }
}

