import java.awt.*;
import java.awt.event.*;

public class Balances extends XFrame implements ActionListener {
    private Label names[];                 //array of customer name labels
    private TextField sbalances[];         //displayed array of balances
    private int balances[];                //integer array of balances
    private Button start, stop;            //buttons to start and stop business
    private int sum;
    private Teller teller1, teller2, teller3;      //3 Tellers
    //-----------------------------------
    public Balances() {
        super("Balance sheet");              //title bar
        setBackground(Color.lightGray );
        setLayout(new BorderLayout());
        
        Panel p1 = new Panel();              //holds names & balances
        Panel p2 = new Panel();              //holds buttons
        add("South", p2);
        add("Center", p1);
        p1.setLayout(new GridLayout(6, 2));  //names and balances 
        balances = new int[5];               //array of balances
        sbalances = new TextField[6];        //displayed balances

        sum =0;
        names = new Label[6];
        names[0] = new Label("Alfie");
        names[1]= new Label("Bonnie");
        names[2] = new Label("Charlie");
        names[3] = new Label("Daphne");
        names[4] = new Label("Essie");
        names[5] = new Label("TOTAL");
        for (int i =0; i< 5; i++) {
            balances[i] = 1000;                //initialize balances
            sum += balances[i];
            sbalances[i] = new TextField(5);
            sbalances[i].setText(new Integer(balances[i]).toString());
            Panel p = new Panel();
            p1.add(p);
            p1.add(names[i]);
            p.add(sbalances[i]);
            p1.add(p);
        }
        sbalances[5] = new TextField(5);
        sbalances[5].setText(new Float(sum).toString());
        Panel p = new Panel();
        p1.add(names[5]);            //add in TOTAL and
        p1.add(p);           
        p.add(sbalances[5]);         //display sum
        start = new Button("Start"); //add in buttons
        stop = new Button("Stop");
        start.addActionListener (this);
        stop.addActionListener (this);

        p2.add(start);
        p2.add(stop);
        setBounds(100,100,300,250);
        setVisible(true);
    }
    //-----------------------------------
    public void paint(Graphics g) {
        //repaint values each time
        float sum =0;
        for (int i=0; i< 5; i++) {
            sbalances[i].setText( new Integer(balances[i]).toString());
            sum += balances[i];
        }
        sbalances[5].setText( new Float(sum).toString());
    }
    //-----------------------------------
    public void clickedStart() {
        //start tellers running about 
        teller1 = new Teller(balances, 1);    //always 1-dollar
        teller2 = new Teller(balances, 5);    //always 5 dollars
        teller3 = new Teller(balances,  7);    //always 7 dollars
        teller1.start();                      
        teller2.start();              //start your tellers!
        teller3.start();
        start.setEnabled(false);              //only once
    }
    //-----------------------------------
    public void clickedStop() {
        teller1.stopTimer();              //stop tellers
        teller2.stopTimer();
        teller3.stopTimer();
        start.setEnabled(true);              //allow restarting
        repaint();
    }
    //-----------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == start) {
            clickedStart();
         }
        else
            if (obj == stop) {
            clickedStop();
        }        
    }
    //-----------------------------------
    public static void main(String argv[]) {
        new Balances();
    }
}

