import java.awt.*;
import java.awt.event.*;
import java.util.*;

//swing classes
import javax.swing.text.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class SimpleJFC extends JxFrame
implements ActionListener {
    private JButton OK, Quit;
    private Color color;
    private JPanel jp;
    
    public SimpleJFC() {
        super("Simple JFC Program");
        color = Color.yellow;
        jp = new JPanel();
        getContentPane().add(jp);
        setGUI();
    }
    //-------------------------------------------
    private void setGUI() {
                
        //create and add buttons
        OK = new JButton("OK");
        Quit = new JButton("Quit"); 
        OK.addActionListener(this);
        Quit.addActionListener(this);

        jp.add(OK);
        jp.add(Quit);

        setSize(new Dimension(250,100));
        setVisible(true);
    }
    //-------------------------------------------
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == OK)
            switchColors();
        if (obj == Quit)
            System.exit(0);
    }
    //------------------------------------------
    private void switchColors() {
        if (color == Color.green)
            color = Color.yellow;
        else
            color = Color.green;
        jp.setBackground(color);
        repaint();
    }
    //-------------------------------------------
    static public void main(String[] argv) {
        new SimpleJFC();
    }
}
