//Simple temperature calculator
//will run either as applet or application

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class subButton extends Applet implements ActionListener {
    private CheckboxGroup grpTemper;       //group radio buttons
    private Label label1;
    private TextField tempEntry;        //edit box
    private Checkbox fahr;              //radio button
    private Checkbox celsius;           //radio button
    private Label result;               //result shown here
    private QuitButton quit;             //compute when clicked
    private ComputeButton compute;                //exit when clicked
//-------------------------------------------------------
    public void init() {
        //initialize applet
        setLayout(new GridLayout(6,1));            
        setBackground(Color.lightGray);
        
        label1 = new Label("Enter temperature:");
        add(label1);

        tempEntry=new TextField(7);
        add(tempEntry);

        result=new Label(" ");
        add(result);

        grpTemper = new CheckboxGroup();
        fahr = new Checkbox("to Fahrenheit",grpTemper, false);
        add(fahr);

        celsius = new Checkbox("to Celsius",grpTemper, false);
        add(celsius);

        
        Panel p = new Panel();
        add(p);
        p.setLayout(new GridLayout(1,2));

        compute = new ComputeButton("Compute");
        Panel lp = new Panel();
        p.add(lp);
        lp.add(compute); 
        compute.addActionListener(this);
        compute.setApp(this);

        Panel rp = new Panel();
        p.add(rp);
        quit = new QuitButton("Quit");
        rp.add(quit);
        quit.addActionListener(this);


        super.init();
    }
    //-------------------------------------------------------
    public void clickedCompute() {
       float temp, newtemp;

       temp = new Float(tempEntry.getText ()).floatValue();
       if (fahr.getState ())
           newtemp = 9 * temp / 5 + 32;
       else
           newtemp = 5 * (temp - 32) / 9;
       result.setText(new String().valueOf(newtemp));

   }
   //-------------------------------------------------------
    public void actionPerformed(ActionEvent evt) {
        ComdButton butn = (ComdButton)evt.getSource ();
        butn.Execute ();
     }
    //-------------------------------------------------------
    public static void main(String arg[]) {
        //create the frame
        XFrame fr = new XFrame("Temperature calculation");
        
        //create the applet
        Applet app = new subButton();
        fr.add("Center",app);   //add into the frame
        fr.setSize(364, 225);   //define its size
        
        fr.show();      //show the frame
        app.init();     //lay out the applet
        app.start();    //start it
        fr.pack();      //arrange applet inside frame
    }
}       
