//Simple temperature calculator
//will run either as applet or application

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class tempcalc extends Applet implements ActionListener {
    private CheckboxGroup grpTemper;       //group radio buttons
    private Label label1;
    private TextField tempEntry;        //edit box
    private Checkbox fahr;              //radio button
    private Checkbox celsius;           //radio button
    private Label result;               //result shown here
    private Button compute;             //compute when clicked
    private Button quit;                //exit when clicked
//-------------------------------------------------------
    public void init() {
        //initialize applet
        setLayout(new GridLayout(6,1));            
        setBackground(Color.lightGray);
        
        label1 = new Label("Enter temperature:");
        add(label1);

        tempEntry=new TextField(7);
        add(tempEntry);

        result=new Label(" ");
        add(result);

        grpTemper = new CheckboxGroup();
        fahr = new Checkbox("to Fahrenheit",grpTemper, false);
        add(fahr);

        celsius = new Checkbox("to Celsius",grpTemper, false);
        add(celsius);

        
        Panel p = new Panel();
        add(p);
        p.setLayout(new GridLayout(1,2));

        compute=new Button("Compute");
        Panel lp = new Panel();
        p.add(lp);
        lp.add(compute); 
        compute.addActionListener(this);

        Panel rp = new Panel();
        p.add(rp);
        quit = new Button("Quit");
        rp.add(quit);
        quit.addActionListener(this);


        super.init();
    }
//-------------------------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == compute) {
            clickedCompute();   //compute temperature
        }
        else
            if (obj == quit) {
            System.exit(0);     //exit from application
        }
    }
//-------------------------------------------------------
    public void clickedCompute() {
        float temp, newtemp;

        temp = new Float(tempEntry.getText()).floatValue();
        if (fahr.getState())
            newtemp = 9 * temp / 5 + 32;
        else
            newtemp = 5 * (temp - 32) / 9;
        result.setText(new String().valueOf(newtemp));

    }
//-------------------------------------------------------
    public static void main(String arg[]) {
        //create the frame
        Frame fr = new Frame("Temperature calculation");
        fr.setLayout(new BorderLayout());
        //create the applet
        Applet app = new tempcalc();
        fr.add("Center",app);   //add into the frame
        fr.setSize(364, 225);   //define its size
        
        fr.show();      //show the frame
        app.init();     //lay out the applet
        app.start();    //start it
        fr.pack();      //arrange applet inside frame
    }
}       
