import java.awt.*;
import java.awt.event.*;
public class Cpanel extends Panel implements MouseListener {
    private int index;              //cursor index
    private Frame frm;
    private Color color;
    private boolean drawFrame;
    private Cursor oldCursor;
    private TipWindow tip;
//--------------------------------
    public Cpanel(Frame fr, Color c) {
        super();
        frm = fr;
        color = c;      //save the color
        drawFrame = false;
        addMouseListener(this);
    }
//--------------------------------
//restores cursor on exit
    public void mouseExited(MouseEvent evt) {
        setCursor(oldCursor);
    }
//--------------------------------
    //sets cursor when mouse enters panel
    public void mouseEntered(MouseEvent evt) {
        oldCursor = getCursor ();
        setCursor(new Cursor(Cursor.HAND_CURSOR) );
    }

    public void mouseClicked(MouseEvent evt) {
    }
    public void mouseReleased(MouseEvent evt) {
        if(tip != null)
            tip.setVisible(false);
        repaint();    
    }
    public void mousePressed(MouseEvent evt) {
     if((evt.getModifiers () & MouseEvent.BUTTON3_MASK ) != 0)  {
         tip = new TipWindow(frm, color);   
     }
    }
//--------------------------------
    public void paint(Graphics g) {
        Dimension sz = getSize();
        g.setColor(color);
        //fill with specified color
        g.fillRect(0,0, sz.width-1, sz.height-1);
        g.setColor(Color.black);
        //draw back border if flag set
        if (drawFrame) {
            g.drawRect(0,0, sz.width-1, sz.height-1);
        }
    }
//--------------------------------
}


