import java.awt.*;
import java.awt.event.*;
public class Cpanel extends Panel implements MouseListener, MouseMotionListener {
    private int index;              //cursor index
    private Frame frm;
    private Color color;
    private boolean drawFrame;
    private int thisX, thisY;
    private int oldX, oldY;
    
//--------------------------------
    public Cpanel(Frame fr, Color c) {
        super();
        frm = fr;
        color = c;      //save the color
        drawFrame = false;
        addMouseListener(this);
        addMouseMotionListener(this);
    }
//--------------------------------
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds (x, y, w, h);
        thisX = x;
        thisY = y;
    }
//--------------------------------
   public void mouseExited(MouseEvent evt) {}
   public void mouseEntered(MouseEvent evt) {}
   public void mouseClicked(MouseEvent evt) {}
    public void mouseReleased(MouseEvent evt) {
        drawFrame=false;
        repaint();    
    }
    public void mousePressed(MouseEvent evt) {
        drawFrame=true;
        oldX = evt.getX();
        oldY = evt.getY ();
        repaint();
    }
    //--------------------------------
//Mouse Motion events
    public void mouseMoved(MouseEvent evt) {}

    public void mouseDragged(MouseEvent evt) {
      Point locn = getLocation();
      thisX = locn.x ;
      thisY = locn.y;
      int dx = evt.getX ()- oldX;
      int dy = evt.getY() - oldY; 
      setLocation(thisX+dx, thisY+dy);
     
      oldX += dx;
      oldY += dy;
      repaint();
    }
    //--------------------------------
    public void paint(Graphics g) {
        Dimension sz = getSize();
        //fill with specified color
        g.setColor(color);
        g.fillRect(0,0, sz.width-1, sz.height-1);
        g.setColor(Color.black);
        //draw back border if flag set
        if (drawFrame) {
            g.drawRect(0,0, sz.width-1, sz.height-1);
        }
    }
//--------------------------------
}


