import java.awt.*;
import java.awt.event.*;
public class Cpanel extends Panel implements MouseListener {
    private int index;              //cursor index
    private Frame frm;
    private Color color;
    private boolean drawFrame;
    private Cursor oldCursor;
//--------------------------------
    public Cpanel(Color c) {
        super();
        color = c;      //save the color
        drawFrame = false;
        addMouseListener(this);
    }
//--------------------------------
//restores cursor on exit
    public void mouseExited(MouseEvent evt) {
        setCursor(oldCursor);
    }
//--------------------------------
    //sets cursor when mouse enters panel
    public void mouseEntered(MouseEvent evt) {
        oldCursor = getCursor ();
        setCursor(new Cursor(Cursor.HAND_CURSOR) );
    }

    public void mousePressed(MouseEvent evt) {
    }
    public void mouseReleased(MouseEvent evt) {
        
    }
    public void mouseClicked(MouseEvent evt) {
       
       if (evt.getClickCount () > 1 ) 
           drawFrame = true;
       else
           drawFrame = false;
        repaint();       
    }
//--------------------------------
    public void paint(Graphics g) {
        Dimension sz = getSize();
        g.setColor(color);
        //fill with specified color
        g.fillRect(0,0, sz.width-1, sz.height-1);
        g.setColor(Color.black);
        //draw back border if flag set
        if (drawFrame) {
            g.drawRect(0,0, sz.width-1, sz.height-1);
        }
    }
//--------------------------------
}


