import java.awt.*;
import java.awt.event.*;
public class Cpanel extends Panel implements MouseListener {
    int index;              //cursor index
    Frame frm;
//--------------------------------
    public Cpanel(int i) {
        super();
        index = i;      //Save the index of this cursor
        addMouseListener(this);
    }
//--------------------------------
    public void paint(Graphics g) {
        Dimension sz = getSize();
        g.setColor(Color.gray);
//draw a gray frame around each panel
        g.drawRect(0,0, sz.width-1, sz.height-1);
//write the cursor name in black inside the panel
        g.setColor(Color.black);
        g.drawString(cursor_name(index), 1,12);
    }
//--------------------------------
    public void mouseEntered(MouseEvent evt) {
//as the mouse enters the panel
//set the cursor to this panels type
        setCursor(new Cursor(index));
   }
    public void mouseClicked(MouseEvent evt){}
    public void mouseExited(MouseEvent evt){}
    public void mousePressed(MouseEvent evt){}
    public void mouseReleased(MouseEvent evt){}
    
//--------------------------------
    private String cursor_name(int i) {
//returns the name of each cursor
//from its index
        String s="";
        switch (i) {
        case 0:
            s="Default";
            break;
        case 1:
            s="crosshair";
            break;
        case 2:
            s="text";
            break;
        case 3:
            s="wait";
            break;
        case 4:
            s="sw_resize";
            break;
        case 5:
            s="se_resize";
            break;
        case 6:
            s="nw_resize";
            break;
        case 7:
            s="ne_resize";
            break;
        case 8:
            s="n_resize";
            break;
        case 9:
            s="s_resize";
            break;
        case 10:
            s="w_resize";
            break;
        case 11:
            s="e_resize";
            break;
        case 12:
            s="hand";
            break;
        case 13:
            s="move";
            break;
        }
        return s;
    }
//--------------------------------
}


