import java.awt.*;
import java.awt.event.*;

public class MenuFrame extends XFrame implements ActionListener {
    MenuBar mbar;                   //the menu bat
    Menu File;                      //top level menus
    Menu Setup;
    MenuItem Open;                  //first menu
    MenuItem Exit;
    MenuItem Appearance;            //second menu
    Menu Preferences;       
    MenuItem Colors;
    MenuItem Filetypes;
    CheckboxMenuItem Sound;

    public MenuFrame() {
        super("Menu Demonstration");
        setBackground(new Color(0x000f0fff));
        mbar = new MenuBar();             //create menu bar
        setMenuBar(mbar);                 //and add to Frame
        File = new Menu("File",true);         //Create two top level menu items
        Setup = new Menu("Setup",false);
        mbar.add(File);                 //and add to Menubar
        mbar.add(Setup);

//File menu is File->Open, separator, Exit
        Open = new MenuItem("Open...");
        Exit = new MenuItem("Exit");
        Open.addActionListener (this);
        Exit.addActionListener (this);
        File.add(Open);
        File.add(new MenuItem("-"));    //separator
        File.add(Exit);

//Setup menu is Setup->Appearance, Preferences->Colors, Filetypes

        Appearance = new MenuItem("Appearance");
        Preferences = new Menu("Preferences");
        Colors = new MenuItem("Colors");
        Filetypes = new MenuItem("Filetypes");
        Sound = new CheckboxMenuItem("Sound");
        Sound.setState(true);
        Setup.add(Appearance);
        Setup.add(Preferences);          //add menu here for sub menus
        Setup.add("Sound");
        Preferences.add(Colors);
        Preferences.add(Filetypes);
        setBounds(100,100,300,200);
        setVisible(true);    }
//-----------------------------------------
    private void clickedExit() {
        QuitDialog qdlg = new QuitDialog(this);
        qdlg.show();

        if (qdlg.getExitflag())
            System.exit(0);       //exit if ok clicked
    }
//-----------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == Exit) {
            clickedExit();
            
        }
        if (obj == Open) {
            FileDialog fdlg = new FileDialog(this, "Open",FileDialog.LOAD);
            fdlg.show();
            
        }
        
    }
//-----------------------------------------
    public static void main(String arg[]) {
        new MenuFrame();
    }
}

