import java.awt.*;
import java.awt.event.*;
public class CheckMenu extends XFrame implements ActionListener {
    MenuBar mbar;                   //the menu bar
    Menu File;                      //top level menus
    Menu Setup;
    MenuItem Open;                  //first menu
    MenuItem Exit;
    MenuItem Appearance;            //second menu
    Menu Preferences;       
    MenuItem Colors;
    MenuItem Filetypes;
    CheckboxMenuItem Sound;
    Label filename;
    Color background;
    ColorDialog cdlg;
//-------------------------------------------------
    public CheckMenu() {
        super("Menu Demonstration");
        setBackground(Color.lightGray);
        mbar = new MenuBar();             //create menu bar
        setMenuBar(mbar);                 //and add to Frame
        File = new Menu("File");         //Create two top level menu items
        Setup = new Menu("Setup");
        mbar.add(File);                 //and add to Menubar
        mbar.add(Setup);

//File menu is File->Open, separator, Exit
        Open = new MenuItem("Open...");
        Exit = new MenuItem("Exit");
        Open.addActionListener (this);
        Exit.addActionListener (this);
        File.add(Open);
        File.add(new MenuItem("-"));    //separator
        File.add(Exit);

//Setup menu is Setup->Appearance, Preferences->Colors, Filetypes
        Appearance = new MenuItem("Appearance");
        Preferences = new Menu("Preferences");
        Colors = new MenuItem("Colors");
        Filetypes = new MenuItem("Filetypes");
        Sound = new CheckboxMenuItem("Sound");
        Sound.setState(true);
        Sound.addActionListener (this);
        Setup.add(Appearance);
        Setup.add(Preferences);          //add menu here for sub menus
        Setup.add("Sound");
        Preferences.add(Colors);
        Preferences.add(Filetypes);

        filename = new Label("no filename");    //where filename will show
        add(filename);
        
        setBounds(100,100,300,200);
        setVisible(true);
    }
//-----------------------------------------
    private void clickedExit() {
//start up quit dialog
        QuitDialog qdlg = new QuitDialog(this);
        qdlg.show();         //show the dialog
        if (qdlg.getExitflag ()) {
            System.exit(0);
        }
    }
//-----------------------------------------
    private void clickedOpen() {
        FileDialog fdlg = new FileDialog(this, "Open",FileDialog.LOAD);
        fdlg.show();
        filename.setText(fdlg.getFile());
    }
//-----------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == Exit) {
            clickedExit();            
        }
        if (obj == Open) {
            clickedOpen();            
        }
        if(obj == Sound)
            clickedSound();
    }
//-----------------------------------------
    private void clickedSound() {
        if (Sound.getState ()) {
            Sound.setState (false);
        }
        else
            Sound.setState (true);
    }
//-----------------------------------------
    public static void main(String arg[]) {
        new CheckMenu();
    }
//-----------------------------------------
}
