import java.awt.*;
import java.awt.event.*;

public class SelectDialog extends Dialog implements ActionListener {
    Button OK, Cancel;
    CheckboxGroup cbg;
    Checkbox red, green, blue;
    SelMethod selm;
//-----------------------------------------
    public SelectDialog(Frame fr, SelMethod sm) {
        super(fr, "Select Color", true);
        setFont(new Font("Helvetica", Font.PLAIN, 12));
        selm = sm;
        Panel p1 = new Panel();
        OK = new Button("OK");
        Cancel = new Button("No");
        add("South", p1);
        p1.add(OK);
        p1.add(Cancel);
        OK.addActionListener (this);
        Cancel.addActionListener (this);
        cbg = new CheckboxGroup();
        red = new Checkbox("red", cbg, true);
        green = new Checkbox("green", cbg, false);
        blue = new Checkbox("blue", cbg, false);
        Panel p2 = new Panel();
        add("Center", p2);

        p2.add(red);
        p2.add(green);
        p2.add(blue);
        setSize(200,100);
    }
//-----------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == OK) {
            clickedOK();
            dispose();
        }
        else
            if (obj == Cancel) {
            dispose();   
        }      
    }
//-----------------------------------------
    private void clickedOK() {
        String colorname="none";
        if (red.getState()) colorname="red";
        if (green.getState()) colorname="green";
        if (blue.getState()) colorname="blue";
        selm.setColorName(colorname);
    }
}
