import java.awt.*;
import java.awt.event.*;

public class gbTemp extends XFrame implements ActionListener {
    private GridBagLayout gbl;      //layout mgr
    private GridBagConstraints gbc; //and constraints

    private Label label1;           //label
    private TextField tempEntry;    //entry field
    private Label result;           //result lable
    private CheckboxGroup cbg;
    private Checkbox fahr;          //radio buttons
    private Checkbox celsius;
    private Button compute;         //compute button
    private Button quit;            //quit button

    public gbTemp(String caption) {
        super(caption);               
        setBackground(Color.lightGray );
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        setLayout(gbl);
        gbc.ipadx = 5;        //make buttons wider
        gbc.ipady = 5;        //make buttons higher


        label1 = new Label("Enter temperature:");
        add_component(label1,0,1,2,1);

        tempEntry = new TextField(5);
        add_component(tempEntry,2,1,1,1);

        result = new Label(" result ");
        add_component(result,1,2,2,1);

        cbg = new CheckboxGroup();
        //left align check boxes in cell 1
        gbc.anchor = GridBagConstraints.WEST;
        fahr = new Checkbox("to Fahrenheit", cbg, true);
        add_component(fahr,1,3,2,1);

        celsius = new Checkbox("to Celsius", cbg, false);
        add_component(celsius,1,4,2,1);

        //return to center alignment
        gbc.anchor = GridBagConstraints.CENTER;
        add_component(new Label(""),1,5,1,1); //leave space
        compute = new Button("Compute");
        compute.addActionListener (this);
        add_component(compute, 0,6,1,1);

        quit = new Button("  Quit   ");
        add_component(quit, 2,6,1,1);
        quit.addActionListener (this);

        setBounds(20, 20, 250, 300);
        setVisible(true);
    }
    //--------------------------------------
    private void add_component(Component c, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight =h;
        add(c);
        gbl.setConstraints(c, gbc);
    }
    //--------------------------------------
    private void weight_cell(Component c, int weightx, int weighty) {
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
    }
    //--------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == compute) {
            clickedCompute();
        }

        if (obj == quit) {
            System.exit(0);  
        }
    }
    //--------------------------------------
    private void clickedCompute() {
        float temp, newtemp;

        temp = new Float(tempEntry.getText()).floatValue();
        if (fahr.getState())
            newtemp = 9 * temp / 5 + 32;
        else
            newtemp = 5 * (temp - 32) / 9;
        result.setText(" " + new String().valueOf(newtemp)+" ");
    }
    //--------------------------------------
    public static void main(String arg[]) {
        new gbTemp("GridBag Temperature");
    }
}
