import java.awt.*;
import java.applet.*;
public class TrackImage extends Applet {
    private Image images[];
    private MediaTracker track;
//--------------------------------------
    public void init() {
        setLayout(null);
        setFont(new Font("Helvetica", Font.PLAIN, 12));
        images = new Image[2];
        track = new MediaTracker(this);
        //begin loading images
        images[0] = getImage(getCodeBase(), "books05.gif");
        images[1] = getImage(getCodeBase(), "beany.gif");
        //add images into tracker
        for (int i = 0; i < 2; i++)
            track.addImage(images[i], 0);
//check to see if they are done loading
        for (int i = 0; i < 2; i++) {
            showStatus("loading image: " + i);
            try {
                track.waitForID(i);
            }
            catch (InterruptedException e) {
            };
            if (track.isErrorID(i))
                showStatus("Error loading image: " + i);
        }

    }
//--------------------------------------
    public void paint(Graphics g) {
        int x, w, h;
        for (int i=0; i <2; i++) {
            x = 100*i + 10;
            w = images[i].getWidth(this);
            h = images[i].getHeight(this);
            g.drawImage(images[i], x, 10, w, h, this);
        }
    }
}
