import java.awt.*;
import java.applet.*;
//blinks back and forth between 2 images
public class BlinkImage extends Applet implements Runnable {
    Image open, closed;     //two images
    MediaTracker track;     //and tracker
    Thread timer;           //timer for blinking
    boolean openvis;        //flag for which to draw
    public void init() {
        setLayout(null);
        //read in the two images
        open = getImage(getDocumentBase(), "mail02a.gif");
        closed = getImage(getDocumentBase(), "mail02b.gif");
        //make sure they are read in
        track = new MediaTracker(this);
        track.addImage(open, 0);
        track.addImage(closed, 1);
//check to see if they are done loading
        for (int i = 0; i < 2; i++) {
            showStatus("loading image: " + i);
            try {
                track.waitForID(i);
            }
            catch (InterruptedException e) {
            };
            if (track.isErrorID(i))
                showStatus("Error loading image: " + i);
        }
        //create a thread
        timer = new Thread(this);
        openvis = false;       //first display closed image
        timer.start();         //start thread
    }
//------------------------------------------
    public void run()    {
    //this method is called in new thread    
        while (true) {
            openvis = ! openvis; //switch between images
            repaint(50,50,32,32);           //and redraw screen
            try {
                Thread.sleep(100);
            }
            catch (InterruptedException e) {
            };
        }
    }
//-------------------------------------------
    public void update() {
    }
//-------------------------------------------
    public void paint(Graphics g) {
        if (openvis)
            g.drawImage(open, 50,50, Color.lightGray, this);
        else
            g.drawImage(closed, 50,50, Color.lightGray, this);
    }
}
