import java.awt.*;
import java.awt.event.*;

public class GrDemo extends XFrame implements ActionListener {
//arrays for polygons
    final int rect_points = 7;
    int xpoints[] = new int[rect_points];
    int ypoints[] = new int[rect_points];
    boolean clip, trans;    //flags to indicate what to do during paint
    Button btClip, btTranslate; //command buttons
    Font font;              //font to draw strings in
//----------------------------------------
    public GrDemo(String caption) {
        super(caption);               //create frame with title bar
        clip = false;                 //no clipping on
        trans = false;                //translation not on
        setLayout(new BorderLayout());
        btClip = new Button("Clip");
        btClip.addActionListener(this);
        btTranslate = new Button("Translate");
        btTranslate.addActionListener (this);

        Panel p1 = new Panel();       //add buttons to Southern border
        add("South", p1);
        p1.add(btClip);
        p1.add(btTranslate);
        //create x and y arrays for polygon
        xpoints[0] = 110;       ypoints[0] = 30;
        xpoints[1] = 120;       ypoints[1] = 30;
        xpoints[2] = 130;       ypoints[2] = 40;                                                   
        xpoints[3] = 120;       ypoints[3] = 50;
        xpoints[4] = 110;       ypoints[4] = 50;
        xpoints[5] = 100;       ypoints[5] = 40;
        xpoints[6] = 110;       ypoints[6] = 30;      //must close

        setBounds(100,100,350,300);
        font = new Font("Helvetica", Font.BOLD, 18);
        
        setVisible(true);
    }
//----------------------------------------
    public void paint (Graphics g) {
        g.setPaintMode();     //set to draw over
        if (clip) {
            g.clipRect(50,50,200,150);    //set smaller clip rectangle
            g.setColor(Color.yellow);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (trans) {
            //translate graphics context by 50 x and y units
            g.translate(50, 50);
            trans = false;              //but only once
        }
        //draw red filled hexagon
        g.setColor(Color.red);
        g.fillPolygon(xpoints, ypoints, rect_points);
        //draw green rounded rectangle
        g.setColor(Color.green);
        g.drawRoundRect(100, 100,75,50,15,15);
        //draw blue filled 3D rectangle
        g.setColor(Color.blue);
        g.fill3DRect(200,100,75,100,false);
        //draw blue arc in XOR mode
        g.setXORMode(Color.red);      //overlap will be orange
        g.fillArc(125,125,100,150,0,90);
        //Draw text, still in XOR mode
        g.setFont(font);
        g.drawString("Here is a string",150,120);
    }
//----------------------------------------
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource ();
        if (obj == btClip) {     //clip button set clip variable
            clip = ! clip;
            repaint();
        }
        else
            if (obj == btTranslate) {   //translate button sets translate 
            trans = true;
            repaint();

        }
    }
//----------------------------------------
    public static void main(String argv[]) {
        new GrDemo("Graphics Demo");
    }
}

