import java.awt.*;
import java.awt.event.*;
import java.io.*;
//displays a file and directory list box
//and an "up directory" button
//clicking on a directory entry causes the
//program to open that directory
public class Filedir2 extends XFrame implements ActionListener, ItemListener {
    List fDir;             //directory list
    List fList;            //filename list
    Button upDir;          //up directory button
    File f;
    String[] filelist;     //list of files
//-------------------------------------------
    public Filedir2() {
        super("File and directory list");   //title
        setBackground(Color.lightGray );
        setLayout(new BorderLayout());
        upDir = new Button("Up Dir");  //button
        upDir.addActionListener(this);
        Panel p0 = new Panel();
        add("North", p0);
        p0.add(upDir);                 //panel for button
        Panel p1 = new Panel();        //panel for lists
        add("Center", p1);
        fDir = new List(10, false);
        fDir.setBackground(Color.white);
        p1.add(fDir);
        fList = new List(10, false);
        fList.setBackground(Color.white);
        fDir.addItemListener(this);
        p1.add(fList);

//start with current directory
        loadlists(System.getProperty("user.dir"));
        setBounds(100, 100,400,300);
        setVisible(true);
    }
//-------------------------------------------
    public void actionPerformed (ActionEvent evt) {
        //if button is clicked move up one directory
        String p =f.getParent();
        if (p == null)
            p = f.pathSeparator;
        loadlists(p);  //and reload list boxes
     }
//-------------------------------------------
    private void loadlists(String p) {
        FileFilter filter;
        filter = new FileFilter("class");
        filter.addExtension("java");

        f = new File(p);       //create new obj each time
        setTitle(f.getAbsolutePath());
        filelist =f.list(filter); //create filtered list
        //clear out lists
        fDir.removeAll ();
        fList.removeAll();

        for (int i = 0; i < filelist.length; i++) {
            File fi1e = new File(f.getAbsolutePath()+"\\"+filelist[i]);
            //put in one list or the other
            if ( fi1e.isDirectory())
                fDir.add(filelist[i]);
            else
                fList.add(filelist[i]);
        }
    }
//-------------------------------------------
    public void itemStateChanged(ItemEvent evt) {
       //open directory that was clicked on
            String st = fDir.getSelectedItem();
            loadlists(f.getAbsolutePath() + File.separator + st);
       
    }
//-------------------------------------------
    public static void main(String argv[]) {
        new Filedir2();
    }
}


