import java.net.URL;
import java.sql.*;
import java.util.*;
public class JdbcOdbcTest {
    ResultSet results;
    ResultSetMetaData rsmd;
    DatabaseMetaData dma;
    Connection con;
    int numCols, i;
//------------------------------------------------
    public JdbcOdbcTest() {
        String url = "jdbc:odbc:Grocery prices";
        String query = "SELECT DISTINCTROW FoodName FROM Food " +
                       "WHERE (FoodName like 'C%');";
        try {
            //load the bridge driver
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            //connect to the database
            con   = DriverManager.getConnection(url);
            //get the database metadata
            dma =con.getMetaData();
            System.out.println("Connected to:"+dma.getURL());
            System.out.println("Driver "+dma.getDriverName());

            //now dump out the names of the tables in the database
            String[] types = new String[1];
            types[0] = "TABLES";

            //note the %-sign is a wild card (not '*')
            results = dma.getTables(null, null, "%", types);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        dumpResults("----Tables----");

        //get Table Column names
        System.out.println("----Column Names----");
        try {
            results = dma.getColumns(null, null, "FoodPrice", null);
            ResultSetMetaData rsmd = results.getMetaData();
            int numCols = rsmd.getColumnCount();
            while (results.next() )
                System.out.print(results.getString("COLUMN_NAME")+"    ");
            System.out.println();           
            results.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        //List out the contents of a column
        try {
            Statement stmt = con.createStatement();
            results = stmt.executeQuery("SELECT FOODNAME FROM FOOD;");
        }
        catch (Exception e) {
            System.out.println("query exception");
        }
        dumpResults("----Contents of FoodName column----");

        //try actual SQL statement
        try {
            Statement stmt = con.createStatement();
            results = stmt.executeQuery(query);
        }
        catch (Exception e) {
            System.out.println("query exception");
        }
        dumpResults("----Results of Query-----");
    }

    //------------------------------------
    private void dumpResults(String head) {
        //this is a general routine to print out
        //column headers and the contents of each column
        System.out.println(head);
        try {
            //get the number of columns from the metadata
            rsmd = results.getMetaData();
            numCols = rsmd.getColumnCount();

            //print out the column names
            for (i = 1; i<= numCols; i++)
                System.out.print(rsmd.getColumnName(i)+"     ");
            System.out.println();

            //print out the column contents
            boolean more = results.next();
            while (more) {
                for (i = 1; i <= numCols; i++)
                    System.out.print(results.getString(i)+"     ");
                System.out.println();
                more = results.next();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }

    }
    //------------------------------------
    public static void main(String argv[]) {
        new JdbcOdbcTest();
    }
}  

